/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDirectoryOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "DIRECTORY";
    private static final Logger LOGGER = new Logger(MOHDirectoryOracle.class);
    protected boolean dbaUser;

    public MOHDirectoryOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHDirectoryOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT").append(' ');
            ((StringBuffer)charSequence).append("directory_name").append(' ');
            ((StringBuffer)charSequence).append("FROM").append(' ');
            ((StringBuffer)charSequence).append(this.dbaUser ? "dba_directories" : "all_directories").append(' ');
            ((StringBuffer)charSequence).append("ORDER BY").append(' ');
            ((StringBuffer)charSequence).append("directory_name");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (Exception exception) {
            LOGGER.error("MOHDirectoryOracle.extract():", exception);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString("directory_name");
                DBObject dBObject = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE);
                arrayList.add(dBObject);
            }
            resultSet.close();
        }
        statement.close();
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Statement statement = null;
        for (int i = 0; i < list.size(); ++i) {
            DBObject dBObject = (DBObject)list.get(i);
            if (OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) {
                Object object;
                ResultSet resultSet = null;
                try {
                    if (statement == null) {
                        object = new StringBuffer();
                        ((StringBuffer)object).append("SELECT").append(' ');
                        ((StringBuffer)object).append("directory_name").append(',');
                        ((StringBuffer)object).append("directory_path").append(' ');
                        ((StringBuffer)object).append("FROM").append(' ');
                        ((StringBuffer)object).append(this.dbaUser ? "dba_directories" : "all_directories").append(' ');
                        ((StringBuffer)object).append("WHERE").append(' ');
                        ((StringBuffer)object).append("directory_name").append('=').append('?');
                        statement = connection.prepareStatement(((StringBuffer)object).toString());
                    }
                    statement.setString(1, dBObject.getName());
                    resultSet = statement.executeQuery();
                }
                catch (Exception exception) {
                    System.out.println("MOHDirectoryOracle.generate(): " + exception.getMessage());
                    LOGGER.error("MOHDirectoryOracle.generate():", exception);
                }
                if (resultSet != null) {
                    object = (StorageDesignOracle)this.getStorageDesign();
                    while (resultSet.next()) {
                        String string = resultSet.getString("directory_name");
                        String string2 = resultSet.getString("directory_path");
                        DirectoryOracle directoryOracle = ((StorageDesignOracle)object).getDirectorySet().createDirectory();
                        directoryOracle.setName(string);
                        directoryOracle.setDirPath(string2);
                        this.stampModelObject(directoryOracle, dBObject);
                    }
                    resultSet.close();
                }
            }
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
        if (statement != null) {
            statement.close();
        }
    }
}

