/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataFileOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TemporaryTablespaceOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDatafileOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "DATAFILE";
    private static final Logger LOGGER = new Logger(MOHDatafileOracle.class);
    protected boolean dbaUser;

    public MOHDatafileOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHDatafileOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        TimeLog.log("Data File begin");
        if (this.dbaUser) {
            Statement statement = null;
            Statement statement2 = null;
            for (StorageObject storageObject : this.getTablespaces()) {
                String string;
                Object object;
                ResultSet resultSet;
                block29: {
                    resultSet = null;
                    if (storageObject instanceof TemporaryTablespaceOracle) {
                        if (statement2 == null) {
                            object = new StringBuffer();
                            ((StringBuffer)object).append("SELECT").append(' ');
                            ((StringBuffer)object).append("FILE_NAME").append(',');
                            ((StringBuffer)object).append("TABLESPACE_NAME").append(',');
                            ((StringBuffer)object).append("BYTES").append(',');
                            ((StringBuffer)object).append("AUTOEXTENSIBLE").append(',');
                            ((StringBuffer)object).append("MAXBYTES").append(',');
                            ((StringBuffer)object).append("INCREMENT_BY").append(' ');
                            ((StringBuffer)object).append("FROM").append(' ');
                            ((StringBuffer)object).append("dba_temp_files").append(' ');
                            ((StringBuffer)object).append("WHERE").append(' ').append("TABLESPACE_NAME").append(' ');
                            ((StringBuffer)object).append('=').append(' ').append('?').append(' ');
                            ((StringBuffer)object).append("ORDER BY").append(' ');
                            ((StringBuffer)object).append("relative_fno").append(',');
                            ((StringBuffer)object).append("TABLESPACE_NAME");
                            string = ((StringBuffer)object).toString();
                            statement2 = connection.prepareStatement(string);
                        }
                        try {
                            statement2.setString(1, storageObject.getName());
                            resultSet = statement2.executeQuery();
                        }
                        catch (Exception exception) {
                            System.out.println("MOHDatafileOracle.generate(): " + exception.getMessage());
                            if (exception.getMessage().startsWith("ORA-00942")) {
                                LOGGER.error("MOHDatafileOracle.generate(): current connection user has no SELECT privilege on dba_temp_files");
                                break block29;
                            }
                            LOGGER.error("MOHDatafileOracle.generate():", exception);
                        }
                    } else {
                        if (statement == null) {
                            object = new StringBuffer();
                            ((StringBuffer)object).append("SELECT").append(' ');
                            ((StringBuffer)object).append("FILE_NAME").append(',');
                            ((StringBuffer)object).append("TABLESPACE_NAME").append(',');
                            ((StringBuffer)object).append("BYTES").append(',');
                            ((StringBuffer)object).append("AUTOEXTENSIBLE").append(',');
                            ((StringBuffer)object).append("MAXBYTES").append(',');
                            ((StringBuffer)object).append("INCREMENT_BY").append(' ');
                            ((StringBuffer)object).append("FROM").append(' ');
                            ((StringBuffer)object).append("dba_data_files").append(' ');
                            ((StringBuffer)object).append("WHERE").append(' ').append("TABLESPACE_NAME").append(' ');
                            ((StringBuffer)object).append('=').append(' ').append('?').append(' ');
                            ((StringBuffer)object).append("ORDER BY").append(' ');
                            ((StringBuffer)object).append("relative_fno").append(',');
                            ((StringBuffer)object).append("TABLESPACE_NAME");
                            string = ((StringBuffer)object).toString();
                            statement = connection.prepareStatement(string);
                        }
                        try {
                            statement.setString(1, storageObject.getName());
                            resultSet = statement.executeQuery();
                        }
                        catch (Exception exception) {
                            System.out.println("MOHDatafileOracle.generate(): " + exception.getMessage());
                            if (exception.getMessage().startsWith("ORA-00942")) {
                                LOGGER.error("MOHDatafileOracle.generate(): current connection user has no SELECT privilege on dba_data_files");
                            }
                            LOGGER.error("MOHDatafileOracle.generate():", exception);
                        }
                    }
                }
                object = (StorageDesignOracle)this.getStorageDesign();
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    long l;
                    string = resultSet.getString("FILE_NAME");
                    String string2 = resultSet.getString("BYTES");
                    try {
                        l = Long.parseLong(string2);
                    }
                    catch (Exception exception) {
                        LOGGER.error("MOHDatafileOracle.generate(): Error parsing \"BYTES\" - " + string2);
                        l = 1024L;
                    }
                    String string3 = resultSet.getString("AUTOEXTENSIBLE");
                    String string4 = resultSet.getString("MAXBYTES");
                    int n = resultSet.getInt("INCREMENT_BY");
                    String string5 = resultSet.getString("TABLESPACE_NAME");
                    DataFileOracle dataFileOracle = ((StorageDesignOracle)object).getDataFileSet().createDataFile();
                    dataFileOracle.setFileName(string);
                    try {
                        File file = new File(string);
                        dataFileOracle.setName(file.getName());
                    }
                    catch (Exception exception) {
                        dataFileOracle.setName(string);
                    }
                    this.stampModelObject((ModelObject)dataFileOracle, "", string);
                    if (l % 1024L == 0L) {
                        dataFileOracle.setSize(l / 1024L);
                        dataFileOracle.setMeasureUnit("K");
                    } else {
                        dataFileOracle.setSize(l);
                        dataFileOracle.setMeasureUnit("");
                    }
                    if (string4 == null) {
                        dataFileOracle.setMaxSize("-1");
                    } else if (!string4.equalsIgnoreCase("34359721984")) {
                        try {
                            double d = Double.parseDouble(string4);
                            dataFileOracle.setMaxSize(String.valueOf(d / 1024.0));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ("YES".equalsIgnoreCase(string3)) {
                        dataFileOracle.setAutoextend("ON");
                    } else if ("NO".equalsIgnoreCase(string3)) {
                        dataFileOracle.setAutoextend("OFF");
                    }
                    dataFileOracle.setNextBlockSize(n * 8);
                    this.assignToTablespace(dataFileOracle, string5, storageObject);
                }
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (statement2 != null) {
                statement2.close();
            }
        }
        TimeLog.log("Data File end");
    }

    private void assignToTablespace(DataFileOracle dataFileOracle, String string, StorageObject storageObject) {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
        if (storageObject instanceof TableSpaceOracle) {
            dataFileOracle.setTableSpace((TableSpaceOracle)storageObject);
        } else if (storageDesignOracle instanceof StorageDesignOraclev9i) {
            if (storageObject instanceof TemporaryTablespaceOracle) {
                ((DataFileOraclev9i)dataFileOracle).setTemporaryTablespace((TemporaryTablespaceOraclev9i)storageObject);
                TemporaryTablespaceOraclev9i temporaryTablespaceOraclev9i = (TemporaryTablespaceOraclev9i)storageObject;
                temporaryTablespaceOraclev9i.setFilename(dataFileOracle.getFileName());
                temporaryTablespaceOraclev9i.setSize(dataFileOracle.getSize());
                temporaryTablespaceOraclev9i.setNextBlockSize(dataFileOracle.getNextBlockSize());
                temporaryTablespaceOraclev9i.setMaxSize(dataFileOracle.getMaxSize());
                temporaryTablespaceOraclev9i.setAutoextend(dataFileOracle.getAutoextend());
                dataFileOracle.remove();
            } else if (storageObject instanceof UndoTablespaceOracle) {
                ((DataFileOraclev9i)dataFileOracle).setUndoTablespace((UndoTablespaceOracle)storageObject);
            }
        } else if (storageDesignOracle instanceof StorageDesignOraclev10g) {
            if (storageObject instanceof TemporaryTablespaceOracle) {
                ((DataFileOraclev10g)dataFileOracle).setTemporaryTablespace((TemporaryTablespaceOraclev10g)storageObject);
            } else if (storageObject instanceof UndoTablespaceOracle) {
                ((DataFileOraclev10g)dataFileOracle).setUndoTablespace((UndoTablespaceOracle)storageObject);
            }
        }
    }

    private List getTablespaces() {
        ArrayList arrayList = new ArrayList();
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
        storageDesignOracle.getTableSpaceSet().addAllElementsTo(arrayList);
        storageDesignOracle.getTemporaryTablespaceSet().addAllElementsTo(arrayList);
        storageDesignOracle.getUndoTablespaceSet().addAllElementsTo(arrayList);
        return arrayList;
    }
}

