/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHClusterOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "CLUSTER";
    private static final Logger LOGGER = new Logger(MOHClusterOracle.class);
    protected boolean dbaUser;
    PreparedStatement col_statement = null;
    PreparedStatement ind_statement = null;

    public MOHClusterOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = false;
    }

    public MOHClusterOracle(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView, boolean bl) {
        super(abstractDBMExtractionHandler, applicationView);
        this.dbaUser = bl;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        Statement statement = null;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            String string;
            Object object;
            if (!dBObject.isSelected()) continue;
            if (statement == null) {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("CLUSTER_NAME").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append(this.dbaUser ? "dba_clusters" : "all_clusters").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ');
                ((StringBuffer)object).append("OWNER").append('=').append(' ').append('?').append(' ');
                ((StringBuffer)object).append("ORDER BY").append(' ');
                ((StringBuffer)object).append("CLUSTER_NAME");
                string = ((StringBuffer)object).toString();
                statement = connection.prepareStatement(string);
            }
            object = null;
            try {
                statement.setString(1, dBObject.getName());
                object = statement.executeQuery();
            }
            catch (Exception exception) {
                System.out.println("MOHClusterOracle.extract(): " + exception.getMessage());
                LOGGER.error("MOHClusterOracle.extract():", exception);
            }
            if (object == null) continue;
            while (object.next()) {
                string = object.getString(1);
                DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), string, OBJECT_TYPE, dBObject.getName());
                arrayList.add(dBObject2);
            }
            object.close();
        }
        if (statement != null) {
            statement.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        StorageDesign storageDesign = this.getStorageDesign();
        if (storageDesign != null && storageDesign instanceof StorageDesignOracle) {
            Statement statement = null;
            this.col_statement = null;
            this.ind_statement = null;
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                Object object2;
                DBObject dBObject = (DBObject)list.get(i);
                if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
                if (statement == null) {
                    object2 = new StringBuffer();
                    ((StringBuffer)object2).append("SELECT").append(' ');
                    ((StringBuffer)object2).append("a.").append("CLUSTER_NAME").append(',');
                    ((StringBuffer)object2).append("TABLESPACE_NAME").append(',');
                    ((StringBuffer)object2).append("PCT_FREE").append(',');
                    ((StringBuffer)object2).append("PCT_USED").append(',');
                    ((StringBuffer)object2).append("KEY_SIZE").append(',');
                    ((StringBuffer)object2).append("INI_TRANS").append(',');
                    ((StringBuffer)object2).append("MAX_TRANS").append(',');
                    ((StringBuffer)object2).append("INITIAL_EXTENT").append(',');
                    ((StringBuffer)object2).append("NEXT_EXTENT").append(',');
                    ((StringBuffer)object2).append("MIN_EXTENTS").append(',');
                    ((StringBuffer)object2).append("MAX_EXTENTS").append(',');
                    ((StringBuffer)object2).append("PCT_INCREASE").append(',');
                    ((StringBuffer)object2).append("FREELISTS").append(',');
                    ((StringBuffer)object2).append("FREELIST_GROUPS").append(',');
                    ((StringBuffer)object2).append("CLUSTER_TYPE").append(',');
                    ((StringBuffer)object2).append("FUNCTION").append(',');
                    ((StringBuffer)object2).append("HASHKEYS").append(',');
                    ((StringBuffer)object2).append("DEGREE").append(',');
                    ((StringBuffer)object2).append("CACHE").append(',');
                    ((StringBuffer)object2).append("BUFFER_POOL").append(',');
                    ((StringBuffer)object2).append("SINGLE_TABLE").append(',');
                    if (storageDesign instanceof StorageDesignOraclev9i) {
                        ((StringBuffer)object2).append("NULL").append(' ').append("AS").append(' ').append("DEPENDENCIES").append(',');
                    } else {
                        ((StringBuffer)object2).append("DEPENDENCIES").append(',');
                    }
                    ((StringBuffer)object2).append("b.").append("HASH_EXPRESSION").append(' ');
                    ((StringBuffer)object2).append("FROM").append(' ');
                    ((StringBuffer)object2).append(this.dbaUser ? "dba_clusters" : "all_clusters").append(' ').append("a").append(',');
                    ((StringBuffer)object2).append(this.dbaUser ? "dba_cluster_hash_expressions" : "all_cluster_hash_expressions").append(' ').append("b").append(' ');
                    ((StringBuffer)object2).append("WHERE").append(' ');
                    ((StringBuffer)object2).append("a.").append("CLUSTER_NAME").append('=').append(' ').append('?').append(' ');
                    ((StringBuffer)object2).append("AND").append(' ');
                    ((StringBuffer)object2).append("a.").append("OWNER").append('=').append(' ').append('?').append(' ');
                    ((StringBuffer)object2).append("AND").append(' ');
                    ((StringBuffer)object2).append("a.").append("OWNER").append('=').append("b.").append("OWNER").append(' ').append("(+)").append(' ');
                    ((StringBuffer)object2).append("AND").append(' ');
                    ((StringBuffer)object2).append("a.").append("CLUSTER_NAME").append('=').append("b.").append("CLUSTER_NAME").append("(+)").append(' ');
                    ((StringBuffer)object2).append("ORDER BY").append(' ');
                    ((StringBuffer)object2).append("a.").append("OWNER").append(',');
                    ((StringBuffer)object2).append("a.").append("CLUSTER_NAME");
                    object = ((StringBuffer)object2).toString();
                    statement = connection.prepareStatement((String)object);
                }
                object2 = null;
                try {
                    statement.setString(1, dBObject.getName());
                    statement.setString(2, dBObject.getSchema());
                    object2 = statement.executeQuery();
                    if (object2 != null) {
                        if (object2.next()) {
                            object = ((StorageDesignOracle)storageDesign).getClusterSet().createCluster();
                            ((StorageObject)object).setName(dBObject.getName());
                            this.setUser((ClusterOracle)object, (StorageDesignOracle)storageDesign, dBObject.getSchema());
                            this.setTableSpace((ClusterOracle)object, (StorageDesignOracle)storageDesign, (ResultSet)object2, dBObject.getSchema());
                            this.setProperties((ClusterOracle)object, (StorageDesignOracle)storageDesign, (ResultSet)object2);
                            this.stampModelObject((ModelObject)object, dBObject);
                        }
                        object2.close();
                    }
                    this.setClusterColumns(connection, dBObject.getName(), dBObject.getSchema(), (StorageDesignOracle)storageDesign);
                    if (this.dbaUser) {
                        this.setClusterIndexes(connection, dBObject.getName(), dBObject.getSchema(), statement, (StorageDesignOracle)storageDesign);
                    } else {
                        this.setClusterIndexesBasic(connection, dBObject.getName(), dBObject.getSchema(), statement, (StorageDesignOracle)storageDesign);
                    }
                }
                catch (Exception exception) {
                    System.out.println("MOHClusterOracle.generate(): " + exception.getMessage());
                    LOGGER.error("MOHClusterOracle.generate():", exception);
                }
                importLogger.incrementImportedStatements();
                this.addToHandledObjects(dBObject);
            }
            if (statement != null) {
                statement.close();
            }
            if (this.col_statement != null) {
                this.col_statement.close();
            }
            if (this.ind_statement != null) {
                this.ind_statement.close();
            }
        } else {
            LOGGER.error("Unable to find Storage Design!");
        }
    }

    private void setUser(ClusterOracle clusterOracle, StorageDesignOracle storageDesignOracle, String string) {
        UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(string);
        clusterOracle.setUser(userOracle);
    }

    private void setTableSpace(ClusterOracle clusterOracle, StorageDesignOracle storageDesignOracle, ResultSet resultSet, String string) throws Exception {
        String string2 = resultSet.getString("TABLESPACE_NAME");
        if (string2 != null && !"".equalsIgnoreCase(string2)) {
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string2);
            if (tableSpaceOracle == null) {
                tableSpaceOracle = storageDesignOracle.getTableSpaceSet().createTableSpace();
                tableSpaceOracle.setName(string2);
                this.stampModelObject((ModelObject)tableSpaceOracle, string, string2);
            }
            clusterOracle.setTableSpace(tableSpaceOracle);
        }
    }

    private void setProperties(ClusterOracle clusterOracle, StorageDesignOracle storageDesignOracle, ResultSet resultSet) throws Exception {
        int n = resultSet.getInt("PCT_FREE");
        String string = resultSet.getString("PCT_USED");
        int n2 = 40;
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n3 = resultSet.getInt("KEY_SIZE");
        int n4 = resultSet.getInt("INI_TRANS");
        int n5 = resultSet.getInt("MAX_TRANS");
        long l = resultSet.getLong("INITIAL_EXTENT");
        long l2 = resultSet.getLong("NEXT_EXTENT");
        int n6 = resultSet.getInt("MIN_EXTENTS");
        String string2 = resultSet.getString("MAX_EXTENTS");
        int n7 = resultSet.getInt("PCT_INCREASE");
        int n8 = resultSet.getInt("FREELISTS");
        int n9 = resultSet.getInt("FREELIST_GROUPS");
        int n10 = resultSet.getInt("HASHKEYS");
        String string3 = resultSet.getString("BUFFER_POOL");
        String string4 = resultSet.getString("DEGREE");
        String string5 = resultSet.getString("CACHE");
        String string6 = resultSet.getString("SINGLE_TABLE");
        String string7 = resultSet.getString("DEPENDENCIES");
        String string8 = resultSet.getString("HASH_EXPRESSION");
        String string9 = resultSet.getString("CLUSTER_TYPE");
        clusterOracle.setSize(n3);
        if ("INDEX".equalsIgnoreCase(string9)) {
            clusterOracle.setIndexed("YES");
        } else {
            clusterOracle.setIndexed("NO");
        }
        if (string6 != null) {
            if ("Y".equalsIgnoreCase(string6.trim())) {
                clusterOracle.setSingleTable("YES");
            } else {
                clusterOracle.setSingleTable("NO");
            }
        }
        clusterOracle.setHashKeys(n10);
        clusterOracle.setHashExpression(string8);
        if ("DEFAULT".equalsIgnoreCase(string4.trim())) {
            clusterOracle.setParallel("YES");
        } else {
            try {
                int n11 = Integer.parseInt(string4);
                if (n11 == 1) {
                    clusterOracle.setParallel("NO");
                }
                clusterOracle.setDegree(n11);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ("Y".equalsIgnoreCase(string5)) {
            clusterOracle.setCache("YES");
        } else {
            clusterOracle.setCache("NO");
        }
        if ("ENABLED".equalsIgnoreCase(string7)) {
            clusterOracle.setRowDependency("YES");
        }
        SegmentOracle segmentOracle = storageDesignOracle.getSegmentSet().createSegment();
        segmentOracle.setPCTFree(n);
        segmentOracle.setPCTUsed(n2);
        segmentOracle.setInitrans(n4);
        segmentOracle.setMaxTrans(n5);
        segmentOracle.setSCInitialExtent(l);
        segmentOracle.setSCNextExtent(l2);
        segmentOracle.setSCMinExtents(n6);
        segmentOracle.setSCMaxExtents(String.valueOf(string2));
        segmentOracle.setSCPctIncrease(n7);
        segmentOracle.setSCFreeLists(n8);
        segmentOracle.setSCFreelistGroups(n9);
        segmentOracle.setSCBufferPool(string3);
        segmentOracle = storageDesignOracle.getSegmentSet().findEqual(segmentOracle);
        clusterOracle.setSegment(segmentOracle);
    }

    private void setClusterColumns(Connection connection, String string, String string2, StorageDesignOracle storageDesignOracle) throws Exception {
        Object object;
        Object object2;
        if (this.col_statement == null) {
            object2 = new StringBuffer();
            ((StringBuffer)object2).append("SELECT").append(' ');
            ((StringBuffer)object2).append("a.").append("OWNER").append(',');
            ((StringBuffer)object2).append("a.").append("TABLE_NAME").append(',');
            ((StringBuffer)object2).append("a.").append("COLUMN_NAME").append(',');
            ((StringBuffer)object2).append("DATA_TYPE").append(',');
            ((StringBuffer)object2).append("DATA_TYPE_MOD").append(',');
            ((StringBuffer)object2).append("DATA_TYPE_OWNER").append(',');
            ((StringBuffer)object2).append("DATA_LENGTH").append(',');
            ((StringBuffer)object2).append("DATA_PRECISION").append(',');
            ((StringBuffer)object2).append("DATA_SCALE").append(',');
            ((StringBuffer)object2).append("CHAR_USED").append(',');
            ((StringBuffer)object2).append("CHAR_LENGTH").append(',');
            ((StringBuffer)object2).append("NULLABLE").append(',');
            ((StringBuffer)object2).append("COLUMN_ID").append(' ');
            ((StringBuffer)object2).append("FROM").append(' ');
            ((StringBuffer)object2).append(this.dbaUser ? "dba_tab_columns" : "all_tab_columns").append(' ').append("a").append(' ');
            ((StringBuffer)object2).append("WHERE").append(' ');
            ((StringBuffer)object2).append("a.").append("OWNER").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object2).append("AND").append(' ');
            ((StringBuffer)object2).append("a.").append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object2).append("ORDER BY").append(' ');
            ((StringBuffer)object2).append("COLUMN_ID");
            object = ((StringBuffer)object2).toString();
            this.col_statement = connection.prepareStatement((String)object);
        }
        object2 = null;
        try {
            this.col_statement.setString(1, string2);
            this.col_statement.setString(2, string);
            object2 = this.col_statement.executeQuery();
            if (object2 != null) {
                while (object2.next()) {
                    object = (ClusterOracle)storageDesignOracle.getClusterSet().getByName(string);
                    if (object == null) continue;
                    String string3 = object2.getString("COLUMN_NAME");
                    String string4 = object2.getString("DATA_TYPE");
                    int n = object2.getInt("DATA_LENGTH");
                    int n2 = object2.getInt("DATA_PRECISION");
                    int n3 = object2.getInt("DATA_SCALE");
                    String string5 = object2.getString("CHAR_USED");
                    int n4 = object2.getInt("CHAR_LENGTH");
                    int n5 = object2.getInt("COLUMN_ID");
                    ClusterColumnOracle clusterColumnOracle = storageDesignOracle.getClusterColumnSet().createClusterColumn();
                    clusterColumnOracle.setName(string3);
                    this.stampModelObject((ModelObject)clusterColumnOracle, string, string3);
                    string4 = this.removeBrackets(string4);
                    clusterColumnOracle.setDataType(string4);
                    clusterColumnOracle.setPosition(n5);
                    clusterColumnOracle.setCluster((ClusterOracle)object);
                    if (string4.indexOf("CHAR") >= 0) {
                        int n6 = n4;
                        String string6 = "";
                        if (string4.equals("CHAR") || string4.equals("VARCHAR2")) {
                            if (string5.equalsIgnoreCase("B")) {
                                n6 = n;
                                string6 = " BYTE";
                            } else {
                                string6 = " CHAR";
                            }
                        }
                        clusterColumnOracle.setLengthPrecision(n6 + string6);
                        continue;
                    }
                    if (string4.equals("RAW") || string4.equals("UROWID")) {
                        clusterColumnOracle.setLengthPrecision(Integer.toString(n));
                        continue;
                    }
                    if (string4.startsWith("TIMESTAMP")) {
                        if (n3 == 0) continue;
                        clusterColumnOracle.setLengthPrecision(Integer.toString(n3));
                        continue;
                    }
                    if (n2 != 0) {
                        clusterColumnOracle.setLengthPrecision(Integer.toString(n2));
                    }
                    clusterColumnOracle.setScale(n3);
                }
                object2.close();
            }
        }
        catch (Exception exception) {
            System.out.println("MOHClusterOracle.setClusterColumns(): " + exception.getMessage());
            LOGGER.error("MOHClusterOracle.setClusterColumns():", exception);
        }
    }

    private String removeBrackets(String string) {
        int n;
        int n2 = string.indexOf(40);
        if (n2 >= 0 && (n = string.indexOf(41, n2)) >= 0) {
            string = this.removeBrackets(string.substring(0, n2) + string.substring(n + 1));
        }
        return string;
    }

    private void setClusterIndexes(Connection connection, String string, String string2, Statement statement, StorageDesignOracle storageDesignOracle) throws Exception {
        block16: {
            Object object;
            Object object2;
            if (this.ind_statement == null) {
                object2 = new StringBuffer();
                ((StringBuffer)object2).append("SELECT").append(' ');
                ((StringBuffer)object2).append("OWNER").append(',');
                ((StringBuffer)object2).append("INDEX_NAME").append(',');
                ((StringBuffer)object2).append("INDEX_TYPE").append(',');
                ((StringBuffer)object2).append("TABLE_OWNER").append(',');
                ((StringBuffer)object2).append("TABLE_NAME").append(',');
                ((StringBuffer)object2).append("TABLE_TYPE").append(',');
                ((StringBuffer)object2).append("TABLESPACE_NAME").append(',');
                ((StringBuffer)object2).append("INI_TRANS").append(',');
                ((StringBuffer)object2).append("MAX_TRANS").append(',');
                ((StringBuffer)object2).append("INITIAL_EXTENT").append(',');
                ((StringBuffer)object2).append("NEXT_EXTENT").append(',');
                ((StringBuffer)object2).append("MIN_EXTENTS").append(',');
                ((StringBuffer)object2).append("MAX_EXTENTS").append(',');
                ((StringBuffer)object2).append("PCT_INCREASE").append(',');
                ((StringBuffer)object2).append("FREELISTS").append(',');
                ((StringBuffer)object2).append("FREELIST_GROUPS").append(',');
                ((StringBuffer)object2).append("PCT_FREE").append(',');
                ((StringBuffer)object2).append("LOGGING").append(',');
                ((StringBuffer)object2).append("DEGREE").append(',');
                ((StringBuffer)object2).append("BUFFER_POOL").append(' ');
                ((StringBuffer)object2).append("FROM").append(' ');
                ((StringBuffer)object2).append(this.dbaUser ? "dba_indexes" : "all_indexes").append(' ');
                ((StringBuffer)object2).append("WHERE").append(' ');
                ((StringBuffer)object2).append("INDEX_TYPE").append('=').append('\'');
                ((StringBuffer)object2).append(OBJECT_TYPE).append('\'').append(' ');
                ((StringBuffer)object2).append("AND").append(' ');
                ((StringBuffer)object2).append("TABLE_OWNER").append('=').append(' ').append('?').append(' ');
                ((StringBuffer)object2).append("AND").append(' ');
                ((StringBuffer)object2).append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
                ((StringBuffer)object2).append("ORDER BY").append(' ');
                ((StringBuffer)object2).append("INDEX_NAME");
                object = ((StringBuffer)object2).toString();
                this.ind_statement = connection.prepareStatement((String)object);
            }
            object2 = null;
            try {
                this.ind_statement.setString(1, string2);
                this.ind_statement.setString(2, string);
                object2 = this.ind_statement.executeQuery();
                if (object2 == null) break block16;
                while (object2.next()) {
                    AbstractStorageObjectOracle abstractStorageObjectOracle;
                    object = (ClusterOracle)storageDesignOracle.getClusterSet().getByName(string);
                    if (object == null) continue;
                    String string3 = object2.getString("INDEX_NAME");
                    String string4 = object2.getString("TABLESPACE_NAME");
                    int n = object2.getInt("PCT_FREE");
                    int n2 = object2.getInt("INI_TRANS");
                    int n3 = object2.getInt("MAX_TRANS");
                    long l = object2.getLong("INITIAL_EXTENT");
                    long l2 = object2.getLong("NEXT_EXTENT");
                    int n4 = Integer.MAX_VALUE;
                    int n5 = Integer.MAX_VALUE;
                    try {
                        n4 = object2.getInt("MIN_EXTENTS");
                    }
                    catch (Exception exception) {
                        LOGGER.error("error in min_extent", exception);
                    }
                    try {
                        n5 = object2.getInt("MAX_EXTENTS");
                    }
                    catch (Exception exception) {
                        LOGGER.error("error in max_extent", exception);
                    }
                    int n6 = object2.getInt("PCT_INCREASE");
                    int n7 = object2.getInt("FREELISTS");
                    int n8 = object2.getInt("FREELIST_GROUPS");
                    String string5 = object2.getString("BUFFER_POOL");
                    String string6 = object2.getString("LOGGING");
                    String string7 = object2.getString("DEGREE");
                    ClusterIndexOracle clusterIndexOracle = storageDesignOracle.getClusterIndexSet().createClusterIndex();
                    clusterIndexOracle.setCluster((ClusterOracle)object);
                    clusterIndexOracle.setName(string3);
                    this.stampModelObject((ModelObject)clusterIndexOracle, string2, string3);
                    if (string4 != null && !"".equalsIgnoreCase(string4)) {
                        abstractStorageObjectOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string4);
                        if (abstractStorageObjectOracle == null) {
                            abstractStorageObjectOracle = storageDesignOracle.getTableSpaceSet().createTableSpace();
                            ((TableSpaceOracle)abstractStorageObjectOracle).setName(string4);
                            this.stampModelObject((ModelObject)abstractStorageObjectOracle, string2, string4);
                        }
                        clusterIndexOracle.setTableSpace((TableSpaceOracle)abstractStorageObjectOracle);
                    }
                    abstractStorageObjectOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(string2);
                    clusterIndexOracle.setUser((UserOracle)abstractStorageObjectOracle);
                    if ("YES".equalsIgnoreCase(string6)) {
                        clusterIndexOracle.setLogging("YES");
                    } else {
                        clusterIndexOracle.setLogging("NO");
                    }
                    if ("DEFAULT".equalsIgnoreCase(string7.trim())) {
                        ((ClusterOracle)object).setParallel("YES");
                    }
                    SegmentOracle segmentOracle = storageDesignOracle.getSegmentSet().createSegment();
                    segmentOracle.setPCTFree(n);
                    segmentOracle.setInitrans(n2);
                    segmentOracle.setMaxTrans(n3);
                    segmentOracle.setSCInitialExtent(l);
                    segmentOracle.setSCNextExtent(l2);
                    segmentOracle.setSCMinExtents(n4);
                    segmentOracle.setSCMaxExtents(String.valueOf(n5));
                    segmentOracle.setSCPctIncrease(n6);
                    segmentOracle.setSCFreeLists(n7);
                    segmentOracle.setSCFreelistGroups(n8);
                    segmentOracle.setSCBufferPool(string5);
                    segmentOracle = storageDesignOracle.getSegmentSet().findEqual(segmentOracle);
                    clusterIndexOracle.setSegment(segmentOracle);
                }
                object2.close();
            }
            catch (SQLException sQLException) {
                if (sQLException.getMessage().startsWith("ORA-00942")) {
                    System.out.println("MOHClusterOracle.setClusterIndexes(): " + sQLException.getMessage());
                    LOGGER.error("MOHClusterOracle.setClusterIndexes(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_indexes" : "all_indexes"));
                } else {
                    System.out.println("MOHClusterOracle.setClusterIndexes(): " + sQLException.getMessage());
                    LOGGER.error("MOHClusterOracle.setClusterIndexes():", sQLException);
                }
            }
            catch (Exception exception) {
                System.out.println("MOHClusterOracle.setClusterIndexes(): " + exception.getMessage());
                LOGGER.error("MOHClusterOracle.setClusterIndexes():", exception);
            }
        }
    }

    private void setClusterIndexesBasic(Connection connection, String string, String string2, Statement statement, StorageDesignOracle storageDesignOracle) throws Exception {
        Object object;
        Object object2;
        if (this.ind_statement == null) {
            object2 = new StringBuffer();
            ((StringBuffer)object2).append("SELECT").append(' ');
            ((StringBuffer)object2).append("DISTINCT").append(' ');
            ((StringBuffer)object2).append("a.").append("INDEX_OWNER").append(',');
            ((StringBuffer)object2).append("a.").append("INDEX_NAME").append(',');
            ((StringBuffer)object2).append('\'').append(OBJECT_TYPE).append('\'').append(' ').append("INDEX_TYPE").append(',');
            ((StringBuffer)object2).append("b.").append("OWNER").append(',');
            ((StringBuffer)object2).append("b.").append("CLUSTER_NAME").append(',');
            ((StringBuffer)object2).append("b.").append("CLUSTER_TYPE").append(' ');
            ((StringBuffer)object2).append("FROM").append(' ');
            ((StringBuffer)object2).append(this.dbaUser ? "dba_ind_columns" : "all_ind_columns").append(' ').append("a").append(',');
            ((StringBuffer)object2).append(this.dbaUser ? "dba_clusters" : "all_clusters").append(' ').append("b").append(' ');
            ((StringBuffer)object2).append("WHERE").append(' ');
            ((StringBuffer)object2).append("a.").append("TABLE_OWNER").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object2).append("AND").append(' ');
            ((StringBuffer)object2).append("a.").append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
            ((StringBuffer)object2).append("AND").append(' ');
            ((StringBuffer)object2).append("b.").append("OWNER").append('=').append("a.").append("TABLE_OWNER").append(' ');
            ((StringBuffer)object2).append("AND").append(' ');
            ((StringBuffer)object2).append("b.").append("CLUSTER_NAME").append('=').append("a.").append("TABLE_NAME").append(' ');
            ((StringBuffer)object2).append("ORDER BY").append(' ');
            ((StringBuffer)object2).append("INDEX_NAME");
            object = ((StringBuffer)object2).toString();
            this.ind_statement = connection.prepareStatement((String)object);
        }
        object2 = null;
        try {
            this.ind_statement.setString(1, string2);
            this.ind_statement.setString(2, string);
            object2 = this.ind_statement.executeQuery();
            if (object2 != null) {
                while (object2.next()) {
                    object = (ClusterOracle)storageDesignOracle.getClusterSet().getByName(string);
                    if (object == null) continue;
                    String string3 = object2.getString("INDEX_OWNER");
                    String string4 = object2.getString("INDEX_NAME");
                    String string5 = object2.getString("INDEX_TYPE");
                    String string6 = object2.getString("OWNER");
                    String string7 = object2.getString("CLUSTER_NAME");
                    String string8 = object2.getString("CLUSTER_TYPE");
                    ClusterIndexOracle clusterIndexOracle = storageDesignOracle.getClusterIndexSet().createClusterIndex();
                    clusterIndexOracle.setCluster((ClusterOracle)object);
                    clusterIndexOracle.setName(string4);
                    this.stampModelObject((ModelObject)clusterIndexOracle, string2, string4);
                    UserOracle userOracle = (UserOracle)storageDesignOracle.getUserSet().getByName(string3);
                    clusterIndexOracle.setUser(userOracle);
                }
                object2.close();
            }
        }
        catch (Exception exception) {
            System.out.println("MOHClusterOracle.setClusterIndexesBasic(): " + exception.getMessage());
            LOGGER.error("MOHClusterOracle.setClusterIndexesBasic():", exception);
        }
    }
}

