/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2.v80;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SequenceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHSequenceDB2v80
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "SEQUENCE";
    private static final Logger LOGGER = new Logger(MOHSequenceDB2v80.class);

    public MOHSequenceDB2v80(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            String string2 = dBObject.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT DATATYPEID, SOURCETYPEID, ");
                ((StringBuffer)object).append("START, INCREMENT, cast(MINVALUE as char(20)), ");
                ((StringBuffer)object).append("cast(MAXVALUE as char(20)), CYCLE, CACHE, ORDER ");
                ((StringBuffer)object).append("from SYSIBM.SYSSEQUENCES").append(' ');
                ((StringBuffer)object).append("WHERE NAME = '").append(string).append("'");
                ((StringBuffer)object).append(" AND SEQTYPE = 'S'");
                ((StringBuffer)object).append(" and SCHEMA = '").append(string2).append("'");
                statement = connection.prepareStatement(((StringBuffer)object).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHSequencesDB2.generate():", sQLException);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    object = this.getStorageDesign();
                    if (object != null && object instanceof AbstractStorageDesignDB2) {
                        StorageDesignDB2v80 storageDesignDB2v80 = (StorageDesignDB2v80)object;
                        int n = resultSet.getInt(1);
                        int n2 = resultSet.getInt(2);
                        int n3 = resultSet.getInt(3);
                        int n4 = resultSet.getInt(4);
                        String string3 = resultSet.getString(5).trim();
                        String string4 = resultSet.getString(6).trim();
                        String string5 = resultSet.getString(7);
                        int n5 = resultSet.getInt(8);
                        String string6 = resultSet.getString(9);
                        SequenceDB2 sequenceDB2 = storageDesignDB2v80.getSequenceSet().createSequence();
                        sequenceDB2.setName(string);
                        this.stampModelObject(sequenceDB2, dBObject);
                        Owner owner = (Owner)storageDesignDB2v80.getOwnerSet().getByName(string2);
                        if (owner != null) {
                            sequenceDB2.setOwner(owner);
                        } else {
                            owner = (Owner)storageDesignDB2v80.getOwnerSet().createElement(string2);
                            owner.setName(string2);
                            this.stampModelObject((ModelObject)owner, "", string2);
                        }
                        if (n2 != 0) {
                            this.initDatatype(connection, sequenceDB2, n);
                        } else if (n == 496) {
                            sequenceDB2.setDatatype("INTEGER");
                        } else if (n == 500) {
                            sequenceDB2.setDatatype("SMALLINT");
                        } else if (n == 484) {
                            sequenceDB2.setDatatype("DECIMAL");
                        }
                        sequenceDB2.setStartWith(n3);
                        sequenceDB2.setIncrementBy(n4);
                        sequenceDB2.setMinValue(string3);
                        sequenceDB2.setMaxValue(string4);
                        if ("N".equalsIgnoreCase(string5)) {
                            sequenceDB2.setCycle("NO");
                        } else {
                            sequenceDB2.setCycle("YES");
                        }
                        sequenceDB2.setCache(n5);
                        if ("N".equalsIgnoreCase(string6)) {
                            sequenceDB2.setOrder("NO");
                        } else {
                            sequenceDB2.setOrder("YES");
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    private void initDatatype(Connection connection, SequenceDB2 sequenceDB2, int n) throws Exception {
        CharSequence charSequence;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT NAME ");
            ((StringBuffer)charSequence).append("from SYSIBM.SYSDATATYPES ");
            ((StringBuffer)charSequence).append("WHERE DATATYPEID = ").append(n);
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHSequenceDB2v80.initDatatype():", sQLException);
        }
        if (resultSet != null) {
            if (resultSet.next()) {
                charSequence = resultSet.getString(1);
                sequenceDB2.setDatatype((String)charSequence);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT name from SYSIBM.SYSSEQUENCES").append(' ');
                ((StringBuffer)charSequence).append("WHERE SEQTYPE = 'S' and SCHEMA = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHSequenceDB2v80.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBObject.getName());
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return arrayList;
    }
}

