/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHView;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHViewDB2
extends MOHView {
    private static final Logger LOGGER = new Logger(MOHViewDB2.class);

    public MOHViewDB2(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT name from SYSIBM.SYSTABLES").append(' ');
                ((StringBuffer)charSequence).append("WHERE TYPE = 'V' and CREATOR = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHViewDB2.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, "VIEW", dBObject.getName());
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            String string2 = dBObject.getSchema();
            if (!"VIEW".equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT CHECK from SYSIBM.SYSVIEWS").append(' ');
                ((StringBuffer)object).append("WHERE NAME = '").append(dBObject.getName()).append("'");
                ((StringBuffer)object).append(" AND CREATOR = '").append(string2).append("'");
                statement = connection.prepareStatement(((StringBuffer)object).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHViewDB2.generate():", sQLException);
                LOGGER.error("MOHViewDB2: name: " + string);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    object = this.getDesign().getRelationalDesign().getTableViewSet().createTableView(null);
                    ((DesignObject)object).setName(string);
                    ((ContainerObject)object).setSchema(string2);
                    this.stampModelObject((ModelObject)object, dBObject);
                    ((AbstractView)object).setSyntaxProvider("DB2");
                    String string3 = resultSet.getString(1);
                    this.initViewBody(connection, (TableView)object, string2);
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)storageDesign;
                        TableViewProxyDB2 tableViewProxyDB2 = (TableViewProxyDB2)abstractStorageDesignDB2.getTableViewProxySet().getProxy(((ModelIDObject)object).getObjectID());
                        if ("N".equalsIgnoreCase(string3)) {
                            tableViewProxyDB2.setCheckOption(false);
                        } else {
                            tableViewProxyDB2.setCheckOption(true);
                        }
                        Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().getByName(string2);
                        if (owner == null) {
                            owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement(string2);
                            owner.setName(string2);
                            this.stampModelObject((ModelObject)owner, "", string2);
                        }
                        if (owner != null) {
                            tableViewProxyDB2.setOwner(owner);
                        }
                        this.initSynonyms(connection, tableViewProxyDB2);
                    }
                }
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    private void initViewBody(Connection connection, TableView tableView, String string) throws Exception {
        int n = connection.getMetaData().getDatabaseMajorVersion();
        if (n < 10) {
            StringBuffer stringBuffer;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT TEXT ");
                stringBuffer.append("FROM SYSIBM.SYSVIEWS ");
                stringBuffer.append("WHERE NAME = '");
                stringBuffer.append(tableView.getName()).append("'");
                stringBuffer.append(" AND CREATOR = '").append(string).append("'");
                stringBuffer.append(" ORDER BY SEQNO ");
                statement = connection.prepareStatement(stringBuffer.toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHViewDB2.initViewBody():", sQLException);
            }
            stringBuffer = new StringBuffer();
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    stringBuffer.append(string2);
                }
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            tableView.setUserDefinedSQL(stringBuffer.toString());
            tableView.setUserDefined(true);
            tableView.getColumns(stringBuffer.toString().replaceAll("\n", " ").replaceAll("\r", " ").replaceAll("\t", " ").replaceAll("   ", " ").replaceAll("  ", " "));
        } else {
            StringBuffer stringBuffer;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT statement ");
                stringBuffer.append("FROM SYSIBM.SYSVIEWS ");
                stringBuffer.append("WHERE NAME = '");
                stringBuffer.append(tableView.getName()).append("'");
                stringBuffer.append(" AND CREATOR = '").append(string).append("'");
                stringBuffer.append(" ORDER BY SEQNO ");
                statement = connection.prepareStatement(stringBuffer.toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHViewDB2.initViewBody():", sQLException);
            }
            stringBuffer = new StringBuffer();
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    stringBuffer.append(string3);
                }
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            tableView.setUserDefinedSQL(stringBuffer.toString());
            tableView.setUserDefined(true);
            tableView.getColumns(stringBuffer.toString().replaceAll("\n", " ").replaceAll("\r", " ").replaceAll("\t", " ").replaceAll("   ", " ").replaceAll("  ", " "));
        }
    }

    private void initSynonyms(Connection connection, TableViewProxyDB2 tableViewProxyDB2) throws Exception {
        CharSequence charSequence;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT NAME, CREATOR ");
            ((StringBuffer)charSequence).append("from SYSIBM.SYSSYNONYMS ");
            ((StringBuffer)charSequence).append("WHERE TBNAME = '");
            ((StringBuffer)charSequence).append(tableViewProxyDB2.getName()).append("'");
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHViewDB2.initSynonyms():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string = resultSet.getString(2);
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 abstractStorageDesignDB2 = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    abstractStorageDesignDB2 = (AbstractStorageDesignDB2)storageDesign;
                }
                if (abstractStorageDesignDB2 != null) {
                    SynonymDB2 synonymDB2 = abstractStorageDesignDB2.getSynonymSet().createSynonym();
                    synonymDB2.setName((String)charSequence);
                    synonymDB2.setView(tableViewProxyDB2);
                    this.stampModelObject((ModelObject)synonymDB2, string, (String)charSequence);
                    Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().getByName(string);
                    if (owner == null) continue;
                    synonymDB2.setOwner(owner);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }
}

