/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTablespaceDB2
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHTablespaceDB2.class);

    public MOHTablespaceDB2(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT TYPE, PARTITIONS, DBNAME, ");
                ((StringBuffer)object).append("DSSIZE, SEGSIZE, BPOOL, LOCKRULE, LOCKMAX, ");
                ((StringBuffer)object).append("CLOSERULE, ENCODING_SCHEME, LOCKPART, MAXROWS, ");
                ((StringBuffer)object).append("OBID, PSID, NACTIVE, CREATEDBY, SPACE ");
                ((StringBuffer)object).append("from SYSIBM.SYSTABLESPACE").append(' ');
                ((StringBuffer)object).append("WHERE NAME = '").append(string).append("'");
                statement = connection.prepareStatement(((StringBuffer)object).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTablespaceDB2.generate():", sQLException);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    object = this.getStorageDesign();
                    if (object != null && object instanceof AbstractStorageDesignDB2) {
                        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)object;
                        String string2 = resultSet.getString(1);
                        int n = resultSet.getInt(2);
                        String string3 = resultSet.getString(3);
                        int n2 = resultSet.getInt(4);
                        int n3 = resultSet.getInt(5);
                        String string4 = resultSet.getString(6);
                        String string5 = resultSet.getString(7);
                        int n4 = resultSet.getInt(8);
                        String string6 = resultSet.getString(9);
                        String string7 = resultSet.getString(10);
                        String string8 = resultSet.getString(11);
                        int n5 = resultSet.getInt(12);
                        int n6 = resultSet.getInt(13);
                        int n7 = resultSet.getInt(14);
                        int n8 = resultSet.getInt(15);
                        String string9 = resultSet.getString(16);
                        int n9 = resultSet.getInt(17);
                        DataBaseDB2 dataBaseDB2 = (DataBaseDB2)abstractStorageDesignDB2.getDataBaseSet().getByName(string3);
                        if (dataBaseDB2 != null) {
                            TableSpaceDB2 tableSpaceDB2 = abstractStorageDesignDB2.getTableSpaceSet().createTableSpace();
                            tableSpaceDB2.setName(string);
                            tableSpaceDB2.setDataBase(dataBaseDB2);
                            this.stampModelObject(tableSpaceDB2, dBObject);
                            if ("L".equalsIgnoreCase(string2)) {
                                tableSpaceDB2.setType("LOB");
                            }
                            tableSpaceDB2.setDsSize(n2 / 0x100000 + " G");
                            tableSpaceDB2.setSegSize("" + n3);
                            BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)abstractStorageDesignDB2.getBufferPoolSet().getByName(string4);
                            if (bufferPoolDB2 != null) {
                                tableSpaceDB2.setBufferPool(bufferPoolDB2);
                            }
                            if ("A".equalsIgnoreCase(string5)) {
                                tableSpaceDB2.setLockSize("ANY");
                            } else if ("L".equalsIgnoreCase(string5)) {
                                tableSpaceDB2.setLockSize("LOB");
                            } else if ("P".equalsIgnoreCase(string5)) {
                                tableSpaceDB2.setLockSize("PAGE");
                            } else if ("R".equalsIgnoreCase(string5)) {
                                tableSpaceDB2.setLockSize("ROW");
                            } else if ("S".equalsIgnoreCase(string5)) {
                                tableSpaceDB2.setLockSize(OBJECT_TYPE);
                            } else if ("T".equalsIgnoreCase(string5)) {
                                tableSpaceDB2.setLockSize("TABLE");
                            }
                            tableSpaceDB2.setLockMax(n4);
                            if ("N".equalsIgnoreCase(string6)) {
                                tableSpaceDB2.setClose(false);
                            } else {
                                tableSpaceDB2.setClose(true);
                            }
                            if (string7.trim().equalsIgnoreCase("E")) {
                                tableSpaceDB2.setCcsid("EBCDIC");
                            } else if (string7.trim().equalsIgnoreCase("A")) {
                                tableSpaceDB2.setCcsid("ASCII");
                            } else if (string7.trim().equalsIgnoreCase("U")) {
                                tableSpaceDB2.setCcsid("UNICODE");
                            }
                            if ("Y".equalsIgnoreCase(string8)) {
                                tableSpaceDB2.setLockPart(true);
                            } else {
                                tableSpaceDB2.setClose(false);
                            }
                            tableSpaceDB2.setMaxRows(n5);
                            tableSpaceDB2.setObid(n6);
                            tableSpaceDB2.setPsid(n7);
                            tableSpaceDB2.setNactive(n8);
                            tableSpaceDB2.setCreatedBy(string9);
                            tableSpaceDB2.setSpace(n9);
                            tableSpaceDB2.setNumParts(n);
                            if (n > 0) {
                                tableSpaceDB2.setType("PARTITIONED");
                                this.initTablespacePartitions(connection, tableSpaceDB2);
                            }
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    private void initTablespacePartitions(Connection connection, TableSpaceDB2 tableSpaceDB2) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT PARTITION, COMPRESS, ");
            stringBuffer.append("VCATNAME, STORNAME, PQTY, SQTY, FREEPAGE, PCTFREE, GBPCACHE, TRACKMOD ");
            stringBuffer.append("from SYSIBM.SYSTABLEPART ");
            stringBuffer.append("WHERE TSNAME = '");
            stringBuffer.append(tableSpaceDB2.getName()).append("'");
            stringBuffer.append("ORDER BY PARTITION");
            statement = connection.prepareStatement(stringBuffer.toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHTablespaceDB2.initTablespacePartitions():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                String string3 = resultSet.getString(4).trim();
                int n2 = resultSet.getInt(5) * 4;
                int n3 = resultSet.getInt(6) * 4;
                int n4 = resultSet.getInt(7);
                int n5 = resultSet.getInt(8);
                String string4 = resultSet.getString(9);
                String string5 = resultSet.getString(10);
                if (n <= 0) continue;
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 abstractStorageDesignDB2 = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    AbstractStorageObjectDB2 abstractStorageObjectDB2;
                    abstractStorageDesignDB2 = (AbstractStorageDesignDB2)storageDesign;
                    tableSpaceDB2.setType("PARTITIONED");
                    PartitionDB2 partitionDB2 = abstractStorageDesignDB2.getPartitionSet().createPartition();
                    partitionDB2.setTableSpace(tableSpaceDB2);
                    partitionDB2.setPartNumber(n);
                    if ("Y".equalsIgnoreCase(string)) {
                        partitionDB2.setCompress(true);
                    } else {
                        partitionDB2.setCompress(false);
                    }
                    StorageTemplateDB2 storageTemplateDB2 = abstractStorageDesignDB2.getStorageTemplateSet().createStorageTemplate();
                    partitionDB2.setStorageTemplate(storageTemplateDB2);
                    if (!"".equalsIgnoreCase(string3)) {
                        abstractStorageObjectDB2 = (StorageGroupDB2)abstractStorageDesignDB2.getStorageGroupSet().getByName(string3);
                        if (abstractStorageObjectDB2 != null) {
                            storageTemplateDB2.setStorageGroup((StorageGroupDB2)abstractStorageObjectDB2);
                        }
                    } else {
                        abstractStorageObjectDB2 = (VCatDB2)abstractStorageDesignDB2.getVCatSet().getByName(string2);
                        if (abstractStorageObjectDB2 != null) {
                            storageTemplateDB2.setVCat((VCatDB2)abstractStorageObjectDB2);
                        }
                    }
                    storageTemplateDB2.setSgPriqty(n2);
                    storageTemplateDB2.setSgSeqty(n3);
                    storageTemplateDB2.setFreePage(n4);
                    storageTemplateDB2.setPctFree(n5);
                    if ("A".equalsIgnoreCase(string4)) {
                        storageTemplateDB2.setGbCache("ALL");
                    } else if ("N".equalsIgnoreCase(string4)) {
                        storageTemplateDB2.setGbCache("NONE");
                    } else if ("S".equalsIgnoreCase(string4)) {
                        storageTemplateDB2.setGbCache("SYSTEM");
                    } else if ("".equalsIgnoreCase(string4)) {
                        storageTemplateDB2.setGbCache("CHANGED");
                    }
                    if ("N".equalsIgnoreCase(string5)) {
                        storageTemplateDB2.setTrackMode(false);
                    } else {
                        storageTemplateDB2.setTrackMode(true);
                    }
                    if ((abstractStorageObjectDB2 = abstractStorageDesignDB2.getStorageTemplateSet().removeIfExistEqual(storageTemplateDB2)) == partitionDB2.getStorageTemplate()) continue;
                    partitionDB2.setStorageTemplate((StorageTemplateDB2)abstractStorageObjectDB2);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT name from SYSIBM.SYSTABLESPACE").append(' ');
                ((StringBuffer)charSequence).append("WHERE CREATOR = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHTablespaceDB2.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBObject.getName());
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return arrayList;
    }
}

