/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.MOHForeignKey;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHForeignKeyDB2
extends MOHForeignKey {
    private static final Logger LOGGER = new Logger(MOHForeignKeyDB2.class);

    public MOHForeignKeyDB2(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.getStorageDesign();
        TableProxySetDB2 tableProxySetDB2 = (TableProxySetDB2)abstractStorageDesignDB2.getTableProxySet();
        if (tableProxySetDB2.size() > 0) {
            Statement statement = null;
            Iterator iterator = tableProxySetDB2.iterator();
            while (iterator.hasNext()) {
                Object object;
                TableProxyDB2 tableProxyDB2 = (TableProxyDB2)iterator.next();
                ResultSet resultSet = null;
                try {
                    if (statement == null) {
                        object = new StringBuffer();
                        ((StringBuffer)object).append("SELECT A.RELNAME, A.REFTBNAME, ");
                        ((StringBuffer)object).append("A.IXNAME, A.DELETERULE, ");
                        ((StringBuffer)object).append("A.TBNAME, A.CREATOR, A.REFTBCREATOR ");
                        ((StringBuffer)object).append("FROM SYSIBM.SYSRELS A ");
                        ((StringBuffer)object).append("WHERE A.TBNAME = ? AND A.CREATOR = ?");
                        statement = connection.prepareStatement(((StringBuffer)object).toString());
                    }
                    statement.setString(1, tableProxyDB2.getName());
                    statement.setString(2, tableProxyDB2.getOwner().getName());
                    resultSet = statement.executeQuery();
                }
                catch (SQLException sQLException) {
                    LOGGER.error("MOHForeignKeyDB2.initForeignKeys():", sQLException);
                }
                object = (Table)tableProxyDB2.getObject();
                RelationalDesign relationalDesign = (RelationalDesign)((DesignObject)object).getDesignPart();
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    String string3 = resultSet.getString(3);
                    String string4 = resultSet.getString(4);
                    String string5 = resultSet.getString(5);
                    String string6 = resultSet.getString(6).trim();
                    String string7 = resultSet.getString(7).trim();
                    TableProxyDB2 tableProxyDB22 = tableProxyDB2;
                    RelationalDesign relationalDesign2 = tableProxyDB22.getStorageDesign().getPhysicalDesign().getRelatedSyncModel();
                    Table table = relationalDesign.getTableSet().getBySchemaAndName(string7, string2);
                    if (table == null && relationalDesign2 != null) {
                        table = relationalDesign2.getTableSet().getBySchemaAndName(string7, string2);
                    }
                    if (table == null) continue;
                    FKIndexAssociation fKIndexAssociation = null;
                    FKIndexAssociation[] fKIndexAssociationArray = ((Table)object).getFKIndexAssociationsWith(table);
                    for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
                        if (!fKIndexAssociationArray[i].getName().equals(string)) continue;
                        fKIndexAssociation = fKIndexAssociationArray[i];
                        break;
                    }
                    if (fKIndexAssociation == null) {
                        Index index = null;
                        if (string3.trim().equalsIgnoreCase("")) {
                            index = (Index)table.getPK();
                        } else {
                            TableProxyDB2 tableProxyDB23 = (TableProxyDB2)abstractStorageDesignDB2.getTableProxySet().getProxy(table.getObjectID());
                            IndexProxyDB2 indexProxyDB2 = (IndexProxyDB2)tableProxyDB23.getIntIndexes().getByName(string3);
                            if (indexProxyDB2 != null) {
                                index = (Index)indexProxyDB2.getObject();
                            } else {
                                System.out.println();
                            }
                        }
                        if (index != null) {
                            fKIndexAssociation = ((Table)object).addFK(index);
                            if (string != null) {
                                fKIndexAssociation.setName(string);
                                fKIndexAssociation.getLocalFKIndex().setName(string);
                                this.stampModelObject((ModelObject)fKIndexAssociation, string6, string);
                            }
                            this.initColumns(connection, fKIndexAssociation, (Table)object, index, string5, string6);
                        }
                    }
                    if (fKIndexAssociation != null) {
                        fKIndexAssociation.resetMandatoryUsingColumns();
                        if ("A".equals(string4)) {
                            fKIndexAssociation.setDeleteRule("NO ACTION");
                            continue;
                        }
                        if ("C".equals(string4)) {
                            fKIndexAssociation.setDeleteRule("CASCADE");
                            continue;
                        }
                        if ("N".equals(string4)) {
                            fKIndexAssociation.setDeleteRule("SET NULL");
                            continue;
                        }
                        if (!"R".equals(string4)) continue;
                        fKIndexAssociation.setDeleteRule("RESTRICT");
                        continue;
                    }
                    System.out.println();
                }
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    private void initColumns(Connection connection, FKIndexAssociation fKIndexAssociation, Table table, Index index, String string, String string2) throws Exception {
        CharSequence charSequence;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT B.COLNAME, B.COLSEQ ");
            ((StringBuffer)charSequence).append("FROM SYSIBM.SYSFOREIGNKEYS B ");
            ((StringBuffer)charSequence).append("WHERE B.TBNAME = '").append(string).append("'");
            ((StringBuffer)charSequence).append(" AND B.RELNAME = '").append(fKIndexAssociation.getName().trim()).append("'");
            ((StringBuffer)charSequence).append(" AND B.CREATOR = '").append(string2).append("'");
            ((StringBuffer)charSequence).append(" ORDER BY B.RELNAME, B.COLSEQ");
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHForeignKeyDB2.initColumns():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                int n = resultSet.getInt(2);
                Column column = (Column)table.getElementByName((String)charSequence);
                Column column2 = null;
                try {
                    column2 = (Column)index.getElement(n - 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                if (column == null || column2 == null) continue;
                column.addFKAssociation(column2, fKIndexAssociation);
                fKIndexAssociation.getLocalFKIndex().add(column);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private TableProxyDB2 getTableProxy(TableProxySetDB2 tableProxySetDB2, String string, String string2) {
        Iterator iterator = tableProxySetDB2.iterator();
        while (iterator.hasNext()) {
            TableProxyDB2 tableProxyDB2 = (TableProxyDB2)iterator.next();
            if (!tableProxyDB2.getName().equalsIgnoreCase(string) || !tableProxyDB2.getOwner().getName().equalsIgnoreCase(string2)) continue;
            return tableProxyDB2;
        }
        return null;
    }
}

