/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.PrivilegesDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDatabaseDB2
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "DATABASE";
    private static final Logger LOGGER = new Logger(MOHDatabaseDB2.class);
    protected static final String DBADM = "DBADM";
    protected static final String DBCTRL = "DBCTRL";
    protected static final String DBMAINT = "DBMAINT";
    protected static final String CREATETAB = "CREATETAB";
    protected static final String CREATETS = "CREATETS";
    protected static final String DISPLAYDB = "DISPLAYDB";
    protected static final String DROP = "DROP";
    protected static final String IMAGCOMPY = "IMAGCOMPY";
    protected static final String LOAD = "LOAD";
    protected static final String RECOVERDB = "RECOVERDB";
    protected static final String REORG = "REORG";
    protected static final String REPAIR = "REPAIR";
    protected static final String STARTDB = "STARTDB";
    protected static final String STATS = "STATS";
    protected static final String STOPDB = "STOPDB";
    protected static final String Y = "Y";
    protected static final String G = "G";

    public MOHDatabaseDB2(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT BPOOL, INDEXBP, TYPE, GROUP_MEMBER, STGROUP, ENCODING_SCHEME").append(' ');
                ((StringBuffer)object).append("from SYSIBM.SYSDATABASE").append(' ');
                ((StringBuffer)object).append("WHERE NAME = '").append(string).append("'");
                statement = connection.prepareStatement(((StringBuffer)object).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHDatabaseDB2.generate():", sQLException);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    object = this.getStorageDesign();
                    if (object != null && object instanceof AbstractStorageDesignDB2) {
                        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)object;
                        String string2 = resultSet.getString(1);
                        String string3 = resultSet.getString(2);
                        String string4 = resultSet.getString(3);
                        String string5 = resultSet.getString(4);
                        String string6 = resultSet.getString(5);
                        String string7 = resultSet.getString(6);
                        DataBaseDB2 dataBaseDB2 = abstractStorageDesignDB2.getDataBaseSet().createDataBase();
                        dataBaseDB2.setName(string);
                        this.stampModelObject(dataBaseDB2, dBObject);
                        BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)abstractStorageDesignDB2.getBufferPoolSet().getByName(string2);
                        if (bufferPoolDB2 != null) {
                            dataBaseDB2.setBufferPool(bufferPoolDB2);
                        }
                        if ((bufferPoolDB2 = (BufferPoolDB2)abstractStorageDesignDB2.getBufferPoolSet().getByName(string3)) != null) {
                            dataBaseDB2.setIndexBufferPool(bufferPoolDB2);
                        }
                        if (string4.trim().equalsIgnoreCase("T")) {
                            dataBaseDB2.setType("TEMP");
                        } else if (string4.trim().equalsIgnoreCase("W")) {
                            dataBaseDB2.setType("WORKFILE");
                        }
                        dataBaseDB2.setMember(string5);
                        if (!"".equalsIgnoreCase(string6.trim())) {
                            StorageGroupDB2 storageGroupDB2 = (StorageGroupDB2)abstractStorageDesignDB2.getStorageGroupSet().getByName(string6);
                            if (storageGroupDB2 == null) {
                                storageGroupDB2 = abstractStorageDesignDB2.getStorageGroupSet().createStorageGroup();
                                storageGroupDB2.setName(string6);
                                this.stampModelObject((ModelObject)storageGroupDB2, dBObject.getSchema(), string6);
                            }
                            dataBaseDB2.setStorageGroup(storageGroupDB2);
                        }
                        if (string7.trim().equalsIgnoreCase("E")) {
                            dataBaseDB2.setCcsid("EBCDIC");
                        } else if (string7.trim().equalsIgnoreCase("A")) {
                            dataBaseDB2.setCcsid("ASCII");
                        } else if (string7.trim().equalsIgnoreCase("U")) {
                            dataBaseDB2.setCcsid("UNICODE");
                        }
                        this.initPrivileges(connection, dataBaseDB2, abstractStorageDesignDB2);
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    private void initPrivileges(Connection connection, DataBaseDB2 dataBaseDB2, AbstractStorageDesignDB2 abstractStorageDesignDB2) throws Exception {
        CharSequence charSequence;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT GRANTOR, CREATETABAUTH, CREATETSAUTH, ");
            ((StringBuffer)charSequence).append("DBADMAUTH, DBCTRLAUTH, DBMAINTAUTH, DISPLAYDBAUTH, ");
            ((StringBuffer)charSequence).append("DROPAUTH, IMAGCOPYAUTH, LOADAUTH, REORGAUTH, ");
            ((StringBuffer)charSequence).append("RECOVERDBAUTH, REPAIRAUTH, STARTDBAUTH, STATSAUTH, STOPAUTH ");
            ((StringBuffer)charSequence).append("from SYSIBM.SYSDBAUTH ");
            ((StringBuffer)charSequence).append("WHERE NAME = '");
            ((StringBuffer)charSequence).append(dataBaseDB2.getName()).append("'");
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHDatabaseDB2.initPrivileges():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1).trim();
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                String string3 = resultSet.getString(4);
                String string4 = resultSet.getString(5);
                String string5 = resultSet.getString(6);
                String string6 = resultSet.getString(7);
                String string7 = resultSet.getString(8);
                String string8 = resultSet.getString(9);
                String string9 = resultSet.getString(10);
                String string10 = resultSet.getString(11);
                String string11 = resultSet.getString(12);
                String string12 = resultSet.getString(13);
                String string13 = resultSet.getString(14);
                String string14 = resultSet.getString(15);
                String string15 = resultSet.getString(16);
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                boolean bl2 = true;
                if (string.equalsIgnoreCase(Y)) {
                    stringBuffer.append(CREATETAB);
                    bl2 = false;
                } else if (string.equalsIgnoreCase(G)) {
                    stringBuffer.append(CREATETAB);
                    bl2 = false;
                    bl = true;
                }
                if (string2.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(CREATETS);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(CREATETS);
                    }
                } else if (string2.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(CREATETS);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(CREATETS);
                    }
                    bl = true;
                }
                if (string3.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(DBADM);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DBADM);
                    }
                } else if (string3.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(DBADM);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DBADM);
                    }
                    bl = true;
                }
                if (string4.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(DBCTRL);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DBCTRL);
                    }
                } else if (string4.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(DBCTRL);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DBCTRL);
                    }
                    bl = true;
                }
                if (string5.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(DBMAINT);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DBMAINT);
                    }
                } else if (string5.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(DBMAINT);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DBMAINT);
                    }
                    bl = true;
                }
                if (string6.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(DISPLAYDB);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DISPLAYDB);
                    }
                } else if (string6.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(DISPLAYDB);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DISPLAYDB);
                    }
                    bl = true;
                }
                if (string7.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(DROP);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DROP);
                    }
                } else if (string7.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(DROP);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(DROP);
                    }
                    bl = true;
                }
                if (string8.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(IMAGCOMPY);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(IMAGCOMPY);
                    }
                } else if (string8.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(IMAGCOMPY);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(IMAGCOMPY);
                    }
                    bl = true;
                }
                if (string9.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(LOAD);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(LOAD);
                    }
                } else if (string9.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(LOAD);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(LOAD);
                    }
                    bl = true;
                }
                if (string11.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(RECOVERDB);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(RECOVERDB);
                    }
                } else if (string11.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(RECOVERDB);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(RECOVERDB);
                    }
                    bl = true;
                }
                if (string10.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(REORG);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(REORG);
                    }
                } else if (string10.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(REORG);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(REORG);
                    }
                    bl = true;
                }
                if (string12.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(REPAIR);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(REPAIR);
                    }
                } else if (string12.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(REPAIR);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(REPAIR);
                    }
                    bl = true;
                }
                if (string13.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(STARTDB);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(STARTDB);
                    }
                } else if (string12.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(STARTDB);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(STARTDB);
                    }
                    bl = true;
                }
                if (string14.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(STATS);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(STATS);
                    }
                } else if (string14.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(STATS);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(STATS);
                    }
                    bl = true;
                }
                if (string15.equalsIgnoreCase(Y)) {
                    if (bl2) {
                        stringBuffer.append(STOPDB);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(STOPDB);
                    }
                } else if (string15.equalsIgnoreCase(G)) {
                    if (bl2) {
                        stringBuffer.append(STOPDB);
                        bl2 = false;
                    } else {
                        stringBuffer.append(',');
                        stringBuffer.append(STOPDB);
                    }
                    bl = true;
                }
                PrivilegesDB2 privilegesDB2 = abstractStorageDesignDB2.getPrivilegesSet().createPriv();
                privilegesDB2.setDb(dataBaseDB2);
                Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().getByName((String)charSequence);
                if (owner == null) {
                    owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement((String)charSequence);
                    owner.setName((String)charSequence);
                    this.stampModelObject((ModelObject)owner, "", (String)charSequence);
                }
                privilegesDB2.setUser(owner);
                privilegesDB2.setSystemPrivileges(stringBuffer.toString());
                if (bl) {
                    privilegesDB2.setGrantOption("YES");
                    continue;
                }
                privilegesDB2.setGrantOption("NO");
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT name from SYSIBM.SYSDATABASE").append(' ');
                ((StringBuffer)charSequence).append("WHERE CREATOR = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHDatabaseDB2.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBObject.getName());
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return arrayList;
    }
}

