/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHAuxTableDB2
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "AUX TABLE";
    private static final Logger LOGGER = new Logger(MOHAuxTableDB2.class);

    public MOHAuxTableDB2(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DBObject dBObject = (DBObject)list.get(i);
            String string = dBObject.getName();
            String string2 = dBObject.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT TSNAME from SYSIBM.SYSTABLES ");
                ((StringBuffer)object).append("WHERE TYPE = 'X' and NAME = '");
                ((StringBuffer)object).append(dBObject.getName()).append("' and CREATOR = '").append(string2).append("'");
                statement = connection.prepareStatement(((StringBuffer)object).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHAuxTableDB2.generate():", sQLException);
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    object = this.getStorageDesign();
                    if (object != null && object instanceof AbstractStorageDesignDB2) {
                        TableSpaceDB2 tableSpaceDB2;
                        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)object;
                        String string3 = resultSet.getString(1);
                        AUXTableDB2 aUXTableDB2 = abstractStorageDesignDB2.getAUXTableSet().createAUXTable();
                        aUXTableDB2.setName(string);
                        this.stampModelObject(aUXTableDB2, dBObject);
                        Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().getByName(string2);
                        if (owner == null) {
                            owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement(string2);
                            owner.setName(string2);
                            this.stampModelObject((ModelObject)owner, "", string2);
                        }
                        if (owner != null) {
                            aUXTableDB2.setOwner(owner);
                        }
                        if ((tableSpaceDB2 = (TableSpaceDB2)abstractStorageDesignDB2.getTableSpaceSet().getByName(string3)) != null) {
                            aUXTableDB2.setTableSpace(tableSpaceDB2);
                        }
                        this.initProps(connection, aUXTableDB2, string2);
                        this.initAuxIndexes(connection, aUXTableDB2, string2);
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    private void initProps(Connection connection, AUXTableDB2 aUXTableDB2, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT TBNAME, COLNAME, PARTITION ");
            ((StringBuffer)charSequence).append("from SYSIBM.SYSAUXRELS ");
            ((StringBuffer)charSequence).append("WHERE AUXTBNAME = '");
            ((StringBuffer)charSequence).append(aUXTableDB2.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND AUXTBOWNER = '");
            ((StringBuffer)charSequence).append(string).append("'");
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHAuxTableDB2.initProps():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                int n = resultSet.getInt(3);
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 abstractStorageDesignDB2 = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    abstractStorageDesignDB2 = (AbstractStorageDesignDB2)storageDesign;
                    TableProxyDB2 tableProxyDB2 = ((TableProxySetDB2)abstractStorageDesignDB2.getTableProxySet()).getByName((String)charSequence);
                    if (tableProxyDB2 != null) {
                        aUXTableDB2.setTable(tableProxyDB2);
                        ColumnProxyDB2 columnProxyDB2 = (ColumnProxyDB2)tableProxyDB2.getColumnProxyByName(string2);
                        if (columnProxyDB2 != null) {
                            aUXTableDB2.setColumn(columnProxyDB2);
                        }
                    }
                    aUXTableDB2.setPartNumber(n);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initAuxIndexes(Connection connection, AUXTableDB2 aUXTableDB2, String string) throws Exception {
        CharSequence charSequence;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT i.NAME, i.PGSIZE, i.BPOOL, ");
            ((StringBuffer)charSequence).append("i.CLOSERULE, i.COPY, i.CREATOR ");
            ((StringBuffer)charSequence).append("from SYSIBM.SYSINDEXES i ");
            ((StringBuffer)charSequence).append("WHERE i.TBNAME = '");
            ((StringBuffer)charSequence).append(aUXTableDB2.getName()).append("'");
            ((StringBuffer)charSequence).append(" AND i.TBCREATOR = '");
            ((StringBuffer)charSequence).append(string).append("'");
            ((StringBuffer)charSequence).append(" AND not exists (");
            ((StringBuffer)charSequence).append(" select 1 from sysibm.systabconst t ");
            ((StringBuffer)charSequence).append("where ");
            ((StringBuffer)charSequence).append("t.ixowner = i.creator and ");
            ((StringBuffer)charSequence).append("t.ixname = i.name)");
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHAuxTableDB2.initAuxIndexes():", sQLException);
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                int n = resultSet.getInt(2);
                String string2 = resultSet.getString(3);
                String string3 = resultSet.getString(4);
                String string4 = resultSet.getString(5);
                String string5 = resultSet.getString(6);
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 abstractStorageDesignDB2 = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    abstractStorageDesignDB2 = (AbstractStorageDesignDB2)storageDesign;
                    AUXTableIndexDB2 aUXTableIndexDB2 = abstractStorageDesignDB2.getAUXTableIndexSet().createAUXTableIndex();
                    aUXTableIndexDB2.setAuxTable(aUXTableDB2);
                    aUXTableIndexDB2.setName((String)charSequence);
                    this.stampModelObject((ModelObject)aUXTableIndexDB2, string, (String)charSequence);
                    Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().getByName(string5);
                    if (owner != null) {
                        aUXTableIndexDB2.setOwner(owner);
                    }
                    aUXTableIndexDB2.setPieceSize(n + " K");
                    BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)abstractStorageDesignDB2.getBufferPoolSet().getByName(string2);
                    if (bufferPoolDB2 != null) {
                        aUXTableIndexDB2.setBufferPool(bufferPoolDB2);
                    }
                    if ("Y".equalsIgnoreCase(string3)) {
                        aUXTableIndexDB2.setClose(true);
                    } else {
                        aUXTableIndexDB2.setClose(false);
                    }
                    if ("Y".equalsIgnoreCase(string4)) {
                        aUXTableIndexDB2.setCopy(true);
                    } else {
                        aUXTableIndexDB2.setCopy(false);
                    }
                    this.initStorageTemplate(connection, aUXTableIndexDB2);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initStorageTemplate(Connection connection, AUXTableIndexDB2 aUXTableIndexDB2) throws Exception {
        CharSequence charSequence;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SELECT VCATNAME, STORNAME, PQTY, SQTY, ");
            ((StringBuffer)charSequence).append("FREEPAGE, PCTFREE, GBPCACHE ");
            ((StringBuffer)charSequence).append("from SYSIBM.SYSINDEXPART ");
            ((StringBuffer)charSequence).append("WHERE IXNAME = '");
            ((StringBuffer)charSequence).append(aUXTableIndexDB2.getName()).append("'");
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("MOHAuxTableDB2.initStorageTemplate():", sQLException);
        }
        if (resultSet != null) {
            if (resultSet.next()) {
                charSequence = resultSet.getString(1);
                String string = resultSet.getString(2).trim();
                int n = resultSet.getInt(3);
                int n2 = resultSet.getInt(4);
                int n3 = resultSet.getInt(5);
                int n4 = resultSet.getInt(6);
                String string2 = resultSet.getString(7);
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 abstractStorageDesignDB2 = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    AbstractStorageObjectDB2 abstractStorageObjectDB2;
                    abstractStorageDesignDB2 = (AbstractStorageDesignDB2)storageDesign;
                    StorageTemplateDB2 storageTemplateDB2 = abstractStorageDesignDB2.getStorageTemplateSet().createStorageTemplate();
                    aUXTableIndexDB2.setStorageTemplate(storageTemplateDB2);
                    if (!"".equalsIgnoreCase(string)) {
                        abstractStorageObjectDB2 = (StorageGroupDB2)abstractStorageDesignDB2.getStorageGroupSet().getByName(string);
                        if (abstractStorageObjectDB2 != null) {
                            storageTemplateDB2.setStorageGroup((StorageGroupDB2)abstractStorageObjectDB2);
                        }
                    } else {
                        abstractStorageObjectDB2 = (VCatDB2)abstractStorageDesignDB2.getVCatSet().getByName((String)charSequence);
                        if (abstractStorageObjectDB2 != null) {
                            storageTemplateDB2.setVCat((VCatDB2)abstractStorageObjectDB2);
                        }
                    }
                    storageTemplateDB2.setSgPriqty(n);
                    storageTemplateDB2.setSgSeqty(n2);
                    storageTemplateDB2.setFreePage(n3);
                    storageTemplateDB2.setPctFree(n4);
                    if ("A".equalsIgnoreCase(string2)) {
                        storageTemplateDB2.setGbCache("ALL");
                    } else if ("N".equalsIgnoreCase(string2)) {
                        storageTemplateDB2.setGbCache("NONE");
                    } else if ("S".equalsIgnoreCase(string2)) {
                        storageTemplateDB2.setGbCache("SYSTEM");
                    } else if ("".equalsIgnoreCase(string2)) {
                        storageTemplateDB2.setGbCache("CHANGED");
                    }
                    abstractStorageObjectDB2 = abstractStorageDesignDB2.getStorageTemplateSet().removeIfExistEqual(storageTemplateDB2);
                    if (abstractStorageObjectDB2 != aUXTableIndexDB2.getStorageTemplate()) {
                        aUXTableIndexDB2.setStorageTemplate((StorageTemplateDB2)abstractStorageObjectDB2);
                    }
                } else {
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : list) {
            CharSequence charSequence;
            if (!dBObject.isSelected()) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT name from SYSIBM.SYSTABLES").append(' ');
                ((StringBuffer)charSequence).append("WHERE TYPE = 'X' and CREATOR = '");
                ((StringBuffer)charSequence).append(dBObject.getName()).append("'");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("MOHAuxTableDB2.extract(): " + sQLException.getMessage());
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), (String)charSequence, OBJECT_TYPE, dBObject.getName());
                    arrayList.add(dBObject2);
                }
                resultSet.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return arrayList;
    }
}

