/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.db2.MOHAliasDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHAuxTableDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHDatabaseDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHDatatypeDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHForeignKeyDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHOwnerDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHProcedureDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHStorageGroupDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHTableDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHTablespaceDB2;
import oracle.dbtools.crest.imports.metadata.db2.MOHViewDB2;
import oracle.dbtools.crest.imports.metadata.db2.v80.MOHProcedureDB2v80;
import oracle.dbtools.crest.imports.metadata.db2.v80.MOHSequenceDB2v80;
import oracle.dbtools.crest.imports.metadata.db2.v80.MOHTableDB2v80;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;

public final class DBMExtractionHandlerDB2
extends AbstractDBMExtractionHandler {
    private static DBMExtractionHandlerDB2 dbmExtractionHandler;
    private List mohObjectsv70 = null;
    private List mohObjectsv80 = null;
    private ApplicationView view;
    private static final Logger LOGGER;

    private DBMExtractionHandlerDB2(ApplicationView applicationView) {
        this.view = applicationView;
    }

    public static AbstractDBMExtractionHandler getInstance(ApplicationView applicationView) {
        if (dbmExtractionHandler == null) {
            dbmExtractionHandler = new DBMExtractionHandlerDB2(applicationView);
        }
        return dbmExtractionHandler;
    }

    public static void clearInstance() {
        dbmExtractionHandler = null;
    }

    @Override
    public List getMOHObjects() {
        switch (this.dbMajorVersion) {
            case 7: {
                return this.getMOHObjectsv70();
            }
            case 8: {
                return this.getMOHObjectsv80();
            }
        }
        return this.getMOHObjectsv80();
    }

    @Override
    public List getDBObjects(Connection connection, List list) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list2 = this.getMOHObjects();
        if (list2.size() > 0 && connection != null) {
            Object object;
            for (Object object2 : list2) {
                ((AbstractMOHandler)object2).reset();
                object = ((AbstractMOHandler)object2).extract(connection, list);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof DBObject)) continue;
                    arrayList.add((DBObject)e);
                }
            }
            for (Object object2 : this.getDB2Schemas(connection)) {
                object = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), ((DBObject)object2).getName(), "OWNER", ((DBObject)object2).getName());
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    public List getMOHObjectsv70() {
        if (this.mohObjectsv70 == null) {
            this.mohObjectsv70 = new ArrayList();
            this.mohObjectsv70.add(new MOHDatatypeDB2(this, this.view));
            this.mohObjectsv70.add(new MOHOwnerDB2(this, this.view));
            this.mohObjectsv70.add(new MOHStorageGroupDB2(this, this.view));
            this.mohObjectsv70.add(new MOHDatabaseDB2(this, this.view));
            this.mohObjectsv70.add(new MOHTablespaceDB2(this, this.view));
            this.mohObjectsv70.add(new MOHTableDB2(this, this.view));
            this.mohObjectsv70.add(new MOHForeignKeyDB2(this, this.view));
            this.mohObjectsv70.add(new MOHAuxTableDB2(this, this.view));
            this.mohObjectsv70.add(new MOHAliasDB2(this, this.view));
            this.mohObjectsv70.add(new MOHViewDB2(this, this.view));
            this.mohObjectsv70.add(new MOHProcedureDB2(this, this.view));
        }
        return this.mohObjectsv70;
    }

    public List getMOHObjectsv80() {
        if (this.mohObjectsv80 == null) {
            this.mohObjectsv80 = new ArrayList();
            this.mohObjectsv80.add(new MOHDatatypeDB2(this, this.view));
            this.mohObjectsv80.add(new MOHOwnerDB2(this, this.view));
            this.mohObjectsv80.add(new MOHStorageGroupDB2(this, this.view));
            this.mohObjectsv80.add(new MOHDatabaseDB2(this, this.view));
            this.mohObjectsv80.add(new MOHTablespaceDB2(this, this.view));
            this.mohObjectsv80.add(new MOHTableDB2v80(this, this.view));
            this.mohObjectsv80.add(new MOHForeignKeyDB2(this, this.view));
            this.mohObjectsv80.add(new MOHAuxTableDB2(this, this.view));
            this.mohObjectsv80.add(new MOHAliasDB2(this, this.view));
            this.mohObjectsv80.add(new MOHViewDB2(this, this.view));
            this.mohObjectsv80.add(new MOHSequenceDB2v80(this, this.view));
            this.mohObjectsv80.add(new MOHProcedureDB2v80(this, this.view));
        }
        return this.mohObjectsv80;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        switch (this.dbMajorVersion) {
            case 7: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignDB2v70.RDBMS_TYPE);
            }
            case 8: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignDB2v80.RDBMS_TYPE);
            }
        }
        return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignDB2v80.RDBMS_TYPE);
    }

    @Override
    public List getSchemas(Connection connection) throws Exception {
        ArrayList arrayList = new ArrayList();
        if (connection != null) {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try {
                this.dbProductName = databaseMetaData.getDatabaseProductName();
                this.dbProductVersion = databaseMetaData.getDatabaseProductVersion();
                this.dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
            }
            catch (Throwable throwable) {
                System.out.println(throwable.getMessage());
            }
            return this.getDB2Schemas(connection);
        }
        return arrayList;
    }

    public List getDB2Schemas(Connection connection) throws Exception {
        CharSequence charSequence;
        ArrayList<DBObject> arrayList = null;
        try {
            arrayList = super.getSchemas(connection);
        }
        catch (Exception exception) {
            LOGGER.error("MOHOwnerDB2.extract(): problem when getSchemas is used " + exception.getMessage());
        }
        if (arrayList == null) {
            arrayList = new ArrayList<DBObject>();
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("select distinct a.grantee from ");
            ((StringBuffer)charSequence).append("(SELECT distinct GRANTEE FROM SYSIBM.SYSPACKAUTH WHERE GRANTEETYPE = ' ' ");
            ((StringBuffer)charSequence).append("UNION ");
            ((StringBuffer)charSequence).append("SELECT distinct GRANTEE FROM SYSIBM.SYSTABAUTH WHERE GRANTEETYPE = ' ' ");
            ((StringBuffer)charSequence).append("UNION ");
            ((StringBuffer)charSequence).append("SELECT distinct GRANTEE FROM SYSIBM.SYSCOLAUTH WHERE GRANTEETYPE = ' ' ");
            ((StringBuffer)charSequence).append("UNION ");
            ((StringBuffer)charSequence).append("SELECT distinct GRANTEE FROM SYSIBM.SYSROUTINEAUTH WHERE GRANTEETYPE = ' ' ");
            ((StringBuffer)charSequence).append(") a ");
            ((StringBuffer)charSequence).append("where ");
            ((StringBuffer)charSequence).append("a.grantee not in ('PUBLIC','SYSIBM', 'PUBLIC*')");
            resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                charSequence = resultSet.getString(1).trim();
                DBObject dBObject = new DBObject(false, (String)charSequence);
                arrayList.add(dBObject);
            }
            resultSet.close();
        }
        return arrayList;
    }

    static {
        LOGGER = new Logger(DBMExtractionHandlerDB2.class);
    }
}

