/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class MOHView
extends AbstractMOHandler {
    PreparedStatement viewDefSt;
    PreparedStatement nullSchemaSt;
    public static final String OBJECT_TYPE = "VIEW";

    public MOHView(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    protected ResultSet getTables(DatabaseMetaData databaseMetaData, DBObject dBObject, boolean bl) throws Exception {
        if (bl) {
            return databaseMetaData.getTables(null, dBObject.getName(), "%", new String[]{OBJECT_TYPE});
        }
        return databaseMetaData.getTables(null, dBObject.getSchema(), dBObject.getName(), new String[]{OBJECT_TYPE});
    }

    protected ResultSet getColumns(DatabaseMetaData databaseMetaData, DBObject dBObject) throws Exception {
        return databaseMetaData.getColumns(null, dBObject.getSchema(), dBObject.getName(), "%");
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        for (DBObject dBObject : list) {
            if (!dBObject.isSelected()) continue;
            ResultSet resultSet = this.getTables(databaseMetaData, dBObject, true);
            while (resultSet.next()) {
                String string = resultSet.getString("TABLE_NAME");
                String string2 = resultSet.getString(2);
                if (string2 == null) {
                    string2 = dBObject.getName();
                }
                DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), string, OBJECT_TYPE, string2);
                arrayList.add(dBObject2);
            }
            resultSet.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        int n;
        this.viewDefSt = null;
        this.nullSchemaSt = null;
        boolean bl = true;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = databaseMetaData.getDatabaseProductName().toUpperCase();
        String string2 = null;
        for (n = 0; n < AbstractView.DB_SYNTAX_PROVIDERS.length; ++n) {
            if (!string.startsWith(AbstractView.DB_SYNTAX_PROVIDERS[n].toUpperCase())) continue;
            string2 = AbstractView.DB_SYNTAX_PROVIDERS[n];
            break;
        }
        for (n = 0; n < list.size(); ++n) {
            DBObject dBObject = (DBObject)list.get(n);
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            ResultSet resultSet = this.getTables(databaseMetaData, dBObject, false);
            if (resultSet.next() || resultSet != null) {
                ResultSet resultSet2;
                TableView tableView = this.getDesign().getRelationalDesign().getTableViewSet().createTableView(null);
                tableView.setSchema(dBObject.getSchema());
                tableView.setName(dBObject.getName());
                this.stampModelObject(tableView, dBObject);
                if (bl || this.isSupportInformation_Schema()) {
                    bl = false;
                    this.getViewDefinition(connection, tableView, dBObject);
                    if (string2 != null && !"".equals(tableView.getUserDefinedSQL())) {
                        tableView.setSyntaxProvider(string2);
                    }
                }
                if ((resultSet2 = this.getColumns(databaseMetaData, dBObject)) != null) {
                    while (resultSet2.next()) {
                        String string3 = resultSet2.getString(4);
                        String string4 = resultSet2.getString(5);
                        String string5 = resultSet2.getString(7);
                        String string6 = resultSet2.getString(10);
                        String string7 = resultSet2.getString(9);
                        AbstractViewElement abstractViewElement = tableView.createViewElement(tableView.getDesignPart());
                        abstractViewElement.setName(string3);
                        this.stampModelObject((ModelObject)abstractViewElement, tableView.getName(), string3);
                        abstractViewElement.setDesign(tableView.getDesign());
                        abstractViewElement.setAlias(string3);
                        abstractViewElement.setContainer(tableView);
                        tableView.add(abstractViewElement);
                    }
                    resultSet2.close();
                }
            }
            if (resultSet != null) {
                resultSet.close();
            }
            importLogger.incrementImportedStatements();
        }
        if (this.viewDefSt != null) {
            this.viewDefSt.close();
            this.viewDefSt = null;
        }
        if (this.nullSchemaSt != null) {
            this.nullSchemaSt.close();
            this.nullSchemaSt = null;
        }
    }

    private void getViewDefinition(Connection connection, TableView tableView, DBObject dBObject) {
        try {
            String string;
            ResultSet resultSet = null;
            if (dBObject.getSchema() != null && !"".equals(dBObject.getSchema())) {
                if (this.viewDefSt == null) {
                    string = "select view_definition from information_schema.views where table_name = ? and table_schema = ?";
                    this.viewDefSt = connection.prepareStatement(string);
                }
                this.viewDefSt.setString(1, dBObject.getName());
                this.viewDefSt.setString(2, dBObject.getSchema());
                resultSet = this.viewDefSt.executeQuery();
            } else {
                if (this.nullSchemaSt == null) {
                    string = "select view_definition from information_schema.views where table_name = ?";
                    this.nullSchemaSt = connection.prepareStatement(string);
                }
                this.nullSchemaSt.setString(1, dBObject.getName());
                resultSet = this.nullSchemaSt.executeQuery();
            }
            if (resultSet != null) {
                if (resultSet.next()) {
                    string = resultSet.getString(1);
                    String string2 = "CREATE VIEW " + tableView.getName();
                    tableView.setUserDefinedSQL(string2 + " \nAS \n" + string);
                    tableView.setUserDefined(true);
                }
                resultSet.close();
            }
            this.setSupportInformation_Schema(true);
        }
        catch (SQLException sQLException) {
            this.setSupportInformation_Schema(false);
            sQLException.printStackTrace();
        }
    }
}

