/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class MOHTable
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TABLE";
    protected static final String COL_OBJECT_TYPE = "COLUMN";
    protected static final String SYSTEM_TABLE = "SYSTEM TABLE";
    private final String NOT_NULL_PATTERN = " IS NOT NULL";
    protected static final String SIZE = "size";
    protected static final String SCALE = "scale";
    protected static final String PRECISION = "precision";
    PreparedStatement checkSt;
    PreparedStatement nullSchemaSt;
    private static final Hashtable SYNONYM_TABLE = new Hashtable();

    public MOHTable(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    protected ResultSet getTables(DatabaseMetaData databaseMetaData, DBObject dBObject, boolean bl) throws Exception {
        if (bl) {
            return databaseMetaData.getTables(null, dBObject.getName(), "%", new String[]{OBJECT_TYPE});
        }
        return databaseMetaData.getTables(null, dBObject.getSchema(), dBObject.getName(), new String[]{OBJECT_TYPE});
    }

    protected ResultSet getColumns(DatabaseMetaData databaseMetaData, DBObject dBObject) throws Exception {
        return databaseMetaData.getColumns(null, dBObject.getSchema(), dBObject.getName(), "%");
    }

    protected ResultSet getPrimaryKeys(DatabaseMetaData databaseMetaData, DBObject dBObject) throws Exception {
        return databaseMetaData.getPrimaryKeys(null, dBObject.getSchema(), dBObject.getName());
    }

    protected ResultSet getIndexInfo(DatabaseMetaData databaseMetaData, DBObject dBObject) throws Exception {
        return databaseMetaData.getIndexInfo(null, dBObject.getSchema(), dBObject.getName(), false, false);
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        for (DBObject dBObject : list) {
            if (!dBObject.isSelected()) continue;
            ResultSet resultSet = this.getTables(databaseMetaData, dBObject, true);
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                if (string2 == null) {
                    string2 = dBObject.getName();
                }
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                if (string3 == null || !OBJECT_TYPE.equalsIgnoreCase(string4)) continue;
                DBObject dBObject2 = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), string3, OBJECT_TYPE, string2);
                arrayList.add(dBObject2);
            }
            resultSet.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        boolean bl = true;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        for (int i = 0; i < list.size(); ++i) {
            DBObject dBObject = (DBObject)list.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dBObject.getType())) continue;
            Table table = this.getDesign().getRelationalDesign().createTable();
            table.setSchema(dBObject.getSchema());
            table.setName(dBObject.getName());
            this.stampModelObject(table, dBObject);
            this.handleColumns(databaseMetaData, dBObject, table);
            this.handlePKS(databaseMetaData, dBObject, table);
            this.handleIndexes(databaseMetaData, dBObject, table);
            if (bl || this.isSupportInformation_Schema()) {
                bl = false;
                this.handleCheckConstraint(connection, dBObject, table);
            }
            table.resetIdentityColumn();
            importLogger.incrementImportedStatements();
            this.addToHandledObjects(dBObject);
        }
    }

    protected void handleCheckConstraint(Connection connection, DBObject dBObject, Table table) {
        try {
            String string;
            CharSequence charSequence;
            ResultSet resultSet = null;
            if (dBObject.getSchema() != null && !"".equals(dBObject.getSchema())) {
                if (this.checkSt == null) {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("SELECT t.table_schema, \n");
                    ((StringBuffer)charSequence).append("  t.table_name, \n");
                    ((StringBuffer)charSequence).append("  t.constraint_name, \n");
                    ((StringBuffer)charSequence).append("  t.constraint_type, \n");
                    ((StringBuffer)charSequence).append("  t.is_deferrable, \n");
                    ((StringBuffer)charSequence).append("  t.initially_deferred, \n");
                    ((StringBuffer)charSequence).append("  c.check_clause \n");
                    ((StringBuffer)charSequence).append("FROM information_schema.check_constraints c, \n");
                    ((StringBuffer)charSequence).append("  information_schema.table_constraints t \n");
                    ((StringBuffer)charSequence).append("WHERE t.table_schema    = ? \n");
                    ((StringBuffer)charSequence).append("AND t.table_name        = ? \n");
                    ((StringBuffer)charSequence).append("AND t.constraint_type   = 'CHECK' \n");
                    ((StringBuffer)charSequence).append("AND c.constraint_name   = t.constraint_name \n");
                    ((StringBuffer)charSequence).append("AND c.constraint_schema = t.constraint_schema");
                    string = ((StringBuffer)charSequence).toString();
                    this.checkSt = connection.prepareStatement(string);
                }
                this.checkSt.setString(1, dBObject.getSchema());
                this.checkSt.setString(2, dBObject.getName());
                resultSet = this.checkSt.executeQuery();
            } else {
                if (this.nullSchemaSt == null) {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("SELECT t.table_schema, \n");
                    ((StringBuffer)charSequence).append("  t.table_name, \n");
                    ((StringBuffer)charSequence).append("  t.constraint_name, \n");
                    ((StringBuffer)charSequence).append("  t.constraint_type, \n");
                    ((StringBuffer)charSequence).append("  t.is_deferrable, \n");
                    ((StringBuffer)charSequence).append("  t.initially_deferred, \n");
                    ((StringBuffer)charSequence).append("  c.check_clause \n");
                    ((StringBuffer)charSequence).append("FROM information_schema.check_constraints c, \n");
                    ((StringBuffer)charSequence).append("  information_schema.table_constraints t \n");
                    ((StringBuffer)charSequence).append("WHERE \n");
                    ((StringBuffer)charSequence).append(" t.table_name        = ? \n");
                    ((StringBuffer)charSequence).append("AND t.constraint_type   = 'CHECK' \n");
                    ((StringBuffer)charSequence).append("AND c.constraint_name   = t.constraint_name \n");
                    ((StringBuffer)charSequence).append("AND c.constraint_schema = t.constraint_schema");
                    string = ((StringBuffer)charSequence).toString();
                    this.nullSchemaSt = connection.prepareStatement(string);
                }
                this.nullSchemaSt.setString(1, dBObject.getName());
                resultSet = this.nullSchemaSt.executeQuery();
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(3);
                    string = resultSet.getString(7);
                    if (string == null || this.isNotNullCheck(string, table)) continue;
                    TableLevelConstraint tableLevelConstraint = table.createCheckConstraint((String)charSequence, string);
                    table.addCheckConstraint(tableLevelConstraint);
                }
                resultSet.close();
            }
            this.setSupportInformation_Schema(true);
        }
        catch (SQLException sQLException) {
            this.setSupportInformation_Schema(false);
        }
    }

    private boolean isNotNullCheck(String string, Table table) {
        String string2 = string.toUpperCase();
        for (Column column : table.getElementsCollection()) {
            if (!column.isMandatory() || !string2.equalsIgnoreCase(column.getName() + " IS NOT NULL")) continue;
            return true;
        }
        return false;
    }

    protected void setLogicalTypeParams(Column column, LogicalDatatype logicalDatatype, int n, int n2) {
        try {
            Map map = logicalDatatype.getToPhysical();
            MDDataType mDDataType = logicalDatatype.createDataType(this.getDbmeHandler().getRDBMSSite().getType().getName(), map);
            if (!(mDDataType instanceof MDImplicitSized)) {
                if (mDDataType instanceof MDPackedSized) {
                    if (n > 0) {
                        column.setDataTypeParameter(PRECISION, String.valueOf(n));
                    }
                    if (n2 > 0) {
                        column.setDataTypeParameter(SCALE, String.valueOf(n2));
                    }
                } else if (n > 0) {
                    column.setDataTypeParameter(SIZE, String.valueOf(n));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void handleColumns(DatabaseMetaData databaseMetaData, DBObject dBObject, Table table) throws Exception {
        String string = databaseMetaData.getDatabaseProductName();
        ResultSet resultSet = this.getColumns(databaseMetaData, dBObject);
        RDBMSType rDBMSType = this.getStorageDesign().getRDBMSType();
        if (resultSet != null) {
            while (resultSet.next()) {
                String string2 = resultSet.getString("COLUMN_NAME");
                short s = resultSet.getShort("DATA_TYPE");
                String string3 = this.getSQLDataType(s);
                String string4 = resultSet.getString("TYPE_NAME");
                if (string3 == null && string4 != null) {
                    string3 = string4;
                }
                int n = 0;
                int n2 = 0;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                try {
                    n = resultSet.getInt("COLUMN_SIZE");
                    if (n > 2000) {
                        n = 0;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    n2 = resultSet.getInt("DECIMAL_DIGITS");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    string5 = resultSet.getString("COLUMN_DEF");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    string6 = this.getColumn(resultSet, "IS_NULLABLE");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    string7 = this.getColumn(resultSet, "IS_AUTOINCREMENT");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String string8 = null;
                try {
                    string8 = this.getColumn(resultSet, "REMARKS");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Column column = new Column(table.getDesignPart());
                column.setName(string2);
                if (string8 != null) {
                    column.setCommentInRDBMS(string8);
                }
                if (string3 != null) {
                    Object object;
                    Object object2 = StandardDatatypeNames.getUsedDatatypeName(string3);
                    if ("MYSQL".equalsIgnoreCase(string)) {
                        int n3;
                        object = (String)SYNONYM_TABLE.get(string3.toUpperCase());
                        if (object == null) {
                            object = (String)SYNONYM_TABLE.get(string4.toUpperCase());
                        }
                        if (object == null && (n3 = string3.indexOf(32)) > 0) {
                            object = string3.substring(0, n3);
                            object = (String)SYNONYM_TABLE.get(((String)object).toUpperCase());
                        }
                        if (object != null) {
                            object2 = object;
                        }
                    }
                    object = null;
                    NativeDBType nativeDBType = null;
                    if (object == null && (nativeDBType = StandardDatatypeNames.getNativeDBType(rDBMSType, string4)) != null) {
                        object = nativeDBType.getLogicalDatatype();
                    }
                    if (object == null) {
                        object = MappingDatatypeNameLogicalDataType.getLogicalDatatype(rDBMSType, (String)object2);
                    }
                    if (object == null) {
                        object = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(string3, rDBMSType.getName());
                    }
                    if (object == null) {
                        String string9 = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype((String)object2);
                        object = this.getDesign().getLogicalDatatypeSet().getLogTypeByName(string9);
                    }
                    if (object != null) {
                        column.setUse((short)1);
                        column.setLogicalDatatype((LogicalDatatype)object);
                        this.setLogicalTypeParams(column, (LogicalDatatype)object, n, n2);
                    } else {
                        System.out.println("Unable to find logical datatype for: " + string3);
                    }
                }
                if (string5 != null) {
                    column.setDefaultValue(string5);
                }
                if (string6 != null) {
                    if ("YES".equalsIgnoreCase(string6)) {
                        column.setNullsAllowed(true);
                    } else {
                        column.setNullsAllowed(false);
                    }
                }
                if (string7 != null && "YES".equalsIgnoreCase(string7)) {
                    column.setAutoIncrementColumn(true);
                }
                table.addColumn(column);
                this.stampModelObject((ModelObject)column, table.getName(), string2);
            }
            resultSet.close();
        }
    }

    protected void handlePKS(DatabaseMetaData databaseMetaData, DBObject dBObject, Table table) throws Exception {
        ResultSet resultSet = this.getPrimaryKeys(databaseMetaData, dBObject);
        if (resultSet != null) {
            while (resultSet.next()) {
                Column column;
                Index index;
                String string = this.getColumn(resultSet, "COLUMN_NAME");
                String string2 = this.getColumn(resultSet, "PK_NAME");
                if (string2 != null) {
                    index = (Index)table.getKeySet().getByName(string2);
                    if (index == null) {
                        index = table.createIndex();
                        index.setName(string2);
                        this.stampModelObject((ModelObject)index, table.getSchema(), string2);
                    }
                } else {
                    index = table.createIndex();
                }
                if (string != null && (column = (Column)table.getElementByName(string)) != null) {
                    index.add(column);
                }
                index.setIndexState("Primary Constraint");
            }
            resultSet.close();
        }
    }

    protected void handleIndexes(DatabaseMetaData databaseMetaData, DBObject dBObject, Table table) throws Exception {
        ResultSet resultSet = this.getIndexInfo(databaseMetaData, dBObject);
        if (resultSet != null) {
            while (resultSet.next()) {
                Index index;
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                boolean bl = resultSet.getBoolean(4);
                String string4 = resultSet.getString(5);
                String string5 = resultSet.getString(6);
                int n = resultSet.getInt(7);
                String string6 = resultSet.getString(8);
                String string7 = resultSet.getString(9);
                String string8 = resultSet.getString(10);
                String string9 = resultSet.getString(11);
                String string10 = resultSet.getString(12);
                String string11 = resultSet.getString(13);
                if (n <= 0) continue;
                String string12 = string5;
                if (string12 != null) {
                    index = (Index)table.getKeySet().getByName(string12);
                    if (index == null) {
                        index = table.createIndex();
                        index.setName(string12);
                        this.stampModelObject((ModelObject)index, table.getSchema(), index.getName());
                    } else if (index.isPK()) {
                        continue;
                    }
                } else {
                    index = table.createIndex();
                }
                String string13 = string7;
                Column column = (Column)table.getElementByName(string13);
                if (column != null) {
                    index.add(column);
                    String string14 = string8;
                    if ("D".equalsIgnoreCase(string14)) {
                        index.setColumnSortOrder(column, "DESC");
                    }
                } else {
                    System.out.println("Unable to find column: " + string13);
                }
                if (bl) continue;
                index.setIndexState("Unique Constraint");
            }
            resultSet.close();
        }
    }

    static {
        SYNONYM_TABLE.put("TEXT", "CLOB");
        SYNONYM_TABLE.put("MEDIUMTEXT", "CLOB");
        SYNONYM_TABLE.put("TINYTEXT", "CLOB");
        SYNONYM_TABLE.put("LONGTEXT", "CLOB");
        SYNONYM_TABLE.put("LONG", "CLOB");
        SYNONYM_TABLE.put("BLOB", "BLOB");
        SYNONYM_TABLE.put("TINYBLOB", "BLOB");
        SYNONYM_TABLE.put("MEDIUMBLOB", "BLOB");
        SYNONYM_TABLE.put("LONGBLOB", "BLOB");
        SYNONYM_TABLE.put("TINYINT", "SMALLINT");
        SYNONYM_TABLE.put("MEDIUMINT", "SMALLINT");
        SYNONYM_TABLE.put("DATETIME", "DATE");
        SYNONYM_TABLE.put("YEAR", "DATE");
        SYNONYM_TABLE.put("TIME", "DATE");
    }
}

