/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHAlterTableOraclev10g;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class MOHForeignKey
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "FOREIGN KEY";

    public MOHForeignKey(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        super(abstractDBMExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    protected ResultSet getImportedKeys(DatabaseMetaData databaseMetaData, Table table) throws Exception {
        return databaseMetaData.getImportedKeys(null, table.getProperty("schema"), table.getName());
    }

    private FKHelper getFKHelperFor(Table table, List<FKHelper> list, String string) {
        FKHelper fKHelper2;
        for (FKHelper fKHelper2 : list) {
            if (fKHelper2.pkTable != table) continue;
            if (string != null && !"".equals(string)) {
                if (!string.equalsIgnoreCase(fKHelper2.fk_NAME)) continue;
                return fKHelper2;
            }
            return fKHelper2;
        }
        fKHelper2 = new FKHelper();
        fKHelper2.pkTable = table;
        list.add(fKHelper2);
        return fKHelper2;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        Object[] objectArray = this.getDesign().getRelationalDesign().getTableSet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Table table = (Table)objectArray[i];
            ResultSet resultSet = this.getImportedKeys(databaseMetaData, table);
            ArrayList<FKHelper> arrayList = new ArrayList<FKHelper>();
            if (resultSet == null) continue;
            while (resultSet.next()) {
                String string = resultSet.getString(3);
                String string2 = resultSet.getString(4);
                object6 = resultSet.getString(8);
                object5 = resultSet.getString(11);
                object4 = resultSet.getString(12);
                object3 = resultSet.getString(13);
                String string3 = string;
                object2 = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(string3);
                if (object2 == null) continue;
                object = this.getFKHelperFor((Table)object2, arrayList, (String)object4);
                ((FKHelper)object).fk_NAME = object4;
                ((FKHelper)object).pk_NAME = object3;
                ((FKHelper)object).fkDELETE_RULE = object5;
                if (object6 != null) {
                    ((FKHelper)object).fkColNames.add(object6);
                    ((FKHelper)object).pkColNames.add(string2);
                    continue;
                }
                System.out.println("Unable to find FK column!");
            }
            resultSet.close();
            for (FKHelper fKHelper : arrayList) {
                object6 = fKHelper.pkTable;
                if (object6 == null) continue;
                object5 = null;
                object5 = fKHelper.pk_NAME == null ? SHAlterTableOraclev10g.getUniqueIndexForColumnNames((Table)object6, fKHelper.pkColNames) : ((Table)object6).getIndexByName(fKHelper.pk_NAME);
                object4 = null;
                object3 = null;
                if (object5 != null) {
                    for (int j = 0; j < fKHelper.fkColNames.size(); ++j) {
                        String string;
                        Column column;
                        object2 = (String)fKHelper.pkColNames.get(j);
                        if (object2 != null && (object3 = (Column)((ContainerObject)object6).getElementByName((String)object2)) == null) {
                            object3 = ((Table)object6).createColumn();
                            ((DesignObject)object3).setName((String)object2);
                            this.stampModelObject((ModelObject)object3, ((DesignObject)object6).getName(), (String)object2);
                            ((Index)object5).add((ContainedObject)object3);
                        }
                        if ((column = (Column)table.getElementByName((String)(object = (String)fKHelper.fkColNames.get(j)))) == null) {
                            column = table.createColumn();
                            column.setName((String)object);
                            this.stampModelObject((ModelObject)object3, table.getName(), (String)object);
                        }
                        if ((string = fKHelper.fk_NAME) != null) {
                            FKIndexAssociation[] fKIndexAssociationArray = table.getFKAssociations();
                            for (int k = 0; k < fKIndexAssociationArray.length; ++k) {
                                FKIndexAssociation fKIndexAssociation = fKIndexAssociationArray[k];
                                if (!fKIndexAssociation.getName().equalsIgnoreCase(string)) continue;
                                object4 = fKIndexAssociation;
                                break;
                            }
                        }
                        if (object4 == null) {
                            int n;
                            object4 = table.addFK((KeyObject)object5);
                            if (string != null) {
                                ((FKIndexAssociation)object4).setName(string);
                                ((FKIndexAssociation)object4).getLocalFKIndex().setName(string);
                                this.stampModelObject((ModelObject)object4, table.getSchema(), string);
                            }
                            try {
                                n = Integer.valueOf(fKHelper.fkDELETE_RULE);
                            }
                            catch (Exception exception) {
                                n = 3;
                            }
                            switch (n) {
                                case 3: {
                                    ((FKIndexAssociation)object4).setDeleteRule("NO ACTION");
                                    break;
                                }
                                case 0: {
                                    ((FKIndexAssociation)object4).setDeleteRule("CASCADE");
                                    break;
                                }
                                case 2: {
                                    ((FKIndexAssociation)object4).setDeleteRule("SET NULL");
                                    break;
                                }
                                case 1: {
                                    ((FKIndexAssociation)object4).setDeleteRule("RESTRICT");
                                }
                            }
                        }
                        column.addFKAssociation((Column)object3, (FKIndexAssociation)object4);
                        ((FKIndexAssociation)object4).getLocalFKIndex().add(column);
                    }
                }
                if (object4 == null) continue;
                ((FKIndexAssociation)object4).resetMandatoryUsingColumns();
                ((FKIndexAssociation)object4).resetEdgeParams();
            }
        }
    }

    private static class FKHelper {
        public List pkColNames = new ArrayList();
        public List fkColNames = new ArrayList();
        public String fkDELETE_RULE = "";
        public String fk_NAME = null;
        public String pk_NAME = null;
        public Table pkTable = null;

        private FKHelper() {
        }
    }
}

