/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.TableProxy;

public class DBObject {
    private boolean selected;
    private String name;
    private String type;
    private String schema;
    private String catalog;
    private String specificName;
    private String status = "";
    private String comments = "";
    private boolean requiredSet = false;
    private List<DBObject> requiredBy = new Vector<DBObject>();
    private List<DBObject> requires = new Vector<DBObject>();
    private String typeName;
    private String superTypeName;
    private String typeCode;
    private String typeOwner;
    private String superTypeOwner;
    private boolean isFinal;
    private boolean instantiable = true;
    private TableProxy tableProxy;
    private String ID;
    private Table table;
    public boolean partitioned = false;
    public boolean hasLOBs = false;
    private Object descrptiveObject = null;
    private int localMethods = -1;
    private int localAttributes = -1;
    private boolean processed = false;
    public static final String NAME_EXIST = "Type name exist";

    public String getSpecificName() {
        return this.specificName;
    }

    public void setSpecificName(String string) {
        this.specificName = string;
    }

    public DBObject(boolean bl, String string) {
        this(bl, string, "", "");
    }

    public DBObject(boolean bl, String string, String string2) {
        this(bl, string, string2, "");
    }

    public DBObject(boolean bl, String string, String string2, String string3) {
        this(bl, string, string2, string3, "");
    }

    public DBObject(boolean bl, String string, String string2, String string3, String string4) {
        this.selected = bl;
        this.name = string;
        this.type = string2;
        this.schema = string3;
        this.specificName = string4;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.makeID();
    }

    private void makeID() {
        if (this.getSchema() != null && this.getName() != null) {
            this.ID = this.getSchema() + "." + this.getName();
        }
    }

    public boolean isSelected() {
        return this.selected || this.isRequired();
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isRequired() {
        if (this.selected) {
            return true;
        }
        for (DBObject dBObject : this.requiredBy) {
            if (dBObject == null || !dBObject.isRequired()) continue;
            return true;
        }
        return false;
    }

    public void addRequiredBy(DBObject dBObject) {
        if (dBObject != null && !this.requiredBy.contains(dBObject)) {
            dBObject.requires.add(this);
            this.requiredBy.add(dBObject);
        }
    }

    public void removeRequiredBy(DBObject dBObject) {
        if (dBObject != null && this.requiredBy.contains(dBObject)) {
            dBObject.requires.remove(this);
            this.requiredBy.remove(dBObject);
        }
    }

    public List<DBObject> getRequiredBy() {
        return Collections.unmodifiableList(this.requiredBy);
    }

    public void addRequires(DBObject dBObject) {
        if (dBObject != null && !this.requires.contains(dBObject)) {
            this.requires.add(dBObject);
            dBObject.requiredBy.add(this);
        }
    }

    public void removeRequires(DBObject dBObject) {
        if (dBObject != null && this.requires.contains(dBObject)) {
            this.requires.remove(dBObject);
            dBObject.requiredBy.remove(this);
        }
    }

    public List<DBObject> getRequires() {
        return Collections.unmodifiableList(this.requires);
    }

    public void setRequiredSet(boolean bl) {
        this.requiredSet = bl;
    }

    public boolean isRequiredSet() {
        return this.requiredSet;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        this.schema = string;
        this.makeID();
    }

    public String getSuperTypeName() {
        return this.superTypeName;
    }

    public void setSuperTypeName(String string) {
        this.superTypeName = string;
    }

    public String getSuperTypeOwner() {
        return this.superTypeOwner;
    }

    public void setSuperTypeOwner(String string) {
        this.superTypeOwner = string;
    }

    public String toString() {
        if (this.getSchema() != null && !this.getSchema().equals("")) {
            return this.getSchema() + "." + this.getName() + "." + this.getType();
        }
        return this.getName();
    }

    public boolean isInstantiable() {
        return this.instantiable;
    }

    public void setInstantiable(boolean bl) {
        this.instantiable = bl;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean bl) {
        this.isFinal = bl;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public String getTypeOwner() {
        return this.typeOwner;
    }

    public void setTypeOwner(String string) {
        this.typeOwner = string;
    }

    public String getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(String string) {
        this.typeCode = string;
    }

    public TableProxy getTableProxy() {
        return this.tableProxy;
    }

    public void setTableProxy(TableProxy tableProxy) {
        this.tableProxy = tableProxy;
    }

    public String getID() {
        if (this.ID == null && this.getSchema() != null && this.getName() != null) {
            this.makeID();
        }
        if (this.ID != null) {
            return this.ID;
        }
        throw new RuntimeException("Owner and name of the object are not set");
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Object getDescrptiveObject() {
        return this.descrptiveObject;
    }

    public void setDescrptiveObject(Object object) {
        this.descrptiveObject = object;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String string) {
        if (string != null) {
            this.comments = string;
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public int getLocalMethods() {
        return this.localMethods;
    }

    public void setLocalMethods(int n) {
        this.localMethods = n;
    }

    public int getLocalAttributes() {
        return this.localAttributes;
    }

    public void setLocalAttributes(int n) {
        this.localAttributes = n;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean bl) {
        this.processed = bl;
    }
}

