/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.awt.Component;
import java.awt.Dimension;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.db2.DBMExtractionHandlerDB2;
import oracle.dbtools.crest.imports.metadata.odbc.DBMExtractionHandlerODBC;
import oracle.dbtools.crest.imports.metadata.oracle.DBMExtractionHandlerOracle;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBMExtractionHandlerSQLServer;
import oracle.dbtools.crest.imports.metadata.udb.DBMExtractionHandlerUDB;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.compare.CompareModelsDialog;
import oracle.dbtools.crest.swingui.compare.ModelChooserDialog;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.wizards.metadata.DefaultDBMExtractionWizard;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.swingui.wizards.metadata.db2.DBMExtractionWizardDB2;
import oracle.dbtools.crest.swingui.wizards.metadata.db2.v80.DBMExtractionWizardDB2v80;
import oracle.dbtools.crest.swingui.wizards.metadata.odbc.DBMExtractionWizardODBC;
import oracle.dbtools.crest.swingui.wizards.metadata.oracle.DBMExtractionWizardOracle;
import oracle.dbtools.crest.swingui.wizards.metadata.sqlserver.DBMExtractionWizardSqlServer;
import oracle.dbtools.crest.swingui.wizards.metadata.udb.DBMExtractionWizardUDB;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class DBMExtractionController {
    public static final String PROPERTIES_CONN_NAME = "ConnName";
    public static final String PROPERTIES_CUSTOM_URL = "customUrl";
    public static final String PROPERTIES_USER = "user";
    private ApplicationView view;
    private Design design;
    private ProgressDialog monitor;
    private String oldDesignPath;
    private RelationalDesign relModel = null;
    public static boolean swapTargetModel = false;
    private Design oldDesign;
    private boolean isNewModel = false;
    private static final Logger LOGGER = new Logger(DBMExtractionController.class);

    public DBMExtractionController(ApplicationView applicationView) {
        this.view = applicationView;
        this.clearInstances();
    }

    private void clearInstances() {
        DBMExtractionHandlerDB2.clearInstance();
        DBMExtractionHandlerUDB.clearInstance();
        DBMExtractionHandlerOracle.clearInstance();
        DBMExtractionHandlerSQLServer.clearInstance();
        DBMExtractionHandlerODBC.clearInstance();
    }

    public AbstractDBMExtractionHandler getDBMExtractionHandler(int n) {
        switch (n) {
            case 3: {
                return DBMExtractionHandlerDB2.getInstance(this.view);
            }
            case 4: {
                return DBMExtractionHandlerUDB.getInstance(this.view);
            }
            case 1: {
                return DBMExtractionHandlerOracle.getInstance(this.view);
            }
            case 2: {
                return DBMExtractionHandlerSQLServer.getInstance(this.view);
            }
            case 0: {
                return DBMExtractionHandlerODBC.getInstance(this.view);
            }
        }
        return null;
    }

    public List getSchemas(int n, Connection connection) throws Exception {
        return this.getDBMExtractionHandler(n).getSchemas(connection);
    }

    public List getDBObjects(int n, List list, Connection connection) throws Exception {
        return this.getDBMExtractionHandler(n).getDBObjects(connection, list);
    }

    public String getDBProductVersion(int n) {
        return this.getDBMExtractionHandler(n).getDBProductVersion();
    }

    public String getDBProductName(int n) {
        return this.getDBMExtractionHandler(n).getDBProductName();
    }

    public void doCancel() {
        if (this.oldDesign != null) {
            this.design = this.oldDesign;
            this.view.setCurrentDesign(this.design);
        }
    }

    public void generateDesign(Connection connection, Properties properties, List list, RelationalDesign relationalDesign, boolean bl, RDBMSSite rDBMSSite) throws Exception {
        this.generateDesign(connection, properties, list, relationalDesign, bl, rDBMSSite, false, null);
    }

    public void generateDesign(Connection connection, Properties properties, List list, RelationalDesign relationalDesign, boolean bl, RDBMSSite rDBMSSite, boolean bl2, Map map) throws Exception {
        Object object;
        this.relModel = relationalDesign;
        swapTargetModel = bl;
        FKIndexAssociation.RESET_COLUMNS_IN_RESETMANDATORY_FROM_COLUMNS = !bl;
        String string = ConnectionInfo.getConnectionName(properties);
        int n = ConnectionInfo.getConnectionType(properties);
        if (properties.isEmpty() && !relationalDesign.getImportConnectionStamps().isEmpty() && relationalDesign.getImportConnectionStampIndex() > -1) {
            object = relationalDesign.getImportConnectionStamp(relationalDesign.getImportConnectionStampIndex());
            string = ((DBConnectionStamp)object).getConnName();
            n = ((DBConnectionStamp)object).getConnType();
        }
        if (relationalDesign == null || relationalDesign.isEmpty()) {
            if (relationalDesign != null) {
                this.design = relationalDesign.getDesign();
                this.oldDesignPath = this.design.getDesignPath();
            } else {
                this.design = this.view.getCurrentDesign();
                this.oldDesignPath = this.view.getCurrentDesign().getDesignPath();
            }
            this.view.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
            if (relationalDesign == null) {
                object = this.design.addRelationalDesign(string);
                this.design.setRelationalDesign((RelationalDesign)object);
                this.relModel = object;
            } else {
                this.design.setRelationalDesign(relationalDesign);
            }
            if (rDBMSSite != null) {
                this.design.setSelectedRDBMSSite(rDBMSSite);
            } else {
                LOGGER.error("DBMExtractionController.generateDesign(): Unable to get approperiate RDBMS Site");
            }
            if (this.design.getRelationalDesign().getImportConnectionStamps().isEmpty() || this.design.getRelationalDesign().findImportConnectionStamp(string) == -1) {
                if (properties.isEmpty()) {
                    int n2 = relationalDesign.findImportConnectionStamp(string);
                    if (n2 > -1) {
                        DBConnectionStamp dBConnectionStamp = relationalDesign.getImportConnectionStamp(n2);
                        n2 = this.design.getRelationalDesign().addImportConnectionStamp(dBConnectionStamp);
                        this.design.getRelationalDesign().setImportConnectionStampIndex(n2);
                    }
                } else {
                    int n3 = this.design.getRelationalDesign().addImportConnectionStamp(new DBConnectionStamp(ConnectionInfo.getConnectionName(properties), properties.getProperty(PROPERTIES_CUSTOM_URL), properties.getProperty(PROPERTIES_USER), n));
                    this.design.getRelationalDesign().setImportConnectionStampIndex(n3);
                }
            }
            new Thread(new EmptyRunner(connection, list, n)).start();
        } else {
            this.oldDesign = relationalDesign.getDesign();
            this.design = new Design(this.view);
            this.design.setDlSettings(this.oldDesign.getDesignLevelSettings());
            this.view.setCurrentDesign(this.design);
            this.oldDesignPath = this.oldDesign.getDesignPath();
            this.view.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
            this.design.getRelationalDesign().setName(string);
            this.design.getRelationalDesign().setRelatedSyncModel(relationalDesign);
            this.oldDesign.setRelationalDesign(relationalDesign);
            this.isNewModel = false;
            if (rDBMSSite != null) {
                this.design.setSelectedRDBMSSite(rDBMSSite);
                this.oldDesign.setSelectedRDBMSSite(rDBMSSite);
            } else {
                LOGGER.error("DBMExtractionController.generateDesign(): Unable to get approperiate RDBMS Site");
            }
            if (this.design.getRelationalDesign().getImportConnectionStamps().isEmpty()) {
                if (properties.isEmpty()) {
                    int n4 = relationalDesign.findImportConnectionStamp(string);
                    if (n4 > -1) {
                        DBConnectionStamp dBConnectionStamp = relationalDesign.getImportConnectionStamp(n4);
                        n4 = this.design.getRelationalDesign().addImportConnectionStamp(dBConnectionStamp);
                        this.design.getRelationalDesign().setImportConnectionStampIndex(n4);
                    }
                } else {
                    int n5 = this.design.getRelationalDesign().addImportConnectionStamp(new DBConnectionStamp(ConnectionInfo.getConnectionName(properties), properties.getProperty(PROPERTIES_CUSTOM_URL), properties.getProperty(PROPERTIES_USER), ConnectionInfo.getConnectionType(properties)));
                    this.design.getRelationalDesign().setImportConnectionStampIndex(n5);
                }
            }
            new Thread(new Runner(connection, list, n, bl2, map)).start();
        }
    }

    public boolean isSecondaryTables(int n) {
        return this.getDBMExtractionHandler(n).isSecondaryTables();
    }

    public void setSecondaryTables(int n, boolean bl) {
        this.getDBMExtractionHandler(n).setSecondaryTables(bl);
    }

    public boolean isSpatialProperties(int n) {
        return this.getDBMExtractionHandler(n).isSpatialProperties();
    }

    public void setSpatialProperties(int n, boolean bl) {
        this.getDBMExtractionHandler(n).setSpatialProperties(bl);
    }

    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    private class EmptyRunner
    implements Runnable {
        private Connection conn;
        private List selectedObjects;
        private int selectedObjectsCount;
        private int type;
        ImportLogger importLog;

        public EmptyRunner(Connection connection, List list, int n) {
            this.conn = connection;
            this.selectedObjects = list;
            this.selectedObjectsCount = list.size();
            this.type = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DBMExtractionController.this.relModel.setMainViewVisible(false);
                DBMExtractionController.this.design.setDisableTreeUpdate(true);
                this.importLog = new ImportLogger();
                try {
                    DBMExtractionController.this.monitor = new ProgressDialog(DBMExtractionController.this.view, "", 0, 100);
                    try {
                        DBMExtractionController.this.design.setPropagatePKChahges(false);
                        DBMExtractionController.this.view.setImporting(true);
                        ApplicationView.log(Messages.getString("DBMExtractionController.ImportingDBMetadata"));
                        ApplicationView.canLogging = false;
                        try {
                            DBMExtractionController.this.monitor.setProgress(5);
                            DBMExtractionController.this.monitor.setNote(Messages.getString("DBMExtractionController.GenerateDesign"));
                            DBMExtractionController.this.monitor.setProgress(10);
                            TimeLog.log("Import begin");
                            DBMExtractionController.this.getDBMExtractionHandler(this.type).generateDesign(this.conn, this.selectedObjects, this.importLog, DBMExtractionController.this.monitor);
                            TimeLog.log("Import end");
                            DBMExtractionController.this.monitor.setNote(Messages.getString("DBMExtractionController.RearrangeTypes"));
                            DBMExtractionController.this.monitor.setProgress(85);
                            try {
                                DBMExtractionController.this.design.getDataTypesDesign().rearrangeTypes();
                                DBMExtractionController.this.design.getDataTypesDesign().updateInheritances();
                            }
                            catch (Exception exception) {
                                LOGGER.error("Unable to rearrange Types", exception);
                            }
                            DBMExtractionController.this.monitor.setNote(Messages.getString("DBMExtractionController.RearrangeTables"));
                            DBMExtractionController.this.monitor.setProgress(90);
                            try {
                                ((DPVRelational)DBMExtractionController.this.design.getRelationalDesign().getMainView()).rearrangeNewDiagram();
                            }
                            catch (Exception exception) {
                                LOGGER.error("Unable to rearrange Tables", exception);
                            }
                            DBMExtractionController.this.monitor.setNote(Messages.getString("DBMExtractionController.RearrangeViews"));
                            DBMExtractionController.this.monitor.setProgress(93);
                            try {
                                DBMExtractionController.this.design.getRelationalDesign().createSubviewsOnSchema(DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()));
                            }
                            catch (Exception exception) {
                                LOGGER.error("Unable to create subviews ", exception);
                            }
                            DBMExtractionController.this.monitor.setProgress(95);
                            DBMExtractionController.this.design.setDirty(true);
                            DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).setOpen(true);
                            DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).setTempModel(false);
                            DBMExtractionController.this.monitor.setProgress(100);
                            TimeLog.log("Import end graphics");
                            DBMExtractionController.this.view.getCurrentDesign().setDesignPath(DBMExtractionController.this.oldDesignPath);
                        }
                        finally {
                            DefaultDBMExtractionWizard.clearInstance();
                            DBMExtractionWizardDB2.clearInstance();
                            DBMExtractionWizardDB2v80.clearInstance();
                            DBMExtractionWizardODBC.clearInstance();
                            DBMExtractionWizardOracle.clearInstance();
                            DBMExtractionWizardSqlServer.clearInstance();
                            DBMExtractionWizardUDB.clearInstance();
                            if (DBMExtractionController.this.design != null) {
                                DBMExtractionController.this.design.setDirty(true);
                                DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).setOpen(true);
                                DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).sortCollections();
                                DBMExtractionController.this.design.setPropagatePKChahges(true);
                                DBMExtractionController.this.design.setDisableTreeUpdate(false);
                            }
                            DBMExtractionController.this.view.setImporting(false);
                            ApplicationView.canLogging = true;
                            DBMExtractionController.this.view.getCurrentDesign().setDesignPath(DBMExtractionController.this.oldDesignPath);
                            ApplicationView.log(Messages.getString("DBMExtractionController.ImportOfDBMetadataFinished"));
                        }
                    }
                    finally {
                        DBMExtractionController.this.monitor.close();
                    }
                    DBMExtractionController.this.view.setImporting(false);
                }
                catch (Throwable throwable) {
                    DBMExtractionController.this.view.setImporting(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DBMExtractionController.this.view.getCurrentDesign().getRelationalDesign().sortCollections();
                            DBMExtractionController.this.view.getCurrentDesign().getDataTypesDesign().sortCollections();
                            DBMExtractionController.this.relModel.setMainViewVisible(true);
                            DBMExtractionController.this.relModel.getMainView().straightenLines();
                            DBMExtractionController.this.view.centerDesign();
                            if (DBMExtractionController.this.view.getSettings().showImportLog()) {
                                LogReport logReport = new LogReport(DBMExtractionController.this.view);
                                logReport.setLog(EmptyRunner.this.importLog.generateDDLReport(DBMExtractionController.this.view, EmptyRunner.this.selectedObjectsCount));
                                logReport.showDialog(new Dimension(750, 550));
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Exception exception) {
                DBMExtractionController.this.view.setImporting(false);
                LOGGER.error("Error Generate Design: " + DBMExtractionController.this.view.getDesignName(), exception);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("DBMExtractionController.UnableToGenerateDesign"), Messages.getString("DBMExtractionController.ErrorGenerateDesign"), 0);
            }
        }
    }

    private class Runner
    implements Runnable {
        private Connection conn;
        private List selectedObjects;
        private int type;
        private boolean synchronize;
        private Map selectedIDs;
        ImportLogger importLog;

        public Runner(Connection connection, List list, int n, boolean bl, Map map) {
            this.conn = connection;
            this.selectedObjects = list;
            this.type = n;
            this.synchronize = bl;
            this.selectedIDs = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DBMExtractionController.this.oldDesign.getDesign().setDisableTreeUpdate(true);
                DBMExtractionController.this.design.getDesign().setDisableTreeUpdate(true);
                DBMExtractionController.this.oldDesign.getAppView().getPersistenceManager().readSystemInit(DBMExtractionController.this.design);
                this.importLog = new ImportLogger();
                DBMExtractionController.this.monitor = new ProgressDialog(DBMExtractionController.this.view, "", 0, 100);
                try {
                    DBMExtractionController.this.design.setPropagatePKChahges(false);
                    DBMExtractionController.this.view.setImporting(true);
                    ApplicationView.log(Messages.getString("DBMExtractionController.ImportingDBMetadata"));
                    ApplicationView.canLogging = false;
                    try {
                        DBMExtractionController.this.monitor.setProgress(5);
                        DBMExtractionController.this.monitor.setNote(Messages.getString("DBMExtractionController.GenerateDesign"));
                        DBMExtractionController.this.monitor.setProgress(10);
                        TimeLog.log("Import begin");
                        DBMExtractionController.this.getDBMExtractionHandler(this.type).generateDesign(this.conn, this.selectedObjects, this.importLog, DBMExtractionController.this.monitor);
                        TimeLog.log("Import end");
                        DBMExtractionController.this.monitor.setNote(Messages.getString("DBMExtractionController.RearrangeTypes"));
                        DBMExtractionController.this.monitor.setProgress(85);
                        try {
                            DBMExtractionController.this.design.getDataTypesDesign().rearrangeTypes();
                        }
                        catch (Exception exception) {
                            LOGGER.error("Unable to rearrange Types", exception);
                        }
                        DBMExtractionController.this.monitor.setNote(Messages.getString("DBMExtractionController.RearrangeTables"));
                        DBMExtractionController.this.monitor.setProgress(90);
                        try {
                            ((DPVRelational)DBMExtractionController.this.design.getRelationalDesign().getMainView()).rearrangeNewDiagram();
                        }
                        catch (Exception exception) {
                            LOGGER.error("Unable to rearrange Tables", exception);
                        }
                        DBMExtractionController.this.monitor.setNote(Messages.getString("DBMExtractionController.RearrangeViews"));
                        DBMExtractionController.this.monitor.setProgress(93);
                        try {
                            DBMExtractionController.this.design.getRelationalDesign().createSubviewsOnSchema(DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()));
                        }
                        catch (Exception exception) {
                            LOGGER.error("Unable to create subviews ", exception);
                        }
                        DBMExtractionController.this.monitor.setProgress(95);
                        DBMExtractionController.this.design.setDirty(true);
                        DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).setOpen(true);
                        DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).setTempModel(false);
                        DBMExtractionController.this.monitor.setProgress(100);
                        TimeLog.log("Import end graphics");
                        DBMExtractionController.this.view.getCurrentDesign().setDesignPath(DBMExtractionController.this.oldDesignPath);
                    }
                    finally {
                        DefaultDBMExtractionWizard.clearInstance();
                        DBMExtractionWizardDB2.clearInstance();
                        DBMExtractionWizardDB2v80.clearInstance();
                        DBMExtractionWizardODBC.clearInstance();
                        DBMExtractionWizardOracle.clearInstance();
                        DBMExtractionWizardSqlServer.clearInstance();
                        DBMExtractionWizardUDB.clearInstance();
                        DBMExtractionController.this.design.setDirty(true);
                        DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).setOpen(true);
                        DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).sortCollections();
                        DBMExtractionController.this.design.setPropagatePKChahges(true);
                        DBMExtractionController.this.oldDesign.setDisableTreeUpdate(false);
                        DBMExtractionController.this.design.setDisableTreeUpdate(true);
                    }
                }
                finally {
                    DBMExtractionController.this.view.getCurrentDesign().setDesignPath(DBMExtractionController.this.oldDesignPath);
                    DBMExtractionController.this.view.setImporting(false);
                    ApplicationView.canLogging = true;
                    ApplicationView.log(Messages.getString("DBMExtractionController.ImportOfDBMetadataFinished"));
                    DBMExtractionController.this.monitor.close();
                }
                RelationalDesign relationalDesign = null;
                if (DBMExtractionController.this.design != null) {
                    relationalDesign = DBMExtractionController.this.design.getRelationalDesign();
                }
                boolean bl = DBMExtractionController.this.relModel == null || DBMExtractionController.this.relModel.isEmpty();
                DBMExtractionController.this.design = DBMExtractionController.this.oldDesign;
                DBMExtractionController.this.view.setCurrentDesign(DBMExtractionController.this.design);
                DBMExtractionController.this.view.getCurrentDesign().setDesignPath(DBMExtractionController.this.oldDesignPath);
                StorageDesign storageDesign = DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite());
                storageDesign.openStorageDesign();
                storageDesign.setDirty(true);
                DBMExtractionController.this.design.getRelationalDesign().sortCollections();
                DBMExtractionController.this.design.getDataTypesDesign().sortCollections();
                try {
                    PropertiesComparator.DDL_ONLY = true;
                    ModelChooserDialog.isSelectedDatabase = true;
                    CompareModelsDialog compareModelsDialog = swapTargetModel ? new CompareModelsDialog(DBMExtractionController.this.view, DBMExtractionController.this.design.getRelationalDesign(), relationalDesign, bl, DBMExtractionController.this.isNewModel, true, this.synchronize, this.selectedIDs) : new CompareModelsDialog(DBMExtractionController.this.view, relationalDesign, DBMExtractionController.this.design.getRelationalDesign(), bl, DBMExtractionController.this.isNewModel, false, this.synchronize, this.selectedIDs);
                    DBMExtractionController.this.view.setMerging(false);
                    compareModelsDialog.show();
                }
                finally {
                    PropertiesComparator.DDL_ONLY = false;
                    DBMExtractionController.this.view.setMerging(false);
                    FKIndexAssociation.RESET_COLUMNS_IN_RESETMANDATORY_FROM_COLUMNS = true;
                }
            }
            catch (Exception exception) {
                DBMExtractionController.this.view.setImporting(false);
                DBMExtractionController.this.design = DBMExtractionController.this.oldDesign;
                DBMExtractionController.this.view.setCurrentDesign(DBMExtractionController.this.design);
                DBMExtractionController.this.view.getCurrentDesign().setDesignPath(DBMExtractionController.this.oldDesignPath);
                LOGGER.error("Error Generate Design: " + DBMExtractionController.this.view.getDesignName(), exception);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("DBMExtractionController.UnableToGenerateDesign"), Messages.getString("DBMExtractionController.ErrorGenerateDesign"), 0);
            }
        }
    }
}

