/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;

public abstract class AbstractMOHandler
implements DBMOConstants {
    protected static final String SCHEMA_PROPERTY = "schema";
    protected AbstractDBMExtractionHandler dbmeHandler;
    protected ApplicationView view;
    protected List<DBObject> handledObjects = new ArrayList<DBObject>();
    private boolean supportInformation_Schema = false;

    public AbstractMOHandler(AbstractDBMExtractionHandler abstractDBMExtractionHandler, ApplicationView applicationView) {
        this.dbmeHandler = abstractDBMExtractionHandler;
        this.view = applicationView;
    }

    public abstract String getType();

    public abstract void generate(Connection var1, List var2, ImportLogger var3) throws Exception;

    public List extract(Connection connection, List list) throws Exception {
        return new ArrayList();
    }

    public Design getDesign() {
        return this.view.getCurrentDesign();
    }

    public StorageDesign getStorageDesign() {
        return this.getDesign().getRelationalDesign().getStorageDesign();
    }

    public ApplicationView getView() {
        return this.view;
    }

    public String getSQLDataType(short s) {
        switch (s) {
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case -8: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "IMAGE";
            }
            case -1: {
                return "LONG alphabetic";
            }
            case 2: {
                return "NUMERIC";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case -9: {
                return "VARCHAR";
            }
        }
        return null;
    }

    public String getColumn(ResultSet resultSet, String string) {
        String string2 = null;
        if (resultSet != null) {
            try {
                string2 = resultSet.getString(string);
            }
            catch (Exception exception) {
                System.out.println("Column does not exist: " + string);
            }
        }
        return string2;
    }

    public boolean getColumn(ResultSet resultSet, String string, boolean bl) {
        boolean bl2 = bl;
        if (resultSet != null) {
            try {
                bl2 = resultSet.getBoolean(string);
            }
            catch (Exception exception) {
                System.out.println("Column does not exist: " + string);
            }
        }
        return bl2;
    }

    public int getColumn(ResultSet resultSet, String string, int n) {
        int n2 = n;
        if (resultSet != null) {
            try {
                n2 = resultSet.getInt(string);
            }
            catch (Exception exception) {
                System.out.println("Column does not exist: " + string);
            }
        }
        return n2;
    }

    protected void dumpResultSet(ResultSet resultSet) {
        try {
            while (resultSet.next()) {
                System.out.println("-----------------------------------------------");
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    System.out.println(resultSetMetaData.getColumnName(i) + " : " + resultSetMetaData.getColumnTypeName(i) + " = " + resultSet.getString(i));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void dumpBuffer(StringBuffer stringBuffer) {
        System.out.println(stringBuffer.toString());
    }

    public AbstractDBMExtractionHandler getDbmeHandler() {
        return this.dbmeHandler;
    }

    protected void addToHandledObjects(DBObject dBObject) {
        this.handledObjects.add(dBObject);
    }

    public void clearHandledObjects(List list) {
        list.removeAll(this.handledObjects);
    }

    public void stampModelObject(ModelObject modelObject, DBObject dBObject) {
        this.stampModelObject(modelObject, dBObject.getSchema(), dBObject.getName());
    }

    public void stampModelObject(ModelObject modelObject, StorageObject storageObject, String string) {
        if (storageObject != null && storageObject.getSchemaObject() != null) {
            String string2 = storageObject.getSchemaObject().getName();
            this.stampModelObject(modelObject, string2, string);
        }
    }

    public void stampModelObject(ModelObject modelObject, RelationalObjectProxy relationalObjectProxy, String string) {
        String string2 = relationalObjectProxy.getObject().getSchema();
        if (relationalObjectProxy.getSchemaObject() != null) {
            string2 = relationalObjectProxy.getSchemaObject().getName();
        }
        this.stampModelObject(modelObject, string2, string);
    }

    public void stampModelObject(ModelObject modelObject, String string, String string2) {
        RelationalDesign relationalDesign = modelObject.getDesign().getRelationalDesign();
        if (!relationalDesign.getImportConnectionStamps().isEmpty() && relationalDesign.getImportConnectionStampIndex() > -1) {
            int n = relationalDesign.getImportConnectionStampIndex();
            DBConnectionStamp dBConnectionStamp = relationalDesign.getImportConnectionStamp(n);
            modelObject.setSourceConnName(dBConnectionStamp.getConnName());
            modelObject.setSourceObjSchema(string != null ? string : "");
            modelObject.setSourceObjName(string2);
        }
    }

    public void reset() {
        this.handledObjects.clear();
    }

    public void postGenerateProcessing(Connection connection) {
    }

    protected DBObject findObject(List<DBObject> list, String string, String string2) {
        DBObject dBObject = null;
        if (list != null && string != null && string2 != null) {
            for (DBObject dBObject2 : list) {
                if (!dBObject2.getType().equals(string) || !dBObject2.getName().equals(string2)) continue;
                dBObject = dBObject2;
                break;
            }
        }
        return dBObject;
    }

    public boolean isSupportInformation_Schema() {
        return this.supportInformation_Schema;
    }

    public void setSupportInformation_Schema(boolean bl) {
        this.supportInformation_Schema = bl;
    }
}

