/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.erwin;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.erwin.ERwinConstantsv7x;
import oracle.dbtools.crest.imports.erwin.ERwinHandler;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ConstrainedObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.GenericConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.logging.ImportLogger;
import org.w3c.dom.Element;

public class ERwinParserv7x
extends ERwinHandler
implements ERwinConstantsv7x {
    private Design design;
    private LogicalDesign logical;
    private RelationalDesign relational;
    private Map proxyObjects = new TreeMap();
    private Map transformScratchObjects = new TreeMap();
    private Map domains = new TreeMap();
    private Map logicalObjects = new TreeMap();
    private Map relationalObjects = new TreeMap();
    private Map fonts = new TreeMap();
    private boolean isMainLogical = true;
    private boolean isMainRelational = true;
    private String defaultNameFontID;
    private String defaultNameColor;
    private String defaultFillColor;
    private String defaultOutlineColor;
    private String defaultAttributeFontID;
    private String defaultAttributeColor;
    private List logicalViews = new ArrayList();
    private List relationalViews = new ArrayList();
    private List logicalFKElements = new ArrayList();
    private List relationalFKElements = new ArrayList();
    private List ihObjects = new ArrayList();
    private Map defaultValues = new TreeMap();
    private Map validationRules = new TreeMap();
    private List replacedAttributes = new ArrayList();

    public ERwinParserv7x(ApplicationView applicationView, boolean bl) {
        super(applicationView, bl);
        this.design = applicationView.getCurrentDesign();
        this.logical = this.design.getLogicalDesign();
        this.relational = this.design.getRelationalDesign();
    }

    public void parseModel(File file, ImportLogger importLogger, ProgressDialog progressDialog, Element element, Element element2) {
        block33: {
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                String string;
                if (element == null) break block33;
                Element element3 = this.getElement(element, "ModelEnvProps");
                String string2 = this.getElementValue(element3, "Target_Server");
                String string3 = this.getElementValue(element3, "Target_Server_Version");
                RDBMSType rDBMSType = null;
                if (string2.equalsIgnoreCase("1075858978")) {
                    rDBMSType = string3.equals("7") ? StorageDesignDB2v70.RDBMS_TYPE : (string3.equals("8") ? StorageDesignDB2v80.RDBMS_TYPE : StorageDesignDB2v70.RDBMS_TYPE);
                } else if (string2.equalsIgnoreCase("1075858979")) {
                    rDBMSType = string3.equals("9") ? StorageDesignOraclev9i.RDBMS_TYPE : (string3.equals("10") ? StorageDesignOraclev10g.RDBMS_TYPE : (string3.equals("11") ? StorageDesignOraclev11g.RDBMS_TYPE : StorageDesignOraclev9i.RDBMS_TYPE));
                } else if (string2.equalsIgnoreCase("1075859016")) {
                    rDBMSType = string3.equals("2000") ? StorageDesignSqlServerv2k.RDBMS_TYPE : (string3.equals("2005") ? StorageDesignSqlServerv2k5.RDBMS_TYPE : StorageDesignSqlServerv2k.RDBMS_TYPE);
                } else if (string2.equalsIgnoreCase("1075858977")) {
                    rDBMSType = string3.equals("7") ? StorageDesignUDBv71.RDBMS_TYPE : (string3.equals("8") ? StorageDesignUDBv81.RDBMS_TYPE : StorageDesignUDBv71.RDBMS_TYPE);
                }
                if (rDBMSType != null) {
                    this.design.setSelectedRDBMSSite(this.design.getFirstOfType(rDBMSType));
                }
                if ((string = element.getAttribute("name")) != null) {
                    this.setDesignName(string);
                }
                progressDialog.setNote(Messages.getString("ERwinHandler.ParseModelProxies"));
                progressDialog.setProgress(5);
                if (element2 != null) {
                    this.parseProxyObjects(element2);
                }
                progressDialog.setNote(Messages.getString("ERwinHandler.ParseDefaultValues"));
                progressDialog.setProgress(10);
                Element element4 = this.getElement(element, "Default_Groups");
                if (element4 != null) {
                    this.parseDefaultValues(element4);
                }
                progressDialog.setNote(Messages.getString("ERwinHandler.ParseValidationRules"));
                progressDialog.setProgress(15);
                Element element5 = this.getElement(element, "Validation_Rule_Groups");
                if (element5 != null) {
                    this.parseValidationRules(element5);
                }
                progressDialog.setNote(Messages.getString("ERwinHandler.ParseDomains"));
                progressDialog.setProgress(20);
                TreeMap treeMap = new TreeMap();
                Element element6 = this.getElement(element, "Domain_Groups");
                if (element6 != null) {
                    object8 = this.getElements(element6, "Domain");
                    Iterator iterator = object8.iterator();
                    while (iterator.hasNext()) {
                        object7 = (Element)iterator.next();
                        this.parseDomain((Element)object7, treeMap, importLogger);
                    }
                }
                object8 = treeMap.keySet().toArray();
                for (int i = 0; i < ((Object)object8).length; ++i) {
                    object7 = object8[i];
                    object6 = treeMap.get(object7);
                    while (treeMap.get(object6) != null) {
                        object6 = treeMap.get(object6);
                    }
                    object5 = (Domain)this.domains.get(object7);
                    if (object5 == null || (object4 = (Domain)this.domains.get(object6)) == null) continue;
                    ((Domain)object5).setLogicalDatatype(((Domain)object4).getLogicalDatatype());
                    ((Domain)object5).setDataTypeParameter("size", ((Domain)object4).getDataTypeParameter("size"));
                    ((Domain)object5).setDataTypeParameter("precision", ((Domain)object4).getDataTypeParameter("precision"));
                    ((Domain)object5).setDataTypeParameter("scale", ((Domain)object4).getDataTypeParameter("scale"));
                }
                progressDialog.setNote(Messages.getString("ERwinHandler.ParseFonts"));
                progressDialog.setProgress(25);
                Element element7 = this.getElement(element, "Font_Groups");
                if (element7 != null) {
                    object7 = this.getElements(element7, "Font");
                    object6 = object7.iterator();
                    while (object6.hasNext()) {
                        object5 = (Element)object6.next();
                        object4 = object5.getAttribute("id");
                        object3 = object5.getAttribute("name");
                        object2 = this.getElement((Element)object5, "FontProps");
                        object = this.getElementValue((Element)object2, "Font_Size");
                        String string4 = this.getElementValue((Element)object2, "Is_Font_Bold");
                        String string5 = this.getElementValue((Element)object2, "Is_Font_Italic");
                        int n = 10;
                        try {
                            n = Integer.parseInt((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        int n2 = 0;
                        if ("true".equalsIgnoreCase(string4)) {
                            n2 |= 1;
                        }
                        if ("true".equalsIgnoreCase(string5)) {
                            n2 |= 2;
                        }
                        Font font = new Font((String)object3, n2, n);
                        this.fonts.put(object4, font);
                    }
                }
                if ((object7 = this.getElement(element, "Default_Fonts_And_Colors_Groups")) != null && (object6 = this.getElement((Element)object7, "Default_Fonts_And_Colors")) != null) {
                    object5 = this.getElement((Element)object7, "Default_Fonts_And_ColorsProps");
                    this.defaultNameFontID = this.getElementValue((Element)object5, "Default_Entity_Name_Font_Ref");
                    this.defaultNameColor = this.getElementValue((Element)object5, "Default_Entity_Name_Color");
                    this.defaultFillColor = this.getElementValue((Element)object5, "Default_Entity_Fill_Color");
                    this.defaultOutlineColor = this.getElementValue((Element)object5, "Default_Entity_Outline_Color");
                    this.defaultAttributeFontID = this.getElementValue((Element)object5, "Default_Owned_Attribute_Font_Ref");
                    this.defaultAttributeColor = this.getElementValue((Element)object5, "Default_Owned_Attribute_Color");
                }
                progressDialog.setNote(Messages.getString("ERwinHandler.ParseEntitiesAndTables"));
                progressDialog.setProgress(30);
                object6 = this.getElement(element, "Entity_Groups");
                if (object6 != null) {
                    object5 = this.getElements((Element)object6, "Entity");
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        object3 = (Element)object4.next();
                        this.parseEntity((Element)object3);
                    }
                }
                progressDialog.setNote(Messages.getString("ERwinHandler.ParseViews"));
                progressDialog.setProgress(60);
                this.parseEntityViews();
                this.parseTableViews();
                progressDialog.setNote(Messages.getString("ERwinHandler.CreateMappings"));
                progressDialog.setProgress(75);
                this.createMappings(this.design, this.logicalObjects, this.relationalObjects);
                progressDialog.setNote(Messages.getString("ERwinHandler.ParseRelationships"));
                progressDialog.setProgress(80);
                object5 = this.getElement(element, "Relationship_Groups");
                if (object5 != null) {
                    object4 = this.getElements((Element)object5, "Relationship");
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object2 = (Element)object3.next();
                        this.parseRelationship((Element)object2);
                    }
                }
                this.createMappings(this.design, this.logicalObjects, this.relationalObjects);
                this.createMany2ManyMapping(this.getElement(element, "Many_To_Many_Transform_Groups"));
                this.createSuperTypeSubTypeMapping(this.getElement(element, "Supertype_Subtype_Roll_Up_Transform_Groups"));
                progressDialog.setNote(Messages.getString("ERwinHandler.RearrangeLayouts"));
                progressDialog.setProgress(90);
                object4 = this.getElement(element, "Subject_Area_Groups");
                if (object4 != null) {
                    object3 = this.getElements((Element)object4, "Subject_Area");
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (Element)object2.next();
                        this.parseSubjectArea((Element)object);
                    }
                }
                this.parseInheritanceRelations();
                if (this.isMainLogical) {
                    this.design.getLogicalDesign().rearrangeEntities();
                    this.design.getLogicalDesign().rearrangeViews();
                    this.design.getLogicalDesign().getMainView().setAutoRoute(true);
                    this.design.getLogicalDesign().getMainView().getWorkSpace().updateSettings();
                }
                if (this.isMainRelational) {
                    ((DPVRelational)this.design.getRelationalDesign().getMainView()).rearrangeNewDiagram();
                    this.design.getRelationalDesign().rearrangeViews();
                    this.design.getRelationalDesign().getMainView().setAutoRoute(true);
                    this.design.getRelationalDesign().getMainView().getWorkSpace().updateSettings();
                }
            }
            catch (Exception exception) {
                LOGGER.error("ERwinHandler - Unable to parse file: " + file.getAbsolutePath(), exception);
                importLogger.addError("Error parsing File...");
            }
        }
    }

    private void parseInheritanceRelations() {
        for (int i = this.ihObjects.size() - 1; i >= 0; --i) {
            ERwinHandler.IHObject iHObject = (ERwinHandler.IHObject)this.ihObjects.get(i);
            String string = iHObject.getParentID();
            String string2 = iHObject.getChildID();
            Entity entity = (Entity)this.logicalObjects.get(string2);
            if (entity == null) continue;
            Entity entity2 = this.getParentEntity(string);
            if (entity2 != null) {
                entity.setHierarchicalParent(entity2);
                Relation relation = entity.getInheritanceRelation();
                if (relation != null) {
                    relation.setComment(iHObject.getComment());
                }
            }
            this.ihObjects.remove(iHObject);
        }
    }

    private Entity getParentEntity(String string) {
        for (ERwinHandler.IHObject iHObject : this.ihObjects) {
            if (!iHObject.getChildID().equalsIgnoreCase(string)) continue;
            return (Entity)this.logicalObjects.get(iHObject.getParentID());
        }
        return null;
    }

    private Color reverseRGB(int n) {
        int n2 = n >> 0 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        return new Color(n2, n3, n4);
    }

    private Rectangle parseCoordinates(String string) {
        Rectangle rectangle = new Rectangle();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            int[] nArray = new int[4];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    int n2;
                    nArray[n] = n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("ERwinHandler.parseCoordinates(): Unable to parse coordinates", numberFormatException);
                }
                ++n;
            }
            rectangle.x = nArray[0];
            rectangle.y = nArray[1];
            rectangle.width = nArray[2] - nArray[0];
            rectangle.height = nArray[3] - nArray[1];
        }
        return rectangle;
    }

    private void applyValidationRule(String string, ConstrainedObject constrainedObject) {
        ERwinHandler.ValidationRuleHolder validationRuleHolder = (ERwinHandler.ValidationRuleHolder)this.validationRules.get(string);
        if (validationRuleHolder != null) {
            switch (validationRuleHolder.getType()) {
                case 0: {
                    CheckConstraint checkConstraint = new CheckConstraint();
                    checkConstraint.setDesign(this.design);
                    checkConstraint.add(new GenericConstraint(), validationRuleHolder.getRule());
                    constrainedObject.setCheck(checkConstraint);
                    break;
                }
                case 1: {
                    AVT aVT = new AVT();
                    aVT.setBeginValue(validationRuleHolder.getMinValue());
                    aVT.setEndValue(validationRuleHolder.getMaxValue());
                    aVT.setDescription(validationRuleHolder.getDefinition());
                    constrainedObject.addAVT(aVT);
                    break;
                }
                case 2: {
                    for (Object k : validationRuleHolder.getValueList().keySet()) {
                        Object v = validationRuleHolder.getValueList().get(k);
                        if (constrainedObject.getValueList() == null) {
                            ConstraintEnumeration constraintEnumeration = new ConstraintEnumeration();
                            constrainedObject.setValueList(constraintEnumeration);
                        }
                        constrainedObject.getValueList().add(k, (String)v);
                    }
                    break;
                }
            }
        }
    }

    private void parseDataType(Domain domain, String string, ImportLogger importLogger) {
        String string2;
        String string3 = string.trim();
        String string4 = "0";
        String string5 = "0";
        String string6 = "0";
        int n = string.indexOf(40);
        if (n > -1) {
            string3 = string.substring(0, n).trim();
            string2 = string.substring(n + 1, string.trim().length() - 1).trim();
            int n2 = string2.indexOf(44);
            if (n2 > -1) {
                string5 = string2.substring(0, n2).trim();
                string6 = string2.substring(n2 + 1, string2.trim().length() - 1);
            } else {
                string4 = string2;
            }
        }
        string2 = StandardDatatypeNames.getUsedDatatypeName(string3);
        String string7 = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(string2);
        LogicalDatatype logicalDatatype = this.design.getLogicalDatatypeSet().getLogTypeByName(string7);
        if (logicalDatatype != null) {
            domain.setLogicalDatatype(logicalDatatype);
            if (!"0".equalsIgnoreCase(string4)) {
                domain.setDataTypeParameter("size", string4);
            } else if (!"0".equalsIgnoreCase(string5)) {
                domain.setDataTypeParameter("precision", string5);
                domain.setDataTypeParameter("scale", string6);
            }
        } else {
            importLogger.addWarning("Unable to find Logical DataType for: " + string2);
        }
    }

    private void parseForeignKey(Element element, String string, String string2, String string3, String string4, String string5) {
        Index index;
        DesignObject designObject = (DesignObject)this.relationalObjects.get(string2);
        DesignObject designObject2 = (DesignObject)this.relationalObjects.get(string3);
        if (designObject != null && designObject2 != null && designObject instanceof Table && designObject2 instanceof Table && (index = this.getUniqueIndexForColumnNames((Table)designObject, this.getFKColumnNames(this.relationalFKElements, string))) != null) {
            FKIndexAssociation fKIndexAssociation = ((Table)designObject2).addFK(index);
            if (string4 != null && !"".equalsIgnoreCase(string4)) {
                fKIndexAssociation.setName(string4);
            }
            if (string5 != null) {
                fKIndexAssociation.setComment(string5);
            }
            for (ERwinHandler.FKElement fKElement : this.relationalFKElements) {
                if (!fKElement.getParentRelationshipID().equalsIgnoreCase(string)) continue;
                Column column = (Column)this.relationalObjects.get(fKElement.getID());
                Column column2 = (Column)this.relationalObjects.get(fKElement.getParentAttributeID());
                if (column == null || column2 == null) continue;
                column.addFKAssociation(column2, fKIndexAssociation);
                fKIndexAssociation.getLocalFKIndex().add(column);
            }
            this.relationalObjects.put(string, fKIndexAssociation);
        }
    }

    private List getFKColumnNames(List list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ERwinHandler.FKElement fKElement : list) {
            Column column;
            if (!fKElement.getParentRelationshipID().equalsIgnoreCase(string) || (column = (Column)this.relationalObjects.get(fKElement.getID())) == null) continue;
            arrayList.add(column.getName());
        }
        return arrayList;
    }

    private Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && this.isIndexForColumnNames(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getName().equalsIgnoreCase((String)list.get(i))) continue;
            return false;
        }
        return true;
    }

    private void setFontAndColor(DesignObject designObject, String string, String string2, String string3, String string4) {
        Object object;
        int n = -1;
        try {
            if (string != null) {
                n = Integer.parseInt(string);
            } else if (this.defaultFillColor != null) {
                n = Integer.parseInt(this.defaultFillColor);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n >= 0) {
            Color color = new Color(n);
            designObject.setUseDefaultColor(false);
            designObject.setBackgroundColor(color);
        }
        int n2 = -1;
        try {
            if (string2 != null) {
                n2 = Integer.parseInt(string2);
            } else if (this.defaultOutlineColor != null) {
                n2 = Integer.parseInt(this.defaultOutlineColor);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n2 >= 0) {
            Color color = new Color(n2);
            designObject.setUseDefaultColor(false);
            designObject.setForegroundColor(color);
        }
        int n3 = -1;
        try {
            if (string4 != null) {
                n3 = Integer.parseInt(string4);
            } else if (this.defaultNameColor != null) {
                n3 = Integer.parseInt(this.defaultNameColor);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n3 >= 0) {
            object = new Color(n3);
            designObject.setUseDefaultColor(false);
            designObject.setForegroundColor((Color)object);
        }
        if (!this.isUTFString(designObject.getName())) {
            object = null;
            if (string3 != null) {
                object = (Font)this.fonts.get(string3);
            } else if (this.defaultNameFontID != null) {
                object = (Font)this.fonts.get(this.defaultNameFontID);
            }
            if (object != null && designObject instanceof EditableFonts) {
                FontObject fontObject = ((EditableFonts)((Object)designObject)).getFontObject(EditableFonts.FO_TITLE);
                fontObject.setFont((Font)object);
            }
        } else if (designObject instanceof EditableFonts) {
            object = ((EditableFonts)((Object)designObject)).getFontObject(EditableFonts.FO_TITLE);
            ((FontObject)object).setFont(new Font("Dialog", ((FontObject)object).getFont().getStyle(), ((FontObject)object).getFont().getSize()));
        }
    }

    private void setAttributeFontAndColor(DesignObject designObject, String string, String string2, boolean bl) {
        FontObject fontObject;
        Object object;
        String string3 = bl ? EditableFonts.FO_ATTRIBUTE : EditableFonts.FO_COLUMN;
        int n = -1;
        try {
            if (string2 != null) {
                n = Integer.parseInt(string2);
            } else if (this.defaultAttributeColor != null) {
                n = Integer.parseInt(this.defaultAttributeColor);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n >= 0 && designObject instanceof EditableFonts) {
            object = new Color(n);
            fontObject = ((EditableFonts)((Object)designObject)).getFontObject(string3);
            fontObject.setColor((Color)object);
        }
        if (!this.isUTFString(designObject.getName())) {
            object = null;
            if (string != null) {
                object = (Font)this.fonts.get(string);
            } else if (this.defaultAttributeFontID != null) {
                object = (Font)this.fonts.get(this.defaultAttributeFontID);
            }
            if (object != null && designObject instanceof EditableFonts) {
                fontObject = ((EditableFonts)((Object)designObject)).getFontObject(string3);
                fontObject.setFont((Font)object);
            }
        } else if (designObject instanceof EditableFonts) {
            object = ((EditableFonts)((Object)designObject)).getFontObject(EditableFonts.FO_TITLE);
            ((FontObject)object).setFont(new Font("Dialog", ((FontObject)object).getFont().getStyle(), ((FontObject)object).getFont().getSize()));
        }
    }

    private void parseSubjectArea(Element element) {
        String string = element.getAttribute("name");
        Element element2 = this.getElement(element, "Subject_AreaProps");
        String string2 = this.getElementValue(element2, "Is_Main_Subject_Area");
        Element element3 = this.getElement(element, "Stored_Display_Groups");
        if (element3 != null) {
            List list = this.getElements(element3, "Stored_Display");
            for (Element element4 : list) {
                Object object;
                Object object2;
                String string3 = element4.getAttribute("name");
                Element element5 = this.getElement(element4, "Stored_DisplayProps");
                String string4 = this.getElementValue(element5, "Proxy_Short_Id");
                Element element6 = (Element)this.proxyObjects.get(string4);
                String string5 = null;
                String string6 = null;
                if (element6 != null) {
                    string5 = this.getElementPropValue(element6, "DisplayLevel_Logical");
                    string6 = this.getElementPropValue(element6, "DisplayLevel_Physical");
                }
                if (string2 != null && "true".equalsIgnoreCase(string2)) {
                    if (string5 != null && "1".equalsIgnoreCase(string5)) {
                        if (this.isMainLogical) {
                            this.parseDisplay(element4, this.logical.getMainView(), false);
                            this.isMainLogical = false;
                        } else {
                            object2 = this.logical.getMainView().addSubordinateView();
                            this.logical.getMainView().copyToDPV((DesignPartView)object2, false);
                            ((DesignPartView)object2).setName(string3);
                            this.parseDisplay(element4, (DesignPartView)object2, false);
                        }
                    }
                    if (string6 != null && "1".equalsIgnoreCase(string6)) {
                        if (this.isMainRelational) {
                            this.parseDisplay(element4, this.relational.getMainView(), false);
                            this.isMainRelational = false;
                        } else {
                            object2 = this.relational.getMainView().addSubordinateView();
                            this.relational.getMainView().copyToDPV((DesignPartView)object2, false);
                            ((DesignPartView)object2).setName(string3);
                            this.parseDisplay(element4, (DesignPartView)object2, false);
                        }
                    }
                } else {
                    if (string5 != null && "1".equalsIgnoreCase(string5)) {
                        object2 = this.logical.getSubViewByName(string);
                        if (object2 == null) {
                            object2 = this.logical.createDesignPartSubView();
                            ((DesignPartView)object2).setName(string);
                            this.parseDisplay(element4, (DesignPartView)object2, true);
                        } else {
                            object = ((DesignPartView)object2).addSubordinateView();
                            ((DesignPartView)object2).copyToDPV((DesignPartView)object, false);
                            ((DesignPartView)object).setName(string3);
                            this.parseDisplay(element4, (DesignPartView)object, false);
                        }
                    }
                    if (string6 != null && "1".equalsIgnoreCase(string6)) {
                        object2 = this.relational.getSubViewByName(string);
                        if (object2 == null) {
                            object2 = this.relational.createDesignPartSubView();
                            ((DesignPartView)object2).setName(string);
                            this.parseDisplay(element4, (DesignPartView)object2, true);
                        } else {
                            object = ((DesignPartView)object2).addSubordinateView();
                            ((DesignPartView)object2).copyToDPV((DesignPartView)object, false);
                            ((DesignPartView)object).setName(string3);
                            this.parseDisplay(element4, (DesignPartView)object, false);
                        }
                    }
                }
                if ((object2 = this.getElement(element4, "Transform_Scratch_Object_Groups")) == null) continue;
                object = this.getElements((Element)object2, "Transform_Scratch_Object");
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Element element7 = (Element)iterator.next();
                    String string7 = element7.getAttribute("id");
                    this.transformScratchObjects.put(string7, element7);
                }
            }
        }
    }

    private void parseDisplay(Element element, DesignPartView designPartView, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        Object object12;
        designPartView.setAutoRoute(false);
        designPartView.setBoxInBox(false);
        designPartView.getWorkSpace().updateSettings();
        Element element2 = this.getElement(element, "Drawing_Object_Entity_Groups");
        if (element2 != null) {
            object12 = this.getElements(element2, "Drawing_Object_Entity");
            object11 = object12.iterator();
            while (object11.hasNext()) {
                object10 = (Element)object11.next();
                object9 = this.getElement((Element)object10, "Drawing_Object_EntityProps");
                object8 = this.getElementValue((Element)object9, "Location_Rectangle");
                object7 = this.getElementValue((Element)object9, "Model_Object_Ref");
                object6 = this.parseCoordinates((String)object8);
                object5 = null;
                object5 = designPartView.getDesignPart() instanceof LogicalDesign ? (DesignObject)this.logicalObjects.get(object7) : (DesignObject)this.relationalObjects.get(object7);
                if (object5 == null) continue;
                this.parseFontsAndColors((Element)object10, (DesignObject)object5);
                object4 = null;
                if (bl) {
                    object4 = ((ContainerView)((DesignObject)object5).getTopView()).createViewSynonim(designPartView);
                    if (object4 == null) continue;
                    if (object4 != null && ((TopView)object4).getCellView() != null) {
                        ((TopView)object4).getCellView().setNewBounds((Rectangle)object6);
                    } else if (object4 != null) {
                        ((TopView)object4).setBounds((Rectangle)object6);
                    }
                    if (designPartView.getDesignPart() instanceof LogicalDesign) {
                        if (object4 instanceof TVEntity) {
                            ((TVEntity)object4).addTVRelations();
                        }
                        ((ContainerView)object4).addTVTypeSubstitutions();
                        designPartView.synchronizeSynonymWithDisplays((TopView)object4);
                        continue;
                    }
                    if (object4 instanceof TVTable) {
                        ((TVTable)object4).addTVFKRelations();
                    }
                    ((ContainerView)object4).addTVTypeSubstitutions();
                    designPartView.synchronizeSynonymWithDisplays((TopView)object4);
                    continue;
                }
                object4 = (ContainerView)((DesignObject)object5).getFirstViewForDPV(designPartView);
                if (object4 == null || ((TopView)object4).getCellView() == null) continue;
                ((TopView)object4).getCellView().setNewBounds((Rectangle)object6);
            }
        }
        designPartView.setVisible(true);
        object12 = this.getElement(element, "Drawing_Object_Relationship_Groups");
        if (object12 != null) {
            object11 = this.getElements((Element)object12, "Drawing_Object_Relationship");
            object10 = object11.iterator();
            while (object10.hasNext()) {
                object9 = (Element)object10.next();
                object8 = this.getElement((Element)object9, "Drawing_Object_RelationshipProps");
                object7 = this.getElementValue((Element)object8, "Model_Object_Ref");
                object6 = null;
                object6 = designPartView.getDesignPart() instanceof LogicalDesign ? (Relation)this.logicalObjects.get(object7) : (FKIndexAssociation)this.relationalObjects.get(object7);
                if (object6 == null || (object5 = (TVConnector)((DesignObject)object6).getFirstViewForDPV(designPartView)) == null) continue;
                try {
                    object4 = (EdgeView)((TopView)object5).getCellView();
                    if (object4 == null && ((TVConnector)object5).getEdge() != null) {
                        object4 = (EdgeView)((TVConnector)object5).getEdge().getCellView();
                    }
                    if (object4 == null) continue;
                    object3 = this.getPoints((Element)object8);
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (Point)object2.next();
                        ((TVConnector)object5).getEdgePoints().add(DiagramConstants.createPoint((Point2D)object));
                    }
                    designPartView.getWorkSpace().addPoints((DefaultEdge)((AbstractCellView)object4).getCell(), ((TVConnector)object5).getEdgePoints());
                    ((EdgeView)object4).update();
                }
                catch (Exception exception) {}
            }
        }
        object11 = new ArrayList();
        object10 = this.getElement(element, "Drawing_Object_Rectangle_Groups");
        if (object10 != null) {
            object9 = this.getElements((Element)object10, "Drawing_Object_Rectangle");
            object8 = object9.iterator();
            while (object8.hasNext()) {
                object7 = (Element)object8.next();
                object11.add(object7);
            }
        }
        if ((object9 = this.getElement(element, "Drawing_Object_Ellipse_Groups")) != null) {
            object8 = this.getElements((Element)object9, "Drawing_Object_Ellipse");
            object7 = object8.iterator();
            while (object7.hasNext()) {
                object6 = (Element)object7.next();
                object11.add(object6);
            }
        }
        object8 = object11.iterator();
        while (object8.hasNext()) {
            Object object13;
            Font font;
            object7 = (Element)object8.next();
            object6 = this.getElementPropValue((Element)object7, "Text");
            object5 = this.getElementPropValue((Element)object7, "Location_Rectangle");
            object4 = this.getElementPropValue((Element)object7, "Font_Ref");
            object3 = this.getElementPropValue((Element)object7, "Font_Color");
            object2 = this.getElementPropValue((Element)object7, "Fill_Color");
            object = this.getElementPropValue((Element)object7, "Outline_Color");
            Note note = designPartView.getDesignPart().createNote();
            note.setText((String)object6);
            TopView topView = note.getFirstViewForDPV(designPartView);
            if (topView == null) {
                topView = designPartView.createTopViewFor(note);
            }
            Rectangle rectangle = this.parseCoordinates((String)object5);
            if (topView != null) {
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(rectangle);
                } else {
                    topView.setBounds(rectangle);
                }
            }
            this.parseFontsAndColors((Element)object7, note);
            if (object4 != null && (font = (Font)this.fonts.get(object4)) != null) {
                object13 = note.getFontObject(EditableFonts.FO_TITLE);
                ((FontObject)object13).setFont(font);
            }
            try {
                if (object3 != null) {
                    int n = Integer.parseInt((String)object3);
                    object13 = new Color(n);
                    FontObject fontObject = note.getFontObject(EditableFonts.FO_TITLE);
                    fontObject.setColor((Color)object13);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                if (object2 != null) {
                    int n = Integer.parseInt((String)object2);
                    object13 = new Color(n);
                    note.setUseDefaultColor(false);
                    note.setBackgroundColor((Color)object13);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                if (object != null) {
                    int n = Integer.parseInt((String)object);
                    object13 = new Color(n);
                    note.setUseDefaultColor(false);
                    note.setForegroundColor((Color)object13);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (topView == null || topView.getCellView() != null) continue;
            designPartView.add(topView, topView.getBounds());
            designPartView.synchronizeSynonymWithDisplays(topView);
        }
    }

    private void parseFontsAndColors(Element element, DesignObject designObject) {
        int n;
        String string = this.getElementPropValue(element, "Font_Color");
        String string2 = this.getElementPropValue(element, "Fill_Color");
        String string3 = this.getElementPropValue(element, "Outline_Color");
        String string4 = this.getElementPropValue(element, "Outline_Style");
        String string5 = this.getElementPropValue(element, "Font_Ref");
        Font font = null;
        String string6 = null;
        int n2 = 10;
        Boolean bl = false;
        Boolean bl2 = false;
        if (string5 != null) {
            font = (Font)this.fonts.get(string5);
        } else if (this.defaultAttributeFontID != null) {
            font = (Font)this.fonts.get(this.defaultAttributeFontID);
        }
        if (font != null) {
            string6 = font.getName();
            n2 = font.getSize();
            bl = font.isBold();
        }
        if (string6 != null) {
            n = 0;
            int n3 = n2;
            n |= bl != false ? 1 : 0;
            Font font2 = new Font(string6, n |= bl2 != false ? 1 : 0, n3);
            if (designObject instanceof EditableFonts) {
                FontObject fontObject = ((EditableFonts)((Object)designObject)).getFontObject(EditableFonts.FO_TITLE);
                fontObject.setFont(font2);
            }
        }
        if (string != null) {
            try {
                n = Integer.parseInt(string);
                if (designObject instanceof EditableFonts) {
                    FontObject fontObject = ((EditableFonts)((Object)designObject)).getFontObject(EditableFonts.FO_TITLE);
                    fontObject.setColor(this.reverseRGB(n));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string2 != null) {
            try {
                int n4 = Integer.parseInt(string2);
                if (designObject instanceof EditableFonts) {
                    designObject.setUseDefaultColor(false);
                    designObject.setBackgroundColor(this.reverseRGB(n4));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string3 != null) {
            try {
                int n5 = Integer.parseInt(string3);
                if ("0".equalsIgnoreCase(string4)) {
                    designObject.setUseDefaultColor(false);
                    designObject.setForegroundColor(this.reverseRGB(n5));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private List getPoints(Element element) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        Element element2 = this.getElement(element, "Relationship_Coordinates_Array");
        List list = this.getElements(element2, "Relationship_Coordinates");
        String string = "";
        for (int i = 1; i < list.size() - 2; ++i) {
            Element element3 = (Element)list.get(i);
            String string2 = this.getValue(element3);
            if (string.equalsIgnoreCase(string2)) continue;
            string = string2;
            String string3 = string2.substring(0, string2.indexOf(32));
            String string4 = string2.substring(string2.indexOf(32) + 1);
            try {
                int n = Integer.parseInt(string3);
                int n2 = Integer.parseInt(string4);
                Point point = new Point(n, n2);
                arrayList.add(point);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private void parseDomain(Element element, Map map, ImportLogger importLogger) {
        String string;
        String string2 = element.getAttribute("id");
        String string3 = element.getAttribute("name");
        Domain domain = null;
        if ("<unknown>".equalsIgnoreCase(string3)) {
            domain = this.design.getDomainSet().getDefaultDomain();
        }
        if (domain == null) {
            domain = (Domain)this.design.getDomainSet().getByName(string3);
        }
        if (domain == null) {
            domain = this.design.getDomainSet().createDomain();
            domain.setName(string3);
            domain.setFileName("ERwin_domains");
        }
        this.domains.put(string2, domain);
        Element element2 = this.getElement(element, "DomainProps");
        String string4 = this.getElementValue(element2, "Logical_Data_Type");
        if (string4 != null) {
            this.parseDataType(domain, string4, importLogger);
        } else {
            string = this.getElementValue(element2, "Parent_Domain_Ref");
            if (string != null) {
                map.put(string2, string);
            }
        }
        string = this.getElementValue(element2, "Validation_Rule_Ref");
        if (string != null) {
            this.applyValidationRule(string, domain);
        }
    }

    private void parseRelationship(Element element) {
        String string = element.getAttribute("id");
        String string2 = element.getAttribute("name");
        Element element2 = this.getElement(element, "RelationshipProps");
        String string3 = this.getElementValue(element2, "Physical_Name");
        if (string3 == null) {
            string3 = string2;
        }
        String string4 = this.getElementValue(element2, "Comment");
        String string5 = this.getElementValue(element2, "Parent_Entity_Ref");
        String string6 = this.getElementValue(element2, "Child_Entity_Ref");
        String string7 = this.getElementValue(element2, "Hide_In_Logical");
        String string8 = this.getElementValue(element2, "Hide_In_Physical");
        String string9 = this.getElementValue(element2, "Type");
        if ("9".equalsIgnoreCase(string9)) {
            ERwinHandler.IHObject iHObject = new ERwinHandler.IHObject(string5, string6);
            if (string4 != null) {
                iHObject.setComment(string4);
            }
            this.ihObjects.add(iHObject);
        } else {
            if (string7 == null || !"true".equalsIgnoreCase(string7)) {
                this.parseRelation(element, string, string5, string6, string2, string4);
            }
            if (!("4".equalsIgnoreCase(string9) || string8 != null && "true".equalsIgnoreCase(string8))) {
                this.parseForeignKey(element, string, string5, string6, string3, string4);
            }
        }
    }

    private void parseRelation(Element element, String string, String string2, String string3, String string4, String string5) {
        DesignObject designObject = (DesignObject)this.logicalObjects.get(string2);
        DesignObject designObject2 = (DesignObject)this.logicalObjects.get(string3);
        if (designObject != null && designObject2 != null && designObject instanceof Entity && designObject2 instanceof Entity) {
            TVRelation tVRelation;
            Object object;
            Object object2;
            Object object32;
            Relation relation = this.logical.createRelation();
            for (Object object32 : this.logicalFKElements) {
                if (!((ERwinHandler.FKElement)object32).getParentRelationshipID().equalsIgnoreCase(string)) continue;
                object2 = (Attribute)this.logicalObjects.get(((ERwinHandler.FKElement)object32).getID());
                object = (Attribute)this.logicalObjects.get(((ERwinHandler.FKElement)object32).getParentAttributeID());
                if (object2 == null || object == null) continue;
                ((ContainedObject)object2).setReferedAttribute(((ModelIDObject)object).getObjectID());
                ((ModelIDObject)object2).setGeneratorID(relation.getObjectID());
                this.replacedAttributes.add(object2);
            }
            if (string4 != null && !"".equalsIgnoreCase(string4)) {
                relation.setName(string4);
            }
            if (string5 != null) {
                relation.setComment(string5);
            }
            relation.setSourceEntity((Entity)designObject);
            relation.setTargetEntity((Entity)designObject2);
            object32 = this.getElementPropValue(element, "Type");
            object2 = this.getElementPropValue(element, "Cardinality");
            object = this.getElementValue(element, "Null_Option_Type");
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            int n = 1;
            int n2 = 1;
            if (object32 != null && object2 != null) {
                if ("7".equalsIgnoreCase((String)object32)) {
                    bl = false;
                    bl2 = !"101".equalsIgnoreCase((String)object);
                    n2 = "-1".equalsIgnoreCase((String)object2) ? 1 : 0;
                    if ("-2".equalsIgnoreCase((String)object2)) {
                        bl3 = false;
                    }
                } else if ("2".equalsIgnoreCase((String)object32)) {
                    bl = true;
                    bl2 = false;
                    n2 = "-1".equalsIgnoreCase((String)object2) ? 1 : 0;
                    if ("-2".equalsIgnoreCase((String)object2)) {
                        bl3 = false;
                    }
                } else if ("4".equalsIgnoreCase((String)object32)) {
                    n = 0;
                    n2 = 0;
                }
                relation.setIdentifying(bl);
                relation.setOptionalSource(bl2);
                relation.setOptionalTarget(bl3);
                relation.setFireCardinalityChange(false);
                relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[n]);
                relation.setFireCardinalityChange(true);
                relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[n2]);
            }
            if ((tVRelation = (TVRelation)relation.getTopView()) != null) {
                tVRelation.addConnection();
                tVRelation.resetEdgeParams();
            }
            this.logicalObjects.put(string, relation);
        }
    }

    private void parseEntity(Element element) {
        Object object;
        String string = element.getAttribute("id");
        String string2 = element.getAttribute("name");
        Element element2 = this.getElement(element, "EntityProps");
        String string3 = this.getElementValue(element2, "Type");
        String string4 = this.getElementValue(element2, "Physical_Name");
        String string5 = this.getElementValue(element2, "Is_Physical_Only");
        String string6 = this.getElementValue(element2, "Is_Logical_Only");
        String string7 = this.getElementValue(element2, "Hide_In_Logical");
        String string8 = this.getElementValue(element2, "Hide_In_Physical");
        String string9 = this.getElementValue(element2, "Definition");
        String string10 = this.getElementValue(element2, "Fill_Color");
        String string11 = this.getElementValue(element2, "Outline_Color");
        String string12 = this.getElementValue(element2, "Default_Entity_Name_Font_Ref");
        String string13 = this.getElementValue(element2, "Default_Entity_Name_Color");
        Object var16_16 = null;
        Object var17_17 = null;
        Object var18_18 = null;
        String string14 = this.getElementValue(element2, "Comment");
        if (string4 == null || "%EntityName()".equalsIgnoreCase(string4)) {
            string4 = string2;
        }
        if (!(string5 != null && "true".equalsIgnoreCase(string5) || string7 != null && "true".equalsIgnoreCase(string7) || "".equalsIgnoreCase(string2))) {
            if ("17".equalsIgnoreCase(string3)) {
                object = this.logical.createEntityView(string2);
                this.logicalObjects.put(string, object);
                if (string9 != null) {
                    ((ModelIDObject)object).setComment(string9);
                }
                if (string14 != null) {
                    ((ModelIDObject)object).setNotes(string14);
                }
                this.setFontAndColor((DesignObject)object, string10, string11, string12, string13);
                this.logicalViews.add(element);
            } else {
                object = this.logical.createEntity(string2);
                this.logicalObjects.put(string, object);
                if (string9 != null) {
                    ((ModelIDObject)object).setComment(string9);
                }
                if (string14 != null) {
                    ((ModelIDObject)object).setNotes(string14);
                }
                this.parseAttributes(element, (Entity)object);
                this.parseKeys(element, (Entity)object);
                this.setFontAndColor((DesignObject)object, string10, string11, string12, string13);
            }
        }
        if (!(string6 != null && "true".equalsIgnoreCase(string6) || string8 != null && "true".equalsIgnoreCase(string8) || "".equalsIgnoreCase(string2))) {
            object = string2;
            if (string4 != null && !"".equalsIgnoreCase(string4)) {
                object = string4;
            }
            if ("17".equalsIgnoreCase(string3)) {
                TableView tableView = this.relational.createTableView((String)object);
                this.relationalObjects.put(string, tableView);
                if (string9 != null) {
                    tableView.setComment(string9);
                }
                if (string14 != null) {
                    tableView.setNotes(string14);
                }
                this.setFontAndColor(tableView, string10, string11, string12, string13);
                this.relationalViews.add(element);
            } else {
                Table table = this.relational.createTable((String)object);
                this.relationalObjects.put(string, table);
                if (string9 != null) {
                    table.setComment(string9);
                }
                if (string14 != null) {
                    table.setNotes(string14);
                }
                this.parseColumns(element, table);
                this.parseIndexes(element, table);
                List list = this.getElements(element2, "Validation_Rule_Ref");
                for (Element element3 : list) {
                    String string15 = this.getValue(element3);
                    ERwinHandler.ValidationRuleHolder validationRuleHolder = (ERwinHandler.ValidationRuleHolder)this.validationRules.get(string15);
                    if (validationRuleHolder == null || validationRuleHolder.getType() != 0) continue;
                    TableLevelConstraint tableLevelConstraint = table.createCheckConstraint(validationRuleHolder.getName(), validationRuleHolder.getRule());
                    table.addCheckConstraint(tableLevelConstraint);
                }
                this.setFontAndColor(table, string10, string11, string12, string13);
            }
        }
    }

    private void parseEntityViews() {
        for (Element element : this.logicalViews) {
            String string = element.getAttribute("id");
            EntityView entityView = (EntityView)this.logicalObjects.get(string);
            if (entityView == null) continue;
            this.parseViewAttributes(element, entityView);
        }
    }

    private void parseTableViews() {
        for (Element element : this.relationalViews) {
            String string = element.getAttribute("id");
            TableView tableView = (TableView)this.relationalObjects.get(string);
            if (tableView == null) continue;
            this.parseViewColumns(element, tableView);
        }
    }

    private void parseKeys(Element element, Entity entity) {
        Element element2 = this.getElement(element, "Key_Group_Groups");
        List list = this.getElements(element2, "Key_Group");
        for (Element element3 : list) {
            List list2;
            String string = element3.getAttribute("id");
            String string2 = element3.getAttribute("name");
            Element element4 = this.getElement(element3, "Key_GroupProps");
            String string3 = this.getElementValue(element4, "Key_Group_Type");
            String string4 = this.getElementValue(element4, "Definition");
            if (string3.toUpperCase().startsWith("IF") || (list2 = this.getAttributes(element3, true)).size() <= 0) continue;
            CandidateKey candidateKey = entity.createCandidateKey();
            candidateKey.setName(string2);
            this.logicalObjects.put(string, candidateKey);
            if (string4 != null) {
                candidateKey.setComment(string4);
            }
            for (Attribute attribute : list2) {
                candidateKey.add(attribute);
            }
            if (!"PK".equalsIgnoreCase(string3)) continue;
            candidateKey.makePK();
        }
    }

    private List getAttributes(Element element, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Element element2 = this.getElement(element, "Key_Group_Member_Groups");
        if (element2 != null) {
            List list = this.getElements(element2, "Key_Group_Member");
            for (Element element3 : list) {
                Element element4 = this.getElement(element3, "Key_Group_MemberProps");
                String string = this.getElementValue(element4, "Attribute_Ref");
                Object e = null;
                e = bl ? (Object)this.logicalObjects.get(string) : (Object)this.relationalObjects.get(string);
                if (e == null) continue;
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    private void parseAttributes(Element element, Entity entity) {
        Element element2 = this.getElement(element, "Attribute_Groups");
        if (element2 != null) {
            List list = this.getElements(element2, "Attribute");
            for (Element element3 : list) {
                String string;
                String string2;
                Object object;
                String string3;
                String string4;
                String string5 = element3.getAttribute("id");
                String string6 = element3.getAttribute("name");
                Element element4 = this.getElement(element3, "AttributeProps");
                String string7 = this.getElementValue(element4, "Hide_In_Logical");
                if (string7 != null && "true".equalsIgnoreCase(string7)) continue;
                String string8 = this.getElementValue(element4, "Parent_Attribute_Ref");
                String string9 = this.getElementValue(element4, "Parent_Relationship_Ref");
                if (string8 != null && string9 != null) {
                    this.logicalFKElements.add(new ERwinHandler.FKElement(string5, string8, string9));
                }
                Attribute attribute = entity.createAttribute(string6);
                this.logicalObjects.put(string5, attribute);
                String string10 = this.getElementValue(element4, "Definition");
                if (string10 != null) {
                    attribute.setComment(string10);
                }
                if ((string4 = this.getElementValue(element4, "Null_Option_Type")) != null) {
                    if ("0".equalsIgnoreCase(string4)) {
                        attribute.setNullsAllowed(true);
                    } else {
                        attribute.setNullsAllowed(false);
                    }
                }
                if ((string3 = this.getElementValue(element4, "Parent_Domain_Ref")) != null && (object = (Domain)this.domains.get(string3)) != null) {
                    attribute.setUse((short)0);
                    attribute.setDomain((Domain)object);
                }
                if ((object = this.getElementValue(element4, "Validation_Rule_Ref")) != null) {
                    attribute.setUseDomainConstraints(false);
                    this.applyValidationRule((String)object, attribute);
                }
                if ((string2 = this.getElementValue(element4, "Default")) != null && (string = (String)this.defaultValues.get(string2)) != null) {
                    attribute.setDefaultValue(string);
                }
                string = this.getElementValue(element4, "Font_Ref");
                String string11 = this.getElementValue(element4, "Font_Color");
                this.setAttributeFontAndColor(entity, string, string11, true);
            }
        }
    }

    private void parseViewAttributes(Element element, EntityView entityView) {
        Element element2 = this.getElement(element, "Attribute_Groups");
        if (element2 != null) {
            List list = this.getElements(element2, "Attribute");
            for (Element element3 : list) {
                Object object;
                String string;
                String string2 = element3.getAttribute("name");
                Element element4 = this.getElement(element3, "AttributeProps");
                String string3 = this.getElementValue(element4, "Hide_In_Logical");
                if (string3 != null && "true".equalsIgnoreCase(string3)) continue;
                String string4 = this.getElementValue(element4, "View_Expression");
                AttributeView attributeView = new AttributeView(this.logical);
                attributeView.setName(string2);
                attributeView.setDesign(this.design);
                entityView.add(attributeView);
                attributeView.setContainer(entityView);
                if (string4 != null) {
                    attributeView.setExpression(string4);
                    attributeView.setEntityAlias(entityView.getName());
                } else {
                    string = this.getElementValue(element4, "Parent_Attribute_Ref");
                    if (string != null && (object = (Attribute)this.logicalObjects.get(string)) != null) {
                        attributeView.setReferencedAttribute((ContainedObjectWithDomain)object);
                        attributeView.setDataType(((Attribute)object).getDataType().toString());
                        attributeView.setEntity((Entity)((ContainedObject)object).getContainer());
                        entityView.addToContainers(((ContainedObject)object).getContainer(), ((ContainedObject)object).getContainer().getName());
                    }
                }
                string = this.getElementValue(element4, "Font_Ref");
                object = this.getElementValue(element4, "Font_Color");
                this.setAttributeFontAndColor(entityView, string, (String)object, true);
            }
            entityView.setUserDefinedSQL(entityView.generateSQL());
        }
    }

    private void parseViewColumns(Element element, TableView tableView) {
        Element element2 = this.getElement(element, "Attribute_Groups");
        if (element2 != null) {
            List list = this.getElements(element2, "Attribute");
            for (Element element3 : list) {
                Object object;
                String string;
                String string2 = element3.getAttribute("name");
                Element element4 = this.getElement(element3, "AttributeProps");
                String string3 = this.getElementValue(element4, "Hide_In_Physical");
                if (string3 != null && "true".equalsIgnoreCase(string3)) continue;
                String string4 = this.getElementValue(element4, "View_Expression");
                String string5 = this.getElementValue(element4, "Physical_Name");
                if (string5 == null || "%AttName".equalsIgnoreCase(string5)) {
                    string5 = string2;
                }
                ColumnView columnView = new ColumnView(this.relational);
                columnView.setName(string5);
                columnView.setDesign(this.design);
                tableView.add(columnView);
                columnView.setContainer(tableView);
                if (string4 != null) {
                    columnView.setExpression(string4);
                    columnView.setTableAlias(tableView.getName());
                } else {
                    string = this.getElementValue(element4, "Parent_Attribute_Ref");
                    if (string != null && (object = (Column)this.relationalObjects.get(string)) != null) {
                        columnView.setReferencedColumn((ContainedObjectWithDomain)object);
                        columnView.setDataType(((Column)object).getDataType().toString());
                        columnView.setTable((Table)((ContainedObject)object).getContainer());
                        tableView.addToContainers(((ContainedObject)object).getContainer(), ((ContainedObject)object).getContainer().getName());
                    }
                }
                string = this.getElementValue(element4, "Font_Ref");
                object = this.getElementValue(element4, "Font_Color");
                this.setAttributeFontAndColor(tableView, string, (String)object, false);
            }
            tableView.setUserDefinedSQL(tableView.generateSQL());
        }
    }

    private void parseIndexes(Element element, Table table) {
        Element element2 = this.getElement(element, "Key_Group_Groups");
        if (element2 != null) {
            List list = this.getElements(element2, "Key_Group");
            for (Element element3 : list) {
                List list2;
                String string = element3.getAttribute("id");
                String string2 = element3.getAttribute("name");
                Element element4 = this.getElement(element3, "Key_GroupProps");
                String string3 = this.getElementValue(element4, "Key_Group_Type");
                String string4 = this.getElementValue(element4, "Definition");
                if (string3.toUpperCase().startsWith("IF") || (list2 = this.getAttributes(element3, false)).size() <= 0) continue;
                Index index = table.createIndex();
                index.setName(string2);
                this.relationalObjects.put(string, index);
                if (string4 != null) {
                    index.setComment(string4);
                }
                for (Column column : list2) {
                    index.add(column);
                }
                if ("PK".equalsIgnoreCase(string3)) {
                    index.makePK();
                    continue;
                }
                if (!string3.toUpperCase().startsWith("AK")) continue;
                index.setIndexState("Unique Constraint");
            }
        }
    }

    private void parseColumns(Element element, Table table) {
        Element element2 = this.getElement(element, "Attribute_Groups");
        if (element2 != null) {
            List list = this.getElements(element2, "Attribute");
            for (Element element3 : list) {
                String string;
                String string2;
                Object object;
                String string3;
                String string4;
                String string5 = element3.getAttribute("id");
                String string6 = element3.getAttribute("name");
                Element element4 = this.getElement(element3, "AttributeProps");
                String string7 = this.getElementValue(element4, "Hide_In_Physical");
                if (string7 != null && "true".equalsIgnoreCase(string7)) continue;
                String string8 = this.getElementValue(element4, "Physical_Name");
                if (string8 != null && "%AttName".equalsIgnoreCase(string8)) {
                    string8 = string6;
                }
                String string9 = string6;
                if (string8 != null && !"".equalsIgnoreCase(string8)) {
                    string9 = string8;
                }
                String string10 = this.getElementValue(element4, "Parent_Attribute_Ref");
                String string11 = this.getElementValue(element4, "Parent_Relationship_Ref");
                if (string10 != null && string11 != null) {
                    this.relationalFKElements.add(new ERwinHandler.FKElement(string5, string10, string11));
                }
                Column column = table.createColumn(string9);
                this.relationalObjects.put(string5, column);
                String string12 = this.getElementValue(element4, "Definition");
                if (string12 != null) {
                    column.setComment(string12);
                }
                if ((string4 = this.getElementValue(element4, "Null_Option_Type")) != null) {
                    if ("0".equalsIgnoreCase(string4)) {
                        column.setNullsAllowed(true);
                    } else {
                        column.setNullsAllowed(false);
                    }
                }
                if ((string3 = this.getElementValue(element4, "Parent_Domain_Ref")) != null && (object = (Domain)this.domains.get(string3)) != null) {
                    column.setUse((short)0);
                    column.setDomain((Domain)object);
                }
                if ((object = this.getElementValue(element4, "Validation_Rule_Ref")) != null) {
                    column.setUseDomainConstraints(false);
                    this.applyValidationRule((String)object, column);
                }
                if ((string2 = this.getElementValue(element4, "Default")) != null && (string = (String)this.defaultValues.get(string2)) != null) {
                    column.setUsesDefaultValue(true);
                    column.setDefaultValue(string);
                }
                string = this.getElementValue(element4, "Font_Ref");
                String string13 = this.getElementValue(element4, "Font_Color");
                this.setAttributeFontAndColor(table, string, string13, false);
            }
        }
    }

    private void createMany2ManyMapping(Element element) {
        if (element != null) {
            List list = this.getElements(element, "Many_To_Many_Transform");
            for (Element element2 : list) {
                XtdMapping xtdMapping;
                Element element3 = this.getElement(element2, "Many_To_Many_TransformProps");
                String string = this.getElementValue(element3, "Many_To_Many_Association_Table_Ref");
                Table table = (Table)this.relationalObjects.get(string);
                String string2 = this.getElementValue(element3, "Relationship_1_Ref");
                Relation relation = (Relation)this.logicalObjects.get(string2);
                String string3 = this.getElementValue(element3, "Relationship_2_Ref");
                Relation relation2 = (Relation)this.logicalObjects.get(string3);
                if (relation != null && table != null) {
                    xtdMapping = this.design.getExtendedMap().createMapping(relation, table);
                    xtdMapping.setRealSourceEntityID(relation.getSourceEntity().getObjectID());
                    xtdMapping.setRealTargetEntityID(relation.getTargetEntity().getObjectID());
                    table.setGeneratorID(relation.getObjectID());
                    xtdMapping.setCreationTime(System.currentTimeMillis());
                }
                if (relation2 == null || table == null) continue;
                xtdMapping = this.design.getExtendedMap().createMapping(relation2, table);
                xtdMapping.setRealSourceEntityID(relation2.getSourceEntity().getObjectID());
                xtdMapping.setRealTargetEntityID(relation2.getTargetEntity().getObjectID());
                table.setGeneratorID(relation2.getObjectID());
                xtdMapping.setCreationTime(System.currentTimeMillis());
            }
        }
    }

    private void createSuperTypeSubTypeMapping(Element element) {
        if (element != null) {
            List list = this.getElements(element, "Supertype_Subtype_Roll_Up_Transform");
            for (Element element2 : list) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Element element3;
                Element element4 = this.getElement(element2, "Supertype_Subtype_Roll_Up_TransformProps");
                String string = this.getElementValue(element4, "Parent_Table_Ref");
                String string2 = this.getElementValue(element4, "Denormalized_Table_In_Roll_Up_Ref");
                if (string != null && string2 != null) {
                    element3 = null;
                    object4 = (Table)this.relationalObjects.get(string2);
                    if (element3 != null && object4 != null) {
                        if (this.design.getExtendedMap().getMapping((DesignObject)((Object)element3), (DesignObject)object4) == null) {
                            object3 = this.design.getExtendedMap().createMapping((DesignObject)((Object)element3), (DesignObject)object4);
                            ((ModelIDObject)object4).setGeneratorID(((ModelIDObject)((Object)element3)).getObjectID());
                            ((XtdMapping)object3).setCreationTime(System.currentTimeMillis());
                        }
                        object3 = ((ContainerWithKeyObject)((Object)element3)).getPK();
                        object2 = ((ContainerWithKeyObject)object4).getPK();
                        if (object3 != null && object2 != null && this.design.getExtendedMap().getMapping((DesignObject)object3, (DesignObject)object2) == null) {
                            object = this.design.getExtendedMap().createMapping((DesignObject)object3, (DesignObject)object2);
                            ((ModelIDObject)object2).setGeneratorID(((ModelIDObject)object3).getObjectID());
                            ((XtdMapping)object).setCreationTime(System.currentTimeMillis());
                        }
                    }
                }
                if ((element3 = this.getElement(element2, "Roll_Up_Subtransform_Groups")) == null) continue;
                object4 = this.getElements(element3, "Roll_Up_Subtransform");
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (Element)object3.next();
                    object = this.getElement((Element)object2, "Association_Groups");
                    if (object == null) continue;
                    List list2 = this.getElements((Element)object, "Association");
                    for (Element element5 : list2) {
                        Element element6 = this.getElement(element5, "AssociationProps");
                        String string3 = this.getElementValue(element6, "Source_Object_Ref");
                        String string4 = this.getElementValue(element6, "Target_Object_Ref");
                        DesignObject designObject = (DesignObject)this.logicalObjects.get(string3);
                        DesignObject designObject2 = (DesignObject)this.relationalObjects.get(string4);
                        if (designObject == null || designObject2 == null || this.design.getExtendedMap().getMapping(designObject, designObject2) != null || this.isDeleted(designObject) || this.isDeleted(designObject2)) continue;
                        XtdMapping xtdMapping = this.design.getExtendedMap().createMapping(designObject, designObject2);
                        designObject2.setGeneratorID(string3);
                        xtdMapping.setCreationTime(System.currentTimeMillis());
                    }
                }
            }
        }
    }

    private void parseDefaultValues(Element element) {
        List list = this.getElements(element, "Default");
        for (Element element2 : list) {
            String string;
            String string2 = element2.getAttribute("id");
            Element element3 = this.getElement(element2, "DefaultProps");
            String string3 = this.getElementValue(element3, "Built_In_Id");
            if (string3 != null && !"0".equalsIgnoreCase(string3) || (string = this.getElementValue(element3, "Server_Value")) == null) continue;
            this.defaultValues.put(string2, string);
        }
    }

    private void parseValidationRules(Element element) {
        List list = this.getElements(element, "Validation_Rule");
        for (Element element2 : list) {
            Object object;
            Object object2;
            Object object3;
            String string = element2.getAttribute("id");
            String string2 = element2.getAttribute("name");
            Element element3 = this.getElement(element2, "Validation_RuleProps");
            String string3 = this.getElementValue(element3, "Type");
            String string4 = this.getElementValue(element2, "Definition");
            if (string3 == null || "0".equalsIgnoreCase(string3)) {
                object3 = this.getElementValue(element2, "Logical_User_Rule");
                if (object3 == null) continue;
                object2 = new ERwinHandler.ValidationRuleHolder(0);
                ((ERwinHandler.ValidationRuleHolder)object2).setName(string2);
                ((ERwinHandler.ValidationRuleHolder)object2).setRule((String)object3);
                this.validationRules.put(string, object2);
                continue;
            }
            if ("1".equalsIgnoreCase(string3)) {
                object3 = this.getElementValue(element2, "Min_Value");
                object2 = this.getElementValue(element2, "Max_Value");
                if (object3 == null || object2 == null) continue;
                object = new ERwinHandler.ValidationRuleHolder(1);
                ((ERwinHandler.ValidationRuleHolder)object).setName(string2);
                ((ERwinHandler.ValidationRuleHolder)object).setMinValue((String)object3);
                ((ERwinHandler.ValidationRuleHolder)object).setMaxValue((String)object2);
                if (string4 != null) {
                    ((ERwinHandler.ValidationRuleHolder)object).setDefinition(string4);
                }
                this.validationRules.put(string, object);
                continue;
            }
            if (!"2".equalsIgnoreCase(string3) || (object3 = this.getElement(element2, "Valid_Value_Groups")) == null) continue;
            object2 = new ERwinHandler.ValidationRuleHolder(2);
            ((ERwinHandler.ValidationRuleHolder)object2).setName(string2);
            this.validationRules.put(string, object2);
            object = this.getElements((Element)object3, "Valid_Value");
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Element element4 = (Element)iterator.next();
                String string5 = element4.getAttribute("name");
                String string6 = this.getElementValue(element4, "Definition");
                ((ERwinHandler.ValidationRuleHolder)object2).addValue(string5, string6);
            }
        }
    }

    private void parseProxyObjects(Element element) {
        String string = element.getAttribute("id");
        this.proxyObjects.put(string, element);
        Element element2 = this.getElement(element, "Stored_Display_Proxy_Object_Groups");
        if (element2 != null) {
            List list = this.getElements(element2, "Stored_Display_Proxy_Object");
            for (Element element3 : list) {
                String string2 = element3.getAttribute("id");
                this.proxyObjects.put(string2, element3);
            }
        }
    }
}

