/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.erwin;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.erwin.ERwinConstantsv4x;
import oracle.dbtools.crest.imports.erwin.ERwinHandler;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ConstrainedObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.GenericConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.logging.ImportLogger;
import org.w3c.dom.Element;

public class ERwinParserv4x
extends ERwinHandler
implements ERwinConstantsv4x {
    private Design design;
    private LogicalDesign logical;
    private RelationalDesign relational;
    private Map domains = new TreeMap();
    private Map logicalObjects = new TreeMap();
    private Map relationalObjects = new TreeMap();
    private Map colors = new TreeMap();
    private Map fonts = new TreeMap();
    private boolean isMainLogical = true;
    private boolean isMainRelational = true;
    private String defaultNameFontID;
    private String defaultNameColorID;
    private String defaultFillColorID;
    private String defaultOutlineColorID;
    private String defaultAttributeFontID;
    private String defaultAttributeColorID;
    private List logicalViews = new ArrayList();
    private List relationalViews = new ArrayList();
    private List logicalFKElements = new ArrayList();
    private List relationalFKElements = new ArrayList();
    private List ihObjects = new ArrayList();
    private Map defaultValues = new TreeMap();
    private Map validationRules = new TreeMap();
    private List replacedAttributes = new ArrayList();

    public ERwinParserv4x(ApplicationView applicationView, boolean bl) {
        super(applicationView, bl);
        this.design = applicationView.getCurrentDesign();
        this.logical = this.design.getLogicalDesign();
        this.relational = this.design.getRelationalDesign();
    }

    public void parseModel(File file, ImportLogger importLogger, ProgressDialog progressDialog, Element element) {
        block31: {
            try {
                Object object;
                Iterator iterator;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                if (element == null) break block31;
                String string = element.getAttribute("TargetServer");
                RDBMSType rDBMSType = StorageDesignDB2v70.RDBMS_TYPE;
                if (string.equalsIgnoreCase("192")) {
                    rDBMSType = StorageDesignUDBv71.RDBMS_TYPE;
                } else if (string.equalsIgnoreCase("174")) {
                    rDBMSType = StorageDesignOraclev9i.RDBMS_TYPE;
                } else if (string.equalsIgnoreCase("172")) {
                    rDBMSType = StorageDesignSqlServerv2k.RDBMS_TYPE;
                }
                this.design.setSelectedRDBMSSite(this.design.getFirstOfType(rDBMSType));
                Element element2 = this.getElement(element, "ModelProps");
                String string2 = this.getElementValue(element2, "Name");
                if (string2 != null) {
                    this.setDesignName(string2);
                }
                progressDialog.setNote(Messages.getString("ERwinHandler.ParseDefaultValues"));
                progressDialog.setProgress(10);
                Element element3 = this.getElement(element, "Default_Value_Groups");
                if (element3 != null) {
                    this.parseDefaultValues(element3);
                }
                progressDialog.setNote(Messages.getString("ERwinHandler.ParseValidationRules"));
                progressDialog.setProgress(15);
                Element element4 = this.getElement(element, "Validation_Rule_Groups");
                if (element4 != null) {
                    this.parseValidationRules(element4);
                }
                progressDialog.setNote(Messages.getString("ERwinHandler.ParseDomains"));
                progressDialog.setProgress(20);
                TreeMap treeMap = new TreeMap();
                Element element5 = this.getElement(element, "Domain_Groups");
                if (element5 != null) {
                    object8 = this.getElements(element5, "Domain");
                    Iterator iterator2 = object8.iterator();
                    while (iterator2.hasNext()) {
                        object7 = (Element)iterator2.next();
                        this.parseDomain((Element)object7, treeMap, importLogger);
                    }
                }
                object8 = treeMap.keySet().toArray();
                for (int i = 0; i < ((Object)object8).length; ++i) {
                    object7 = object8[i];
                    object6 = treeMap.get(object7);
                    while (treeMap.get(object6) != null) {
                        object6 = treeMap.get(object6);
                    }
                    object5 = (Domain)this.domains.get(object7);
                    if (object5 == null || (object4 = (Domain)this.domains.get(object6)) == null) continue;
                    ((Domain)object5).setLogicalDatatype(((Domain)object4).getLogicalDatatype());
                    ((Domain)object5).setDataTypeParameter("size", ((Domain)object4).getDataTypeParameter("size"));
                    ((Domain)object5).setDataTypeParameter("precision", ((Domain)object4).getDataTypeParameter("precision"));
                    ((Domain)object5).setDataTypeParameter("scale", ((Domain)object4).getDataTypeParameter("scale"));
                }
                progressDialog.setNote(Messages.getString("ERwinHandler.ParseFonts"));
                progressDialog.setProgress(15);
                Element element6 = this.getElement(element, "Font_Groups");
                if (element6 != null) {
                    object7 = this.getElements(element6, "Font");
                    object6 = object7.iterator();
                    while (object6.hasNext()) {
                        object5 = (Element)object6.next();
                        object4 = object5.getAttribute("id");
                        object3 = this.getElementValue((Element)object5, "Font_Name");
                        object2 = this.getElementValue((Element)object5, "Font_Size");
                        iterator = this.getElementValue((Element)object5, "Font_Bold");
                        object = this.getElementValue((Element)object5, "Font_Italic");
                        int n = 10;
                        try {
                            n = Integer.parseInt((String)object2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        int n2 = 0;
                        if ("true".equalsIgnoreCase((String)((Object)iterator))) {
                            n2 |= 1;
                        }
                        if ("true".equalsIgnoreCase((String)object)) {
                            n2 |= 2;
                        }
                        Font font = new Font((String)object3, n2, n);
                        this.fonts.put(object4, font);
                    }
                }
                progressDialog.setNote(Messages.getString("ERwinHandler.ParseColors"));
                progressDialog.setProgress(20);
                object7 = this.getElement(element, "Color_Groups");
                if (object7 != null) {
                    object6 = this.getElements((Element)object7, "Color");
                    object5 = object6.iterator();
                    while (object5.hasNext()) {
                        object4 = (Element)object5.next();
                        object3 = object4.getAttribute("id");
                        object2 = object4.getAttribute("Name");
                        iterator = (Iterator)this.parseRGB((String)object2);
                        object = new Color((int)iterator[0], (int)iterator[1], (int)iterator[2]);
                        this.colors.put(object3, object);
                    }
                }
                if ((object6 = this.getElement(element, "Default_Fonts_and_Colors_Object_Groups")) != null) {
                    this.defaultNameFontID = this.getElementValue((Element)object6, "Default_Entity_Name_Font");
                    this.defaultNameColorID = this.getElementValue((Element)object6, "Default_Entity_Name_Color");
                    this.defaultFillColorID = this.getElementValue((Element)object6, "Default_Entity_Fill_Color");
                    this.defaultOutlineColorID = this.getElementValue((Element)object6, "Default_Entity_Outline_Color");
                    this.defaultAttributeFontID = this.getElementValue((Element)object6, "Default_Owned_Attribute_Font");
                    this.defaultAttributeColorID = this.getElementValue((Element)object6, "Default_Owned_Attribute_Color");
                }
                progressDialog.setNote(Messages.getString("ERwinHandler.ParseEntitiesAndTables"));
                progressDialog.setProgress(30);
                object5 = this.getElement(element, "Entity_Groups");
                if (object5 != null) {
                    object4 = this.getElements((Element)object5, "Entity");
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object2 = (Element)object3.next();
                        this.parseEntity((Element)object2);
                    }
                }
                progressDialog.setNote(Messages.getString("ERwinHandler.ParseViews"));
                progressDialog.setProgress(60);
                this.parseEntityViews();
                this.parseTableViews();
                progressDialog.setNote(Messages.getString("ERwinHandler.CreateMappings"));
                progressDialog.setProgress(75);
                this.createMappings(this.design, this.logicalObjects, this.relationalObjects);
                progressDialog.setNote(Messages.getString("ERwinHandler.ParseRelationships"));
                progressDialog.setProgress(80);
                object4 = this.getElement(element, "Relationship_Groups");
                if (object4 != null) {
                    object3 = this.getElements((Element)object4, "Relationship");
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        iterator = (Element)object2.next();
                        this.parseRelationship((Element)((Object)iterator));
                    }
                }
                this.createMappings(this.design, this.logicalObjects, this.relationalObjects);
                this.createMany2ManyMapping(this.getElement(element, "Many_To_Many_Transform_Groups"));
                this.createSuperTypeSubTypeMapping(this.getElement(element, "Supertype_Subtype_Roll_Up_Groups"));
                progressDialog.setNote(Messages.getString("ERwinHandler.RearrangeLayouts"));
                progressDialog.setProgress(90);
                object3 = this.getElement(element, "Subject_Area_Groups");
                if (object3 != null) {
                    object2 = this.getElements((Element)object3, "Subject_Area");
                    iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        object = (Element)iterator.next();
                        this.parseSubjectArea((Element)object);
                    }
                }
                this.parseInheritanceRelations();
                if (this.isMainLogical) {
                    this.design.getLogicalDesign().rearrangeEntities();
                    this.design.getLogicalDesign().rearrangeViews();
                    this.design.getLogicalDesign().getMainView().setAutoRoute(true);
                    this.design.getLogicalDesign().getMainView().getWorkSpace().updateSettings();
                }
                if (this.isMainRelational) {
                    ((DPVRelational)this.design.getRelationalDesign().getMainView()).rearrangeNewDiagram();
                    this.design.getRelationalDesign().rearrangeViews();
                    this.design.getRelationalDesign().getMainView().setAutoRoute(true);
                    this.design.getRelationalDesign().getMainView().getWorkSpace().updateSettings();
                }
            }
            catch (Exception exception) {
                LOGGER.error("ERwinHandler - Unable to parse file: " + file.getAbsolutePath(), exception);
                importLogger.addError("Error parsing File...");
            }
        }
    }

    private void parseInheritanceRelations() {
        for (int i = this.ihObjects.size() - 1; i >= 0; --i) {
            ERwinHandler.IHObject iHObject = (ERwinHandler.IHObject)this.ihObjects.get(i);
            String string = iHObject.getParentID();
            String string2 = iHObject.getChildID();
            Entity entity = (Entity)this.logicalObjects.get(string2);
            if (entity == null) continue;
            Entity entity2 = this.getParentEntity(string);
            if (entity2 != null) {
                entity.setHierarchicalParent(entity2);
                Relation relation = entity.getInheritanceRelation();
                if (relation != null) {
                    relation.setComment(iHObject.getComment());
                }
            }
            this.ihObjects.remove(iHObject);
        }
    }

    private Entity getParentEntity(String string) {
        for (ERwinHandler.IHObject iHObject : this.ihObjects) {
            if (!iHObject.getChildID().equalsIgnoreCase(string)) continue;
            return (Entity)this.logicalObjects.get(iHObject.getParentID());
        }
        return null;
    }

    private int[] parseRGB(String string) {
        int[] nArray = new int[3];
        String string2 = string.substring(string.indexOf(40) + 1, string.length() - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            try {
                int n2;
                nArray[n] = n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n;
        }
        return nArray;
    }

    private Color reverseRGB(int n) {
        int n2 = n >> 0 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        return new Color(n2, n3, n4);
    }

    private Rectangle parseCoordinates(String string) {
        Rectangle rectangle = new Rectangle();
        if (string != null) {
            String string2 = string.substring(1, string.length() - 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int[] nArray = new int[4];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    int n2;
                    nArray[n] = n2 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("ERwinHandler.parseCoordinates(): Unable to parse coordinates", numberFormatException);
                }
                ++n;
            }
            rectangle.y = nArray[0];
            rectangle.x = nArray[1];
            rectangle.height = nArray[2] - nArray[0];
            rectangle.width = nArray[3] - nArray[1];
        }
        return rectangle;
    }

    private void applyValidationRule(String string, ConstrainedObject constrainedObject) {
        ERwinHandler.ValidationRuleHolder validationRuleHolder = (ERwinHandler.ValidationRuleHolder)this.validationRules.get(string);
        if (validationRuleHolder != null) {
            switch (validationRuleHolder.getType()) {
                case 0: {
                    CheckConstraint checkConstraint = new CheckConstraint();
                    checkConstraint.setDesign(this.design);
                    checkConstraint.add(new GenericConstraint(), validationRuleHolder.getRule());
                    constrainedObject.setCheck(checkConstraint);
                    break;
                }
                case 1: {
                    AVT aVT = new AVT();
                    aVT.setBeginValue(validationRuleHolder.getMinValue());
                    aVT.setEndValue(validationRuleHolder.getMaxValue());
                    aVT.setDescription(validationRuleHolder.getDefinition());
                    constrainedObject.addAVT(aVT);
                    break;
                }
                case 2: {
                    for (Object k : validationRuleHolder.getValueList().keySet()) {
                        Object v = validationRuleHolder.getValueList().get(k);
                        if (constrainedObject.getValueList() == null) {
                            ConstraintEnumeration constraintEnumeration = new ConstraintEnumeration();
                            constrainedObject.setValueList(constraintEnumeration);
                        }
                        constrainedObject.getValueList().add(k, (String)v);
                    }
                    break;
                }
            }
        }
    }

    private void parseDataType(Domain domain, String string, ImportLogger importLogger) {
        String string2;
        String string3 = string.trim();
        String string4 = "0";
        String string5 = "0";
        String string6 = "0";
        int n = string.indexOf(40);
        if (n > -1) {
            string3 = string.substring(0, n).trim();
            string2 = string.substring(n + 1, string.trim().length() - 1).trim();
            int n2 = string2.indexOf(44);
            if (n2 > -1) {
                string5 = string2.substring(0, n2).trim();
                string6 = string2.substring(n2 + 1, string2.trim().length() - 1);
            } else {
                string4 = string2;
            }
        }
        string2 = StandardDatatypeNames.getUsedDatatypeName(string3);
        String string7 = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(string2);
        LogicalDatatype logicalDatatype = this.design.getLogicalDatatypeSet().getLogTypeByName(string7);
        if (logicalDatatype != null) {
            domain.setLogicalDatatype(logicalDatatype);
            if (!"0".equalsIgnoreCase(string4)) {
                domain.setDataTypeParameter("size", string4);
            } else if (!"0".equalsIgnoreCase(string5)) {
                domain.setDataTypeParameter("precision", string5);
                domain.setDataTypeParameter("scale", string6);
            }
        } else {
            importLogger.addWarning("Unable to find Logical DataType for: " + string2);
        }
    }

    private void parseForeignKey(Element element, String string, String string2, String string3, String string4, String string5) {
        Index index;
        DesignObject designObject = (DesignObject)this.relationalObjects.get(string2);
        DesignObject designObject2 = (DesignObject)this.relationalObjects.get(string3);
        if (designObject != null && designObject2 != null && designObject instanceof Table && designObject2 instanceof Table && (index = this.getUniqueIndexForColumnNames((Table)designObject, this.getFKColumnNames(this.relationalFKElements, string))) != null) {
            FKIndexAssociation fKIndexAssociation = ((Table)designObject2).addFK(index);
            if (string4 != null && !"".equalsIgnoreCase(string4)) {
                fKIndexAssociation.setName(string4);
            }
            if (string5 != null) {
                fKIndexAssociation.setComment(string5);
            }
            for (ERwinHandler.FKElement fKElement : this.relationalFKElements) {
                if (!fKElement.getParentRelationshipID().equalsIgnoreCase(string)) continue;
                Column column = (Column)this.relationalObjects.get(fKElement.getID());
                Column column2 = (Column)this.relationalObjects.get(fKElement.getParentAttributeID());
                if (column == null || column2 == null) continue;
                column.addFKAssociation(column2, fKIndexAssociation);
                fKIndexAssociation.getLocalFKIndex().add(column);
            }
            this.relationalObjects.put(string, fKIndexAssociation);
        }
    }

    private List getFKColumnNames(List list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ERwinHandler.FKElement fKElement : list) {
            Column column;
            if (!fKElement.getParentRelationshipID().equalsIgnoreCase(string) || (column = (Column)this.relationalObjects.get(fKElement.getID())) == null) continue;
            arrayList.add(column.getName());
        }
        return arrayList;
    }

    private Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && this.isIndexForColumnNames(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getName().equalsIgnoreCase((String)list.get(i))) continue;
            return false;
        }
        return true;
    }

    private void setFontAndColor(DesignObject designObject, String string, String string2, String string3, String string4) {
        Object object;
        Color color = null;
        if (string != null) {
            color = (Color)this.colors.get(string);
        } else if (this.defaultFillColorID != null) {
            color = (Color)this.colors.get(this.defaultFillColorID);
        }
        if (color != null) {
            designObject.setUseDefaultColor(false);
            designObject.setBackgroundColor(color);
        }
        Color color2 = null;
        if (string2 != null) {
            color2 = (Color)this.colors.get(string2);
        } else if (this.defaultOutlineColorID != null) {
            color2 = (Color)this.colors.get(this.defaultOutlineColorID);
        }
        if (color2 != null) {
            designObject.setUseDefaultColor(false);
            designObject.setForegroundColor(color2);
        }
        Color color3 = null;
        if (string4 != null) {
            color3 = (Color)this.colors.get(string4);
        } else if (this.defaultNameColorID != null) {
            color3 = (Color)this.colors.get(this.defaultNameColorID);
        }
        if (color3 != null && designObject instanceof EditableFonts) {
            object = ((EditableFonts)((Object)designObject)).getFontObject(EditableFonts.FO_TITLE);
            ((FontObject)object).setColor(color3);
        }
        if (!this.isUTFString(designObject.getName())) {
            object = null;
            if (string3 != null) {
                object = (Font)this.fonts.get(string3);
            } else if (this.defaultNameFontID != null) {
                object = (Font)this.fonts.get(this.defaultNameFontID);
            }
            if (object != null && designObject instanceof EditableFonts) {
                FontObject fontObject = ((EditableFonts)((Object)designObject)).getFontObject(EditableFonts.FO_TITLE);
                fontObject.setFont((Font)object);
            }
        } else if (designObject instanceof EditableFonts) {
            object = ((EditableFonts)((Object)designObject)).getFontObject(EditableFonts.FO_TITLE);
            ((FontObject)object).setFont(new Font("Dialog", ((FontObject)object).getFont().getStyle(), ((FontObject)object).getFont().getSize()));
        }
    }

    private void setAttributeFontAndColor(DesignObject designObject, String string, String string2, boolean bl) {
        Object object;
        Color color = null;
        String string3 = bl ? EditableFonts.FO_ATTRIBUTE : EditableFonts.FO_COLUMN;
        if (string2 != null) {
            color = (Color)this.colors.get(string2);
        } else if (this.defaultAttributeColorID != null) {
            color = (Color)this.colors.get(this.defaultAttributeColorID);
        }
        if (color != null && designObject instanceof EditableFonts) {
            object = ((EditableFonts)((Object)designObject)).getFontObject(string3);
            ((FontObject)object).setColor(color);
        }
        if (!this.isUTFString(designObject.getName())) {
            object = null;
            if (string != null) {
                object = (Font)this.fonts.get(string);
            } else if (this.defaultAttributeFontID != null) {
                object = (Font)this.fonts.get(this.defaultAttributeFontID);
            }
            if (object != null && designObject instanceof EditableFonts) {
                FontObject fontObject = ((EditableFonts)((Object)designObject)).getFontObject(string3);
                fontObject.setFont((Font)object);
            }
        } else if (designObject instanceof EditableFonts) {
            object = ((EditableFonts)((Object)designObject)).getFontObject(EditableFonts.FO_TITLE);
            ((FontObject)object).setFont(new Font("Dialog", ((FontObject)object).getFont().getStyle(), ((FontObject)object).getFont().getSize()));
        }
    }

    private void parseSubjectArea(Element element) {
        String string = element.getAttribute("Name");
        Element element2 = this.getElement(element, "Stored_Display_Groups");
        if (element2 != null) {
            List list = this.getElements(element2, "Stored_Display");
            for (Element element3 : list) {
                DesignPartView designPartView;
                DesignPartView designPartView2;
                Element element4 = this.getElement(element3, "Stored_DisplayProps");
                String string2 = this.getElementValue(element4, "Name");
                String string3 = this.getElementValue(element4, "Display_Physical_Level");
                if ("<Main Subject Area>".equalsIgnoreCase(string)) {
                    if ("0".equalsIgnoreCase(string3)) {
                        if (this.isMainLogical) {
                            this.parseDisplay(element3, this.logical.getMainView(), false);
                            this.isMainLogical = false;
                            continue;
                        }
                        designPartView2 = this.logical.getMainView().addSubordinateView();
                        this.logical.getMainView().copyToDPV(designPartView2, false);
                        designPartView2.setName(string2);
                        this.parseDisplay(element3, designPartView2, false);
                        continue;
                    }
                    if (this.isMainRelational) {
                        this.parseDisplay(element3, this.relational.getMainView(), false);
                        this.isMainRelational = false;
                        continue;
                    }
                    designPartView2 = this.relational.getMainView().addSubordinateView();
                    this.relational.getMainView().copyToDPV(designPartView2, false);
                    designPartView2.setName(string2);
                    this.parseDisplay(element3, designPartView2, false);
                    continue;
                }
                if ("0".equalsIgnoreCase(string3)) {
                    designPartView2 = this.logical.getSubViewByName(string);
                    if (designPartView2 == null) {
                        designPartView2 = this.logical.createDesignPartSubView();
                        designPartView2.setName(string);
                        this.parseDisplay(element3, designPartView2, true);
                        continue;
                    }
                    designPartView = designPartView2.addSubordinateView();
                    designPartView2.copyToDPV(designPartView, false);
                    designPartView.setName(string2);
                    this.parseDisplay(element3, designPartView, false);
                    continue;
                }
                designPartView2 = this.relational.getSubViewByName(string);
                if (designPartView2 == null) {
                    designPartView2 = this.relational.createDesignPartSubView();
                    designPartView2.setName(string);
                    this.parseDisplay(element3, designPartView2, true);
                    continue;
                }
                designPartView = designPartView2.addSubordinateView();
                designPartView2.copyToDPV(designPartView, false);
                designPartView.setName(string2);
                this.parseDisplay(element3, designPartView, false);
            }
        }
    }

    private void parseDisplay(Element element, DesignPartView designPartView, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Element element2;
        Object object9;
        Object object10;
        Object object11;
        designPartView.setAutoRoute(false);
        designPartView.setBoxInBox(false);
        designPartView.getWorkSpace().updateSettings();
        Element element3 = this.getElement(element, "Drawing_Object_Entity_Groups");
        if (element3 != null) {
            object11 = this.getElements(element3, "Drawing_Object_Entity");
            object10 = object11.iterator();
            while (object10.hasNext()) {
                object9 = (Element)object10.next();
                element2 = this.getElement((Element)object9, "Drawing_Object_EntityProps");
                object8 = this.getElementValue(element2, "DO_Location");
                object7 = this.getElementValue(element2, "DO_Reference_Object");
                object6 = this.parseCoordinates((String)object8);
                object5 = null;
                object5 = designPartView.getDesignPart() instanceof LogicalDesign ? (DesignObject)this.logicalObjects.get(object7) : (DesignObject)this.relationalObjects.get(object7);
                if (object5 == null) continue;
                this.parseFontsAndColors((Element)object9, (DesignObject)object5);
                object4 = null;
                if (bl) {
                    object4 = ((ContainerView)((DesignObject)object5).getTopView()).createViewSynonim(designPartView);
                    if (object4 != null && ((TopView)object4).getCellView() != null) {
                        ((TopView)object4).getCellView().setNewBounds((Rectangle)object6);
                    } else if (object4 != null) {
                        ((TopView)object4).setBounds((Rectangle)object6);
                    }
                    if (object4 == null) continue;
                    if (designPartView.getDesignPart() instanceof LogicalDesign) {
                        if (object4 instanceof TVEntity) {
                            ((TVEntity)object4).addTVRelations();
                        }
                        ((ContainerView)object4).addTVTypeSubstitutions();
                        designPartView.synchronizeSynonymWithDisplays((TopView)object4);
                        continue;
                    }
                    if (object4 instanceof TVTable) {
                        ((TVTable)object4).addTVFKRelations();
                    }
                    ((ContainerView)object4).addTVTypeSubstitutions();
                    designPartView.synchronizeSynonymWithDisplays((TopView)object4);
                    continue;
                }
                object4 = (ContainerView)((DesignObject)object5).getFirstViewForDPV(designPartView);
                if (object4 == null || ((TopView)object4).getCellView() == null) continue;
                ((TopView)object4).getCellView().setNewBounds((Rectangle)object6);
            }
        }
        designPartView.setVisible(true);
        object11 = this.getElement(element, "Drawing_Object_Relationship_Groups");
        if (object11 != null) {
            object10 = this.getElements((Element)object11, "Drawing_Object_Relationship");
            object9 = object10.iterator();
            while (object9.hasNext()) {
                element2 = (Element)object9.next();
                object8 = this.getElement(element2, "Drawing_Object_RelationshipProps");
                object7 = this.getElementValue((Element)object8, "DO_Reference_Object");
                object6 = null;
                object6 = designPartView.getDesignPart() instanceof LogicalDesign ? (Relation)this.logicalObjects.get(object7) : (FKIndexAssociation)this.relationalObjects.get(object7);
                if (object6 == null || (object5 = (TVConnector)((DesignObject)object6).getFirstViewForDPV(designPartView)) == null) continue;
                try {
                    object4 = (EdgeView)((TopView)object5).getCellView();
                    if (object4 == null && ((TVConnector)object5).getEdge() != null) {
                        object4 = (EdgeView)((TVConnector)object5).getEdge().getCellView();
                    }
                    if (object4 == null) continue;
                    object3 = this.getPoints((Element)object8);
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (Point)object2.next();
                        ((TVConnector)object5).getEdgePoints().add(DiagramConstants.createPoint((Point2D)object));
                    }
                    designPartView.getWorkSpace().addPoints((DefaultEdge)((AbstractCellView)object4).getCell(), ((TVConnector)object5).getEdgePoints());
                    ((EdgeView)object4).update();
                }
                catch (Exception exception) {}
            }
        }
        object10 = new ArrayList();
        object9 = this.getElement(element, "Drawing_Object_Rectangle_Groups");
        if (object9 != null) {
            object10.addAll(this.getElements((Element)object9, "Drawing_Object_Rectangle"));
        }
        if ((element2 = this.getElement(element, "Drawing_Object_Round_Rectangle_Groups")) != null) {
            object10.addAll(this.getElements(element2, "Drawing_Object_Round_Rectangle"));
        }
        if ((object8 = this.getElement(element, "Drawing_Object_Ellipse_Groups")) != null) {
            object10.addAll(this.getElements((Element)object8, "Drawing_Object_Ellipse"));
        }
        object7 = object10.iterator();
        while (object7.hasNext()) {
            FontObject fontObject;
            Serializable serializable;
            object6 = (Element)object7.next();
            object5 = this.getElementValue((Element)object6, "DO_Text");
            object4 = this.getElementValue((Element)object6, "DO_Location");
            object3 = this.getElementValue((Element)object6, "Drawing_Object_Font");
            object2 = this.getElementValue((Element)object6, "Drawing_Object_Font_Color");
            object = this.getElementValue((Element)object6, "Drawing_Object_Fill_Color");
            String string = this.getElementValue((Element)object6, "Drawing_Object_Outline_Color");
            String string2 = this.getElementValue((Element)object6, "DO_Outline_Style");
            Note note = designPartView.getDesignPart().createNote();
            note.setText((String)object5);
            TopView topView = note.getFirstViewForDPV(designPartView);
            if (topView == null) {
                topView = designPartView.createTopViewFor(note);
            }
            Rectangle rectangle = this.parseCoordinates((String)object4);
            if (topView != null) {
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(rectangle);
                } else {
                    topView.setBounds(rectangle);
                }
            }
            this.parseFontsAndColors((Element)object6, note);
            if (object3 != null && (serializable = (Font)this.fonts.get(object3)) != null) {
                fontObject = note.getFontObject(EditableFonts.FO_TITLE);
                fontObject.setFont((Font)serializable);
            }
            if (object2 != null && (serializable = (Color)this.colors.get(object2)) != null) {
                fontObject = note.getFontObject(EditableFonts.FO_TITLE);
                fontObject.setColor((Color)serializable);
            }
            if (object != null && (serializable = (Color)this.colors.get(object)) != null) {
                note.setUseDefaultColor(false);
                note.setBackgroundColor((Color)serializable);
            }
            if (string != null && "0".equalsIgnoreCase(string2) && (serializable = (Color)this.colors.get(string)) != null) {
                note.setUseDefaultColor(false);
                note.setForegroundColor((Color)serializable);
            }
            if (topView == null || topView.getCellView() != null) continue;
            designPartView.add(topView, topView.getBounds());
            designPartView.synchronizeSynonymWithDisplays(topView);
        }
    }

    private void parseFontsAndColors(Element element, DesignObject designObject) {
        int n;
        String string = this.getElementValue(element, "DO_Font_Name");
        String string2 = this.getElementValue(element, "DO_Font_Size");
        String string3 = this.getElementValue(element, "DO_Font_Color");
        String string4 = this.getElementValue(element, "DO_Font_Bold");
        String string5 = this.getElementValue(element, "DO_Font_Italic");
        String string6 = this.getElementValue(element, "DO_Background_Color");
        String string7 = this.getElementValue(element, "DO_Outline_Color");
        String string8 = this.getElementValue(element, "DO_Outline_Style");
        if (string != null) {
            n = 10;
            if (string2 != null) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int n2 = 0;
            if (string4 != null) {
                try {
                    n |= Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string5 != null) {
                try {
                    n |= Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Font font = new Font(string, n2, n);
            if (designObject instanceof EditableFonts) {
                FontObject fontObject = ((EditableFonts)((Object)designObject)).getFontObject(EditableFonts.FO_TITLE);
                fontObject.setFont(font);
            }
        }
        if (string3 != null) {
            n = Integer.parseInt(string3);
            if (designObject instanceof EditableFonts) {
                FontObject fontObject = ((EditableFonts)((Object)designObject)).getFontObject(EditableFonts.FO_TITLE);
                fontObject.setColor(this.reverseRGB(n));
            }
        }
        if (string6 != null) {
            try {
                n = Integer.parseInt(string6);
                designObject.setUseDefaultColor(false);
                designObject.setBackgroundColor(this.reverseRGB(n));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string7 != null && "0".equalsIgnoreCase(string8)) {
            try {
                int n3 = Integer.parseInt(string7);
                designObject.setUseDefaultColor(false);
                designObject.setForegroundColor(this.reverseRGB(n3));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private List getPoints(Element element) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        List list = this.getElements(element, "DO_Relationship_Path");
        String string = "";
        for (int i = 1; i < list.size() - 2; ++i) {
            Element element2 = (Element)list.get(i);
            String string2 = Token.getValBetweenBrackets(element2.getFirstChild().getNodeValue());
            if (string.equalsIgnoreCase(string2)) continue;
            string = string2;
            String string3 = string2.substring(0, string2.indexOf(44));
            String string4 = string2.substring(string2.indexOf(44) + 1);
            try {
                int n = Integer.parseInt(string3);
                int n2 = Integer.parseInt(string4);
                Point point = new Point(n, n2);
                arrayList.add(point);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private void parseDomain(Element element, Map map, ImportLogger importLogger) {
        String string;
        String string2 = element.getAttribute("id");
        String string3 = element.getAttribute("Name");
        Domain domain = null;
        if ("<unknown>".equalsIgnoreCase(string3)) {
            domain = this.design.getDomainSet().getDefaultDomain();
        }
        if (domain == null) {
            domain = (Domain)this.design.getDomainSet().getByName(string3);
        }
        if (domain == null) {
            domain = this.design.getDomainSet().createDomain();
            domain.setName(string3);
            domain.setFileName("ERwin_domains");
        }
        this.domains.put(string2, domain);
        Element element2 = this.getElement(element, "DomainProps");
        String string4 = this.getElementValue(element2, "Datatype");
        if (string4 != null) {
            this.parseDataType(domain, string4, importLogger);
        } else {
            string = this.getElementValue(element2, "Parent_Domain");
            if (string != null) {
                map.put(string2, string);
            }
        }
        string = this.getElementValue(element2, "Validation_Rule_Ref");
        if (string != null) {
            this.applyValidationRule(string, domain);
        }
    }

    private void parseRelationship(Element element) {
        String string = element.getAttribute("id");
        String string2 = this.getElementValue(element, "Name");
        String string3 = this.getElementValue(element, "Physical_Name");
        if (string3 == null) {
            string3 = string2;
        }
        String string4 = this.getElementValue(element, "Note");
        String string5 = this.getElementValue(element, "Relationship_Parent_Entity");
        String string6 = this.getElementValue(element, "Relationship_Child_Entity");
        String string7 = this.getElementValue(element, "Hide_in_Logical");
        String string8 = this.getElementValue(element, "Hide_in_Physical");
        String string9 = this.getElementValue(element, "Type");
        if ("9".equalsIgnoreCase(string9)) {
            ERwinHandler.IHObject iHObject = new ERwinHandler.IHObject(string5, string6);
            if (string4 != null) {
                iHObject.setComment(string4);
            }
            this.ihObjects.add(iHObject);
        } else {
            if (string7 == null || !"true".equalsIgnoreCase(string7)) {
                this.parseRelation(element, string, string5, string6, string2, string4);
            }
            if (!("4".equalsIgnoreCase(string9) || string8 != null && "true".equalsIgnoreCase(string8))) {
                this.parseForeignKey(element, string, string5, string6, string3, string4);
            }
        }
    }

    private void parseRelation(Element element, String string, String string2, String string3, String string4, String string5) {
        DesignObject designObject = (DesignObject)this.logicalObjects.get(string2);
        DesignObject designObject2 = (DesignObject)this.logicalObjects.get(string3);
        if (designObject != null && designObject2 != null && designObject instanceof Entity && designObject2 instanceof Entity) {
            TVRelation tVRelation;
            Object object;
            Object object2;
            Object object32;
            Relation relation = this.logical.createRelation();
            for (Object object32 : this.logicalFKElements) {
                if (!((ERwinHandler.FKElement)object32).getParentRelationshipID().equalsIgnoreCase(string)) continue;
                object2 = (Attribute)this.logicalObjects.get(((ERwinHandler.FKElement)object32).getID());
                object = (Attribute)this.logicalObjects.get(((ERwinHandler.FKElement)object32).getParentAttributeID());
                if (object2 == null || object == null) continue;
                ((ContainedObject)object2).setReferedAttribute(((ModelIDObject)object).getObjectID());
                ((ModelIDObject)object2).setGeneratorID(relation.getObjectID());
                this.replacedAttributes.add(object2);
            }
            if (string4 != null && !"".equalsIgnoreCase(string4)) {
                relation.setName(string4);
            }
            if (string5 != null) {
                relation.setComment(string5);
            }
            relation.setSourceEntity((Entity)designObject);
            relation.setTargetEntity((Entity)designObject2);
            object32 = this.getElementValue(element, "Type");
            object2 = this.getElementValue(element, "Cardinality");
            object = this.getElementValue(element, "Relationship_No_Nulls");
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            int n = 1;
            int n2 = 1;
            if (object32 != null && object2 != null) {
                if ("7".equalsIgnoreCase((String)object32)) {
                    bl = false;
                    bl2 = !"101".equalsIgnoreCase((String)object);
                    n2 = "-1".equalsIgnoreCase((String)object2) ? 1 : 0;
                    if ("-2".equalsIgnoreCase((String)object2)) {
                        bl3 = false;
                    }
                } else if ("2".equalsIgnoreCase((String)object32)) {
                    bl = true;
                    bl2 = false;
                    n2 = "-1".equalsIgnoreCase((String)object2) ? 1 : 0;
                    if ("-2".equalsIgnoreCase((String)object2)) {
                        bl3 = false;
                    }
                } else if ("4".equalsIgnoreCase((String)object32)) {
                    n = 0;
                    n2 = 0;
                }
                relation.setIdentifying(bl);
                relation.setOptionalSource(bl2);
                relation.setOptionalTarget(bl3);
                relation.setFireCardinalityChange(false);
                relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[n]);
                relation.setFireCardinalityChange(true);
                relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[n2]);
            }
            if ((tVRelation = (TVRelation)relation.getTopView()) != null) {
                tVRelation.addConnection();
                tVRelation.resetEdgeParams();
            }
            this.logicalObjects.put(string, relation);
        }
    }

    private void parseEntity(Element element) {
        Object object;
        String string = element.getAttribute("id");
        String string2 = element.getAttribute("Name");
        Element element2 = this.getElement(element, "EntityProps");
        String string3 = this.getElementValue(element2, "Type");
        String string4 = this.getElementValue(element2, "Physical_Name");
        String string5 = this.getElementValue(element2, "Physical_Only");
        String string6 = this.getElementValue(element2, "Logical_Only");
        String string7 = this.getElementValue(element2, "Hide_in_Logical");
        String string8 = this.getElementValue(element2, "Hide_in_Physical");
        String string9 = this.getElementValue(element2, "Definition");
        String string10 = this.getElementValue(element2, "Entity_Fill_Color");
        String string11 = this.getElementValue(element2, "Entity_Outline_Color");
        String string12 = this.getElementValue(element2, "Entity_Name_Font");
        String string13 = this.getElementValue(element2, "Entity_Name_Color");
        String string14 = this.getElementValue(element2, "View_Where");
        String string15 = this.getElementValue(element2, "View_Group_By");
        String string16 = this.getElementValue(element2, "View_Having");
        if (!(string5 != null && "true".equalsIgnoreCase(string5) || string7 != null && "true".equalsIgnoreCase(string7) || "".equalsIgnoreCase(string2))) {
            if ("17".equalsIgnoreCase(string3)) {
                object = this.logical.createEntityView(string2);
                this.logicalObjects.put(string, object);
                if (string9 != null) {
                    ((ModelIDObject)object).setComment(string9);
                }
                ((ModelIDObject)object).setNotes(this.parseNotes(element2));
                if (string14 != null) {
                    ((AbstractView)object).setWhere(string14);
                }
                if (string15 != null) {
                    ((AbstractView)object).setGroupBy(string15);
                }
                if (string16 != null) {
                    ((AbstractView)object).setHaving(string16);
                }
                this.setFontAndColor((DesignObject)object, string10, string11, string12, string13);
                this.logicalViews.add(element);
            } else {
                object = this.logical.createEntity(string2);
                this.logicalObjects.put(string, object);
                if (string9 != null) {
                    ((ModelIDObject)object).setComment(string9);
                }
                ((ModelIDObject)object).setNotes(this.parseNotes(element2));
                this.parseAttributes(element, (Entity)object);
                this.parseKeys(element, (Entity)object);
                this.setFontAndColor((DesignObject)object, string10, string11, string12, string13);
            }
        }
        if (!(string6 != null && "true".equalsIgnoreCase(string6) || string8 != null && "true".equalsIgnoreCase(string8) || "".equalsIgnoreCase(string2))) {
            object = string2;
            if (string4 != null && !"".equalsIgnoreCase(string4)) {
                object = string4;
            }
            if ("17".equalsIgnoreCase(string3)) {
                TableView tableView = this.relational.createTableView((String)object);
                this.relationalObjects.put(string, tableView);
                if (string9 != null) {
                    tableView.setComment(string9);
                }
                tableView.setNotes(this.parseNotes(element2));
                if (string14 != null) {
                    tableView.setWhere(string14);
                }
                if (string15 != null) {
                    tableView.setGroupBy(string15);
                }
                if (string16 != null) {
                    tableView.setHaving(string16);
                }
                this.setFontAndColor(tableView, string10, string11, string12, string13);
                this.relationalViews.add(element);
            } else {
                Table table = this.relational.createTable((String)object);
                this.relationalObjects.put(string, table);
                if (string9 != null) {
                    table.setComment(string9);
                }
                table.setNotes(this.parseNotes(element2));
                this.parseColumns(element, table);
                this.parseIndexes(element, table);
                List list = this.getElements(element2, "Valid_Rule");
                for (Element element3 : list) {
                    String string17 = element3.getFirstChild().getNodeValue();
                    ERwinHandler.ValidationRuleHolder validationRuleHolder = (ERwinHandler.ValidationRuleHolder)this.validationRules.get(string17);
                    if (validationRuleHolder == null || validationRuleHolder.getType() != 0) continue;
                    TableLevelConstraint tableLevelConstraint = table.createCheckConstraint(validationRuleHolder.getName(), validationRuleHolder.getRule());
                    table.addCheckConstraint(tableLevelConstraint);
                }
                this.setFontAndColor(table, string10, string11, string12, string13);
            }
        }
    }

    private void parseEntityViews() {
        for (Element element : this.logicalViews) {
            String string = element.getAttribute("id");
            EntityView entityView = (EntityView)this.logicalObjects.get(string);
            if (entityView == null) continue;
            this.parseViewAttributes(element, entityView);
        }
    }

    private void parseTableViews() {
        for (Element element : this.relationalViews) {
            String string = element.getAttribute("id");
            TableView tableView = (TableView)this.relationalObjects.get(string);
            if (tableView == null) continue;
            this.parseViewColumns(element, tableView);
        }
    }

    private String parseNotes(Element element) {
        String string = "";
        String string2 = this.getElementValue(element, "Note");
        String string3 = this.getElementValue(element, "Note_2");
        String string4 = this.getElementValue(element, "Note_3");
        if (string2 != null) {
            string = string2;
        }
        if (string3 != null) {
            string = "".equalsIgnoreCase(string) ? string3 : string + "\n\n" + string3;
        }
        if (string4 != null) {
            string = "".equalsIgnoreCase(string) ? string4 : string + "\n\n" + string4;
        }
        return string;
    }

    private void parseKeys(Element element, Entity entity) {
        Element element2 = this.getElement(element, "Key_Group_Groups");
        List list = this.getElements(element2, "Key_Group");
        for (Element element3 : list) {
            List list2;
            String string = element3.getAttribute("id");
            String string2 = element3.getAttribute("Name");
            Element element4 = this.getElement(element3, "Key_GroupProps");
            String string3 = this.getElementValue(element4, "Key_Group_Type");
            String string4 = this.getElementValue(element4, "Definition");
            if (string3.toUpperCase().startsWith("IF") || (list2 = this.getAttributes(element3, true)).size() <= 0) continue;
            CandidateKey candidateKey = entity.createCandidateKey();
            candidateKey.setName(string2);
            this.logicalObjects.put(string, candidateKey);
            if (string4 != null) {
                candidateKey.setComment(string4);
            }
            candidateKey.setNotes(this.parseNotes(element4));
            for (Attribute attribute : list2) {
                candidateKey.add(attribute);
            }
            if (!"PK".equalsIgnoreCase(string3)) continue;
            candidateKey.makePK();
        }
    }

    private List getAttributes(Element element, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Element element2 = this.getElement(element, "Key_Group_Member_Groups");
        if (element2 != null) {
            List list = this.getElements(element2, "Key_Group_Member");
            for (Element element3 : list) {
                String string = this.getElementValue(element3, "Key_Group_Member_Column");
                Object e = null;
                e = bl ? (Object)this.logicalObjects.get(string) : (Object)this.relationalObjects.get(string);
                if (e == null) continue;
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    private void parseAttributes(Element element, Entity entity) {
        Element element2 = this.getElement(element, "Attribute_Groups");
        if (element2 != null) {
            List list = this.getElements(element2, "Attribute");
            for (Element element3 : list) {
                String string;
                String string2;
                Object object;
                String string3;
                String string4 = element3.getAttribute("id");
                String string5 = element3.getAttribute("Name");
                Element element4 = this.getElement(element3, "AttributeProps");
                String string6 = this.getElementValue(element4, "Hide_in_Logical");
                if (string6 != null && "true".equalsIgnoreCase(string6)) continue;
                String string7 = this.getElementValue(element4, "Parent_Attribute");
                String string8 = this.getElementValue(element4, "Parent_Relationship");
                if (string7 != null && string8 != null) {
                    this.logicalFKElements.add(new ERwinHandler.FKElement(string4, string7, string8));
                }
                Attribute attribute = entity.createAttribute(string5);
                this.logicalObjects.put(string4, attribute);
                String string9 = this.getElementValue(element4, "Definition");
                if (string9 != null) {
                    attribute.setComment(string9);
                }
                if ((string3 = this.getElementValue(element4, "Null_Option")) != null) {
                    if ("0".equalsIgnoreCase(string3)) {
                        attribute.setNullsAllowed(true);
                    } else {
                        attribute.setNullsAllowed(false);
                    }
                }
                attribute.setNotes(this.parseNotes(element4));
                String string10 = this.getElementValue(element4, "Parent_Domain");
                if (string10 != null && (object = (Domain)this.domains.get(string10.trim())) != null) {
                    attribute.setUse((short)0);
                    attribute.setDomain((Domain)object);
                }
                if ((object = this.getElementValue(element4, "Validation_Rule_Ref")) != null) {
                    attribute.setUseDomainConstraints(false);
                    this.applyValidationRule((String)object, attribute);
                }
                if ((string2 = this.getElementValue(element4, "Default")) != null && (string = (String)this.defaultValues.get(string2)) != null) {
                    attribute.setDefaultValue(string);
                }
                string = this.getElementValue(element4, "Attribute_Font");
                String string11 = this.getElementValue(element4, "Attribute_Color");
                this.setAttributeFontAndColor(entity, string, string11, true);
            }
        }
    }

    private void parseViewAttributes(Element element, EntityView entityView) {
        Element element2 = this.getElement(element, "Attribute_Groups");
        if (element2 != null) {
            List list = this.getElements(element2, "Attribute");
            for (Element element3 : list) {
                Object object;
                String string;
                String string2 = element3.getAttribute("Name");
                Element element4 = this.getElement(element3, "AttributeProps");
                String string3 = this.getElementValue(element4, "Hide_in_Logical");
                if (string3 != null && "true".equalsIgnoreCase(string3)) continue;
                String string4 = this.getElementValue(element4, "View_Expression");
                AttributeView attributeView = new AttributeView(this.logical);
                attributeView.setName(string2);
                attributeView.setDesign(this.design);
                entityView.add(attributeView);
                if (string4 != null) {
                    attributeView.setExpression(string4);
                    attributeView.setTableAlias(entityView.getName());
                } else {
                    string = this.getElementValue(element4, "Parent_Attribute");
                    if (string != null && (object = (Attribute)this.logicalObjects.get(string)) != null) {
                        attributeView.setReferencedColumn((ContainedObjectWithDomain)object);
                        attributeView.setDataType(((Attribute)object).getDataType().toString());
                        attributeView.setContainer(entityView);
                        attributeView.setEntity((Entity)((ContainedObject)object).getContainer());
                        entityView.addToContainers(((ContainedObject)object).getContainer(), ((ContainedObject)object).getContainer().getName());
                    }
                }
                string = this.getElementValue(element4, "Attribute_Font");
                object = this.getElementValue(element4, "Attribute_Color");
                this.setAttributeFontAndColor(entityView, string, (String)object, true);
            }
            entityView.setUserDefinedSQL(entityView.generateSQL());
        }
    }

    private void parseViewColumns(Element element, TableView tableView) {
        Element element2 = this.getElement(element, "Attribute_Groups");
        if (element2 != null) {
            List list = this.getElements(element2, "Attribute");
            for (Element element3 : list) {
                Object object;
                String string;
                String string2 = element3.getAttribute("Name");
                Element element4 = this.getElement(element3, "AttributeProps");
                String string3 = this.getElementValue(element4, "Hide_in_Physical");
                if (string3 != null && "true".equalsIgnoreCase(string3)) continue;
                String string4 = this.getElementValue(element4, "View_Expression");
                String string5 = this.getElementValue(element4, "Physical_Name");
                if (string5 == null) {
                    string5 = string2;
                }
                ColumnView columnView = new ColumnView(this.relational);
                columnView.setName(string5);
                columnView.setDesign(this.design);
                tableView.add(columnView);
                columnView.setContainer(tableView);
                if (string4 != null) {
                    columnView.setExpression(string4);
                    columnView.setTableAlias(tableView.getName());
                } else {
                    string = this.getElementValue(element4, "Parent_Attribute");
                    if (string != null && (object = (Column)this.relationalObjects.get(string)) != null) {
                        columnView.setReferencedColumn((ContainedObjectWithDomain)object);
                        columnView.setDataType(((Column)object).getDataType().toString());
                        columnView.setTable((Table)((ContainedObject)object).getContainer());
                        tableView.addToContainers(((ContainedObject)object).getContainer(), ((ContainedObject)object).getContainer().getName());
                    }
                }
                string = this.getElementValue(element4, "Attribute_Font");
                object = this.getElementValue(element4, "Attribute_Color");
                this.setAttributeFontAndColor(tableView, string, (String)object, false);
            }
            tableView.setUserDefinedSQL(tableView.generateSQL());
        }
    }

    private void parseIndexes(Element element, Table table) {
        Element element2 = this.getElement(element, "Key_Group_Groups");
        if (element2 != null) {
            List list = this.getElements(element2, "Key_Group");
            for (Element element3 : list) {
                List list2;
                String string = element3.getAttribute("id");
                String string2 = element3.getAttribute("Name");
                Element element4 = this.getElement(element3, "Key_GroupProps");
                String string3 = this.getElementValue(element4, "Key_Group_Type");
                String string4 = this.getElementValue(element4, "Definition");
                if (string3.toUpperCase().startsWith("IF") || (list2 = this.getAttributes(element3, false)).size() <= 0) continue;
                Index index = table.createIndex();
                index.setName(string2);
                this.relationalObjects.put(string, index);
                if (string4 != null) {
                    index.setComment(string4);
                }
                index.setNotes(this.parseNotes(element4));
                for (Column column : list2) {
                    index.add(column);
                }
                if ("PK".equalsIgnoreCase(string3)) {
                    index.makePK();
                    continue;
                }
                if (!string3.toUpperCase().startsWith("AK")) continue;
                index.setIndexState("Unique Constraint");
            }
        }
    }

    private void parseColumns(Element element, Table table) {
        Element element2 = this.getElement(element, "Attribute_Groups");
        if (element2 != null) {
            List list = this.getElements(element2, "Attribute");
            for (Element element3 : list) {
                String string;
                String string2;
                Object object;
                String string3;
                String string4 = element3.getAttribute("id");
                String string5 = element3.getAttribute("Name");
                Element element4 = this.getElement(element3, "AttributeProps");
                String string6 = this.getElementValue(element4, "Hide_in_Physical");
                if (string6 != null && "true".equalsIgnoreCase(string6)) continue;
                String string7 = this.getElementValue(element4, "Physical_Name");
                String string8 = string5;
                if (string7 != null && !"".equalsIgnoreCase(string7)) {
                    string8 = string7;
                }
                String string9 = this.getElementValue(element4, "Parent_Attribute");
                String string10 = this.getElementValue(element4, "Parent_Relationship");
                if (string9 != null && string10 != null) {
                    this.relationalFKElements.add(new ERwinHandler.FKElement(string4, string9, string10));
                }
                Column column = table.createColumn(string8);
                this.relationalObjects.put(string4, column);
                String string11 = this.getElementValue(element4, "Definition");
                if (string11 != null) {
                    column.setComment(string11);
                }
                if ((string3 = this.getElementValue(element4, "Null_Option")) != null) {
                    if ("0".equalsIgnoreCase(string3)) {
                        column.setNullsAllowed(true);
                    } else {
                        column.setNullsAllowed(false);
                    }
                }
                column.setNotes(this.parseNotes(element4));
                String string12 = this.getElementValue(element4, "Parent_Domain");
                if (string12 != null && (object = (Domain)this.domains.get(string12)) != null) {
                    column.setUse((short)0);
                    column.setDomain((Domain)object);
                }
                if ((object = this.getElementValue(element4, "Validation_Rule_Ref")) != null) {
                    column.setUseDomainConstraints(false);
                    this.applyValidationRule((String)object, column);
                }
                if ((string2 = this.getElementValue(element4, "Default")) != null && (string = (String)this.defaultValues.get(string2)) != null) {
                    column.setUsesDefaultValue(true);
                    column.setDefaultValue(string);
                }
                string = this.getElementValue(element4, "Attribute_Font");
                String string13 = this.getElementValue(element4, "Attribute_Color");
                this.setAttributeFontAndColor(table, string, string13, false);
            }
        }
    }

    private void createMany2ManyMapping(Element element) {
        if (element != null) {
            List list = this.getElements(element, "Many_To_Many_Transform");
            for (Element element2 : list) {
                String string = this.getElementValue(element2, "MTM_ManyToMany_Relationship");
                String string2 = this.getElementValue(element2, "MTM_Association_Table");
                Relation relation = (Relation)this.logicalObjects.get(string);
                Table table = (Table)this.relationalObjects.get(string2);
                if (relation == null || table == null) continue;
                XtdMapping xtdMapping = this.design.getExtendedMap().createMapping(relation, table);
                xtdMapping.setRealSourceEntityID(relation.getSourceEntity().getObjectID());
                xtdMapping.setRealTargetEntityID(relation.getTargetEntity().getObjectID());
                table.setGeneratorID(relation.getObjectID());
                xtdMapping.setCreationTime(System.currentTimeMillis());
            }
        }
    }

    private void createSuperTypeSubTypeMapping(Element element) {
        if (element != null) {
            List list = this.getElements(element, "Supertype_Subtype_Roll_Up");
            for (Element element2 : list) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                String string = this.getElementValue(element2, "D2T_Parent_Table");
                String string2 = this.getElementValue(element2, "D2TUp_Denormalized_Table");
                if (string != null && string2 != null) {
                    object4 = (Entity)this.logicalObjects.get(string);
                    object3 = (Table)this.relationalObjects.get(string2);
                    if (object4 != null && object3 != null) {
                        RepositoryObject repositoryObject;
                        if (this.design.getExtendedMap().getMapping((DesignObject)object4, (DesignObject)object3) == null) {
                            repositoryObject = this.design.getExtendedMap().createMapping((DesignObject)object4, (DesignObject)object3);
                            ((ModelIDObject)object3).setGeneratorID(((ModelIDObject)object4).getObjectID());
                            ((XtdMapping)repositoryObject).setCreationTime(System.currentTimeMillis());
                        }
                        repositoryObject = ((ContainerWithKeyObject)object4).getPK();
                        object2 = ((ContainerWithKeyObject)object3).getPK();
                        if (repositoryObject != null && object2 != null && this.design.getExtendedMap().getMapping((DesignObject)repositoryObject, (DesignObject)object2) == null) {
                            object = this.design.getExtendedMap().createMapping((DesignObject)repositoryObject, (DesignObject)object2);
                            ((ModelIDObject)object2).setGeneratorID(((ModelIDObject)repositoryObject).getObjectID());
                            ((XtdMapping)object).setCreationTime(System.currentTimeMillis());
                        }
                    }
                }
                object4 = this.getElements(element2, "Left_Column_in_Xform_ID_Map");
                object3 = this.getElements(element2, "Right_Column_in_Xform_ID_Map");
                if (object4.size() != object3.size()) continue;
                for (int i = 0; i < object4.size(); ++i) {
                    object2 = ((Element)object4.get(i)).getFirstChild().getNodeValue();
                    object = ((Element)object3.get(i)).getFirstChild().getNodeValue();
                    DesignObject designObject = (DesignObject)this.logicalObjects.get(object2);
                    DesignObject designObject2 = (DesignObject)this.relationalObjects.get(object);
                    if (designObject == null || designObject2 == null || this.design.getExtendedMap().getMapping(designObject, designObject2) != null || this.isDeleted(designObject) || this.isDeleted(designObject2)) continue;
                    XtdMapping xtdMapping = this.design.getExtendedMap().createMapping(designObject, designObject2);
                    designObject2.setGeneratorID(designObject.getObjectID());
                    xtdMapping.setCreationTime(System.currentTimeMillis());
                }
            }
        }
    }

    private void parseDefaultValues(Element element) {
        List list = this.getElements(element, "Default_Value");
        for (Element element2 : list) {
            String string;
            String string2 = element2.getAttribute("id");
            String string3 = this.getElementValue(element2, "Is_Builtin");
            if (string3 != null && !"false".equalsIgnoreCase(string3) || (string = this.getElementValue(element2, "Server_Value")) == null) continue;
            this.defaultValues.put(string2, string);
        }
    }

    private void parseValidationRules(Element element) {
        List list = this.getElements(element, "Validation_Rule");
        for (Element element2 : list) {
            Object object;
            Object object2;
            Object object3;
            String string = element2.getAttribute("id");
            String string2 = element2.getAttribute("Name");
            String string3 = this.getElementValue(element2, "Type");
            String string4 = this.getElementValue(element2, "Definition");
            if (string3 == null || "0".equalsIgnoreCase(string3)) {
                object3 = this.getElementValue(element2, "Logical_User_Rule");
                if (object3 == null) continue;
                object2 = new ERwinHandler.ValidationRuleHolder(0);
                ((ERwinHandler.ValidationRuleHolder)object2).setName(string2);
                ((ERwinHandler.ValidationRuleHolder)object2).setRule((String)object3);
                this.validationRules.put(string, object2);
                continue;
            }
            if ("1".equalsIgnoreCase(string3)) {
                object3 = this.getElementValue(element2, "Validation_Rule_Min_Value");
                object2 = this.getElementValue(element2, "Validation_Rule_Max_Value");
                if (object3 == null || object2 == null) continue;
                object = new ERwinHandler.ValidationRuleHolder(1);
                ((ERwinHandler.ValidationRuleHolder)object).setName(string2);
                ((ERwinHandler.ValidationRuleHolder)object).setMinValue((String)object3);
                ((ERwinHandler.ValidationRuleHolder)object).setMaxValue((String)object2);
                if (string4 != null) {
                    ((ERwinHandler.ValidationRuleHolder)object).setDefinition(string4);
                }
                this.validationRules.put(string, object);
                continue;
            }
            if (!"2".equalsIgnoreCase(string3) || (object3 = this.getElement(element2, "Valid_Value_Groups")) == null) continue;
            object2 = new ERwinHandler.ValidationRuleHolder(2);
            ((ERwinHandler.ValidationRuleHolder)object2).setName(string2);
            this.validationRules.put(string, object2);
            object = this.getElements((Element)object3, "Valid_Value");
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                String string5 = element3.getAttribute("Name");
                String string6 = this.getElementValue(element3, "Definition");
                ((ERwinHandler.ValidationRuleHolder)object2).addValue(string5, string6);
            }
        }
    }
}

