/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.erwin;

import java.awt.Component;
import java.awt.Dimension;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.erwin.ERSAXHandler;
import oracle.dbtools.crest.imports.erwin.ERSAXParserv7x;
import oracle.dbtools.crest.imports.erwin.ERwinConstants;
import oracle.dbtools.crest.imports.erwin.ERwinParserv4x;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ERwinHandler
extends DefaultHandler
implements ERwinConstants {
    protected static final Logger LOGGER = new Logger(ERwinHandler.class);
    private ApplicationView appView;
    private ProgressDialog monitor;
    private File currentFile;
    private boolean inExistingDesign;
    private String oldDesignPath;
    private String designName;
    private Design design;
    private int version = 0;
    String tempVal;
    Entity tempEntity;
    Attribute tempAttr;
    boolean inent;
    boolean inattr;
    boolean inrel;
    CharArrayWriter text = new CharArrayWriter();

    public ERwinHandler(ApplicationView applicationView, boolean bl) {
        this.appView = applicationView;
        this.inExistingDesign = bl;
        this.design = applicationView.getCurrentDesign();
    }

    protected void setDesignName(String string) {
        this.designName = !this.inExistingDesign ? string : this.appView.getDesignName();
        this.appView.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
        if (this.appView.designExists(string)) {
            this.appView.deleteDesign(string);
        }
        if (!this.inExistingDesign) {
            this.appView.setDesignName(string);
        }
        if (!this.inExistingDesign) {
            this.design.setFileName(this.designName);
        }
    }

    public void parse(File file, int n) {
        this.version = n;
        if (file.isFile()) {
            try {
                this.oldDesignPath = this.appView.getCurrentDesign().getDesignPath();
                this.currentFile = file;
                new Thread(new Runner()).start();
            }
            catch (Exception exception) {
                LOGGER.error("ERwinHandler - Unable to parse file: " + file.getAbsolutePath(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(File file, ImportLogger importLogger) {
        try {
            FileInputStream fileInputStream;
            block26: {
                fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                InputSource inputSource = new InputSource(inputStreamReader);
                if (this.version == 4) {
                    try {
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder documentBuilder = null;
                        try {
                            documentBuilder = documentBuilderFactory.newDocumentBuilder();
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                            LOGGER.error(parserConfigurationException);
                        }
                        if (documentBuilder == null) break block26;
                        Document document = documentBuilder.parse(inputSource);
                        Element element = document.getDocumentElement();
                        String string = element.getNodeName();
                        Element element2 = this.getElement(element, "Model");
                        if (string.equalsIgnoreCase("ERwin4") && element2 != null) {
                            ERwinParserv4x eRwinParserv4x = new ERwinParserv4x(this.appView, this.inExistingDesign);
                            eRwinParserv4x.parseModel(file, importLogger, this.monitor, element2);
                            break block26;
                        }
                        importLogger.addError("Error parsing ERwin 4.x file: " + file.getAbsolutePath());
                    }
                    catch (Throwable throwable) {
                        LOGGER.error("ERwinHandler - Unable to parse ERwin 4.x file: " + file.getAbsolutePath(), throwable);
                        importLogger.addError("Error parsing ERwin 4.x File...");
                    }
                } else if (this.version == 7) {
                    try {
                        System.out.println("start " + System.currentTimeMillis());
                        ApplicationView.canLogging = false;
                        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                        ERSAXHandler eRSAXHandler = null;
                        try {
                            SAXParser sAXParser = sAXParserFactory.newSAXParser();
                            eRSAXHandler = new ERSAXParserv7x(this.appView, this.inExistingDesign);
                            sAXParser.parse(inputSource, (DefaultHandler)eRSAXHandler);
                        }
                        catch (SAXException sAXException) {
                            importLogger.addError(sAXException.getMessage());
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            if (eRSAXHandler != null) {
                                eRSAXHandler.monitorClose();
                            }
                        }
                        System.out.println("end " + System.currentTimeMillis());
                    }
                    catch (Throwable throwable) {
                        LOGGER.error("ERwinHandler - Unable to parse ERwin 7.x file: " + file.getAbsolutePath(), throwable);
                        importLogger.addError("Error parsing ERwin 7.x File: " + file.getAbsolutePath());
                    }
                    finally {
                        ApplicationView.canLogging = true;
                        this.getLogicalDesign().sortCollections();
                    }
                } else {
                    importLogger.addError("ERwinHandler - Unable to parse file: " + file.getAbsolutePath());
                    this.appView.getCurrentDesign().setDesignPath(this.oldDesignPath);
                    this.design = null;
                    System.gc();
                }
            }
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            LOGGER.error("ERwinHandler - Unable to parse file: " + file.getAbsolutePath(), exception);
            importLogger.addError("Error parsing File...");
        }
    }

    protected Element getElement(Element element, String string, String string2) {
        NodeList nodeList = element.getElementsByTagNameNS(string, string2);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    protected Element getElement(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    protected String getElementValue(Element element, String string) {
        try {
            return this.getElement(element, string).getFirstChild().getNodeValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getElementPropValue(Element element, String string) {
        String string2 = element.getTagName() + "Props";
        Element element2 = this.getElement(element, string2);
        if (element2 != null) {
            return this.getElementValue(element2, string);
        }
        return null;
    }

    protected String getValue(Element element) {
        try {
            return element.getFirstChild().getNodeValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected List getElements(Element element, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = element.getElementsByTagName(string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(nodeList.item(i));
        }
        return arrayList;
    }

    protected void createMappings(Design design, Map map, Map map2) {
        for (Object k : map.keySet()) {
            DesignObject designObject = (DesignObject)map.get(k);
            DesignObject designObject2 = (DesignObject)map2.get(k);
            if (designObject == null || designObject2 == null || design.getExtendedMap().getMapping(designObject, designObject2) != null || this.isDeleted(designObject) || this.isDeleted(designObject2)) continue;
            XtdMapping xtdMapping = design.getExtendedMap().createMapping(designObject, designObject2);
            designObject2.setGeneratorID(designObject.getObjectID());
            xtdMapping.setCreationTime(System.currentTimeMillis());
        }
    }

    protected boolean isDeleted(DesignObject designObject) {
        if (designObject instanceof ContainedObject) {
            ContainedObject containedObject = (ContainedObject)designObject;
            return containedObject.getContainer() == null;
        }
        return false;
    }

    protected boolean isUTFString(String string) {
        int n = string.length();
        try {
            byte[] byArray = string.getBytes("UTF-8");
            return n < byArray.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    private Design getDesign() {
        return this.appView.getCurrentDesign();
    }

    private LogicalDesign getLogicalDesign() {
        return this.getDesign().getLogicalDesign();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.text.reset();
        if (string3.equalsIgnoreCase("Entity")) {
            this.tempEntity = this.getLogicalDesign().createEntity();
            this.tempEntity.setName(attributes.getValue("name"));
            this.inent = true;
        }
        if (this.tempEntity != null && string3.equalsIgnoreCase("Attribute")) {
            this.tempAttr = this.tempEntity.createAttribute();
            this.tempAttr.setName(attributes.getValue("name"));
            this.inattr = true;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.inent && !this.inattr) {
            String string4;
            if (string3.equalsIgnoreCase("Comment") && (string4 = this.getText()) != null && !"".equals(string4)) {
                this.tempEntity.setComment(string4);
            }
            if (string3.equalsIgnoreCase("Entity")) {
                this.inent = false;
            }
        } else if (this.inent && this.inattr) {
            String string5;
            if (string3.equalsIgnoreCase("Comment") && (string5 = this.getText()) != null && !"".equals(string5)) {
                this.tempAttr.setComment(string5);
            }
            if (string3.equalsIgnoreCase("Attribute")) {
                this.inattr = false;
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        this.text.write(cArray, n, n2);
    }

    public String getText() {
        return this.text.toString().trim();
    }

    protected class ValidationRuleHolder {
        private int type = 0;
        private String rule;
        private String minValue;
        private String maxValue;
        private Map valueList = new TreeMap();
        private String definition = "";
        private String name = "";

        public ValidationRuleHolder(int n) {
            this.type = n;
        }

        public String getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(String string) {
            this.maxValue = string;
        }

        public String getMinValue() {
            return this.minValue;
        }

        public void setMinValue(String string) {
            this.minValue = string;
        }

        public String getRule() {
            return this.rule;
        }

        public void setRule(String string) {
            this.rule = string;
        }

        public int getType() {
            return this.type;
        }

        public Map getValueList() {
            return this.valueList;
        }

        public void addValue(String string, String string2) {
            this.valueList.put(string, string2);
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setDefinition(String string) {
            this.definition = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }

    protected class IHObject {
        private String parentID;
        private String childID;
        private String comment = "";

        public IHObject(String string, String string2) {
            this.parentID = string;
            this.childID = string2;
        }

        public String getChildID() {
            return this.childID;
        }

        public String getParentID() {
            return this.parentID;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String string) {
            this.comment = string;
        }
    }

    protected class FKElement {
        private String id;
        private String parentAttributeID;
        private String parentRelationshipID;

        public FKElement(String string, String string2, String string3) {
            this.id = string;
            this.parentAttributeID = string2;
            this.parentRelationshipID = string3;
        }

        public String getID() {
            return this.id;
        }

        public String getParentAttributeID() {
            return this.parentAttributeID;
        }

        public String getParentRelationshipID() {
            return this.parentRelationshipID;
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ERwinHandler.this.design.closeAllDiagrams();
                ERwinHandler.this.design.setDisableTreeUpdate(true);
                ERwinHandler.this.design.setPropagatePKChahges(false);
                ERwinHandler.this.design.getLogicalDesign().getMainView().setAutoRoute(false);
                ERwinHandler.this.design.getLogicalDesign().getMainView().setBoxInBox(false);
                ERwinHandler.this.design.getLogicalDesign().getMainView().getWorkSpace().updateSettings();
                ERwinHandler.this.design.getRelationalDesign().getMainView().setAutoRoute(false);
                ERwinHandler.this.design.getRelationalDesign().getMainView().setBoxInBox(false);
                ERwinHandler.this.design.getRelationalDesign().getMainView().getWorkSpace().updateSettings();
                ImportLogger importLogger = new ImportLogger();
                try {
                    ERwinHandler.this.monitor = new ProgressDialog(ERwinHandler.this.appView, "", 0, 100);
                    try {
                        try {
                            ERwinHandler.this.monitor.setNote(Messages.getString("ERwinHandler.ParseFile"));
                            ERwinHandler.this.monitor.setProgress(5);
                            ERwinHandler.this.parseFile(ERwinHandler.this.currentFile, importLogger);
                            ERwinHandler.this.monitor.setProgress(100);
                            if (ERwinHandler.this.inExistingDesign) {
                                ERwinHandler.this.appView.getCurrentDesign().setDesignPath(ERwinHandler.this.oldDesignPath);
                            } else {
                                ERwinHandler.this.appView.getCurrentDesign().setDesignPath("");
                            }
                            ERwinHandler.this.appView.synchronizeTitle();
                        }
                        finally {
                            ERwinHandler.this.appView.setImporting(false);
                        }
                    }
                    finally {
                        ERwinHandler.this.monitor.close();
                    }
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ERwinHandler.this.design.setPropagatePKChahges(true);
                            ERwinHandler.this.design.getLogicalDesign().setMainViewVisible(true);
                            ERwinHandler.this.design.getRelationalDesign().setMainViewVisible(true);
                            ERwinHandler.this.design.setDisableTreeUpdate(false);
                            ERwinHandler.this.appView.centerDesign();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                if (ERwinHandler.this.appView.getSettings().showImportLog()) {
                    LogReport logReport = new LogReport(ERwinHandler.this.appView);
                    logReport.setLog(importLogger.generateReport(ERwinHandler.this.appView));
                    logReport.showDialog(new Dimension(750, 550));
                }
            }
            catch (Exception exception) {
                ERwinHandler.this.design.destroyAll(false);
                ERwinHandler.this.design = null;
                LOGGER.error("Error Parsing File: " + ERwinHandler.this.designName, exception);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ERwinHandler.UnableToImportTheFile"), Messages.getString("ERwinHandler.ErrorImportingFile"), 0);
            }
        }
    }
}

