/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.erwin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.erwin.ERSAXHandler;
import oracle.dbtools.crest.imports.erwin.ERwinConstantsv7x;
import oracle.dbtools.crest.imports.erwin.ERwinHandler;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ConstrainedObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.GenericConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ERSAXParserv7x
extends ERSAXHandler
implements ERwinConstantsv7x {
    protected static final Logger LOGGER = new Logger(ERwinHandler.class);
    private Design design;
    private LogicalDesign logical;
    private RelationalDesign relational;
    private boolean fileOK;
    private static int PROGRESS_INCREMENT = 5;
    private static String ID_PREFIX_ATTRIBUTE = "ATT-";
    private static String ID_PREFIX_ATTRIBUTE_VIEW = "AVW-";
    private static String ID_PREFIX_CANDIDATE_KEY = "CKY-";
    private static String ID_PREFIX_COLUMN = "COL-";
    private static String ID_PREFIX_COLUMN_VIEW = "CVW-";
    private static String ID_PREFIX_DOMAIN = "DOM-";
    private static String ID_PREFIX_ENTITY = "ENT-";
    private static String ID_PREFIX_ENTITY_VIEW = "EVW-";
    private static String ID_PREFIX_FK_INDEX_ASSOCIATION = "FKI-";
    private static String ID_PREFIX_FK_INDEX_ASSOCIATION2 = "FK2-";
    private static String ID_PREFIX_FUNCTION = "FUN-";
    private static String ID_PREFIX_INDEX = "IND-";
    private static String ID_PREFIX_INHERITANCE_RELATION = "IHR-";
    private static String ID_PREFIX_PACKAGE = "PKG-";
    private static String ID_PREFIX_PARTITION = "PRT-";
    private static String ID_PREFIX_PK_INDEX = "XPK-";
    private static String ID_PREFIX_RELATION = "REL-";
    private static String ID_PREFIX_SEQUENCE = "SEQ-";
    private static String ID_PREFIX_STORED_PROCEDURE = "PRC-";
    private static String ID_PREFIX_TABLE = "TAB-";
    private static String ID_PREFIX_TABLE_VIEW = "TVW-";
    private static String ID_PREFIX_TABLESPACE = "TSP-";
    private static String ID_PREFIX_TRIGGER = "TRG-";
    private static int DO_SCRATCH_ENTITY_WIDTH = 200;
    private static int DO_SCRATCH_ENTITY_HEIGHT = 200;
    private static int DO_MTM_ENTITY_WIDTH = 200;
    private static int DO_MTM_ENTITY_HEIGHT = 100;
    private String targetServer;
    private String targetVersion;
    private RDBMSType rdbmsType = null;
    private RDBMSSite rdbmsSite = null;
    private StorageDesignOracle oracleStorage = null;
    private boolean createLogical;
    private boolean createRelational;
    private String designName;
    private Map logicalObjects = new TreeMap();
    private Map relationalObjects = new TreeMap();
    private Map relationKey = new TreeMap();
    private List logicalViews = new ArrayList();
    private List relationalViews = new ArrayList();
    private List logicalFKElements = new ArrayList();
    private List relationalFKElements = new ArrayList();
    private TempEntity tempEntity;
    private String tempEntityID;
    private TempAttribute tempAttribute;
    private String tempAttributeID;
    private TempKey tempKey;
    private String tempKeyID;
    private TempKeyMember tempKeyMember;
    private String tempKeyMemberID;
    private TempPhysicalStorage tempPhysicalStorage;
    private String tempPhysicalStorageID;
    private TempTrigger tempTableTrigger;
    private String tempTableTriggerID;
    private TempPartition tempPartition;
    private String tempPartitionID;
    private TempPartitionInfo tempPartitionInfo;
    private String tempPartitionInfoID;
    private TempSubPartitionInfo tempSubPartitionInfo;
    private String tempSubPartitionInfoID;
    private Map domains = new TreeMap();
    private Map childDomains = new TreeMap();
    private List usedDomains = new ArrayList();
    private TempDomain tempDomain;
    private String tempDomainID;
    private Map tablespaces = new TreeMap();
    private TempOracleTablespace tempOracleTablespace;
    private String tempOracleTablespaceID;
    private boolean isMainLogical = true;
    private boolean isMainRelational = true;
    private List subjectAreas = new ArrayList();
    private TempSubjectArea tempSubjectArea;
    private String tempSubjectAreaID;
    private TempStoredDisplay tempStoredDisplay;
    private String tempStoredDisplayID;
    private TempDrawingObject tempDrawingObject;
    private String tempDrawingObjectID;
    private List inheritanceObjects = new ArrayList();
    private List replacedAttributes = new ArrayList();
    private List manyToManyTables = new ArrayList();
    private TempRelationship tempRelationship;
    private String tempRelationshipID;
    private Map defaultValues = new TreeMap();
    private TempDefaultValue tempDefaultValue;
    private String tempDefaultValueID;
    private Map validationRules = new TreeMap();
    private TempValidationRule tempValidationRule;
    private String tempValidationRuleID;
    private Map storedProcedures = new TreeMap();
    private TempPLSQLSource tempStoredProcedure;
    private String tempStoredProcedureID;
    private TempMTMTransform tempMTMTransform;
    private String tempMTMTransformID;
    private Map rollUpTransforms = new TreeMap();
    private TempRollUpTransform tempRollUpTransform;
    private String tempRollUpTransformID;
    private TempRollUpSubTransform tempRollUpSubTransform;
    private String tempRollUpSubTransformID;
    private String tempSourceObjectRef;
    private String tempTargetObjectRef;
    private List logicalViews2 = new ArrayList();
    private List relationalViews2 = new ArrayList();
    private TempView tempView;
    private String tempViewID;
    private TempViewAttribute tempViewAttribute;
    private String tempViewAttributeID;
    private TempTrigger tempViewTrigger;
    private String tempViewTriggerID;
    private TempSequence tempSequence;
    private String tempSequenceID;
    private Map fonts = new TreeMap();
    private TempFont tempFont;
    private String tempFontID;
    private String defaultNameFontID;
    private String defaultNameColor;
    private String defaultFillColor;
    private String defaultOutlineColor;
    private String defaultAttributeFontID;
    private String defaultAttributeColor;
    private TempPLSQLSource tempOraclePackage;
    private String tempOraclePackageID;
    private Map functions = new TreeMap();
    private TempPLSQLSource tempFunction;
    private String tempFunctionID;
    private Stack scratchGroupStack = new Stack();
    private Stack scratchObjectStack = new Stack();
    private Map scratchObjects = new TreeMap();
    private TempScratchObject tempScratchObject;
    private String tempScratchObjectID;
    private List domainWaitingList = new ArrayList();
    private List schemaWaitingList = new ArrayList();
    private List storedProcedureWaitingList = new ArrayList();
    private List functionWaitingList = new ArrayList();
    private List tablespaceWaitingList = new ArrayList();
    private List defaultValueWaitingList = new ArrayList();
    private List validationRuleWaitingList = new ArrayList();
    private List fontWaitingList = new ArrayList();
    private List transformWaitingList = new ArrayList();

    public ERSAXParserv7x(ApplicationView applicationView, boolean bl) {
        super(applicationView, bl);
        this.design = applicationView.getCurrentDesign();
        this.logical = this.design.getLogicalDesign();
        this.relational = this.design.getRelationalDesign();
        this.fileOK = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if (attributes == null) {
                LOGGER.error("ERSAXParserv7x.startElement() - Invalid XML File - No Attributes found for Tag " + string3);
                throw new SAXException(MessageFormat.format(Messages.getString("ERSAXParserv7x.FileFormatNoAttributes"), string3));
            }
            if (string3.equalsIgnoreCase("ERwin")) {
                this.monitorProgress(Messages.getString("ERSAXParserv7x.StartOfImport"), 0);
                this.initWaitingLists();
                String string4 = attributes.getValue("FileVersion");
                if (!string4.startsWith("7.3.")) {
                    LOGGER.error("ERSAXParserv7x.startElement() - Invalid XML File - FileVersion=" + string4);
                    throw new SAXException(MessageFormat.format(Messages.getString("ERSAXParserv7x.FileVersionNotSupported"), "7.3", string4));
                }
                this.fileOK = true;
            } else if (!this.fileOK) {
                LOGGER.error("ERSAXParserv7x.startElement() - Invalid XML File - First Tag is " + string3);
                throw new SAXException(MessageFormat.format(Messages.getString("ERSAXParserv7x.FileFormatInvalidTagStart"), "ERwin", string3));
            }
            this.stack.push(string3);
            this.text.reset();
            if (this.stack.search("EMX:Model") == -1) return;
            if (this.stack.search("ModelEnvProps") != -1) {
                this.startModelEnvProps(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("ModelProps") != -1) {
                this.startModelProps(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("Entity_Groups") != -1) {
                this.startEntitiesAndAttributes(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("Domain_Groups") != -1) {
                this.startDomains(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("Oracle_Tablespace_Groups") != -1) {
                this.startOracleTablespaces(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("Subject_Area_Groups") != -1) {
                this.startSubjectAreas(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("Relationship_Groups") != -1) {
                this.startRelationships(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("Default_Groups") != -1) {
                this.startDefaultValues(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("Validation_Rule_Groups") != -1) {
                this.startValidationRules(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("Stored_Procedure_Groups") != -1) {
                this.startStoredProcedures(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("Many_To_Many_Transform_Groups") != -1) {
                this.startManyToManyTransforms(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("Supertype_Subtype_Roll_Up_Transform_Groups") != -1) {
                this.startRollUpTransforms(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("View_Groups") != -1) {
                this.startViews(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("Sequence_Groups") != -1) {
                this.startSequences(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("Font_Groups") != -1) {
                this.startFonts(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("Default_Fonts_And_Colors_Groups") != -1) {
                this.startDefaultFontsAndColors(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("Oracle_Package_Groups") != -1) {
                this.startOraclePackages(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("Function_Groups") != -1) {
                this.startFunctions(string, string2, string3, attributes);
                return;
            }
            if (this.stack.search("Transform_Scratch_Object_Groups") == -1) return;
            this.startTransformScratchObjects(string, string2, string3, attributes);
            return;
        }
        catch (EmptyStackException emptyStackException) {
            LOGGER.error("ERSAXParserv7x.startElement() - Invalid XML - Stack error at " + string3, emptyStackException);
            throw new SAXException(MessageFormat.format(Messages.getString("ERSAXParserv7x.FileFormatInvalidStackStart"), string3));
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (!((String)this.stack.peek()).equalsIgnoreCase(string3)) {
                LOGGER.error("ERSAXParserv7x.endElement() - Invalid XML - Stack error at " + string3);
                throw new SAXException(MessageFormat.format(Messages.getString("ERSAXParserv7x.FileFormatInvalidTagEnd"), (String)this.stack.peek(), string3));
            }
            if (this.stack.search("EMX:Model") != -1) {
                if (this.stack.search("ModelEnvProps") != -1) {
                    this.endModelEnvProps(string, string2, string3);
                } else if (this.stack.search("ModelProps") != -1) {
                    this.endModelProps(string, string2, string3);
                } else if (this.stack.search("Entity_Groups") != -1) {
                    this.endEntitiesAndAttributes(string, string2, string3);
                } else if (this.stack.search("Domain_Groups") != -1) {
                    this.endDomains(string, string2, string3);
                } else if (this.stack.search("Oracle_Tablespace_Groups") != -1) {
                    this.endOracleTablespaces(string, string2, string3);
                } else if (this.stack.search("Subject_Area_Groups") != -1) {
                    this.endSubjectAreas(string, string2, string3);
                } else if (this.stack.search("Relationship_Groups") != -1) {
                    this.endRelationships(string, string2, string3);
                } else if (this.stack.search("Default_Groups") != -1) {
                    this.endDefaultValues(string, string2, string3);
                } else if (this.stack.search("Validation_Rule_Groups") != -1) {
                    this.endValidationRules(string, string2, string3);
                } else if (this.stack.search("Stored_Procedure_Groups") != -1) {
                    this.endStoredProcedures(string, string2, string3);
                } else if (this.stack.search("Many_To_Many_Transform_Groups") != -1) {
                    this.endManyToManyTransforms(string, string2, string3);
                } else if (this.stack.search("Supertype_Subtype_Roll_Up_Transform_Groups") != -1) {
                    this.endRollUpTransforms(string, string2, string3);
                } else if (this.stack.search("View_Groups") != -1) {
                    this.endViews(string, string2, string3);
                } else if (this.stack.search("Sequence_Groups") != -1) {
                    this.endSequences(string, string2, string3);
                } else if (this.stack.search("Font_Groups") != -1) {
                    this.endFonts(string, string2, string3);
                } else if (this.stack.search("Default_Fonts_And_Colors_Groups") != -1) {
                    this.endDefaultFontsAndColors(string, string2, string3);
                } else if (this.stack.search("Oracle_Package_Groups") != -1) {
                    this.endOraclePackages(string, string2, string3);
                } else if (this.stack.search("Function_Groups") != -1) {
                    this.endFunctions(string, string2, string3);
                } else if (this.stack.search("Transform_Scratch_Object_Groups") != -1) {
                    this.endTransformScratchObjects(string, string2, string3);
                }
            }
            if (string3.equalsIgnoreCase("ERwin")) {
                this.monitorProgress(Messages.getString("ERSAXParserv7x.ResolveReferences"), PROGRESS_INCREMENT);
                this.resolveWaitingLists();
                this.resolveSubjectAreas();
                if (this.isMainLogical) {
                    this.design.getLogicalDesign().rearrangeEntities();
                    this.design.getLogicalDesign().rearrangeViews();
                    this.design.getLogicalDesign().getMainView().setAutoRoute(true);
                    this.design.getLogicalDesign().getMainView().getWorkSpace().updateSettings();
                }
                if (this.isMainRelational) {
                    ((DPVRelational)this.design.getRelationalDesign().getMainView()).rearrangeNewDiagram();
                    this.design.getRelationalDesign().rearrangeViews();
                    this.design.getRelationalDesign().getMainView().setAutoRoute(true);
                    this.design.getRelationalDesign().getMainView().getWorkSpace().updateSettings();
                }
                this.resolveDesignModels();
                this.setDesignName(this.designName);
                Object[] objectArray = new Object[]{this.design.getParent(), this.design};
                JTree jTree = this.design.getAppView().getBrowserPanel().getJTree();
                int n = jTree.getRowForPath(new TreePath(objectArray));
                jTree.collapseRow(n);
                jTree.expandRow(n);
                this.monitorProgress(Messages.getString("ERSAXParserv7x.EndOfImport"), 100);
            }
            this.stack.pop();
            if (string3.equalsIgnoreCase("ERwin")) {
                if (!this.stack.empty()) {
                    LOGGER.error("ERSAXParserv7x.endElement() - Invalid XML - Stack error at " + string3);
                    throw new SAXException(MessageFormat.format(Messages.getString("ERSAXParserv7x.FileFormatInvalidStackEnd"), string3));
                }
                this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportComplete"), -1);
            }
        }
        catch (EmptyStackException emptyStackException) {
            LOGGER.error("ERSAXParserv7x.endElement() - Invalid XML - Stack error at " + string3, emptyStackException);
            throw new SAXException(MessageFormat.format(Messages.getString("ERSAXParserv7x.FileFormatInvalidStackEnd"), string3));
        }
    }

    private void startModelEnvProps(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("ModelEnvProps")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportModelEnvironment"), PROGRESS_INCREMENT);
            this.targetServer = "";
            this.targetVersion = "";
        }
    }

    private void endModelEnvProps(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("ModelEnvProps")) {
            this.rdbmsType = null;
            if (this.targetServer.equalsIgnoreCase("1075858978")) {
                this.rdbmsType = this.targetVersion.equals("7") ? StorageDesignDB2v70.RDBMS_TYPE : (this.targetVersion.equals("8") ? StorageDesignDB2v70.RDBMS_TYPE : StorageDesignDB2v80.RDBMS_TYPE);
            } else if (this.targetServer.equalsIgnoreCase("1075858979")) {
                this.rdbmsType = this.targetVersion.equals("9") ? StorageDesignOraclev9i.RDBMS_TYPE : (this.targetVersion.equals("10") ? StorageDesignOraclev10g.RDBMS_TYPE : (this.targetVersion.equals("11") ? StorageDesignOraclev11g.RDBMS_TYPE : StorageDesignOraclev10g.RDBMS_TYPE));
            } else if (this.targetServer.equalsIgnoreCase("1075859016")) {
                this.rdbmsType = this.targetVersion.equals("8") ? StorageDesignSqlServerv2k.RDBMS_TYPE : (this.targetVersion.equals("9") ? StorageDesignSqlServerv2k5.RDBMS_TYPE : StorageDesignSqlServerv2k.RDBMS_TYPE);
            } else if (this.targetServer.equalsIgnoreCase("1075858977")) {
                this.rdbmsType = this.targetVersion.equals("7") ? StorageDesignUDBv71.RDBMS_TYPE : (this.targetVersion.equals("8") ? StorageDesignUDBv81.RDBMS_TYPE : StorageDesignUDBv71.RDBMS_TYPE);
            }
            if (this.rdbmsType != null) {
                this.rdbmsSite = this.design.getFirstOfType(this.rdbmsType);
                this.design.setSelectedRDBMSSite(this.rdbmsSite);
                if ("Oracle Database".equalsIgnoreCase(this.rdbmsType.getProductName())) {
                    this.oracleStorage = (StorageDesignOracle)this.design.getStorageDesign(this.rdbmsSite);
                    this.relational.getStorageDesignFactory().getSorageDesigns().add(this.oracleStorage);
                    this.oracleStorage.setOpen(true);
                }
            }
        } else if (string3.equalsIgnoreCase("Target_Server")) {
            this.targetServer = this.getText();
        } else if (string3.equalsIgnoreCase("Target_Server_Version")) {
            this.targetVersion = this.getText();
        }
    }

    private void startModelProps(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("ModelProps")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportModelProperties"), PROGRESS_INCREMENT);
            this.createLogical = true;
            this.createRelational = true;
            this.designName = "";
        }
    }

    private void endModelProps(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Name")) {
            this.designName = this.getText();
        } else if (string3.equalsIgnoreCase("Type")) {
            if (this.getText().equalsIgnoreCase("1")) {
                this.createRelational = false;
            } else if (this.getText().equalsIgnoreCase("2")) {
                this.createLogical = false;
            }
        }
    }

    private void startEntitiesAndAttributes(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("Entity_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportEntitiesAndAttributes"), PROGRESS_INCREMENT);
            this.logicalObjects = new TreeMap();
            this.relationalObjects = new TreeMap();
            this.logicalViews = new ArrayList();
            this.relationalViews = new ArrayList();
            this.logicalFKElements = new ArrayList();
            this.relationalFKElements = new ArrayList();
        } else if (string3.equalsIgnoreCase("Entity")) {
            this.tempEntityID = attributes.getValue("id");
            this.tempEntity = new TempEntity(this.tempEntityID, attributes.getValue("name"));
        } else if (string3.equalsIgnoreCase("Attribute_Groups")) {
            this.tempEntity.initAttributes();
        } else if (string3.equalsIgnoreCase("Attribute")) {
            this.tempAttributeID = attributes.getValue("id");
            this.tempAttribute = new TempAttribute(this.tempAttributeID, attributes.getValue("name"));
        } else if (string3.equalsIgnoreCase("Key_Group_Groups")) {
            this.tempEntity.initKeys();
        } else if (string3.equalsIgnoreCase("Key_Group")) {
            this.tempKeyID = attributes.getValue("id");
            this.tempKey = new TempKey(this.tempKeyID, attributes.getValue("name"));
        } else if (string3.equalsIgnoreCase("Key_Group_Member")) {
            this.tempKeyMemberID = attributes.getValue("id");
            this.tempKeyMember = new TempKeyMember(this.tempKeyMemberID, attributes.getValue("name"));
        } else if (string3.equalsIgnoreCase("Oracle_Physical_Storage_Groups") && this.stack.search("Oracle_Partition_Description") == -1) {
            this.tempEntity.initPhysicalStorages();
        } else if (string3.equalsIgnoreCase("Oracle_Physical_Storage") && this.stack.search("Oracle_Partition_Description") == -1) {
            this.tempPhysicalStorageID = attributes.getValue("id");
            this.tempPhysicalStorage = new TempPhysicalStorage(this.tempPhysicalStorageID, attributes.getValue("name"));
        } else if (string3.equalsIgnoreCase("Trigger_Groups")) {
            this.tempEntity.initTriggers();
        } else if (string3.equalsIgnoreCase("Trigger")) {
            this.tempTableTriggerID = attributes.getValue("id");
            this.tempTableTrigger = new TempTrigger(this.tempTableTriggerID, attributes.getValue("name"));
        } else if (string3.equalsIgnoreCase("Oracle_Range_Partition_Groups")) {
            this.tempEntity.initPartitions();
        } else if (string3.equalsIgnoreCase("Oracle_Range_Partition")) {
            this.tempPartitionID = attributes.getValue("id");
            this.tempPartition = new TempPartition(this.tempPartitionID, attributes.getValue("name"), "1");
        } else if (string3.equalsIgnoreCase("Oracle_Range_Partition_Info_Groups")) {
            this.tempPartition.initPartitionInfos();
        } else if (string3.equalsIgnoreCase("Oracle_Range_Partition_Info")) {
            this.tempPartitionInfoID = attributes.getValue("id");
            this.tempPartitionInfo = new TempPartitionInfo(this.tempPartitionInfoID, attributes.getValue("name"));
        } else if (string3.equalsIgnoreCase("Oracle_List_Partition_Groups")) {
            this.tempEntity.initPartitions();
        } else if (string3.equalsIgnoreCase("Oracle_List_Partition")) {
            this.tempPartitionID = attributes.getValue("id");
            this.tempPartition = new TempPartition(this.tempPartitionID, attributes.getValue("name"), "2");
        } else if (string3.equalsIgnoreCase("Oracle_List_Partition_Info_Groups")) {
            this.tempPartition.initPartitionInfos();
        } else if (string3.equalsIgnoreCase("Oracle_List_Partition_Info")) {
            this.tempPartitionInfoID = attributes.getValue("id");
            this.tempPartitionInfo = new TempPartitionInfo(this.tempPartitionInfoID, attributes.getValue("name"));
        } else if (string3.equalsIgnoreCase("Oracle_Hash_Partition_Groups")) {
            this.tempEntity.initPartitions();
        } else if (string3.equalsIgnoreCase("Oracle_Hash_Partition")) {
            this.tempPartitionID = attributes.getValue("id");
            this.tempPartition = new TempPartition(this.tempPartitionID, attributes.getValue("name"), "3");
            this.tempPartitionInfoID = "";
            this.tempPartitionInfo = null;
        } else if (string3.equalsIgnoreCase("Oracle_Individual_Hash_Partition_Groups")) {
            this.tempPartition.initPartitionInfos();
        } else if (string3.equalsIgnoreCase("Oracle_Individual_Hash_Partition")) {
            this.tempPartitionInfoID = attributes.getValue("id");
            this.tempPartitionInfo = new TempPartitionInfo(this.tempPartitionInfoID, attributes.getValue("name"));
        } else if (string3.equalsIgnoreCase("Oracle_Composite_Partition_Groups")) {
            this.tempEntity.initPartitions();
        } else if (string3.equalsIgnoreCase("Oracle_Composite_Partition")) {
            this.tempPartitionID = attributes.getValue("id");
            this.tempPartition = new TempPartition(this.tempPartitionID, attributes.getValue("name"), "4");
        } else if (string3.equalsIgnoreCase("Oracle_Subpartition_Spec_Groups")) {
            this.tempPartitionInfo.initSubPartitionInfos();
        } else if (string3.equalsIgnoreCase("Oracle_Subpartition_Spec")) {
            this.tempSubPartitionInfoID = attributes.getValue("id");
            this.tempSubPartitionInfo = new TempSubPartitionInfo(this.tempSubPartitionInfoID, attributes.getValue("name"));
        }
    }

    private void endEntitiesAndAttributes(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Entity_Groups")) {
            if (this.createLogical) {
                this.parseEntityViews();
            }
            if (this.createRelational) {
                this.parseTableViews();
            }
            if (this.createLogical && this.createRelational) {
                this.createMappings(this.design, this.logicalObjects, this.relationalObjects);
            }
        } else if (string3.equalsIgnoreCase("Entity")) {
            this.parseEntity();
        } else if (this.stack.search("EntityProps") != -1) {
            if (string3.equalsIgnoreCase("Type")) {
                this.tempEntity.setType(this.getText());
            } else if (string3.equalsIgnoreCase("Physical_Name")) {
                this.tempEntity.setPhysicalName(this.getText());
            } else if (string3.equalsIgnoreCase("Schema_Name")) {
                this.tempEntity.setSchemaName(this.getText());
            } else if (string3.equalsIgnoreCase("Is_Physical_Only")) {
                this.tempEntity.setPhysicalOnly(this.getText());
            } else if (string3.equalsIgnoreCase("Is_Logical_Only")) {
                this.tempEntity.setLogicalOnly(this.getText());
            } else if (string3.equalsIgnoreCase("Hide_In_Logical")) {
                this.tempEntity.setHideInLogical(this.getText());
            } else if (string3.equalsIgnoreCase("Hide_In_Physical")) {
                this.tempEntity.setHideInPhysical(this.getText());
            } else if (string3.equalsIgnoreCase("Definition")) {
                this.tempEntity.setDefinition(this.getText());
            } else if (string3.equalsIgnoreCase("Fill_Color")) {
                this.tempEntity.setBgColorVal(this.getText());
            } else if (string3.equalsIgnoreCase("Outline_Color")) {
                this.tempEntity.setOutlineColorVal(this.getText());
            } else if (string3.equalsIgnoreCase("Default_Entity_Name_Font_Ref")) {
                this.tempEntity.setNameFontID(this.getText());
            } else if (string3.equalsIgnoreCase("Default_Entity_Name_Color")) {
                this.tempEntity.setNameColorVal(this.getText());
            } else if (string3.equalsIgnoreCase("Compress_Type")) {
                this.tempEntity.setCompressType(this.getText());
            } else if (string3.equalsIgnoreCase("Comment") || string3.equalsIgnoreCase("Note")) {
                this.tempEntity.setComment(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Partition_Type")) {
                this.tempEntity.setPartitionType(this.getText());
            } else if (string3.equalsIgnoreCase("Source_Of_Transforms_Ref")) {
                this.tempEntity.addSourceOfTransform(this.getText());
            } else if (string3.equalsIgnoreCase("Target_Of_Transforms_Ref")) {
                this.tempEntity.addTargetOfTransform(this.getText());
            } else if (string3.equalsIgnoreCase("Validation_Rule_Ref")) {
                this.tempEntity.addValidRuleRef(this.getText());
            } else if (string3.equalsIgnoreCase("Stored_Procedures_Ref")) {
                this.tempEntity.addStoredProcedureRef(this.getText());
            } else if (string3.equalsIgnoreCase("Functions_Ref")) {
                this.tempEntity.addFunctionRef(this.getText());
            } else if (this.stack.search("Attributes_Order_Ref_Array") != -1) {
                if (string3.equalsIgnoreCase("Attributes_Order_Ref")) {
                    this.tempEntity.getAttributesOrder().add(this.getText());
                }
            } else if (this.stack.search("Columns_Order_Ref_Array") != -1 && string3.equalsIgnoreCase("Columns_Order_Ref")) {
                this.tempEntity.getColumnsOrder().add(this.getText());
            }
        } else if (string3.equalsIgnoreCase("Attribute")) {
            this.tempEntity.addAttribute(this.tempAttribute);
        } else if (this.stack.search("AttributeProps") != -1) {
            if (string3.equalsIgnoreCase("Physical_Name")) {
                this.tempAttribute.setPhysicalName(this.getText());
            } else if (string3.equalsIgnoreCase("Hide_In_Logical")) {
                this.tempAttribute.setHideInLogical(this.getText());
            } else if (string3.equalsIgnoreCase("Hide_In_Physical")) {
                this.tempAttribute.setHideInPhysical(this.getText());
            } else if (string3.equalsIgnoreCase("Parent_Attribute_Ref")) {
                this.tempAttribute.setParentAttrRef(this.getText());
            } else if (string3.equalsIgnoreCase("Parent_Relationship_Ref")) {
                this.tempAttribute.setParentRelRef(this.getText());
            } else if (string3.equalsIgnoreCase("Logical_Lead_Attribute_Ref")) {
                this.tempAttribute.setLogicalRef(this.getText());
            } else if (string3.equalsIgnoreCase("Physical_Lead_Attribute_Ref")) {
                this.tempAttribute.setPhysicalRef(this.getText());
            } else if (string3.equalsIgnoreCase("Parent_Domain_Ref")) {
                this.tempAttribute.setParentDomRef(this.getText());
            } else if (string3.equalsIgnoreCase("Logical_Data_Type")) {
                this.tempAttribute.setLogicalDataType(this.getText());
            } else if (string3.equalsIgnoreCase("Physical_Data_Type")) {
                this.tempAttribute.setPhysicalDataType(this.getText());
            } else if (string3.equalsIgnoreCase("Definition")) {
                this.tempAttribute.setDefinition(this.getText());
            } else if (string3.equalsIgnoreCase("Null_Option_Type")) {
                this.tempAttribute.setNullOptionType(this.getText());
            } else if (string3.equalsIgnoreCase("Validation_Rule_Ref")) {
                this.tempAttribute.setValidRuleRef(this.getText());
            } else if (string3.equalsIgnoreCase("Default")) {
                this.tempAttribute.setDefaultRef(this.getText());
            } else if (string3.equalsIgnoreCase("Font_Ref")) {
                this.tempAttribute.setFontRef(this.getText());
            } else if (string3.equalsIgnoreCase("Font_Color")) {
                this.tempAttribute.setFontColor(this.getText());
            } else if (string3.equalsIgnoreCase("Comment") || string3.equalsIgnoreCase("Note")) {
                this.tempAttribute.setComment(this.getText());
            } else if (string3.equalsIgnoreCase("Source_Of_Transforms_Ref")) {
                this.tempAttribute.addSourceOfTransform(this.getText());
            } else if (string3.equalsIgnoreCase("Target_Of_Transforms_Ref")) {
                this.tempAttribute.addTargetOfTransform(this.getText());
            } else if (string3.equalsIgnoreCase("View_Expression")) {
                this.tempAttribute.setViewExpression(this.getText());
            }
        } else if (string3.equalsIgnoreCase("Key_Group")) {
            this.tempEntity.addKey(this.tempKey);
        } else if (this.stack.search("Key_GroupProps") != -1) {
            if (string3.equalsIgnoreCase("Physical_Name")) {
                this.tempKey.setPhysicalName(this.getText());
            } else if (string3.equalsIgnoreCase("Key_Group_Type")) {
                this.tempKey.setType(this.getText());
            } else if (string3.equalsIgnoreCase("Definition")) {
                this.tempKey.setDefinition(this.getText());
            } else if (string3.equalsIgnoreCase("Relationship_Ref")) {
                String string4 = this.getText();
                this.relationKey.put(string4, this.tempKey);
            }
        } else if (string3.equalsIgnoreCase("Key_Group_Member")) {
            this.tempKey.addKeyMember(this.tempKeyMember);
        } else if (this.stack.search("Key_Group_MemberProps") != -1) {
            if (string3.equalsIgnoreCase("Attribute_Ref")) {
                this.tempKeyMember.setAttributeRef(this.getText());
            } else if (string3.equalsIgnoreCase("Key_Group_Sort_Order")) {
                this.tempKeyMember.setSortOrder(this.getText());
            }
        } else if (string3.equalsIgnoreCase("Oracle_Physical_Storage") && this.stack.search("Oracle_Partition_Description") == -1) {
            this.tempEntity.addPhysicalStorage(this.tempPhysicalStorage);
        } else if (this.stack.search("Oracle_Physical_StorageProps") != -1 && this.stack.search("Oracle_Partition_Description") == -1) {
            if (string3.equalsIgnoreCase("Oracle_Tablespace_Ref")) {
                this.tempPhysicalStorage.setTablespaceRef(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Buffer_Pool")) {
                this.tempPhysicalStorage.setBufferPool(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Free_List_Groups")) {
                this.tempPhysicalStorage.setFreeListGroups(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Free_Lists")) {
                this.tempPhysicalStorage.setFreeLists(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Initial_Extent_Size")) {
                this.tempPhysicalStorage.setInitialExtentSize(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Initial_Transactions")) {
                this.tempPhysicalStorage.setInitialTransactions(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Max_Extent_Type")) {
                this.tempPhysicalStorage.setMaxExtentType(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Max_Extents")) {
                this.tempPhysicalStorage.setMaxExtents(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Min_Extents")) {
                this.tempPhysicalStorage.setMinExtents(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Next_Extent_Size")) {
                this.tempPhysicalStorage.setNextExtentSize(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_No_Logging")) {
                this.tempPhysicalStorage.setNoLogging(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Percent_Free")) {
                this.tempPhysicalStorage.setPercentIncrease(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Percent_Increase")) {
                this.tempPhysicalStorage.setPercentIncrease(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Percent_Used")) {
                this.tempPhysicalStorage.setPercentIncrease(this.getText());
            }
        } else if (string3.equalsIgnoreCase("Trigger")) {
            this.tempEntity.addTrigger(this.tempTableTrigger);
        } else if (this.stack.search("TriggerProps") != -1) {
            if (string3.equalsIgnoreCase("Definition")) {
                this.tempTableTrigger.setDefinition(this.getText());
            } else if (string3.equalsIgnoreCase("Schema_Name")) {
                this.tempTableTrigger.setSchemaName(this.getText());
            } else if (string3.equalsIgnoreCase("Type")) {
                this.tempTableTrigger.setType(this.getText());
            } else if (string3.equalsIgnoreCase("Trigger_Status")) {
                this.tempTableTrigger.setStatus(this.getText());
            } else if (string3.equalsIgnoreCase("Trigger_Fire_Type")) {
                this.tempTableTrigger.setFireType(this.getText());
            } else if (string3.equalsIgnoreCase("Trigger_Scope")) {
                this.tempTableTrigger.setScope(this.getText());
            } else if (string3.equalsIgnoreCase("Trigger_Old")) {
                this.tempTableTrigger.setOldAs(this.getText());
            } else if (string3.equalsIgnoreCase("Trigger_New")) {
                this.tempTableTrigger.setNewAs(this.getText());
            } else if (string3.equalsIgnoreCase("Trigger_Body")) {
                this.tempTableTrigger.setBody(this.getText());
            } else if (string3.equalsIgnoreCase("When_Clause")) {
                this.tempTableTrigger.setWhen(this.getText());
            } else if (string3.equalsIgnoreCase("Trigger_Update_Columns_Ref")) {
                this.tempTableTrigger.addColumnRef(this.getText());
            }
        } else if (string3.equalsIgnoreCase("Oracle_Range_Partition")) {
            this.tempEntity.addPartition(this.tempPartition);
        } else if (this.stack.search("Oracle_Range_Partition") != -1) {
            if (string3.equalsIgnoreCase("Columns_Ref")) {
                this.tempPartition.addColumnRef(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Range_Partition_Info")) {
                this.tempPartition.addPartitionInfo(this.tempPartitionInfo);
            } else if (string3.equalsIgnoreCase("Partition_Values")) {
                this.tempPartitionInfo.addPartitionValue(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Tablespace_Ref")) {
                this.tempPartitionInfo.addTablespaceRef(this.getText());
            }
        } else if (string3.equalsIgnoreCase("Oracle_List_Partition")) {
            this.tempEntity.addPartition(this.tempPartition);
        } else if (this.stack.search("Oracle_List_Partition") != -1) {
            if (string3.equalsIgnoreCase("Column_Ref")) {
                this.tempPartition.addColumnRef(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_List_Partition_Info")) {
                this.tempPartition.addPartitionInfo(this.tempPartitionInfo);
            } else if (string3.equalsIgnoreCase("Partition_Values")) {
                this.tempPartitionInfo.addPartitionValue(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Tablespace_Ref")) {
                this.tempPartitionInfo.addTablespaceRef(this.getText());
            }
        } else if (string3.equalsIgnoreCase("Oracle_Hash_Partition")) {
            if ("1".equalsIgnoreCase(this.tempPartition.getHashType())) {
                this.tempPartitionInfoID = this.tempPartitionID.replace("+00000000", "+00000001");
                this.tempPartitionInfo = new TempPartitionInfo(this.tempPartitionInfoID, this.tempPartition.getName());
                this.tempPartitionInfo.setTablespaceRefs(this.tempPartition.getTablespaceRefs());
                this.tempPartition.addPartitionInfo(this.tempPartitionInfo);
            }
            this.tempEntity.addPartition(this.tempPartition);
        } else if (this.stack.search("Oracle_Hash_Partition") != -1) {
            if (string3.equalsIgnoreCase("Columns_Ref")) {
                this.tempPartition.addColumnRef(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Hash_Partition_Type")) {
                this.tempPartition.setHashType(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Hash_Partition_Quantity")) {
                this.tempPartition.setHashQuantity(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Tablespaces_Ref")) {
                this.tempPartition.addTablespaceRef(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Individual_Hash_Partition")) {
                this.tempPartition.addPartitionInfo(this.tempPartitionInfo);
            } else if (string3.equalsIgnoreCase("Oracle_Tablespace_Ref")) {
                this.tempPartitionInfo.addTablespaceRef(this.getText());
            }
        } else if (string3.equalsIgnoreCase("Oracle_Composite_Partition")) {
            this.tempEntity.setCompositeType(this.tempPartition.getCompositePartitionType());
            this.tempEntity.addPartition(this.tempPartition);
        } else if (this.stack.search("Oracle_Composite_Partition") != -1) {
            if (string3.equalsIgnoreCase("Columns_Ref")) {
                this.tempPartition.addColumnRef(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Composite_Subpartition_Type")) {
                this.tempPartition.setCompositePartitionType(this.getText());
            } else if (string3.equalsIgnoreCase("Column_Ref")) {
                this.tempPartition.setCompositeListColumnRef(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Hash_Columns_Ref")) {
                this.tempPartition.addHashColumnRef(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Range_Partition_Info")) {
                this.tempPartition.addPartitionInfo(this.tempPartitionInfo);
            } else if (string3.equalsIgnoreCase("Oracle_Subpartition_Spec")) {
                this.tempPartitionInfo.addSubPartitionInfo(this.tempSubPartitionInfo);
            } else if (string3.equalsIgnoreCase("Oracle_Hash_Partition_Quantity") && this.stack.search("Oracle_Range_Partition_Info") == -1) {
                this.tempPartition.setHashQuantity(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Hash_Partition_Quantity") && this.stack.search("Oracle_Range_Partition_Info") != -1) {
                this.tempPartitionInfo.setPartHashQuantity(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Tablespaces_Ref") && this.stack.search("Oracle_Range_Partition_Info") == -1) {
                this.tempPartition.addTablespaceRef(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Tablespaces_Ref") && this.stack.search("Oracle_Range_Partition_Info") != -1) {
                this.tempPartitionInfo.addTablespaceRef(this.getText());
            } else if (string3.equalsIgnoreCase("Partition_Values") && this.stack.search("Oracle_Subpartition_Spec") == -1) {
                this.tempPartitionInfo.addPartitionValue(this.getText());
            } else if (string3.equalsIgnoreCase("Partition_Values") && this.stack.search("Oracle_Subpartition_Spec") != -1) {
                this.tempSubPartitionInfo.addSubPartitionValue(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Tablespace_Ref") && this.stack.search("Oracle_Subpartition_Spec") == -1) {
                this.tempPartitionInfo.addTablespaceRef(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Tablespace_Ref") && this.stack.search("Oracle_Subpartition_Spec") != -1) {
                this.tempSubPartitionInfo.setSubTablespaceRef(this.getText());
            }
        }
    }

    private void orderContainer(ContainerObject containerObject, List<String> list, Map map) {
        Iterator<String> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = iterator.next();
            ContainedObject containedObject = (ContainedObject)map.get(string);
            if (containedObject == null || containedObject.getContainer() != containerObject) continue;
            containerObject.moveToIndex(containedObject, n);
            ++n;
        }
    }

    private void parseEntity() {
        Object object;
        if (this.createLogical && !"true".equalsIgnoreCase(this.tempEntity.getPhysicalOnly()) && !"true".equalsIgnoreCase(this.tempEntity.getHideInLogical()) && this.tempEntity.getTargetOfTransforms().isEmpty() && !"".equalsIgnoreCase(this.tempEntity.getName())) {
            if ("17".equalsIgnoreCase(this.tempEntity.getType())) {
                object = this.logical.getEntityViewSet().createEntityView(this.deriveObjectID(ID_PREFIX_ENTITY_VIEW, this.tempEntityID));
                ((DesignObject)object).setName(this.tempEntity.getName());
                this.logicalObjects.put(this.tempEntityID, object);
                if (!"".equals(this.tempEntity.getDefinition())) {
                    ((ModelIDObject)object).setComment(this.tempEntity.getDefinition());
                }
                if (!"".equals(this.tempEntity.getComment())) {
                    ((ModelIDObject)object).setNotes(this.tempEntity.getComment());
                }
                this.setFontAndColor((DesignObject)object, this.tempEntity.getBgColorVal(), this.tempEntity.getOutlineColorVal(), this.tempEntity.getNameFontID(), this.tempEntity.getNameColorVal());
                this.logicalViews.add(this.tempEntity);
            } else {
                object = this.logical.getEntitySet().createEntity(this.deriveObjectID(ID_PREFIX_ENTITY, this.tempEntityID));
                ((DesignObject)object).setName(this.tempEntity.getName());
                this.logicalObjects.put(this.tempEntityID, object);
                if (!"".equals(this.tempEntity.getDefinition())) {
                    ((ModelIDObject)object).setComment(this.tempEntity.getDefinition());
                }
                if (!"".equals(this.tempEntity.getComment())) {
                    ((ModelIDObject)object).setNotes(this.tempEntity.getComment());
                }
                this.parseAttributes(this.tempEntity, (Entity)object);
                this.parseKeys(this.tempEntity, (Entity)object);
                this.setFontAndColor((DesignObject)object, this.tempEntity.getBgColorVal(), this.tempEntity.getOutlineColorVal(), this.tempEntity.getNameFontID(), this.tempEntity.getNameColorVal());
                if (this.createLogical && this.createRelational) {
                    for (Object object2 : this.tempEntity.getSourceOfTransforms()) {
                        this.transformWaitingList.add(new TransformWaitingListEntry(true, (String)object2, this.tempEntityID));
                    }
                }
                this.orderContainer((ContainerObject)object, this.tempEntity.getAttributesOrder(), this.logicalObjects);
            }
        }
        if (this.createRelational && !"true".equalsIgnoreCase(this.tempEntity.getLogicalOnly()) && !"true".equalsIgnoreCase(this.tempEntity.getHideInPhysical()) && this.tempEntity.getSourceOfTransforms().isEmpty() && !"".equalsIgnoreCase(this.tempEntity.getName())) {
            Object object3;
            object = this.tempEntity.getName();
            if (!"".equalsIgnoreCase(this.tempEntity.getPhysicalName())) {
                object = this.tempEntity.getPhysicalName();
            }
            if ("17".equalsIgnoreCase(this.tempEntity.getType())) {
                Object object2;
                object3 = this.relational.getTableViewSet().createTableView(this.deriveObjectID(ID_PREFIX_TABLE_VIEW, this.tempEntityID));
                ((DesignObject)object3).setName((String)object);
                this.relationalObjects.put(this.tempEntityID, object3);
                if (!"".equals(this.tempEntity.getSchemaName())) {
                    this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempEntity.getSchemaName(), object3));
                }
                if (!"".equals(this.tempEntity.getDefinition())) {
                    ((ModelIDObject)object3).setComment(this.tempEntity.getDefinition());
                }
                if (!"".equals(this.tempEntity.getComment())) {
                    ((ModelIDObject)object3).setNotes(this.tempEntity.getComment());
                }
                this.setFontAndColor((DesignObject)object3, this.tempEntity.getBgColorVal(), this.tempEntity.getOutlineColorVal(), this.tempEntity.getNameFontID(), this.tempEntity.getNameColorVal());
                this.relationalViews.add(this.tempEntity);
                if (this.oracleStorage != null && (object2 = (TableViewProxyOracle)this.oracleStorage.getTableViewProxySet().getProxy(((ModelIDObject)object3).getObjectID())) != null && !"".equals(this.tempEntity.getSchemaName())) {
                    this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempEntity.getSchemaName(), object2));
                }
            } else {
                Object object4;
                Object object52;
                object3 = this.relational.getTableSet().createTable(this.deriveObjectID(ID_PREFIX_TABLE, this.tempEntityID));
                ((Table)object3).setName((String)object);
                this.relationalObjects.put(this.tempEntityID, object3);
                if (!"".equals(this.tempEntity.getSchemaName())) {
                    this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempEntity.getSchemaName(), object3));
                }
                if (!"".equals(this.tempEntity.getDefinition())) {
                    ((ModelIDObject)object3).setComment(this.tempEntity.getDefinition());
                }
                if (!"".equals(this.tempEntity.getComment())) {
                    ((ModelIDObject)object3).setNotes(this.tempEntity.getComment());
                }
                this.parseColumns(this.tempEntity, (Table)object3);
                this.parseIndexes(this.tempEntity, (Table)object3);
                for (Object object52 : this.tempEntity.getValidRuleRefs()) {
                    if (this.validationRules.isEmpty()) {
                        this.validationRuleWaitingList.add(new ValidationRuleWaitingListEntry((DesignObject)object3, (String)object52, true));
                        continue;
                    }
                    object4 = (ValidationRuleHolder)this.validationRules.get(object52);
                    if (object4 == null || ((ValidationRuleHolder)object4).getType() != 0) continue;
                    Iterator iterator = ((Table)object3).createCheckConstraint(((ValidationRuleHolder)object4).getName(), ((ValidationRuleHolder)object4).getRule());
                    ((Table)object3).addCheckConstraint((TableLevelConstraint)((Object)iterator));
                }
                this.setFontAndColor((DesignObject)object3, this.tempEntity.getBgColorVal(), this.tempEntity.getOutlineColorVal(), this.tempEntity.getNameFontID(), this.tempEntity.getNameColorVal());
                this.orderContainer((ContainerObject)object3, this.tempEntity.getColumnsOrder(), this.relationalObjects);
                if (this.createLogical && this.createRelational) {
                    object52 = this.tempEntity.getTargetOfTransforms().iterator();
                    while (object52.hasNext()) {
                        object4 = (String)object52.next();
                        this.transformWaitingList.add(new TransformWaitingListEntry(false, (String)object4, this.tempEntityID));
                    }
                }
                if (this.oracleStorage != null && (object52 = (TableProxyOracle)this.oracleStorage.getTableProxySet().getProxy(((ModelIDObject)object3).getObjectID())) != null) {
                    for (Iterator iterator : this.tempEntity.getPhysicalStorages()) {
                        ((TableProxyOracle)object52).setSegment(this.parseSegment((TempPhysicalStorage)((Object)iterator)));
                        if (((TempPhysicalStorage)((Object)iterator)).noLogging()) {
                            ((TableProxyOracle)object52).setLogging("NOLOGGING");
                        } else {
                            ((TableProxyOracle)object52).setLogging("LOGGING");
                        }
                        if ("".equals(((TempPhysicalStorage)((Object)iterator)).getTablespaceRef())) continue;
                        this.tablespaceWaitingList.add(new TablespaceWaitingListEntry(((TempPhysicalStorage)((Object)iterator)).getTablespaceRef(), object52));
                    }
                    if (!"".equals(this.tempEntity.getSchemaName())) {
                        this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempEntity.getSchemaName(), object52));
                    }
                    if ("918".equalsIgnoreCase(this.tempEntity.getCompressType()) || "919".equalsIgnoreCase(this.tempEntity.getCompressType())) {
                        if (object52 instanceof TableProxyOraclev11g) {
                            ((TableProxyOraclev11g)object52).setDataSegmentCompression("919".equalsIgnoreCase(this.tempEntity.getCompressType()) ? "YES" : "NO");
                        } else if (object52 instanceof TableProxyOraclev10g) {
                            ((TableProxyOraclev10g)object52).setDataSegmentCompression("919".equalsIgnoreCase(this.tempEntity.getCompressType()) ? "YES" : "NO");
                        }
                    }
                    for (Object object6 : this.tempEntity.getTriggers()) {
                        Object object7 = this.oracleStorage.getTriggerSet().createTrigger(this.deriveObjectID(ID_PREFIX_TRIGGER, ((TempTrigger)object6).getID()));
                        ((StorageObject)object7).setName(((TempTrigger)object6).getName());
                        ((TriggerOracle)object7).setTable((TableProxyOracle)object52);
                        this.parseTrigger((TempTrigger)object6, (TriggerOracle)object7);
                        if ("".equals(((TempTrigger)object6).getSchemaName())) continue;
                        this.schemaWaitingList.add(new SchemaWaitingListEntry(((TempTrigger)object6).getSchemaName(), object7));
                    }
                    for (Object object7 : this.tempEntity.getStoredProcedureRefs()) {
                        this.storedProcedureWaitingList.add(new StoredProcedureWaitingListEntry((String)object7, (RelationalObjectProxy)object52));
                    }
                    for (String string : this.tempEntity.getFunctionRefs()) {
                        this.functionWaitingList.add(new FunctionWaitingListEntry(string, (RelationalObjectProxy)object52));
                    }
                    if (!"".equals(this.tempEntity.getPartitionType())) {
                        this.parseTablePartition((TableProxyOracle)object52);
                    }
                }
            }
        }
    }

    private void parseSchema(String string, DesignObject designObject) {
        if (designObject instanceof Table) {
            ((Table)designObject).setSchema(string);
            ((Table)designObject).getSchemaObject().getTables().add(designObject);
        } else if (designObject instanceof TableView) {
            ((TableView)designObject).setSchema(string);
            ((TableView)designObject).getSchemaObject().getViews().add(designObject);
        } else if (designObject instanceof Index) {
            ((Index)designObject).setSchema(string);
            ((Index)designObject).getSchemaObject().getIndexes().add(designObject);
        }
    }

    private void parseProxySchema(String string, RelationalObjectProxy relationalObjectProxy) {
        SchemaObjectSet schemaObjectSet;
        SchemaObject schemaObject;
        UserOracle userOracle = (UserOracle)((StorageDesignOracle)relationalObjectProxy.getStorageDesign()).getUserSet().getByName(string);
        if (userOracle == null) {
            userOracle = (UserOracle)((StorageDesignOracle)relationalObjectProxy.getStorageDesign()).getUserSet().createElement(null);
            userOracle.setName(string);
        }
        if ((schemaObject = (SchemaObject)(schemaObjectSet = this.relational.getSchemaObjectSet()).getByName(string)) == null && !string.trim().equalsIgnoreCase("")) {
            schemaObject = schemaObjectSet.createSchemaObject(null);
            schemaObject.setName(string);
        }
        if (userOracle != null) {
            if (userOracle.getSchemaObject() == null) {
                userOracle.setSchemaObject(schemaObject);
            }
            if (userOracle.getSchemaObject() != schemaObject) {
                if (relationalObjectProxy instanceof TableProxyOracle) {
                    ((TableProxyOracle)relationalObjectProxy).setUser(userOracle);
                } else if (relationalObjectProxy instanceof TableViewProxyOracle) {
                    ((TableViewProxyOracle)relationalObjectProxy).setUser(userOracle);
                } else if (relationalObjectProxy instanceof IndexProxyOracle) {
                    ((IndexProxyOracle)relationalObjectProxy).setUser(userOracle);
                }
            }
        }
    }

    private void parseStorageSchema(String string, StorageObject storageObject) {
        UserOracle userOracle = this.createUser(string);
        if (storageObject instanceof SequenceOracle) {
            ((SequenceOracle)storageObject).setUser(userOracle);
        } else if (storageObject instanceof TriggerOracle) {
            ((TriggerOracle)storageObject).setOwner(userOracle);
        } else if (storageObject instanceof StoredProcedureOracle) {
            ((StoredProcedureOracle)storageObject).setOwner(userOracle);
        } else if (storageObject instanceof PackageOracle) {
            ((PackageOracle)storageObject).setOwner(userOracle);
        } else if (storageObject instanceof FunctionOracle) {
            ((FunctionOracle)storageObject).setOwner(userOracle);
        }
    }

    private UserOracle createUser(String string) {
        UserOracle userOracle = (UserOracle)this.oracleStorage.getUserSet().getByName(string);
        if (userOracle == null) {
            userOracle = this.oracleStorage.getUserSet().createUser();
            userOracle.setName(string);
        }
        return userOracle;
    }

    private SegmentOracle parseSegment(TempPhysicalStorage tempPhysicalStorage) {
        SegmentOracle segmentOracle = this.oracleStorage.getSegmentSet().createSegment();
        segmentOracle.setName(tempPhysicalStorage.getName());
        segmentOracle.setInitrans(tempPhysicalStorage.getInitialTransactions());
        segmentOracle.setPCTFree(tempPhysicalStorage.getPercentFree());
        segmentOracle.setPCTUsed(tempPhysicalStorage.getPercentUsed());
        segmentOracle.setSCBufferPool(tempPhysicalStorage.getBufferPool());
        segmentOracle.setSCFreeLists(tempPhysicalStorage.getFreeLists());
        segmentOracle.setSCFreelistGroups(tempPhysicalStorage.getFreeListGroups());
        segmentOracle.setSCInitialExtent(tempPhysicalStorage.getInitialExtentSize());
        segmentOracle.setSCMinExtents(tempPhysicalStorage.getMinExtents());
        segmentOracle.setSCNextExtent(tempPhysicalStorage.getNextExtentSize());
        segmentOracle.setSCPctIncrease(tempPhysicalStorage.getPercentIncrease());
        if ("900".equalsIgnoreCase(tempPhysicalStorage.getBufferPool())) {
            segmentOracle.setSCBufferPool("KEEP");
        } else if ("901".equalsIgnoreCase(tempPhysicalStorage.getBufferPool())) {
            segmentOracle.setSCBufferPool("RECYCLE");
        } else if ("902".equalsIgnoreCase(tempPhysicalStorage.getBufferPool())) {
            segmentOracle.setSCBufferPool("DEFAULT");
        }
        if ("0".equalsIgnoreCase(tempPhysicalStorage.getMaxExtentType())) {
            segmentOracle.setSCMaxExtents("0");
        } else if ("1".equalsIgnoreCase(tempPhysicalStorage.getMaxExtentType())) {
            segmentOracle.setSCMaxExtents(String.valueOf(tempPhysicalStorage.getMaxExtents()));
        }
        return this.oracleStorage.getSegmentSet().findEqual(segmentOracle);
    }

    private void parseAttributes(TempEntity tempEntity, Entity entity) {
        for (TempAttribute tempAttribute : tempEntity.getAttributes()) {
            Object object;
            Object object2;
            String string = tempAttribute.getID();
            if ("true".equalsIgnoreCase(tempAttribute.getHideInLogical()) || !tempAttribute.getTargetOfTransforms().isEmpty()) continue;
            if (!"".equals(tempAttribute.getParentAttrRef()) && !"".equals(tempAttribute.getParentRelRef())) {
                object2 = new FKElement(string, tempAttribute.getParentAttrRef(), tempAttribute.getParentRelRef());
                ((FKElement)object2).setLogicalRef(tempAttribute.getLogicalRef());
                ((FKElement)object2).setPhysicalRef(tempAttribute.getPhysicalRef());
                this.logicalFKElements.add(object2);
            }
            object2 = entity.createAttribute(tempAttribute.getName());
            ((Attribute)object2).setObjectID(this.deriveObjectID(ID_PREFIX_ATTRIBUTE, string));
            this.logicalObjects.put(string, object2);
            if (!"".equals(tempAttribute.getDefinition())) {
                ((Attribute)object2).setComment(tempAttribute.getDefinition());
            }
            if (!"".equals(tempAttribute.getComment())) {
                ((Attribute)object2).setNotes(tempAttribute.getComment());
            }
            if ("0".equals(tempAttribute.getNullOptionType())) {
                ((Attribute)object2).setNullsAllowed(true);
            } else {
                ((Attribute)object2).setNullsAllowed(false);
            }
            boolean bl = false;
            if (!"".equals(tempAttribute.getLogicalDataType())) {
                bl = this.parseDataType((DesignObject)object2, tempAttribute.getLogicalDataType());
            }
            if (!"".equals(tempAttribute.getParentDomRef())) {
                if (this.domains.isEmpty()) {
                    this.domainWaitingList.add(new DomainWaitingListEntry((DesignObject)object2, tempAttribute.getParentDomRef(), bl));
                } else {
                    object = (Domain)this.domains.get(tempAttribute.getParentDomRef());
                    if (!(object == null || ((DesignObject)object).getName().equalsIgnoreCase("<root>") || ((DesignObject)object).getName().equalsIgnoreCase("<default>") || ((DesignObject)object).getName().equalsIgnoreCase("<unknown>") || ((DesignObject)object).getName().equalsIgnoreCase("Unknown") || bl)) {
                        ((Attribute)object2).setDomain((Domain)object);
                        ((ContainedObjectWithDomain)object2).setUse((short)0);
                        if (!this.usedDomains.contains(((ModelIDObject)object).getObjectID())) {
                            this.usedDomains.add(((ModelIDObject)object).getObjectID());
                        }
                    }
                }
            }
            if (!"".equals(tempAttribute.getValidRuleRef())) {
                if (this.validationRules.isEmpty()) {
                    this.validationRuleWaitingList.add(new ValidationRuleWaitingListEntry((DesignObject)object2, tempAttribute.getValidRuleRef(), false));
                } else {
                    ((ContainedObjectWithDomain)object2).setUseDomainConstraints(false);
                    this.applyValidationRule((ConstrainedObject)object2, tempAttribute.getValidRuleRef());
                }
            }
            if (!"".equals(tempAttribute.getDefaultRef())) {
                if (this.defaultValues.isEmpty()) {
                    this.defaultValueWaitingList.add(new DefaultValueWaitingListEntry((DesignObject)object2, tempAttribute.getDefaultRef()));
                } else {
                    object = (String)this.defaultValues.get(tempAttribute.getDefaultRef());
                    if (object != null) {
                        ((ContainedObjectWithDomain)object2).setUsesDefaultValue(true);
                        ((ContainedObjectWithDomain)object2).setDefaultValue((String)object);
                    }
                }
            }
            this.setAttributeFontAndColor(entity, tempAttribute.getFontRef(), tempAttribute.getFontColor(), true);
        }
    }

    private void parseKeys(TempEntity tempEntity, Entity entity) {
        for (TempKey tempKey : tempEntity.getKeys()) {
            String string = tempKey.getID();
            String string2 = tempKey.getType();
            if (string2.toUpperCase().startsWith("IF") || tempKey.getKeyMembers().size() <= 0) continue;
            CandidateKey candidateKey = entity.createCandidateKey(this.deriveObjectID(ID_PREFIX_CANDIDATE_KEY, string));
            candidateKey.setName(tempKey.getName());
            this.logicalObjects.put(string, candidateKey);
            if (!"".equals(tempKey.getDefinition())) {
                candidateKey.setComment(tempKey.getDefinition());
            }
            for (TempKeyMember tempKeyMember : tempKey.getKeyMembers()) {
                String string3 = tempKeyMember.getAttributeRef();
                Attribute attribute = (Attribute)this.logicalObjects.get(string3);
                if (attribute == null) continue;
                candidateKey.add(attribute);
            }
            if (!string2.equalsIgnoreCase("PK")) continue;
            candidateKey.makePK();
        }
    }

    private void parseColumns(TempEntity tempEntity, Table table) {
        for (TempAttribute tempAttribute : tempEntity.getAttributes()) {
            Object object;
            Object object2;
            String string = tempAttribute.getID();
            if (!tempAttribute.getSourceOfTransforms().isEmpty()) continue;
            String string2 = tempAttribute.getName();
            if (!"".equals(tempAttribute.getPhysicalName())) {
                string2 = tempAttribute.getPhysicalName();
            }
            if (!"".equals(tempAttribute.getParentAttrRef()) && !"".equals(tempAttribute.getParentRelRef())) {
                object2 = new FKElement(string, tempAttribute.getParentAttrRef(), tempAttribute.getParentRelRef());
                ((FKElement)object2).setLogicalRef(tempAttribute.getLogicalRef());
                ((FKElement)object2).setPhysicalRef(tempAttribute.getPhysicalRef());
                this.relationalFKElements.add(object2);
            }
            if ("true".equalsIgnoreCase(tempAttribute.getHideInPhysical())) continue;
            object2 = table.createColumn(string2, this.deriveObjectID(ID_PREFIX_COLUMN, string));
            this.relationalObjects.put(string, object2);
            if (!"".equals(tempAttribute.getDefinition())) {
                ((ModelIDObject)object2).setComment(tempAttribute.getDefinition());
            }
            if (!"".equals(tempAttribute.getComment())) {
                ((ModelIDObject)object2).setNotes(tempAttribute.getComment());
            }
            if ("0".equals(tempAttribute.getNullOptionType())) {
                ((ContainedObject)object2).setNullsAllowed(true);
            } else {
                ((ContainedObject)object2).setNullsAllowed(false);
            }
            boolean bl = false;
            if (!"".equals(tempAttribute.getPhysicalDataType())) {
                bl = this.parsePhysicalDataType((DesignObject)object2, tempAttribute.getPhysicalDataType());
            }
            if (!bl && !"".equals(tempAttribute.getLogicalDataType())) {
                bl = this.parseDataType((DesignObject)object2, tempAttribute.getLogicalDataType());
            }
            if (!"".equals(tempAttribute.getParentDomRef())) {
                if (this.domains.isEmpty()) {
                    this.domainWaitingList.add(new DomainWaitingListEntry((DesignObject)object2, tempAttribute.getParentDomRef(), bl));
                } else {
                    object = (Domain)this.domains.get(tempAttribute.getParentDomRef());
                    if (!(object == null || ((DesignObject)object).getName().equalsIgnoreCase("<root>") || ((DesignObject)object).getName().equalsIgnoreCase("<default>") || ((DesignObject)object).getName().equalsIgnoreCase("<unknown>") || ((DesignObject)object).getName().equalsIgnoreCase("Unknown") || bl)) {
                        ((Column)object2).setDomain((Domain)object);
                        ((ContainedObjectWithDomain)object2).setUse((short)0);
                        if (!this.usedDomains.contains(((ModelIDObject)object).getObjectID())) {
                            this.usedDomains.add(((ModelIDObject)object).getObjectID());
                        }
                    }
                }
            }
            if (!"".equals(tempAttribute.getValidRuleRef())) {
                if (this.validationRules.isEmpty()) {
                    this.validationRuleWaitingList.add(new ValidationRuleWaitingListEntry((DesignObject)object2, tempAttribute.getValidRuleRef(), false));
                } else {
                    ((ContainedObjectWithDomain)object2).setUseDomainConstraints(false);
                    this.applyValidationRule((ConstrainedObject)object2, tempAttribute.getValidRuleRef());
                }
            }
            if (!"".equals(tempAttribute.getDefaultRef())) {
                if (this.defaultValues.isEmpty()) {
                    this.defaultValueWaitingList.add(new DefaultValueWaitingListEntry((DesignObject)object2, tempAttribute.getDefaultRef()));
                } else {
                    object = (String)this.defaultValues.get(tempAttribute.getDefaultRef());
                    if (object != null) {
                        ((ContainedObjectWithDomain)object2).setUsesDefaultValue(true);
                        ((ContainedObjectWithDomain)object2).setDefaultValue((String)object);
                    }
                }
            }
            this.setAttributeFontAndColor(table, tempAttribute.getFontRef(), tempAttribute.getFontColor(), false);
        }
    }

    private void parseIndexes(TempEntity tempEntity, Table table) {
        for (TempKey tempKey : tempEntity.getKeys()) {
            Object object2;
            String string = tempKey.getID();
            String string2 = tempKey.getType();
            if (string2.toUpperCase().startsWith("IF") || tempKey.getKeyMembers().size() <= 0) continue;
            String string3 = tempKey.getName();
            if (!"".equals(tempKey.getPhysicalName())) {
                string3 = tempKey.getPhysicalName();
            }
            String string4 = this.deriveObjectID(ID_PREFIX_INDEX, string);
            if (string2.equalsIgnoreCase("PK")) {
                string4 = this.deriveObjectID(ID_PREFIX_PK_INDEX, string);
            }
            Index index = table.createIndex(string4);
            index.setName(string3);
            this.relationalObjects.put(string, index);
            if (!"".equals(tempEntity.getSchemaName())) {
                this.schemaWaitingList.add(new SchemaWaitingListEntry(tempEntity.getSchemaName(), index));
            }
            if (!"".equals(tempKey.getDefinition())) {
                index.setComment(tempKey.getDefinition());
            }
            for (Object object2 : tempKey.getKeyMembers()) {
                String string5 = ((TempKeyMember)object2).getAttributeRef();
                Object object3 = (Column)this.relationalObjects.get(string5);
                if (object3 == null) continue;
                index.add((ContainedObject)object3);
                if (!"ASC".equalsIgnoreCase(((TempKeyMember)object2).getSortOrder()) && !"DESC".equalsIgnoreCase(((TempKeyMember)object2).getSortOrder())) continue;
                index.setColumnSortOrder(object3, ((TempKeyMember)object2).getSortOrder().toUpperCase());
            }
            if (string2.equalsIgnoreCase("PK")) {
                index.makePK();
            } else if (string2.toUpperCase().startsWith("AK")) {
                index.setIndexState("Unique Constraint");
            }
            if (this.oracleStorage == null || (object2 = (IndexProxyOracle)this.oracleStorage.getIndexProxySet().getProxy(index.getObjectID())) == null) continue;
            ((RelationalObjectProxy)object2).setName(string3);
            if (!"".equals(tempEntity.getSchemaName())) {
                this.schemaWaitingList.add(new SchemaWaitingListEntry(tempEntity.getSchemaName(), object2));
            }
            for (Object object3 : tempEntity.getPhysicalStorages()) {
                if ("".equals(((TempPhysicalStorage)object3).getTablespaceRef())) continue;
                this.tablespaceWaitingList.add(new TablespaceWaitingListEntry(((TempPhysicalStorage)object3).getTablespaceRef(), object2));
            }
        }
    }

    private void parseEntityViews() {
        for (TempEntity tempEntity : this.logicalViews) {
            String string = tempEntity.getID();
            EntityView entityView = (EntityView)this.logicalObjects.get(string);
            if (entityView == null) continue;
            this.parseViewAttributes(tempEntity, entityView);
        }
    }

    private void parseTableViews() {
        for (TempEntity tempEntity : this.relationalViews) {
            String string = tempEntity.getID();
            TableView tableView = (TableView)this.relationalObjects.get(string);
            if (tableView == null) continue;
            this.parseViewColumns(tempEntity, tableView);
        }
    }

    private void parseViewAttributes(TempEntity tempEntity, EntityView entityView) {
        for (TempAttribute tempAttribute : tempEntity.getAttributes()) {
            Attribute attribute;
            String string = tempAttribute.getID();
            if ("true".equalsIgnoreCase(tempAttribute.getHideInLogical())) continue;
            AttributeView attributeView = (AttributeView)entityView.createContainedObject(this.deriveObjectID(ID_PREFIX_ATTRIBUTE_VIEW, string));
            attributeView.setName(tempAttribute.getName());
            if (!"".equals(tempAttribute.getViewExpression())) {
                attributeView.setExpression(tempAttribute.getViewExpression());
                attributeView.setEntityAlias(entityView.getName());
            } else if (!"".equals(tempAttribute.getParentAttrRef()) && (attribute = (Attribute)this.logicalObjects.get(tempAttribute.getParentAttrRef())) != null) {
                attributeView.setReferencedAttribute(attribute);
                attributeView.setDataType(attribute.getDataType().toString());
                attributeView.setEntity((Entity)attribute.getContainer());
                entityView.addToContainers(attribute.getContainer(), attribute.getContainer().getName());
            }
            this.setAttributeFontAndColor(entityView, tempAttribute.getFontRef(), tempAttribute.getFontColor(), true);
        }
    }

    private void parseViewColumns(TempEntity tempEntity, TableView tableView) {
        for (TempAttribute tempAttribute : tempEntity.getAttributes()) {
            Column column;
            String string = tempAttribute.getID();
            if ("true".equalsIgnoreCase(tempAttribute.getHideInPhysical())) continue;
            ColumnView columnView = (ColumnView)tableView.createContainedObject(this.deriveObjectID(ID_PREFIX_COLUMN_VIEW, string));
            if (!"".equals(tempAttribute.getPhysicalName())) {
                columnView.setName(tempAttribute.getPhysicalName());
            } else {
                columnView.setName(tempAttribute.getName());
            }
            if (!"".equals(tempAttribute.getViewExpression())) {
                columnView.setExpression(tempAttribute.getViewExpression());
                columnView.setTableAlias(tableView.getName());
            } else if (!"".equals(tempAttribute.getParentAttrRef()) && (column = (Column)this.relationalObjects.get(tempAttribute.getParentAttrRef())) != null) {
                columnView.setReferencedColumn(column);
                columnView.setDataType(column.getDataType().toString());
                columnView.setTable((Table)column.getContainer());
                tableView.addToContainers(column.getContainer(), column.getContainer().getName());
            }
            this.setAttributeFontAndColor(tableView, tempAttribute.getFontRef(), tempAttribute.getFontColor(), false);
        }
    }

    private void parseTrigger(TempTrigger tempTrigger, TriggerOracle triggerOracle) {
        if (!"".equals(tempTrigger.getDefinition())) {
            triggerOracle.setComment(tempTrigger.getDefinition());
        }
        if (!"".equals(tempTrigger.getType())) {
            try {
                int n = Integer.parseInt(tempTrigger.getType());
                if ((n & 1) == 1) {
                    triggerOracle.setActions("UPDATE");
                }
                if ((n & 2) == 2) {
                    triggerOracle.setActions("INSERT");
                }
                if ((n & 4) == 4) {
                    triggerOracle.setActions("DELETE");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ("0".equalsIgnoreCase(tempTrigger.getFireType())) {
            triggerOracle.setTriggerTime("AFTER");
        } else if ("1".equalsIgnoreCase(tempTrigger.getFireType())) {
            triggerOracle.setTriggerTime("BEFORE");
        } else if ("4".equalsIgnoreCase(tempTrigger.getFireType())) {
            triggerOracle.setTriggerTime("INSTEADOF");
        }
        if ("1".equalsIgnoreCase(tempTrigger.getScope())) {
            triggerOracle.setScope("FOREACHROW");
        }
        if (!"".equals(tempTrigger.getOldAs())) {
            triggerOracle.setRef_OLD_AS(tempTrigger.getOldAs());
        }
        if (!"".equals(tempTrigger.getNewAs())) {
            triggerOracle.setRef_NEW_AS(tempTrigger.getNewAs());
        }
        if (!"".equals(tempTrigger.getStatus())) {
            if ("0".equalsIgnoreCase(tempTrigger.getStatus())) {
                triggerOracle.setState("ENABLE");
            } else if ("1".equalsIgnoreCase(tempTrigger.getStatus())) {
                triggerOracle.setState("DISABLE");
            }
        }
        if (!"".equals(tempTrigger.getBody())) {
            String string = tempTrigger.getBody().trim();
            if (string.toUpperCase().startsWith("CREATE")) {
                int n = string.toUpperCase().indexOf("DECLARE");
                int n2 = string.toUpperCase().indexOf("BEGIN");
                if (n != -1 && n < n2) {
                    n2 = n;
                }
                if (n2 > 0) {
                    string = string.substring(n2).trim();
                }
            }
            triggerOracle.setBody(string);
        }
        if (!"".equals(tempTrigger.getWhen())) {
            triggerOracle.setCondition(tempTrigger.getWhen());
        }
        for (String string : tempTrigger.getColumnRefs()) {
            Column column = (Column)this.relationalObjects.get(string);
            if (column == null) continue;
            triggerOracle.setColumns(column.getObjectID());
        }
    }

    private void parseTablePartition(TableProxyOracle tableProxyOracle) {
        for (TempPartition tempPartition : this.tempEntity.getPartitions()) {
            Object object4;
            Object object2;
            Object object32;
            PartitionListOracle partitionListOracle = this.oracleStorage.getPartitionListSet().createPartitionList(this.deriveObjectID(ID_PREFIX_PARTITION, tempPartition.getID()));
            partitionListOracle.setName(tempPartition.getName());
            String string = "RANGE";
            if ("1".equalsIgnoreCase(tempPartition.getPartitionType())) {
                string = "RANGE";
            } else if ("2".equalsIgnoreCase(tempPartition.getPartitionType())) {
                string = "LIST";
            } else if ("3".equalsIgnoreCase(tempPartition.getPartitionType())) {
                if ("0".equalsIgnoreCase(tempPartition.getHashType())) {
                    string = "HASH BY LIST OF PARTITIONS";
                } else if ("1".equalsIgnoreCase(tempPartition.getHashType())) {
                    string = "HASH BY QUANTITY";
                    if (tempPartition.getHashQuantity() > 0) {
                        partitionListOracle.setHashPQuantity(tempPartition.getHashQuantity());
                    }
                } else if ("".equalsIgnoreCase(tempPartition.getHashType())) {
                    string = "HASH BY QUANTITY";
                }
            } else if ("4".equalsIgnoreCase(tempPartition.getPartitionType())) {
                if ("0".equalsIgnoreCase(tempPartition.getCompositePartitionType())) {
                    string = "COMPOSITE BY LIST";
                } else if ("1".equalsIgnoreCase(tempPartition.getCompositePartitionType())) {
                    string = "COMPOSITE BY HASH";
                    if (tempPartition.getHashQuantity() > 0) {
                        partitionListOracle.setSubPartitionsQuantity(tempPartition.getHashQuantity());
                    }
                }
            }
            partitionListOracle.setPartitionType(string);
            tableProxyOracle.setPartitionList(partitionListOracle);
            for (Object object32 : tempPartition.getColumnRefs()) {
                object2 = (Column)this.relationalObjects.get(object32);
                if (object2 == null) continue;
                partitionListOracle.setColumnIDs(((ModelIDObject)object2).getObjectID());
            }
            if (!"".equals(tempPartition.getCompositeListColumnRef()) && (object32 = (Column)this.relationalObjects.get(tempPartition.getCompositeListColumnRef())) != null) {
                partitionListOracle.setSubPartitionsColumnIDs(((ModelIDObject)object32).getObjectID());
            }
            object32 = tempPartition.getHashColumnRefs().iterator();
            while (object32.hasNext()) {
                object2 = (String)object32.next();
                object4 = (Column)this.relationalObjects.get(object2);
                if (object4 == null) continue;
                partitionListOracle.setSubPartitionsColumnIDs(((ModelIDObject)object4).getObjectID());
            }
            for (Object object4 : tempPartition.getTablespaceRefs()) {
                this.tablespaceWaitingList.add(new TablespaceWaitingListEntry((String)object4, partitionListOracle));
            }
            object4 = tempPartition.getPartitionInfos().iterator();
            while (object4.hasNext()) {
                Object object52;
                TempPartitionInfo tempPartitionInfo = (TempPartitionInfo)object4.next();
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = tempPartitionInfo.getPartitionValues().iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append((String)iterator.next()).append(",");
                }
                String string2 = stringBuffer.toString();
                String string3 = this.deriveObjectID(ID_PREFIX_PARTITION, tempPartitionInfo.getID());
                AbstractStorageObjectOracle abstractStorageObjectOracle = null;
                if ("LIST".equalsIgnoreCase(partitionListOracle.getPartitionType())) {
                    abstractStorageObjectOracle = this.oracleStorage.getListPartitionSet().createListPartition(string3);
                    abstractStorageObjectOracle.setPartitionList(partitionListOracle);
                    if (!"".equals(string2)) {
                        abstractStorageObjectOracle.setColumns(string2.substring(0, string2.length() - 1));
                    }
                } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionListOracle.getPartitionType()) || "HASH BY QUANTITY".equalsIgnoreCase(partitionListOracle.getPartitionType())) {
                    abstractStorageObjectOracle = this.oracleStorage.getHashPartitionSet().createHashPartition(string3);
                    ((HashPartitionOracle)abstractStorageObjectOracle).setPartitionList(partitionListOracle);
                } else {
                    abstractStorageObjectOracle = this.oracleStorage.getPartitionSet().createPartition(string3);
                    ((PartitionOracle)abstractStorageObjectOracle).setPartitionList(partitionListOracle);
                    if (!"".equals(string2)) {
                        ((PartitionOracle)abstractStorageObjectOracle).setValueList(string2.substring(0, string2.length() - 1));
                    }
                    if (tempPartitionInfo.getPartHashQuantity() > 0) {
                        ((PartitionOracle)abstractStorageObjectOracle).setSubPartitionsQuantity(tempPartitionInfo.getPartHashQuantity());
                    }
                }
                abstractStorageObjectOracle.setName(tempPartitionInfo.getName());
                for (Object object52 : tempPartitionInfo.getTablespaceRefs()) {
                    this.tablespaceWaitingList.add(new TablespaceWaitingListEntry((String)object52, abstractStorageObjectOracle));
                }
                object52 = tempPartitionInfo.getSubPartitionInfos().iterator();
                while (object52.hasNext()) {
                    String string42;
                    TempSubPartitionInfo tempSubPartitionInfo = (TempSubPartitionInfo)object52.next();
                    String string5 = "";
                    for (String string42 : tempSubPartitionInfo.getSubPartitionValues()) {
                        string5 = string5 + string42 + ",";
                    }
                    string42 = this.deriveObjectID(ID_PREFIX_PARTITION, tempSubPartitionInfo.getID());
                    AbstractStorageObjectOracle abstractStorageObjectOracle2 = null;
                    if ("LIST".equalsIgnoreCase(partitionListOracle.getPartitionType()) || "COMPOSITE BY LIST".equalsIgnoreCase(partitionListOracle.getPartitionType())) {
                        abstractStorageObjectOracle2 = this.oracleStorage.getListStorageTemplatePartitionSet().createListStorageTemplatePartition(string42);
                        ((ListStorageTemplatePartitionOracle)abstractStorageObjectOracle2).setSubPartitionOf(abstractStorageObjectOracle);
                        if (!"".equals(string5)) {
                            ((ListStorageTemplatePartitionOracle)abstractStorageObjectOracle2).setValueList(string5.substring(0, string5.length() - 1));
                        }
                    } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionListOracle.getPartitionType()) || "HASH BY QUANTITY".equalsIgnoreCase(partitionListOracle.getPartitionType()) || "COMPOSITE BY HASH".equalsIgnoreCase(partitionListOracle.getPartitionType())) {
                        abstractStorageObjectOracle2 = this.oracleStorage.getHashPartitionSet().createHashPartition(string3);
                        ((HashPartitionOracle)abstractStorageObjectOracle2).setSubPartitionOf(abstractStorageObjectOracle);
                    } else if ("RANGE".equalsIgnoreCase(partitionListOracle.getPartitionType()) && abstractStorageObjectOracle instanceof PartitionOraclev11g) {
                        abstractStorageObjectOracle2 = this.oracleStorage.getPartitionSet().createPartition(string42);
                        ((PartitionOraclev11g)abstractStorageObjectOracle2).setSubPartitionOf(abstractStorageObjectOracle);
                        if (!"".equals(string5)) {
                            ((PartitionOraclev11g)abstractStorageObjectOracle2).setValueList(string5.substring(0, string5.length() - 1));
                        }
                    }
                    if (abstractStorageObjectOracle2 == null) continue;
                    abstractStorageObjectOracle2.setName(tempSubPartitionInfo.getName());
                    if ("".equals(tempSubPartitionInfo.getSubTablespaceRef())) continue;
                    this.tablespaceWaitingList.add(new TablespaceWaitingListEntry(tempSubPartitionInfo.getSubTablespaceRef(), abstractStorageObjectOracle2));
                }
            }
        }
    }

    private void setScratchFontAndColor(DesignObject designObject) {
        this.setFontAndColor(designObject, "", "", "", "");
    }

    private void setFontAndColor(DesignObject designObject, String string, String string2, String string3, String string4) {
        Object object;
        int n = -1;
        try {
            if (!"".equals(string)) {
                n = Integer.parseInt(string);
            } else if (!"".equals(this.defaultFillColor)) {
                n = Integer.parseInt(this.defaultFillColor);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n >= 0) {
            Color color = new Color(n);
            designObject.setUseDefaultColor(false);
            designObject.setBackgroundColor(color);
        }
        int n2 = -1;
        try {
            if (!"".equals(string2)) {
                n2 = Integer.parseInt(string2);
            } else if (!"".equals(this.defaultOutlineColor)) {
                n2 = Integer.parseInt(this.defaultOutlineColor);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n2 >= 0) {
            Color color = new Color(n2);
            designObject.setUseDefaultColor(false);
            designObject.setForegroundColor(color);
        }
        int n3 = -1;
        try {
            if (!"".equals(string4)) {
                n3 = Integer.parseInt(string4);
            } else if (!"".equals(this.defaultNameColor)) {
                n3 = Integer.parseInt(this.defaultNameColor);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n3 >= 0) {
            object = new Color(n3);
            designObject.setUseDefaultColor(false);
            designObject.setForegroundColor((Color)object);
        }
        if (!this.isUTFString(designObject.getName())) {
            if (this.fonts.isEmpty()) {
                this.fontWaitingList.add(new FontWaitingListEntry(designObject, string3, EditableFonts.FO_TITLE, false));
            } else {
                object = null;
                if (!"".equals(string3)) {
                    object = (Font)this.fonts.get(string3);
                } else if (!"".equals(this.defaultNameFontID)) {
                    object = (Font)this.fonts.get(this.defaultNameFontID);
                }
                if (object != null && designObject instanceof EditableFonts) {
                    FontObject fontObject = ((EditableFonts)((Object)designObject)).getFontObject(EditableFonts.FO_TITLE);
                    fontObject.setFont((Font)object);
                }
            }
        } else if (designObject instanceof EditableFonts) {
            object = ((EditableFonts)((Object)designObject)).getFontObject(EditableFonts.FO_TITLE);
            ((FontObject)object).setFont(new Font("Dialog", ((FontObject)object).getFont().getStyle(), ((FontObject)object).getFont().getSize()));
        }
    }

    private void setScratchAttributeFontAndColor(DesignObject designObject, boolean bl) {
        this.setAttributeFontAndColor(designObject, "", "", bl);
    }

    private void setAttributeFontAndColor(DesignObject designObject, String string, String string2, boolean bl) {
        FontObject fontObject;
        Object object;
        String string3 = bl ? EditableFonts.FO_ATTRIBUTE : EditableFonts.FO_COLUMN;
        int n = -1;
        try {
            if (string2 != null) {
                n = Integer.parseInt(string2);
            } else if (!"".equals(this.defaultAttributeColor)) {
                n = Integer.parseInt(this.defaultAttributeColor);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n >= 0 && designObject instanceof EditableFonts) {
            object = new Color(n);
            fontObject = ((EditableFonts)((Object)designObject)).getFontObject(string3);
            fontObject.setColor((Color)object);
        }
        if (!this.isUTFString(designObject.getName())) {
            if (this.fonts.isEmpty()) {
                this.fontWaitingList.add(new FontWaitingListEntry(designObject, string, string3, true));
            } else {
                object = null;
                if (string != null) {
                    object = (Font)this.fonts.get(string);
                } else if (!"".equals(this.defaultAttributeFontID)) {
                    object = (Font)this.fonts.get(this.defaultAttributeFontID);
                }
                if (object != null && designObject instanceof EditableFonts) {
                    fontObject = ((EditableFonts)((Object)designObject)).getFontObject(string3);
                    fontObject.setFont((Font)object);
                }
            }
        } else if (designObject instanceof EditableFonts) {
            object = ((EditableFonts)((Object)designObject)).getFontObject(EditableFonts.FO_TITLE);
            ((FontObject)object).setFont(new Font("Dialog", ((FontObject)object).getFont().getStyle(), ((FontObject)object).getFont().getSize()));
        }
    }

    private void startDomains(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("Domain_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportDomains"), PROGRESS_INCREMENT);
            this.domains = new TreeMap();
            this.childDomains = new TreeMap();
            this.usedDomains = new ArrayList();
        } else if (string3.equalsIgnoreCase("Domain")) {
            this.tempDomainID = attributes.getValue("id");
            this.tempDomain = new TempDomain(this.tempDomainID, attributes.getValue("name"));
        }
    }

    private void endDomains(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Domain_Groups")) {
            this.parseChildDomains();
        } else if (string3.equalsIgnoreCase("Domain")) {
            this.parseDomain();
        } else if (string3.equalsIgnoreCase("Logical_Data_Type")) {
            this.tempDomain.setLogicalDatatype(this.getText());
        } else if (string3.equalsIgnoreCase("Physical_Data_Type")) {
            this.tempDomain.setPhysicalDatatype(this.getText());
        } else if (string3.equalsIgnoreCase("Parent_Domain_Ref")) {
            this.tempDomain.setParentDomainRef(this.getText());
        } else if (string3.equalsIgnoreCase("Validation_Rule_Ref")) {
            this.tempDomain.setValidationRuleRef(this.getText());
        }
    }

    private void parseDomain() {
        Domain domain = null;
        String string = this.tempDomain.getName();
        if (string.equalsIgnoreCase("<unknown>")) {
            domain = this.design.getDomainSet().getDefaultDomain();
        }
        if (domain == null) {
            domain = (Domain)this.design.getDomainSet().getByName(string);
        }
        if (domain == null) {
            domain = this.design.getDomainSet().createDomain(this.deriveObjectID(ID_PREFIX_DOMAIN, this.tempDomainID));
            domain.setName(string);
            domain.setFileName("ERwin_domains");
        }
        boolean bl = false;
        if (!"".equals(this.tempDomain.getLogicalDatatype())) {
            bl = this.parseDataType(domain, this.tempDomain.getLogicalDatatype());
        }
        if (!"".equals(this.tempDomain.getPhysicalDatatype())) {
            bl = this.parsePhysicalDataType(domain, this.tempDomain.getPhysicalDatatype());
        }
        if (!bl && !"".equals(this.tempDomain.getParentDomainRef())) {
            this.childDomains.put(this.tempDomainID, this.tempDomain.getParentDomainRef());
        }
        if (!"".equals(this.tempDomain.getValidationRuleRef())) {
            this.applyValidationRule(domain, this.tempDomain.getValidationRuleRef());
        }
        this.domains.put(this.tempDomainID, domain);
    }

    private void parseChildDomains() {
        Object[] objectArray = this.childDomains.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Domain domain;
            Object object = objectArray[i];
            Object v = this.childDomains.get(object);
            while (this.childDomains.get(v) != null) {
                v = this.childDomains.get(v);
            }
            Domain domain2 = (Domain)this.domains.get(object);
            if (domain2 == null || (domain = (Domain)this.domains.get(v)) == null) continue;
            domain2.setLogicalDatatype(domain.getLogicalDatatype());
            domain2.setDataTypeParameter("size", domain.getDataTypeParameter("size"));
            domain2.setDataTypeParameter("precision", domain.getDataTypeParameter("precision"));
            domain2.setDataTypeParameter("scale", domain.getDataTypeParameter("scale"));
        }
    }

    private boolean parseDataType(DesignObject designObject, String string) {
        String string2;
        if (!(designObject instanceof Domain || designObject instanceof Attribute || designObject instanceof Column)) {
            return false;
        }
        String string3 = string.trim();
        String string4 = "0";
        String string5 = "0";
        String string6 = "0";
        int n = string.indexOf(40);
        if (n > -1) {
            string3 = string.substring(0, n).trim();
            string2 = string.substring(n + 1, string.trim().length() - 1).trim();
            int n2 = string2.indexOf(44);
            if (n2 > -1) {
                string5 = string2.substring(0, n2).trim();
                string6 = string2.substring(n2 + 1).trim();
            } else {
                string4 = string2;
            }
        }
        string2 = StandardDatatypeNames.getUsedDatatypeName(string3);
        String string7 = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(string2);
        LogicalDatatype logicalDatatype = this.design.getLogicalDatatypeSet().getLogTypeByName(string7);
        if (logicalDatatype != null) {
            String[] stringArray = logicalDatatype.getRequiredParameters();
            if (designObject instanceof Domain) {
                Domain domain = (Domain)designObject;
                domain.setLogicalDatatype(logicalDatatype);
                for (int i = 0; i < stringArray.length; ++i) {
                    if ("size".equalsIgnoreCase(stringArray[i])) {
                        if ("0".equalsIgnoreCase(string4)) continue;
                        domain.setDataTypeParameter("size", string4);
                        continue;
                    }
                    if ("precision".equalsIgnoreCase(stringArray[i])) {
                        if (!"0".equalsIgnoreCase(string4)) {
                            domain.setDataTypeParameter("precision", string4);
                            continue;
                        }
                        domain.setDataTypeParameter("precision", string5);
                        continue;
                    }
                    if (!"scale".equalsIgnoreCase(stringArray[i])) continue;
                    domain.setDataTypeParameter("scale", string6);
                }
            } else if (designObject instanceof Attribute) {
                Attribute attribute = (Attribute)designObject;
                attribute.setUse((short)1);
                attribute.setLogicalDatatype(logicalDatatype);
                for (int i = 0; i < stringArray.length; ++i) {
                    if ("size".equalsIgnoreCase(stringArray[i])) {
                        if ("0".equalsIgnoreCase(string4)) continue;
                        attribute.setDataTypeParameter("size", string4);
                        continue;
                    }
                    if ("precision".equalsIgnoreCase(stringArray[i])) {
                        if (!"0".equalsIgnoreCase(string4)) {
                            attribute.setDataTypeParameter("precision", string4);
                            continue;
                        }
                        attribute.setDataTypeParameter("precision", string5);
                        continue;
                    }
                    if (!"scale".equalsIgnoreCase(stringArray[i])) continue;
                    attribute.setDataTypeParameter("scale", string6);
                }
            } else if (designObject instanceof Column) {
                Column column = (Column)designObject;
                column.setUse((short)1);
                column.setLogicalDatatype(logicalDatatype);
                for (int i = 0; i < stringArray.length; ++i) {
                    if ("size".equalsIgnoreCase(stringArray[i])) {
                        if ("0".equalsIgnoreCase(string4)) continue;
                        column.setDataTypeParameter("size", string4);
                        continue;
                    }
                    if ("precision".equalsIgnoreCase(stringArray[i])) {
                        if (!"0".equalsIgnoreCase(string4)) {
                            column.setDataTypeParameter("precision", string4);
                            continue;
                        }
                        column.setDataTypeParameter("precision", string5);
                        continue;
                    }
                    if (!"scale".equalsIgnoreCase(stringArray[i])) continue;
                    column.setDataTypeParameter("scale", string6);
                }
            }
            return true;
        }
        LOGGER.warn("Unable to find Logical DataType for: " + string2);
        return false;
    }

    private boolean parsePhysicalDataType(DesignObject designObject, String string) {
        String string2;
        if (!(designObject instanceof Domain) && !(designObject instanceof Column)) {
            return false;
        }
        String string3 = string.trim();
        String string4 = "0";
        String string5 = "0";
        String string6 = "0";
        int n = string.indexOf(40);
        if (n > -1) {
            string3 = string.substring(0, n).trim();
            string2 = string.substring(n + 1, string.trim().length() - 1).trim();
            int n2 = string2.indexOf(44);
            if (n2 > -1) {
                string5 = string2.substring(0, n2).trim();
                string6 = string2.substring(n2 + 1).trim();
            } else {
                string4 = string2;
            }
        }
        string2 = StandardDatatypeNames.getUsedDatatypeName(string3);
        String string7 = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(string2);
        LogicalDatatype logicalDatatype = this.design.getLogicalDatatypeSet().getLogTypeByName(string7);
        if (logicalDatatype == null && (string7 = MappingDatatypeNameLogicalDataType.getERWinMappedName(string3)) != null) {
            logicalDatatype = this.design.getLogicalDatatypeSet().getLogTypeByName(string7);
        }
        if (logicalDatatype != null) {
            String[] stringArray = logicalDatatype.getRequiredParameters();
            if (designObject instanceof Domain) {
                Domain domain = (Domain)designObject;
                domain.setLogicalDatatype(logicalDatatype);
                for (int i = 0; i < stringArray.length; ++i) {
                    if ("size".equalsIgnoreCase(stringArray[i])) {
                        if ("0".equalsIgnoreCase(string4)) continue;
                        domain.setDataTypeParameter("size", string4);
                        continue;
                    }
                    if ("precision".equalsIgnoreCase(stringArray[i])) {
                        if (!"0".equalsIgnoreCase(string4)) {
                            domain.setDataTypeParameter("precision", string4);
                            continue;
                        }
                        domain.setDataTypeParameter("precision", string5);
                        continue;
                    }
                    if (!"scale".equalsIgnoreCase(stringArray[i])) continue;
                    domain.setDataTypeParameter("scale", string6);
                }
            } else if (designObject instanceof Column) {
                Column column = (Column)designObject;
                column.setUse((short)1);
                column.setLogicalDatatype(logicalDatatype);
                for (int i = 0; i < stringArray.length; ++i) {
                    if ("size".equalsIgnoreCase(stringArray[i])) {
                        if ("0".equalsIgnoreCase(string4)) continue;
                        column.setDataTypeParameter("size", string4);
                        continue;
                    }
                    if ("precision".equalsIgnoreCase(stringArray[i])) {
                        if (!"0".equalsIgnoreCase(string4)) {
                            column.setDataTypeParameter("precision", string4);
                            continue;
                        }
                        column.setDataTypeParameter("precision", string5);
                        continue;
                    }
                    if (!"scale".equalsIgnoreCase(stringArray[i])) continue;
                    column.setDataTypeParameter("scale", string6);
                }
            }
            return true;
        }
        LOGGER.warn("Unable to parse Physical DataType: " + string);
        return false;
    }

    private void startOracleTablespaces(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("Oracle_Tablespace_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportOracleTablespaces"), PROGRESS_INCREMENT);
            this.tablespaces = new TreeMap();
        } else if (string3.equalsIgnoreCase("Oracle_Tablespace")) {
            this.tempOracleTablespaceID = attributes.getValue("id");
            this.tempOracleTablespace = new TempOracleTablespace(this.tempOracleTablespaceID, attributes.getValue("name"));
        }
    }

    private void endOracleTablespaces(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Oracle_Tablespace")) {
            if (this.oracleStorage != null) {
                this.parseOracleTablespace();
            }
        } else if (this.stack.search("Oracle_TablespaceProps") != -1) {
            if (string3.equalsIgnoreCase("Definition")) {
                this.tempOracleTablespace.setDefinition(this.getText());
            } else if (string3.equalsIgnoreCase("Can_Flashback")) {
                this.tempOracleTablespace.setCanFlashback(this.getText());
            } else if (string3.equalsIgnoreCase("Compress_Type")) {
                this.tempOracleTablespace.setCompressType(this.getText());
            } else if (string3.equalsIgnoreCase("Data_Block_Size")) {
                this.tempOracleTablespace.setDataBlockSize(this.getText());
            } else if (string3.equalsIgnoreCase("Extent_Management_Type")) {
                this.tempOracleTablespace.setExtentManagementType(this.getText());
            } else if (string3.equalsIgnoreCase("Extent_Size")) {
                this.tempOracleTablespace.setExtentSize(this.getText());
            } else if (string3.equalsIgnoreCase("Force_Logging")) {
                this.tempOracleTablespace.setForceLogging(this.getText());
            } else if (string3.equalsIgnoreCase("Is_Read_Only")) {
                this.tempOracleTablespace.setIsReadOnly(this.getText());
            } else if (string3.equalsIgnoreCase("Local_Extent_Management_Type")) {
                this.tempOracleTablespace.setLocalExtentManagementType(this.getText());
            } else if (string3.equalsIgnoreCase("Minimum_Extent")) {
                this.tempOracleTablespace.setMinimumExtent(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Initial_Extent_Size")) {
                this.tempOracleTablespace.setInitialExtentSize(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Is_Offline")) {
                this.tempOracleTablespace.setIsOffline(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Max_Extent_Type")) {
                this.tempOracleTablespace.setMaxExtentType(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Max_Extents")) {
                this.tempOracleTablespace.setMaxExtents(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Min_Extents")) {
                this.tempOracleTablespace.setMinExtents(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Next_Extent_Size")) {
                this.tempOracleTablespace.setNextExtentSize(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_No_Logging")) {
                this.tempOracleTablespace.setNoLogging(this.getText());
            } else if (string3.equalsIgnoreCase("Oracle_Percent_Increase")) {
                this.tempOracleTablespace.setPercentIncrease(this.getText());
            } else if (string3.equalsIgnoreCase("Retention_Guarantee")) {
                this.tempOracleTablespace.setRetentionGuarantee(this.getText());
            } else if (string3.equalsIgnoreCase("Segment_Management_Type")) {
                this.tempOracleTablespace.setSegmentManagementType(this.getText());
            } else if (string3.equalsIgnoreCase("Storage_File_Type")) {
                this.tempOracleTablespace.setStorageFileType(this.getText());
            } else if (string3.equalsIgnoreCase("Tablespace_System_Type")) {
                this.tempOracleTablespace.setSystemType(this.getText());
            } else if (string3.equalsIgnoreCase("Tablespace_Type")) {
                this.tempOracleTablespace.setType(this.getText());
            }
        }
    }

    private void parseOracleTablespace() {
        TableSpaceOracle tableSpaceOracle = this.oracleStorage.getTableSpaceSet().createTableSpace(this.deriveObjectID(ID_PREFIX_TABLESPACE, this.tempOracleTablespaceID));
        if (tableSpaceOracle != null) {
            tableSpaceOracle.setName(this.tempOracleTablespace.getName());
            if (!"".equals(this.tempOracleTablespace.getDefinition())) {
                tableSpaceOracle.setComment(this.tempOracleTablespace.getDefinition());
            }
            if ("2".equalsIgnoreCase(this.tempOracleTablespace.getType())) {
                tableSpaceOracle.setContents("PERMANENT");
            } else if ("1".equalsIgnoreCase(this.tempOracleTablespace.getType())) {
                tableSpaceOracle.setContents("TEMPORARY");
            } else if ("0".equalsIgnoreCase(this.tempOracleTablespace.getType())) {
                tableSpaceOracle.setContents("UNDO");
            }
            if (this.tempOracleTablespace.isOffline()) {
                tableSpaceOracle.setStatus("OFFLINE");
            } else {
                tableSpaceOracle.setStatus("ONLINE");
            }
            if (this.tempOracleTablespace.noLogging()) {
                tableSpaceOracle.setLogging("NOLOGGING");
            } else {
                tableSpaceOracle.setLogging("LOGGING");
            }
            if ("920".equalsIgnoreCase(this.tempOracleTablespace.getLocalExtentManagementType())) {
                tableSpaceOracle.setEMLocalSubtype("AUTOALLOCATE");
            } else if ("921".equalsIgnoreCase(this.tempOracleTablespace.getLocalExtentManagementType())) {
                tableSpaceOracle.setEMLocalSubtype("UNIFORM");
                tableSpaceOracle.setEMUniformSize(this.tempOracleTablespace.getExtentSize());
            } else if ("903".equalsIgnoreCase(this.tempOracleTablespace.getLocalExtentManagementType())) {
                tableSpaceOracle.setEMLocalSubtype("DEFAULT");
            }
            if ("922".equalsIgnoreCase(this.tempOracleTablespace.getExtentManagementType())) {
                tableSpaceOracle.setExtentManagement("DICTIONARY");
            } else if ("923".equalsIgnoreCase(this.tempOracleTablespace.getExtentManagementType())) {
                tableSpaceOracle.setExtentManagement("LOCAL");
            }
            tableSpaceOracle.setMinExtLen(this.tempOracleTablespace.getMinimumExtent());
            tableSpaceOracle.setDSInitialExtent(this.tempOracleTablespace.getInitialExtentSize());
            tableSpaceOracle.setDSNextExtent(this.tempOracleTablespace.getNextExtentSize());
            tableSpaceOracle.setDSMinExtents(this.tempOracleTablespace.getMinExtents());
            tableSpaceOracle.setDSPctIncrease(this.tempOracleTablespace.getPercentIncrease());
            if ("0".equalsIgnoreCase(this.tempOracleTablespace.getMaxExtentType())) {
                tableSpaceOracle.setDSMaxExtents("0");
            } else if ("1".equalsIgnoreCase(this.tempOracleTablespace.getMaxExtentType())) {
                tableSpaceOracle.setDSMaxExtents(String.valueOf(this.tempOracleTablespace.getMaxExtents()));
            }
            if (tableSpaceOracle instanceof TableSpaceOraclev10g) {
                ((TableSpaceOraclev10g)tableSpaceOracle).setBlockSize(this.tempOracleTablespace.getDataBlockSize());
                if (this.tempOracleTablespace.forceLogging()) {
                    ((TableSpaceOraclev10g)tableSpaceOracle).setForceLogging("YES");
                } else {
                    ((TableSpaceOraclev10g)tableSpaceOracle).setForceLogging("NO");
                }
                if ("926".equalsIgnoreCase(this.tempOracleTablespace.getSegmentManagementType())) {
                    ((TableSpaceOraclev10g)tableSpaceOracle).setSegmentManagement("AUTO");
                } else if ("927".equalsIgnoreCase(this.tempOracleTablespace.getSegmentManagementType())) {
                    ((TableSpaceOraclev10g)tableSpaceOracle).setSegmentManagement("MANUAL");
                }
                if ("0".equalsIgnoreCase(this.tempOracleTablespace.getStorageFileType())) {
                    ((TableSpaceOraclev10g)tableSpaceOracle).setFileType("BIGFILE");
                } else if ("1".equalsIgnoreCase(this.tempOracleTablespace.getStorageFileType())) {
                    ((TableSpaceOraclev10g)tableSpaceOracle).setFileType("SMALLFILE");
                }
                if (this.tempOracleTablespace.canFlashback()) {
                    ((TableSpaceOraclev10g)tableSpaceOracle).setFlashBack("ON");
                } else {
                    ((TableSpaceOraclev10g)tableSpaceOracle).setFlashBack("OFF");
                }
            } else if (tableSpaceOracle instanceof TableSpaceOraclev9i) {
                ((TableSpaceOraclev9i)tableSpaceOracle).setBlockSize(this.tempOracleTablespace.getDataBlockSize());
                if (this.tempOracleTablespace.forceLogging()) {
                    ((TableSpaceOraclev9i)tableSpaceOracle).setForceLogging("YES");
                } else {
                    ((TableSpaceOraclev9i)tableSpaceOracle).setForceLogging("NO");
                }
                if ("926".equalsIgnoreCase(this.tempOracleTablespace.getSegmentManagementType())) {
                    ((TableSpaceOraclev9i)tableSpaceOracle).setSegmentManagement("AUTO");
                } else if ("927".equalsIgnoreCase(this.tempOracleTablespace.getSegmentManagementType())) {
                    ((TableSpaceOraclev9i)tableSpaceOracle).setSegmentManagement("MANUAL");
                }
            }
            this.tablespaces.put(this.tempOracleTablespaceID, tableSpaceOracle);
        }
    }

    private int calculateSize(String string) {
        int n = 0;
        try {
            int n2 = string.length();
            if (n2 > 1) {
                String string2 = string.substring(n2 - 1);
                int n3 = Integer.valueOf(string.substring(0, n2 - 1));
                n = "K".equalsIgnoreCase(string2) ? n3 * 1024 : ("M".equalsIgnoreCase(string2) ? n3 * 1024 * 1024 : ("G".equalsIgnoreCase(string2) ? n3 * 1024 * 1024 * 1024 : ("T".equalsIgnoreCase(string2) ? n3 * 1024 * 1024 * 1024 * 1024 : Integer.valueOf(string))));
            } else {
                n = Integer.valueOf(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private void startSubjectAreas(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("Subject_Area_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportSubjectAreas"), PROGRESS_INCREMENT);
            this.subjectAreas = new ArrayList();
            this.isMainLogical = true;
            this.isMainRelational = true;
        } else if (string3.equalsIgnoreCase("Subject_Area")) {
            this.tempSubjectAreaID = attributes.getValue("id");
            this.tempSubjectArea = new TempSubjectArea(this.tempSubjectAreaID, attributes.getValue("name"));
        } else if (string3.equalsIgnoreCase("Stored_Display")) {
            this.tempStoredDisplayID = attributes.getValue("id");
            this.tempStoredDisplay = new TempStoredDisplay(this.tempStoredDisplayID, attributes.getValue("name"));
        } else if (string3.equalsIgnoreCase("Drawing_Object_Entity")) {
            this.tempDrawingObjectID = attributes.getValue("id");
            this.tempDrawingObject = new TempDrawingObject(this.tempDrawingObjectID, attributes.getValue("name"));
            this.tempDrawingObject.setType("Entity");
        } else if (string3.equalsIgnoreCase("Drawing_Object_Relationship")) {
            this.tempDrawingObjectID = attributes.getValue("id");
            this.tempDrawingObject = new TempDrawingObject(this.tempDrawingObjectID, attributes.getValue("name"));
            this.tempDrawingObject.setType("Relationship");
        } else if (string3.equalsIgnoreCase("Drawing_Object_View")) {
            this.tempDrawingObjectID = attributes.getValue("id");
            this.tempDrawingObject = new TempDrawingObject(this.tempDrawingObjectID, attributes.getValue("name"));
            this.tempDrawingObject.setType("View");
        } else if (string3.equalsIgnoreCase("Drawing_Object_Rectangle")) {
            this.tempDrawingObjectID = attributes.getValue("id");
            this.tempDrawingObject = new TempDrawingObject(this.tempDrawingObjectID, attributes.getValue("name"));
            this.tempDrawingObject.setType("Rectangle");
        } else if (string3.equalsIgnoreCase("Drawing_Object_Ellipse")) {
            this.tempDrawingObjectID = attributes.getValue("id");
            this.tempDrawingObject = new TempDrawingObject(this.tempDrawingObjectID, attributes.getValue("name"));
            this.tempDrawingObject.setType("Ellipse");
        } else if (string3.equalsIgnoreCase("Transform_Scratch_Object")) {
            this.tempDrawingObjectID = attributes.getValue("id");
            this.tempDrawingObject = new TempDrawingObject(this.tempDrawingObjectID, attributes.getValue("name"));
            this.tempDrawingObject.setType("Scratch");
        }
    }

    private void endSubjectAreas(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Subject_Area")) {
            this.subjectAreas.add(this.tempSubjectArea);
        } else if (string3.equalsIgnoreCase("Is_Main_Subject_Area")) {
            this.tempSubjectArea.setIsMain(this.getText());
        } else if (string3.equalsIgnoreCase("Stored_Display")) {
            this.tempSubjectArea.addStoredDisplay(this.tempStoredDisplay);
        } else if (string3.equalsIgnoreCase("Drawing_Object_Entity")) {
            this.tempStoredDisplay.addDrawingObject(this.tempDrawingObject);
        } else if (string3.equalsIgnoreCase("Drawing_Object_Relationship")) {
            this.tempStoredDisplay.addDrawingObject(this.tempDrawingObject);
        } else if (string3.equalsIgnoreCase("Drawing_Object_View")) {
            this.tempStoredDisplay.addDrawingObject(this.tempDrawingObject);
        } else if (string3.equalsIgnoreCase("Drawing_Object_Rectangle")) {
            this.tempStoredDisplay.addDrawingObject(this.tempDrawingObject);
        } else if (string3.equalsIgnoreCase("Drawing_Object_Ellipse")) {
            this.tempStoredDisplay.addDrawingObject(this.tempDrawingObject);
        } else if (string3.equalsIgnoreCase("Transform_Scratch_Object")) {
            this.tempStoredDisplay.addDrawingObject(this.tempDrawingObject);
        } else if (this.stack.search("Drawing_Object_EntityProps") != -1 || this.stack.search("Drawing_Object_RelationshipProps") != -1 || this.stack.search("Drawing_Object_ViewProps") != -1 || this.stack.search("Drawing_Object_RectangleProps") != -1 || this.stack.search("Drawing_Object_EllipseProps") != -1 || this.stack.search("Transform_Scratch_ObjectProps") != -1) {
            if (string3.equalsIgnoreCase("Model_Object_Ref") || string3.equalsIgnoreCase("Scratch_Model_Object_Ref")) {
                this.tempDrawingObject.setModelObjectRef(this.getText());
            } else if (string3.equalsIgnoreCase("Location_Rectangle")) {
                this.tempDrawingObject.setLocationRectangle(this.getText());
            } else if (string3.equalsIgnoreCase("Anchor_Point")) {
                this.tempDrawingObject.setAnchorPoint(this.getText());
            } else if (string3.equalsIgnoreCase("Fixed_Size_Point")) {
                this.tempDrawingObject.setFixedSizePoint(this.getText());
            } else if (string3.equalsIgnoreCase("Text")) {
                this.tempDrawingObject.setText(this.getText());
            } else if (string3.equalsIgnoreCase("Font_Ref")) {
                this.tempDrawingObject.setFontRef(this.getText());
            } else if (string3.equalsIgnoreCase("Font_Color")) {
                this.tempDrawingObject.setFontColor(this.getText());
            } else if (string3.equalsIgnoreCase("Fill_Color")) {
                this.tempDrawingObject.setFillColor(this.getText());
            } else if (string3.equalsIgnoreCase("Outline_Color")) {
                this.tempDrawingObject.setOutlineColor(this.getText());
            } else if (string3.equalsIgnoreCase("Outline_Style")) {
                this.tempDrawingObject.setOutlineStyle(this.getText());
            } else if (string3.equalsIgnoreCase("Relationship_Coordinates")) {
                this.tempDrawingObject.addPathCoordinate(this.getText());
            }
        }
    }

    private void parseSubjectArea(TempSubjectArea tempSubjectArea) {
        Object object;
        Object object22;
        Object object3 = null;
        Object object4 = null;
        for (Object object22 : tempSubjectArea.getTempStoredDisplays()) {
            DesignPartView designPartView;
            if (tempSubjectArea.isMain()) {
                if (this.createLogical) {
                    if (this.isMainLogical) {
                        this.parseDisplay((TempStoredDisplay)object22, this.logical.getMainView(), false);
                        object3 = this.logical.getMainView();
                        this.isMainLogical = false;
                    } else {
                        object = this.logical.getMainView().addSubordinateView();
                        this.logical.getMainView().copyToDPV((DesignPartView)object, false);
                        ((DesignPartView)object).setName(((TempStoredDisplay)object22).getName());
                        this.parseDisplay((TempStoredDisplay)object22, (DesignPartView)object, false);
                    }
                }
                if (!this.createRelational) continue;
                if (this.isMainRelational) {
                    this.parseDisplay((TempStoredDisplay)object22, this.relational.getMainView(), false);
                    object4 = this.relational.getMainView();
                    this.isMainRelational = false;
                    continue;
                }
                object = this.relational.getMainView().addSubordinateView();
                this.relational.getMainView().copyToDPV((DesignPartView)object, false);
                ((DesignPartView)object).setName(((TempStoredDisplay)object22).getName());
                this.parseDisplay((TempStoredDisplay)object22, (DesignPartView)object, false);
                continue;
            }
            if (this.createLogical) {
                object = this.logical.getSubViewByName(tempSubjectArea.getName());
                if (object == null) {
                    object = this.logical.createDesignPartSubView();
                    ((DesignPartView)object).setName(tempSubjectArea.getName());
                    this.parseDisplay((TempStoredDisplay)object22, (DesignPartView)object, true);
                    object3 = object;
                } else {
                    designPartView = ((DesignPartView)object).addSubordinateView();
                    ((DesignPartView)object).copyToDPV(designPartView, false);
                    designPartView.setName(((TempStoredDisplay)object22).getName());
                    this.parseDisplay((TempStoredDisplay)object22, designPartView, false);
                }
            }
            if (!this.createRelational) continue;
            object = this.relational.getSubViewByName(tempSubjectArea.getName());
            if (object == null) {
                object = this.relational.createDesignPartSubView();
                ((DesignPartView)object).setName(tempSubjectArea.getName());
                this.parseDisplay((TempStoredDisplay)object22, (DesignPartView)object, true);
                object4 = object;
                continue;
            }
            designPartView = ((DesignPartView)object).addSubordinateView();
            ((DesignPartView)object).copyToDPV(designPartView, false);
            designPartView.setName(((TempStoredDisplay)object22).getName());
            this.parseDisplay((TempStoredDisplay)object22, designPartView, false);
        }
        if (object3 != null) {
            object22 = ((DesignPartView)object3).getDPVId();
            object = ((DesignPartView)object3).getTabbedPane().getComponents();
            for (int i = 0; i < ((Component[])object).length; ++i) {
                if (!(object[i] instanceof DesignPartView) || !((String)object22).equals(((DesignPartView)object[i]).getDPVId())) continue;
                ((DesignPartView)object3).getTabbedPane().setSelectedComponent((Component)object[i]);
                break;
            }
        }
        if (object4 != null) {
            object22 = ((DesignPartView)object4).getDPVId();
            object = ((DesignPartView)object4).getTabbedPane().getComponents();
            for (int i = 0; i < ((Component[])object).length; ++i) {
                if (!(object[i] instanceof DesignPartView) || !((String)object22).equals(((DesignPartView)object[i]).getDPVId())) continue;
                ((DesignPartView)object4).getTabbedPane().setSelectedComponent((Component)object[i]);
                break;
            }
        }
    }

    private void parseDisplay(TempStoredDisplay tempStoredDisplay, DesignPartView designPartView, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        designPartView.setAutoRoute(false);
        designPartView.setBoxInBox(false);
        designPartView.setVisible(true);
        designPartView.getWorkSpace().updateSettings();
        if (designPartView.getDesignPart() instanceof RelationalDesign) {
            ArrayList arrayList = new ArrayList();
            for (TempDrawingObject tempDrawingObject : tempStoredDisplay.getDrawingObjects()) {
                DesignObject designObject;
                object5 = tempDrawingObject.getModelObjectRef();
                if (!"Relationship".equalsIgnoreCase(tempDrawingObject.getType()) || !this.manyToManyTables.contains(object5)) continue;
                object4 = tempDrawingObject.getID();
                object3 = new TempDrawingObject(((String)object4).replace("+00000000", "+00000001"), tempDrawingObject.getName());
                ((TempDrawingObject)object3).copyFrom(tempDrawingObject);
                ((TempDrawingObject)object3).setType("Relationship");
                ((TempDrawingObject)object3).setModelObjectRef(((String)object5).replace("+00000000", "+00000001"));
                this.setManyToManyPoints((TempDrawingObject)object3);
                arrayList.add(object3);
                object2 = new TempDrawingObject(((String)object4).replace("+00000000", "+00000002"), tempDrawingObject.getName());
                ((TempDrawingObject)object2).copyFrom(tempDrawingObject);
                ((TempDrawingObject)object2).setType("Relationship");
                ((TempDrawingObject)object2).setModelObjectRef(((String)object5).replace("+00000000", "+00000002"));
                this.setManyToManyPoints((TempDrawingObject)object2);
                arrayList.add(object2);
                tempDrawingObject.setType("Entity");
                this.setManyToManyLocation(tempDrawingObject);
                object = ((TempDrawingObject)object3).getModelObjectRef();
                DesignObject designObject2 = (DesignObject)this.relationalObjects.get(object);
                if (designObject2 == null || !(designObject2 instanceof FKIndexAssociation) || (designObject = ((FKIndexAssociation)designObject2).getSourceObject()) == null || !(designObject instanceof Table)) continue;
                String string = designObject.getObjectID();
                this.setScratchFontAndColor(tempStoredDisplay, tempDrawingObject, string);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                tempStoredDisplay.addDrawingObject((TempDrawingObject)arrayList.get(i));
            }
        }
        for (Object object6 : tempStoredDisplay.getDrawingObjects()) {
            DesignObject designObject = null;
            if ("Scratch".equalsIgnoreCase(((TempDrawingObject)object6).getType()) && (designObject = designPartView.getDesignPart() instanceof LogicalDesign ? (DesignObject)this.logicalObjects.get(((TempDrawingObject)object6).getModelObjectRef()) : (DesignObject)this.relationalObjects.get(((TempDrawingObject)object6).getModelObjectRef())) != null) {
                this.setScratchLocation(tempStoredDisplay, (TempDrawingObject)object6);
                if (designObject instanceof Entity || designObject instanceof Table) {
                    ((TempDrawingObject)object6).setType("Entity");
                } else if (designObject instanceof Relation || designObject instanceof FKIndexAssociation) {
                    ((TempDrawingObject)object6).setType("Relationship");
                }
            }
            if ("Entity".equalsIgnoreCase(((TempDrawingObject)object6).getType()) || "View".equalsIgnoreCase(((TempDrawingObject)object6).getType())) {
                designObject = designPartView.getDesignPart() instanceof LogicalDesign ? (DesignObject)this.logicalObjects.get(((TempDrawingObject)object6).getModelObjectRef()) : (DesignObject)this.relationalObjects.get(((TempDrawingObject)object6).getModelObjectRef());
                if (designObject == null) continue;
                this.setDrawingObjectFontAndColor(designObject, ((TempDrawingObject)object6).getFillColor(), ((TempDrawingObject)object6).getOutlineColor(), ((TempDrawingObject)object6).getOutlineStyle(), ((TempDrawingObject)object6).getFontRef(), ((TempDrawingObject)object6).getFontColor());
                object5 = null;
                if (bl) {
                    object5 = ((ContainerView)designObject.getTopView()).createViewSynonim(designPartView);
                    if (object5 == null) continue;
                    if (((TopView)object5).getCellView() != null) {
                        ((TopView)object5).getCellView().setNewBounds(((TempDrawingObject)object6).getLocationRectangle());
                    } else {
                        ((TopView)object5).setBounds(((TempDrawingObject)object6).getLocationRectangle());
                    }
                    if (designPartView.getDesignPart() instanceof LogicalDesign) {
                        if (object5 instanceof TVEntity) {
                            ((TVEntity)object5).addTVRelations();
                        }
                        ((ContainerView)object5).addTVTypeSubstitutions();
                        designPartView.synchronizeSynonymWithDisplays((TopView)object5);
                        continue;
                    }
                    if (object5 instanceof TVTable) {
                        ((TVTable)object5).addTVFKRelations();
                    }
                    ((ContainerView)object5).addTVTypeSubstitutions();
                    designPartView.synchronizeSynonymWithDisplays((TopView)object5);
                    continue;
                }
                object5 = (ContainerView)designObject.getFirstViewForDPV(designPartView);
                if (object5 == null || ((TopView)object5).getCellView() == null) continue;
                ((TopView)object5).getCellView().setNewBounds(((TempDrawingObject)object6).getLocationRectangle());
                continue;
            }
            if ("Relationship".equalsIgnoreCase(((TempDrawingObject)object6).getType())) {
                designObject = designPartView.getDesignPart() instanceof LogicalDesign ? (Relation)this.logicalObjects.get(((TempDrawingObject)object6).getModelObjectRef()) : (FKIndexAssociation)this.relationalObjects.get(((TempDrawingObject)object6).getModelObjectRef());
                if (designObject == null || (object5 = (TVConnector)designObject.getFirstViewForDPV(designPartView)) == null) continue;
                try {
                    object4 = (EdgeView)((TopView)object5).getCellView();
                    if (object4 == null && ((TVConnector)object5).getEdge() != null) {
                        object4 = (EdgeView)((TVConnector)object5).getEdge().getCellView();
                    }
                    if (object4 == null) continue;
                    object3 = this.getPoints(((TempDrawingObject)object6).getPathCoordinates());
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (Point)object2.next();
                        ((TVConnector)object5).getEdgePoints().add(DiagramConstants.createPoint((Point2D)object));
                    }
                    designPartView.getWorkSpace().addPoints((DefaultEdge)((AbstractCellView)object4).getCell(), ((TVConnector)object5).getEdgePoints());
                    ((EdgeView)object4).update();
                }
                catch (Exception exception) {}
                continue;
            }
            if (!"Rectangle".equalsIgnoreCase(((TempDrawingObject)object6).getType()) && !"Ellipse".equalsIgnoreCase(((TempDrawingObject)object6).getType())) continue;
            object5 = designPartView.getDesignPart().createNote();
            ((Note)object5).setText(((TempDrawingObject)object6).getText());
            object4 = ((MultiShapedDesignObject)object5).getFirstViewForDPV(designPartView);
            if (object4 == null) {
                object4 = designPartView.createTopViewFor((DesignObject)object5);
            }
            object3 = ((TempDrawingObject)object6).getLocationRectangle();
            if (object4 == null) continue;
            if (((TopView)object4).getCellView() != null) {
                ((TopView)object4).getCellView().setNewBounds((Rectangle)object3);
            } else {
                ((TopView)object4).setBounds((Rectangle)object3);
            }
            this.setDrawingObjectFontAndColor((DesignObject)object5, ((TempDrawingObject)object6).getFillColor(), ((TempDrawingObject)object6).getOutlineColor(), ((TempDrawingObject)object6).getOutlineStyle(), ((TempDrawingObject)object6).getFontRef(), ((TempDrawingObject)object6).getFontColor());
            this.setFontAndColor((DesignObject)object5, ((TempDrawingObject)object6).getFillColor(), ((TempDrawingObject)object6).getOutlineColor(), ((TempDrawingObject)object6).getFontRef(), ((TempDrawingObject)object6).getFontColor());
            if (((TopView)object4).getCellView() != null) continue;
            designPartView.add((TopView)object4, ((TopView)object4).getBounds());
            designPartView.synchronizeSynonymWithDisplays((TopView)object4);
        }
    }

    private void setDrawingObjectFontAndColor(DesignObject designObject, String string, String string2, String string3, String string4, String string5) {
        FontObject fontObject;
        int n;
        try {
            if (!"".equals(string)) {
                n = Integer.parseInt(string);
                if (designObject instanceof EditableFonts) {
                    designObject.setUseDefaultColor(false);
                    designObject.setBackgroundColor(this.reverseRGB(n));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (!"".equals(string2)) {
                n = Integer.parseInt(string2);
                if ("0".equalsIgnoreCase(string3)) {
                    designObject.setUseDefaultColor(false);
                    designObject.setForegroundColor(this.reverseRGB(n));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (!"".equals(string5)) {
                int n2 = Integer.parseInt(string5);
                if (designObject instanceof EditableFonts) {
                    fontObject = ((EditableFonts)((Object)designObject)).getFontObject(EditableFonts.FO_TITLE);
                    fontObject.setColor(this.reverseRGB(n2));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.fonts.isEmpty()) {
            this.fontWaitingList.add(new FontWaitingListEntry(designObject, string4, EditableFonts.FO_TITLE, true));
        } else {
            Font font = null;
            fontObject = null;
            int n3 = 10;
            boolean bl = false;
            boolean bl2 = false;
            if (!"".equals(string4)) {
                font = (Font)this.fonts.get(string4);
            } else if (!"".equals(this.defaultAttributeFontID)) {
                font = (Font)this.fonts.get(this.defaultAttributeFontID);
            }
            if (font != null && designObject instanceof EditableFonts) {
                FontObject fontObject2 = ((EditableFonts)((Object)designObject)).getFontObject(EditableFonts.FO_TITLE);
                fontObject2.setFont(font);
            }
        }
    }

    private Color reverseRGB(int n) {
        int n2 = n >> 0 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        return new Color(n2, n3, n4);
    }

    private Rectangle parseCoordinates(String string) {
        Rectangle rectangle = new Rectangle();
        if (!"".equals(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            int[] nArray = new int[4];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    int n2;
                    nArray[n] = n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("ERSAXParser.parseCoordinates(): Unable to parse location coordinates", numberFormatException);
                }
                ++n;
            }
            rectangle.x = nArray[0];
            rectangle.y = nArray[1];
            rectangle.width = nArray[2] - nArray[0];
            rectangle.height = nArray[3] - nArray[1];
        }
        return rectangle;
    }

    private List getPoints(List list) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        String string = "";
        for (int i = 1; i < list.size() - 2; ++i) {
            String string2 = (String)list.get(i);
            if (string.equalsIgnoreCase(string2)) continue;
            string = string2;
            String string3 = string2.substring(0, string2.indexOf(32));
            String string4 = string2.substring(string2.indexOf(32) + 1);
            try {
                int n = Integer.parseInt(string3);
                int n2 = Integer.parseInt(string4);
                Point point = new Point(n, n2);
                arrayList.add(point);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private Point getPoint(String string) {
        int n = 0;
        int n2 = 0;
        if (!"".equals(string)) {
            String string2 = string.substring(0, string.indexOf(32));
            String string3 = string.substring(string.indexOf(32) + 1);
            try {
                n = Integer.parseInt(string2);
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Point(n, n2);
    }

    private void setScratchFontAndColor(TempStoredDisplay tempStoredDisplay, TempDrawingObject tempDrawingObject, String string) {
        for (int i = 0; i < tempStoredDisplay.getDrawingObjects().size(); ++i) {
            TempDrawingObject tempDrawingObject2 = tempStoredDisplay.getDrawingObject(i);
            DesignObject designObject = (DesignObject)this.relationalObjects.get(tempDrawingObject2.getModelObjectRef());
            if (designObject == null || !designObject.getObjectID().equalsIgnoreCase(string)) continue;
            tempDrawingObject.setFillColor(tempDrawingObject2.getFillColor());
            tempDrawingObject.setFontColor(tempDrawingObject2.getFontColor());
            tempDrawingObject.setFontRef(tempDrawingObject2.getFontRef());
            tempDrawingObject.setOutlineColor(tempDrawingObject2.getOutlineColor());
            tempDrawingObject.setOutlineStyle(tempDrawingObject2.getOutlineStyle());
            return;
        }
    }

    private void setScratchLocation(TempStoredDisplay tempStoredDisplay, TempDrawingObject tempDrawingObject) {
        Rectangle rectangle = tempDrawingObject.getLocationRectangle();
        if (rectangle.getWidth() == 0.0 || rectangle.getHeight() == 0.0) {
            Object object;
            String string = tempDrawingObject.getModelObjectRef();
            for (Object object2 : this.transformWaitingList) {
                if (!((TransformWaitingListEntry)object2).getScratchObjectRef().equalsIgnoreCase(string)) continue;
                object = ((TransformWaitingListEntry)object2).getDesignObjectRef();
                for (int i = 0; i < tempStoredDisplay.getDrawingObjects().size(); ++i) {
                    TempDrawingObject tempDrawingObject2 = tempStoredDisplay.getDrawingObject(i);
                    if (!tempDrawingObject2.getModelObjectRef().equalsIgnoreCase((String)object)) continue;
                    rectangle.setBounds(tempDrawingObject2.getLocationRectangle());
                    return;
                }
            }
            if (!"".equals(tempDrawingObject.getAnchorPoint())) {
                Object object2;
                object2 = this.getPoint(tempDrawingObject.getAnchorPoint());
                object = ((Point)object2).getX();
                Double d = ((Point)object2).getY();
                int n = ((Double)object).intValue();
                int n2 = d.intValue();
                int n3 = DO_SCRATCH_ENTITY_WIDTH;
                int n4 = DO_SCRATCH_ENTITY_HEIGHT;
                if (!"".equals(tempDrawingObject.getFixedSizePoint())) {
                    Point point = this.getPoint(tempDrawingObject.getFixedSizePoint());
                    Double d2 = point.getX();
                    Double d3 = point.getY();
                    n3 = d2.intValue();
                    n4 = d3.intValue();
                }
                int n5 = n - n3 / 2 > 0 ? n - n3 / 2 : 0;
                int n6 = n2 - n4 / 2 > 0 ? n2 - n4 / 2 : 0;
                rectangle.setBounds(n5, n6, n3, n4);
            }
        }
    }

    private void setManyToManyLocation(TempDrawingObject tempDrawingObject) {
        Rectangle rectangle = tempDrawingObject.getLocationRectangle();
        if (rectangle.getWidth() > (double)DO_MTM_ENTITY_WIDTH || rectangle.getHeight() > (double)DO_MTM_ENTITY_HEIGHT) {
            Double d = rectangle.getX();
            Double d2 = rectangle.getWidth();
            int n = d.intValue();
            int n2 = d2.intValue();
            if (n2 > DO_MTM_ENTITY_WIDTH) {
                n += (n2 - DO_MTM_ENTITY_WIDTH) / 2;
                n2 = DO_MTM_ENTITY_WIDTH;
            }
            Double d3 = rectangle.getY();
            Double d4 = rectangle.getHeight();
            int n3 = d3.intValue();
            int n4 = d4.intValue();
            if (n4 > DO_MTM_ENTITY_HEIGHT) {
                n3 += (n4 - DO_MTM_ENTITY_HEIGHT) / 2;
                n4 = DO_MTM_ENTITY_HEIGHT;
            }
            rectangle.setBounds(n, n3, n2, n4);
        }
    }

    private void setManyToManyPoints(TempDrawingObject tempDrawingObject) {
        tempDrawingObject.initPathCoordinates();
    }

    private void startRelationships(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("Relationship_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportRelationships"), PROGRESS_INCREMENT);
            this.inheritanceObjects = new ArrayList();
            this.replacedAttributes = new ArrayList();
            this.manyToManyTables = new ArrayList();
        } else if (string3.equalsIgnoreCase("Relationship")) {
            this.tempRelationshipID = attributes.getValue("id");
            this.tempRelationship = new TempRelationship(this.tempRelationshipID, attributes.getValue("name"));
        }
    }

    private void endRelationships(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Relationship_Groups")) {
            if (this.createLogical && this.createRelational) {
                this.createMappings(this.design, this.logicalObjects, this.relationalObjects);
            }
            this.parseInheritanceRelations();
        } else if (string3.equalsIgnoreCase("Relationship")) {
            this.parseRelationship();
        } else if (string3.equalsIgnoreCase("Physical_Name")) {
            this.tempRelationship.setPhysicalName(this.getText());
        } else if (string3.equalsIgnoreCase("Type")) {
            this.tempRelationship.setType(this.getText());
        } else if (string3.equalsIgnoreCase("Parent_Entity_Ref")) {
            this.tempRelationship.setParentEntityRef(this.getText());
        } else if (string3.equalsIgnoreCase("Child_Entity_Ref")) {
            this.tempRelationship.setChildEntityRef(this.getText());
        } else if (string3.equalsIgnoreCase("Parent_To_Child_Verb_Phrase")) {
            this.tempRelationship.setParentToChildVerbPhrase(this.getText());
        } else if (string3.equalsIgnoreCase("Child_To_Parent_Verb_Phrase")) {
            this.tempRelationship.setChildToParentVerbPhrase(this.getText());
        } else if (string3.equalsIgnoreCase("Hide_In_Logical")) {
            this.tempRelationship.setHideInLogical(this.getText());
        } else if (string3.equalsIgnoreCase("Hide_In_Physical")) {
            this.tempRelationship.setHideInPhysical(this.getText());
        } else if (string3.equalsIgnoreCase("Cardinality")) {
            this.tempRelationship.setCardinality(this.getText());
        } else if (string3.equalsIgnoreCase("Comment") || string3.equalsIgnoreCase("Note")) {
            this.tempRelationship.setComment(this.getText());
        } else if (string3.equalsIgnoreCase("Null_Option_Type")) {
            this.tempRelationship.setNullOptionType(this.getText());
        } else if (string3.equalsIgnoreCase("Parent_Delete_Rule")) {
            this.tempRelationship.setParentDeleteRule(this.getText());
        } else if (string3.equalsIgnoreCase("Key_Group_Ref")) {
            this.tempRelationship.setRefKey(this.getText());
        }
    }

    private void parseRelationship() {
        String string = this.tempRelationship.getType();
        if ("9".equalsIgnoreCase(string)) {
            IHObject iHObject = new IHObject(this.tempRelationshipID, this.tempRelationship.getName(), this.tempRelationship.getParentEntityRef(), this.tempRelationship.getChildEntityRef());
            if (!"".equals(this.tempRelationship.getPhysicalName())) {
                iHObject.setPhysicalName(this.tempRelationship.getPhysicalName());
            }
            if (!"".equals(this.tempRelationship.getParentDeleteRule())) {
                iHObject.setParentDeleteRule(this.tempRelationship.getParentDeleteRule());
            }
            if (!"".equals(this.tempRelationship.getComment())) {
                iHObject.setComment(this.tempRelationship.getComment());
            }
            this.inheritanceObjects.add(iHObject);
        } else {
            if (this.createLogical && !"true".equalsIgnoreCase(this.tempRelationship.getHideInLogical())) {
                this.parseRelation();
            }
            if (this.createRelational && !"true".equalsIgnoreCase(this.tempRelationship.getHideInPhysical())) {
                if ("4".equalsIgnoreCase(string)) {
                    this.parseRelationalManyToMany();
                } else {
                    this.parseForeignKey();
                }
            }
        }
    }

    private void parseRelation() {
        DesignObject designObject = (DesignObject)this.logicalObjects.get(this.tempRelationship.getParentEntityRef());
        DesignObject designObject2 = (DesignObject)this.logicalObjects.get(this.tempRelationship.getChildEntityRef());
        if (designObject != null && designObject2 != null && designObject instanceof Entity && designObject2 instanceof Entity) {
            TVRelation tVRelation;
            Relation relation = this.logical.getRelationSet().createRelation(this.deriveObjectID(ID_PREFIX_RELATION, this.tempRelationshipID));
            if (!"".equals(this.tempRelationship.getName())) {
                relation.setName(this.tempRelationship.getName());
            }
            if (!"".equals(this.tempRelationship.getComment())) {
                relation.setComment(this.tempRelationship.getComment());
            }
            for (FKElement fKElement : this.logicalFKElements) {
                if (!fKElement.getParentRelationshipID().equalsIgnoreCase(this.tempRelationshipID)) continue;
                Attribute attribute = (Attribute)this.logicalObjects.get(fKElement.getID());
                Attribute attribute2 = (Attribute)this.logicalObjects.get(fKElement.getParentAttributeID());
                if (attribute == null || attribute2 == null) continue;
                attribute.setReferedAttribute(attribute2.getObjectID());
                attribute.setGeneratorID(relation.getObjectID());
                this.replacedAttributes.add(attribute);
            }
            relation.setFireCardinalityChange(false);
            relation.setSourceEntity((Entity)designObject);
            relation.setTargetEntity((Entity)designObject2);
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            int n = -5;
            try {
                n = Integer.parseInt(this.tempRelationship.getCardinality());
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n2 = 1;
            int n3 = 1;
            if (!"".equals(this.tempRelationship.getType()) && !"".equals(this.tempRelationship.getCardinality())) {
                if ("7".equals(this.tempRelationship.getType())) {
                    bl = false;
                    bl3 = !"101".equals(this.tempRelationship.getNullOptionType());
                    bl2 = !"-2".equals(this.tempRelationship.getCardinality()) && n <= 0;
                    n2 = 1;
                    n3 = "-1".equals(this.tempRelationship.getCardinality()) ? 1 : 0;
                } else if ("2".equals(this.tempRelationship.getType())) {
                    bl = true;
                    bl2 = !"-2".equals(this.tempRelationship.getCardinality()) && n <= 0;
                    bl3 = false;
                    n2 = 1;
                    n3 = "-1".equals(this.tempRelationship.getCardinality()) || n == 1 ? 1 : 0;
                } else if ("4".equals(this.tempRelationship.getType())) {
                    bl = false;
                    bl2 = true;
                    bl3 = true;
                    n2 = 0;
                    n3 = 0;
                }
                if (n2 == 1 && n3 == 1) {
                    relation.setDominantRole((Entity)designObject);
                }
                relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[n2]);
                relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[n3]);
                relation.setOptionalSource(bl2);
                relation.setOptionalTarget(bl3);
                relation.setIdentifying(bl);
                relation.setFireCardinalityChange(true);
                relation.setTargetCardinality(relation.getTargetCardinality());
                relation.setNameOnSource(this.tempRelationship.getParentToChildVerbPhrase());
                relation.setNameOnTarget(this.tempRelationship.getChildToParentVerbPhrase());
            }
            if ((tVRelation = (TVRelation)relation.getTopView()) != null) {
                tVRelation.addConnection();
                tVRelation.resetEdgeParams();
            }
            this.logicalObjects.put(this.tempRelationshipID, relation);
        }
    }

    private void parseRelationalManyToMany() {
        DesignObject designObject = (DesignObject)this.relationalObjects.get(this.tempRelationship.getParentEntityRef());
        DesignObject designObject2 = (DesignObject)this.relationalObjects.get(this.tempRelationship.getChildEntityRef());
        if (designObject != null && designObject2 != null && designObject instanceof Table && designObject2 instanceof Table) {
            Column column;
            DesignObject designObject3;
            String string = this.tempRelationship.getName();
            if (!"".equals(this.tempRelationship.getPhysicalName())) {
                string = this.tempRelationship.getPhysicalName();
            }
            Table table = this.relational.getTableSet().createTable(this.deriveObjectID(ID_PREFIX_TABLE, this.tempRelationshipID));
            table.setName(string);
            this.relationalObjects.put(this.tempRelationshipID, table);
            this.manyToManyTables.add(this.tempRelationshipID);
            if (!"".equals(this.tempRelationship.getComment())) {
                table.setNotes(this.tempRelationship.getComment());
            }
            Index index = table.createIndex(this.deriveObjectID(ID_PREFIX_PK_INDEX, this.tempRelationshipID));
            index.setName(ID_PREFIX_PK_INDEX + string);
            KeyObject keyObject = ((Table)designObject).getPK();
            if (keyObject != null) {
                designObject3 = table.addFK(keyObject);
                designObject3.setObjectID(this.deriveObjectID(ID_PREFIX_FK_INDEX_ASSOCIATION, this.tempRelationshipID));
                for (int i = 0; i < keyObject.getElements().length; ++i) {
                    Column column2 = (Column)keyObject.getElement(i);
                    column = table.createColumn(column2.getName());
                    column2.copy(column);
                    column.addFKAssociation(column2, (FKIndexAssociation)designObject3);
                    ((FKIndexAssociation)designObject3).getLocalFKIndex().add(column);
                    index.add(column);
                }
                this.relationalObjects.put(this.tempRelationshipID.replace("+00000000", "+00000001"), designObject3);
            }
            if ((designObject3 = ((Table)designObject2).getPK()) != null) {
                FKIndexAssociation fKIndexAssociation = table.addFK((KeyObject)designObject3);
                fKIndexAssociation.setObjectID(this.deriveObjectID(ID_PREFIX_FK_INDEX_ASSOCIATION2, this.tempRelationshipID));
                for (int i = 0; i < ((ContainerObject)designObject3).getElements().length; ++i) {
                    column = (Column)((ContainerObject)designObject3).getElement(i);
                    Column column3 = table.createColumn(column.getName());
                    column.copy(column3);
                    column3.addFKAssociation(column, fKIndexAssociation);
                    fKIndexAssociation.getLocalFKIndex().add(column3);
                    index.add(column3);
                }
                this.relationalObjects.put(this.tempRelationshipID.replace("+00000000", "+00000002"), fKIndexAssociation);
            }
            index.makePK();
            this.relationalObjects.put(this.tempRelationshipID.replace("+00000000", "+00000003"), index);
        }
    }

    private void parseForeignKey() {
        KeyObject keyObject;
        DesignObject designObject = (DesignObject)this.relationalObjects.get(this.tempRelationship.getParentEntityRef());
        DesignObject designObject2 = (DesignObject)this.relationalObjects.get(this.tempRelationship.getChildEntityRef());
        if (designObject != null && designObject2 != null && designObject instanceof Table && designObject2 instanceof Table && (keyObject = (KeyObject)this.relationalObjects.get(this.tempRelationship.getRefKey())) != null) {
            Column column;
            Object object2;
            FKIndexAssociation fKIndexAssociation = ((Table)designObject2).addFK(keyObject);
            fKIndexAssociation.setObjectID(this.deriveObjectID(ID_PREFIX_FK_INDEX_ASSOCIATION, this.tempRelationshipID));
            if (!"".equals(this.tempRelationship.getPhysicalName())) {
                fKIndexAssociation.setName(this.tempRelationship.getPhysicalName());
            } else if (!"".equals(this.tempRelationship.getName())) {
                fKIndexAssociation.setName(this.tempRelationship.getName());
            }
            if (!"".equals(this.tempRelationship.getComment())) {
                fKIndexAssociation.setComment(this.tempRelationship.getComment());
            }
            if (!"".equals(this.tempRelationship.getParentDeleteRule())) {
                if ("10005".equalsIgnoreCase(this.tempRelationship.getParentDeleteRule())) {
                    fKIndexAssociation.setDeleteRule("CASCADE");
                } else if ("9999".equalsIgnoreCase(this.tempRelationship.getParentDeleteRule())) {
                    fKIndexAssociation.setDeleteRule("NO ACTION");
                } else if ("10004".equalsIgnoreCase(this.tempRelationship.getParentDeleteRule())) {
                    fKIndexAssociation.setDeleteRule("RESTRICT");
                } else if ("10006".equalsIgnoreCase(this.tempRelationship.getParentDeleteRule())) {
                    fKIndexAssociation.setDeleteRule("SET NULL");
                }
            }
            List list = this.getFKElements(this.relationalFKElements, this.tempRelationshipID);
            FKElement[] fKElementArray = list.toArray(new FKElement[0]);
            list.clear();
            TempKey tempKey = (TempKey)this.relationKey.get(this.tempRelationship.getID());
            block0: for (Object object2 : tempKey.getKeyMembers()) {
                for (int i = 0; i < fKElementArray.length; ++i) {
                    if (!fKElementArray[i].id.equals(((TempKeyMember)object2).getAttributeRef())) continue;
                    list.add(fKElementArray[i]);
                    continue block0;
                }
            }
            object2 = new HashMap();
            for (FKElement fKElement : list) {
                if (!fKElement.getParentRelationshipID().equalsIgnoreCase(this.tempRelationshipID)) continue;
                column = (Column)this.relationalObjects.get(fKElement.getID());
                if (column == null && fKElement.getPhysicalRef() != null) {
                    column = (Column)this.relationalObjects.get(fKElement.getPhysicalRef());
                }
                Column column2 = (Column)this.relationalObjects.get(fKElement.getParentAttributeID());
                if (column == null || column2 == null) continue;
                object2.put(column2.getObjectID(), column);
            }
            for (Column column3 : keyObject.getElementsCollection()) {
                column = (Column)object2.get(column3.getObjectID());
                column.addFKAssociation(column3, fKIndexAssociation);
                fKIndexAssociation.getLocalFKIndex().add(column);
            }
            fKIndexAssociation.resetMandatoryUsingColumns();
            this.relationalObjects.put(this.tempRelationshipID, fKIndexAssociation);
        }
    }

    private List getFKColumnNames(List list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FKElement fKElement : list) {
            Column column;
            if (!fKElement.getParentRelationshipID().equalsIgnoreCase(string) || (column = (Column)this.relationalObjects.get(fKElement.getParentAttributeID())) == null) continue;
            arrayList.add(column.getName());
        }
        return arrayList;
    }

    private List getFKElements(List list, String string) {
        ArrayList<FKElement> arrayList = new ArrayList<FKElement>();
        for (FKElement fKElement : list) {
            if (!fKElement.getParentRelationshipID().equalsIgnoreCase(string)) continue;
            arrayList.add(fKElement);
        }
        return arrayList;
    }

    private Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && this.isIndexForColumnNames_No_ColumnOrder(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames_No_ColumnOrder(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getName().equalsIgnoreCase((String)list.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isIndexForColumnNames_No_ColumnOrder(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < list.size(); ++j) {
                if (!columnArray[i].getName().equalsIgnoreCase((String)list.get(j))) continue;
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private void parseInheritanceRelations() {
        for (int i = this.inheritanceObjects.size() - 1; i >= 0; --i) {
            DesignObject designObject;
            ContainerWithKeyObject containerWithKeyObject;
            ContainerWithKeyObject containerWithKeyObject2;
            IHObject iHObject = (IHObject)this.inheritanceObjects.get(i);
            String string = iHObject.getID();
            String string2 = iHObject.getParentID();
            String string3 = iHObject.getChildID();
            boolean bl = false;
            if (this.createLogical && (containerWithKeyObject2 = (Entity)this.logicalObjects.get(string3)) != null) {
                containerWithKeyObject = this.getParentEntity(string2);
                if (containerWithKeyObject != null) {
                    ((Entity)containerWithKeyObject2).setHierarchicalParent((Entity)containerWithKeyObject);
                    designObject = ((Entity)containerWithKeyObject2).getInheritanceRelation();
                    designObject.setObjectID(this.deriveObjectID(ID_PREFIX_INHERITANCE_RELATION, string));
                    if (!"".equals(iHObject.getComment())) {
                        designObject.setComment(iHObject.getComment());
                    }
                    this.logicalObjects.put(string, designObject);
                }
                bl = true;
            }
            if (this.createRelational && (containerWithKeyObject2 = (Table)this.relationalObjects.get(string3)) != null) {
                containerWithKeyObject = this.getParentTable(string2);
                if (containerWithKeyObject != null && (designObject = this.getUniqueIndexForColumnNames((Table)containerWithKeyObject, this.getFKColumnNames(this.relationalFKElements, string))) != null) {
                    FKIndexAssociation fKIndexAssociation = ((Table)containerWithKeyObject2).addFK((KeyObject)designObject);
                    fKIndexAssociation.setObjectID(this.deriveObjectID(ID_PREFIX_FK_INDEX_ASSOCIATION, string));
                    if (!"".equals(iHObject.getPhysicalName())) {
                        fKIndexAssociation.setName(iHObject.getPhysicalName());
                    } else if (!"".equals(iHObject.getName())) {
                        fKIndexAssociation.setName(iHObject.getName());
                    }
                    if (!"".equals(iHObject.getComment())) {
                        fKIndexAssociation.setComment(iHObject.getComment());
                    }
                    if (!"".equals(iHObject.getParentDeleteRule())) {
                        if ("10005".equalsIgnoreCase(iHObject.getParentDeleteRule())) {
                            fKIndexAssociation.setDeleteRule("CASCADE");
                        } else if ("9999".equalsIgnoreCase(iHObject.getParentDeleteRule())) {
                            fKIndexAssociation.setDeleteRule("NO ACTION");
                        } else if ("10004".equalsIgnoreCase(iHObject.getParentDeleteRule())) {
                            fKIndexAssociation.setDeleteRule("RESTRICT");
                        } else if ("10006".equalsIgnoreCase(iHObject.getParentDeleteRule())) {
                            fKIndexAssociation.setDeleteRule("SET NULL");
                        }
                    }
                    for (FKElement fKElement : this.relationalFKElements) {
                        if (!fKElement.getParentRelationshipID().equalsIgnoreCase(string)) continue;
                        Column column = (Column)this.relationalObjects.get(fKElement.getID());
                        Column column2 = (Column)this.relationalObjects.get(fKElement.getParentAttributeID());
                        if (column == null || column2 == null) continue;
                        column.addFKAssociation(column2, fKIndexAssociation);
                        fKIndexAssociation.getLocalFKIndex().add(column);
                    }
                    this.relationalObjects.put(string, fKIndexAssociation);
                }
                bl = true;
            }
            if (!bl) continue;
            this.inheritanceObjects.remove(iHObject);
        }
    }

    private Entity getParentEntity(String string) {
        for (IHObject iHObject : this.inheritanceObjects) {
            if (!iHObject.getChildID().equalsIgnoreCase(string)) continue;
            return (Entity)this.logicalObjects.get(iHObject.getParentID());
        }
        return null;
    }

    private Table getParentTable(String string) {
        for (IHObject iHObject : this.inheritanceObjects) {
            if (!iHObject.getChildID().equalsIgnoreCase(string)) continue;
            return (Table)this.relationalObjects.get(iHObject.getParentID());
        }
        return null;
    }

    private void startDefaultValues(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("Default_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportDefaults"), PROGRESS_INCREMENT);
            this.defaultValues = new TreeMap();
        } else if (string3.equalsIgnoreCase("Default")) {
            this.tempDefaultValueID = attributes.getValue("id");
            this.tempDefaultValue = new TempDefaultValue(this.tempDefaultValueID, attributes.getValue("name"));
        }
    }

    private void endDefaultValues(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Default")) {
            this.defaultValues.put(this.tempDefaultValueID, this.tempDefaultValue);
        } else if (string3.equalsIgnoreCase("Built_In_Id")) {
            try {
                this.tempDefaultValue.setBuiltIn(Integer.parseInt(this.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string3.equalsIgnoreCase("Server_Value")) {
            this.tempDefaultValue.setServerValue(this.getText());
        }
    }

    private void startValidationRules(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("Validation_Rule_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportValidationRules"), PROGRESS_INCREMENT);
            this.validationRules = new TreeMap();
        } else if (string3.equalsIgnoreCase("Validation_Rule")) {
            this.tempValidationRuleID = attributes.getValue("id");
            this.tempValidationRule = new TempValidationRule(this.tempValidationRuleID, attributes.getValue("name"));
        } else if (string3.equalsIgnoreCase("Valid_Value_Groups")) {
            this.tempValidationRule.initValidValues();
        } else if (string3.equalsIgnoreCase("Valid_Value")) {
            this.tempValidationRule.addValidValueName(attributes.getValue("name"));
            this.tempValidationRule.addValidValueDefinition("");
        }
    }

    private void endValidationRules(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Validation_Rule")) {
            this.validationRules.put(this.tempValidationRuleID, this.tempValidationRule);
        } else if (string3.equalsIgnoreCase("Definition") && this.stack.search("Valid_Value") == -1) {
            this.tempValidationRule.setDefinition(this.getText());
        } else if (string3.equalsIgnoreCase("Type")) {
            try {
                this.tempValidationRule.setType(Integer.parseInt(this.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string3.equalsIgnoreCase("Logical_User_Rule")) {
            this.tempValidationRule.setUserRule(this.getText());
        } else if (string3.equalsIgnoreCase("Min_Value")) {
            this.tempValidationRule.setMinValue(this.getText());
        } else if (string3.equalsIgnoreCase("Max_Value")) {
            this.tempValidationRule.setMaxValue(this.getText());
        } else if (string3.equalsIgnoreCase("Definition") && this.stack.search("Valid_Value") != -1) {
            this.tempValidationRule.setValidValueDefinition(this.getText());
        }
    }

    private void applyValidationRule(ConstrainedObject constrainedObject, String string) {
        ValidationRuleHolder validationRuleHolder = (ValidationRuleHolder)this.validationRules.get(string);
        if (validationRuleHolder != null) {
            switch (validationRuleHolder.getType()) {
                case 0: {
                    CheckConstraint checkConstraint = new CheckConstraint();
                    checkConstraint.setDesign(this.design);
                    checkConstraint.add(new GenericConstraint(), validationRuleHolder.getRule());
                    constrainedObject.setCheck(checkConstraint);
                    break;
                }
                case 1: {
                    AVT aVT = new AVT();
                    aVT.setBeginValue(validationRuleHolder.getMinValue());
                    aVT.setEndValue(validationRuleHolder.getMaxValue());
                    aVT.setDescription(validationRuleHolder.getDefinition());
                    constrainedObject.addAVT(aVT);
                    break;
                }
                case 2: {
                    for (Object k : validationRuleHolder.getValueList().keySet()) {
                        Object v = validationRuleHolder.getValueList().get(k);
                        if (constrainedObject.getValueList() == null) {
                            ConstraintEnumeration constraintEnumeration = new ConstraintEnumeration();
                            constrainedObject.setValueList(constraintEnumeration);
                        }
                        constrainedObject.getValueList().add(k, (String)v);
                    }
                    break;
                }
            }
        }
    }

    private void startStoredProcedures(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("Stored_Procedure_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportStoredProcedures"), PROGRESS_INCREMENT);
        } else if (string3.equalsIgnoreCase("Stored_Procedure")) {
            this.tempStoredProcedureID = attributes.getValue("id");
            this.tempStoredProcedure = new TempPLSQLSource(this.tempStoredProcedureID, attributes.getValue("name"));
        }
    }

    private void endStoredProcedures(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Stored_Procedure")) {
            if (this.oracleStorage != null) {
                this.parseStoredProcedure();
            }
        } else if (string3.equalsIgnoreCase("Definition")) {
            this.tempStoredProcedure.setDefinition(this.getText());
        } else if (string3.equalsIgnoreCase("Schema_Name")) {
            this.tempStoredProcedure.setSchemaName(this.getText());
        } else if (string3.equalsIgnoreCase("Type")) {
            this.tempStoredProcedure.setType(this.getText());
        } else if (string3.equalsIgnoreCase("Template_Code")) {
            this.tempStoredProcedure.setCodeKeyword("PROCEDURE");
            this.tempStoredProcedure.setTemplateCode(this.getText());
        }
    }

    private void parseStoredProcedure() {
        StoredProcedureOracle storedProcedureOracle = this.oracleStorage.getStoredProcedureSet().createStoredProcedure(this.deriveObjectID(ID_PREFIX_STORED_PROCEDURE, this.tempStoredProcedureID));
        if (!"".equals(this.tempStoredProcedure.getTemplateCode())) {
            storedProcedureOracle.setSource(this.tempStoredProcedure.getTemplateCode());
        }
        storedProcedureOracle.setName(this.tempStoredProcedure.getName());
        if (!"".equals(this.tempStoredProcedure.getDefinition())) {
            storedProcedureOracle.setComment(this.tempStoredProcedure.getDefinition());
        }
        if (!"".equals(this.tempStoredProcedure.getSchemaName())) {
            this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempStoredProcedure.getSchemaName(), storedProcedureOracle));
        }
        this.storedProcedures.put(this.tempStoredProcedureID, storedProcedureOracle);
    }

    private void startManyToManyTransforms(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("Many_To_Many_Transform_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportManyToManyTransforms"), PROGRESS_INCREMENT);
        } else if (string3.equalsIgnoreCase("Many_To_Many_Transform")) {
            this.tempMTMTransformID = attributes.getValue("id");
            this.tempMTMTransform = new TempMTMTransform(this.tempMTMTransformID, attributes.getValue("name"));
        }
    }

    private void endManyToManyTransforms(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Many_To_Many_Transform")) {
            if (this.createLogical && this.createRelational) {
                this.parseMTMTransform();
            }
        } else if (string3.equalsIgnoreCase("Many_To_Many_Association_Table_Ref")) {
            this.tempMTMTransform.setAssociationTableRef(this.getText());
        } else if (string3.equalsIgnoreCase("Relationship_1_Ref")) {
            this.tempMTMTransform.setRelationshipRef_1(this.getText());
        } else if (string3.equalsIgnoreCase("Relationship_2_Ref")) {
            this.tempMTMTransform.setRelationshipRef_2(this.getText());
        }
    }

    private void parseMTMTransform() {
        XtdMapping xtdMapping;
        Table table = (Table)this.relationalObjects.get(this.tempMTMTransform.getAssociationTableRef());
        Relation relation = (Relation)this.logicalObjects.get(this.tempMTMTransform.getRelationshipRef_1());
        Relation relation2 = (Relation)this.logicalObjects.get(this.tempMTMTransform.getRelationshipRef_2());
        if (relation != null && table != null) {
            xtdMapping = this.design.getExtendedMap().createMapping(relation, table);
            xtdMapping.setRealSourceEntityID(relation.getSourceEntity().getObjectID());
            xtdMapping.setRealTargetEntityID(relation.getTargetEntity().getObjectID());
            table.setGeneratorID(relation.getObjectID());
            xtdMapping.setCreationTime(System.currentTimeMillis());
        }
        if (relation2 != null && table != null) {
            xtdMapping = this.design.getExtendedMap().createMapping(relation2, table);
            xtdMapping.setRealSourceEntityID(relation2.getSourceEntity().getObjectID());
            xtdMapping.setRealTargetEntityID(relation2.getTargetEntity().getObjectID());
            table.setGeneratorID(relation2.getObjectID());
            xtdMapping.setCreationTime(System.currentTimeMillis());
        }
    }

    private void startRollUpTransforms(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("Supertype_Subtype_Roll_Up_Transform_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportRollUpTransforms"), PROGRESS_INCREMENT);
        } else if (string3.equalsIgnoreCase("Supertype_Subtype_Roll_Up_Transform")) {
            this.tempRollUpTransformID = attributes.getValue("id");
            this.tempRollUpTransform = new TempRollUpTransform(this.tempRollUpTransformID, attributes.getValue("name"));
        } else if (string3.equalsIgnoreCase("Roll_Up_Subtransform")) {
            this.tempRollUpSubTransformID = attributes.getValue("id");
            this.tempRollUpSubTransform = new TempRollUpSubTransform(this.tempRollUpSubTransformID, attributes.getValue("name"));
        } else if (string3.equalsIgnoreCase("Association")) {
            this.tempSourceObjectRef = "";
            this.tempTargetObjectRef = "";
        }
    }

    private void endRollUpTransforms(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Supertype_Subtype_Roll_Up_Transform")) {
            if (this.createLogical && this.createRelational) {
                this.rollUpTransforms.put(this.tempRollUpTransformID, this.tempRollUpTransform);
                this.updateTransformWaitingList();
            }
        } else if (string3.equalsIgnoreCase("Parent_Table_Ref")) {
            this.tempRollUpTransform.setParentTableRef(this.getText());
        } else if (string3.equalsIgnoreCase("Scratch_Parent_Table_Ref")) {
            this.tempRollUpTransform.setScratchParentTableRef(this.getText());
        } else if (string3.equalsIgnoreCase("Denormalized_Table_In_Roll_Up_Ref")) {
            this.tempRollUpTransform.setDenormalizedTableRef(this.getText());
        } else if (string3.equalsIgnoreCase("Scratch_Denormalized_Table_In_Roll_Up_Ref")) {
            this.tempRollUpTransform.setScratchDenormalizedTableRef(this.getText());
        } else if (string3.equalsIgnoreCase("Roll_Up_Subtransform")) {
            this.tempRollUpTransform.addTempRollUpSubTransform(this.tempRollUpSubTransform);
        } else if (string3.equalsIgnoreCase("Association")) {
            if (this.stack.search("Roll_Up_Subtransform") == -1) {
                this.tempRollUpTransform.addSourceAssociation(this.tempSourceObjectRef);
                this.tempRollUpTransform.addTargetAssociation(this.tempTargetObjectRef);
            } else {
                this.tempRollUpSubTransform.addSubSourceAssociation(this.tempSourceObjectRef);
                this.tempRollUpSubTransform.addSubTargetAssociation(this.tempTargetObjectRef);
            }
        } else if (string3.equalsIgnoreCase("Child_Table_Ref")) {
            this.tempRollUpSubTransform.setChildTableRef(this.getText());
        } else if (string3.equalsIgnoreCase("Scratch_Child_Table_Ref")) {
            this.tempRollUpSubTransform.setScratchChildTableRef(this.getText());
        } else if (string3.equalsIgnoreCase("Source_Object_Ref")) {
            this.tempSourceObjectRef = this.getText();
        } else if (string3.equalsIgnoreCase("Target_Object_Ref")) {
            this.tempTargetObjectRef = this.getText();
        }
    }

    private void updateTransformWaitingList() {
        String string = this.tempRollUpTransform.getParentTableRef();
        String string2 = this.tempRollUpTransform.getDenormalizedTableRef();
        Entity entity = (Entity)this.logicalObjects.get(string);
        Table table = (Table)this.relationalObjects.get(string2);
        if (entity != null && table == null && !"".equals(this.tempRollUpTransform.getScratchDenormalizedTableRef()) || entity == null && table != null && !"".equals(this.tempRollUpTransform.getScratchParentTableRef())) {
            for (TransformWaitingListEntry transformWaitingListEntry : this.transformWaitingList) {
                if (!this.tempRollUpTransformID.equalsIgnoreCase(transformWaitingListEntry.getTransformRef())) continue;
                if (transformWaitingListEntry.isSourceOfTransform() && string.equalsIgnoreCase(transformWaitingListEntry.getDesignObjectRef())) {
                    transformWaitingListEntry.setScratchObjectRef(this.tempRollUpTransform.getScratchDenormalizedTableRef());
                    continue;
                }
                if (transformWaitingListEntry.isSourceOfTransform() || !string2.equalsIgnoreCase(transformWaitingListEntry.getDesignObjectRef())) continue;
                transformWaitingListEntry.setScratchObjectRef(this.tempRollUpTransform.getScratchParentTableRef());
            }
        }
    }

    private void parseRollUpTransform(TempRollUpTransform tempRollUpTransform, String string, String string2, boolean bl) {
        Object object;
        DesignObject designObject;
        Object object2;
        Object object32;
        Entity entity = (Entity)this.logicalObjects.get(string);
        Table table = (Table)this.relationalObjects.get(string2);
        if (entity != null && table != null) {
            RepositoryObject repositoryObject;
            if (this.design.getExtendedMap().getMapping(entity, table) == null) {
                repositoryObject = this.design.getExtendedMap().createMapping(entity, table);
                table.setGeneratorID(entity.getObjectID());
                ((XtdMapping)repositoryObject).setCreationTime(System.currentTimeMillis());
            }
            repositoryObject = entity.getPK();
            object32 = table.getPK();
            if (repositoryObject != null && object32 != null && this.design.getExtendedMap().getMapping((DesignObject)repositoryObject, (DesignObject)object32) == null) {
                object2 = this.design.getExtendedMap().createMapping((DesignObject)repositoryObject, (DesignObject)object32);
                ((ModelIDObject)object32).setGeneratorID(((ModelIDObject)repositoryObject).getObjectID());
                ((XtdMapping)object2).setCreationTime(System.currentTimeMillis());
            }
        }
        if (tempRollUpTransform.getSourceAssociations().size() == tempRollUpTransform.getTargetAssociations().size()) {
            for (int i = 0; i < tempRollUpTransform.getSourceAssociations().size(); ++i) {
                object32 = tempRollUpTransform.getSourceAssociation(i);
                object2 = tempRollUpTransform.getTargetAssociation(i);
                designObject = (DesignObject)this.logicalObjects.get(object32);
                DesignObject designObject2 = (DesignObject)this.relationalObjects.get(object2);
                if (designObject == null || designObject2 == null || this.design.getExtendedMap().getMapping(designObject, designObject2) != null || this.isDeleted(designObject) || this.isDeleted(designObject2)) continue;
                object = this.design.getExtendedMap().createMapping(designObject, designObject2);
                designObject2.setGeneratorID((String)object32);
                ((XtdMapping)object).setCreationTime(System.currentTimeMillis());
            }
        }
        for (Object object32 : tempRollUpTransform.getTempRollUpSubTransforms()) {
            Object object4;
            object2 = bl ? ((TempRollUpSubTransform)object32).getChildTableRef() : ((TempRollUpSubTransform)object32).getScratchChildTableRef();
            designObject = (Entity)this.logicalObjects.get(object2);
            if (designObject != null && table != null) {
                if (this.design.getExtendedMap().getMapping(designObject, table) == null) {
                    XtdMapping xtdMapping = this.design.getExtendedMap().createMapping(designObject, table);
                    table.setGeneratorID(designObject.getObjectID());
                    xtdMapping.setCreationTime(System.currentTimeMillis());
                }
                KeyObject keyObject = ((ContainerWithKeyObject)designObject).getPK();
                object = table.getPK();
                if (keyObject != null && object != null && this.design.getExtendedMap().getMapping(keyObject, (DesignObject)object) == null) {
                    object4 = this.design.getExtendedMap().createMapping(keyObject, (DesignObject)object);
                    ((ModelIDObject)object).setGeneratorID(keyObject.getObjectID());
                    ((XtdMapping)object4).setCreationTime(System.currentTimeMillis());
                }
            }
            if (((TempRollUpSubTransform)object32).getSubSourceAssociations().size() != ((TempRollUpSubTransform)object32).getSubTargetAssociations().size()) continue;
            for (int i = 0; i < ((TempRollUpSubTransform)object32).getSubSourceAssociations().size(); ++i) {
                object = ((TempRollUpSubTransform)object32).getSubSourceAssociation(i);
                object4 = ((TempRollUpSubTransform)object32).getSubTargetAssociation(i);
                DesignObject designObject3 = (DesignObject)this.logicalObjects.get(object);
                DesignObject designObject4 = (DesignObject)this.relationalObjects.get(object4);
                if (designObject3 == null || designObject4 == null || this.design.getExtendedMap().getMapping(designObject3, designObject4) != null || this.isDeleted(designObject3) || this.isDeleted(designObject4)) continue;
                XtdMapping xtdMapping = this.design.getExtendedMap().createMapping(designObject3, designObject4);
                designObject4.setGeneratorID((String)object);
                xtdMapping.setCreationTime(System.currentTimeMillis());
            }
        }
    }

    private void startViews(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("View_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportViews"), PROGRESS_INCREMENT);
            this.logicalViews2 = new ArrayList();
            this.relationalViews2 = new ArrayList();
        } else if (string3.equalsIgnoreCase("View")) {
            this.tempViewID = attributes.getValue("id");
            this.tempView = new TempView(this.tempViewID, attributes.getValue("name"));
        } else if (string3.equalsIgnoreCase("Attribute")) {
            this.tempViewAttributeID = attributes.getValue("id");
            this.tempViewAttribute = new TempViewAttribute(this.tempViewAttributeID, attributes.getValue("name"));
        } else if (string3.equalsIgnoreCase("Trigger_Groups")) {
            this.tempView.initViewTriggers();
        } else if (string3.equalsIgnoreCase("Trigger")) {
            this.tempViewTriggerID = attributes.getValue("id");
            this.tempViewTrigger = new TempTrigger(this.tempViewTriggerID, attributes.getValue("name"));
        }
    }

    private void endViews(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("View_Groups")) {
            if (this.createLogical) {
                this.parseEntityViews2();
            }
            if (this.createRelational) {
                this.parseTableViews2();
            }
        } else if (string3.equalsIgnoreCase("View")) {
            this.parseView();
        } else if (this.stack.search("ViewProps") != -1) {
            if (string3.equalsIgnoreCase("Type")) {
                this.tempView.setType(this.getText());
            } else if (string3.equalsIgnoreCase("Physical_Name")) {
                this.tempView.setPhysicalName(this.getText());
            } else if (string3.equalsIgnoreCase("Schema_Name")) {
                this.tempView.setSchemaName(this.getText());
            } else if (string3.equalsIgnoreCase("Is_Physical_Only")) {
                this.tempView.setPhysicalOnly(this.getText());
            } else if (string3.equalsIgnoreCase("Is_Logical_Only")) {
                this.tempView.setLogicalOnly(this.getText());
            } else if (string3.equalsIgnoreCase("Hide_In_Logical")) {
                this.tempView.setHideInLogical(this.getText());
            } else if (string3.equalsIgnoreCase("Hide_In_Physical")) {
                this.tempView.setHideInPhysical(this.getText());
            } else if (string3.equalsIgnoreCase("Definition")) {
                this.tempView.setDefinition(this.getText());
            } else if (string3.equalsIgnoreCase("Fill_Color")) {
                this.tempView.setBgColorVal(this.getText());
            } else if (string3.equalsIgnoreCase("Outline_Color")) {
                this.tempView.setOutlineColorVal(this.getText());
            } else if (string3.equalsIgnoreCase("Default_Entity_Name_Font_Ref")) {
                this.tempView.setNameFontID(this.getText());
            } else if (string3.equalsIgnoreCase("Default_Entity_Name_Color")) {
                this.tempView.setNameColorVal(this.getText());
            } else if (string3.equalsIgnoreCase("Comment") || string3.equalsIgnoreCase("Note")) {
                this.tempView.setComment(this.getText());
            } else if (string3.equalsIgnoreCase("SQL")) {
                this.tempView.setSQL(this.getText());
            } else if (string3.equalsIgnoreCase("Stored_Procedures_Ref")) {
                this.tempView.addStoredProcedureRef(this.getText());
            } else if (string3.equalsIgnoreCase("Functions_Ref")) {
                this.tempView.addFunctionRef(this.getText());
            }
        } else if (string3.equalsIgnoreCase("Attribute")) {
            this.tempView.addViewAttribute(this.tempViewAttribute);
        } else if (this.stack.search("AttributeProps") != -1) {
            if (string3.equalsIgnoreCase("Type")) {
                this.tempViewAttribute.setType(this.getText());
            } else if (string3.equalsIgnoreCase("Physical_Name")) {
                this.tempViewAttribute.setPhysicalName(this.getText());
            } else if (string3.equalsIgnoreCase("Hide_In_Logical")) {
                this.tempViewAttribute.setHideInLogical(this.getText());
            } else if (string3.equalsIgnoreCase("Parent_Attribute_Ref")) {
                this.tempViewAttribute.setParentAttrRef(this.getText());
            } else if (string3.equalsIgnoreCase("Parent_Relationship_Ref")) {
                this.tempViewAttribute.setParentRelRef(this.getText());
            } else if (string3.equalsIgnoreCase("Parent_Domain_Ref")) {
                this.tempViewAttribute.setParentDomRef(this.getText());
            } else if (string3.equalsIgnoreCase("Logical_Data_Type")) {
                this.tempViewAttribute.setLogicalDatatype(this.getText());
            } else if (string3.equalsIgnoreCase("Physical_Data_Type")) {
                this.tempViewAttribute.setPhysicalDatatype(this.getText());
            } else if (string3.equalsIgnoreCase("Definition")) {
                this.tempViewAttribute.setDefinition(this.getText());
            } else if (string3.equalsIgnoreCase("Null_Option_Type")) {
                this.tempViewAttribute.setNullOptionType(this.getText());
            } else if (string3.equalsIgnoreCase("Font_Ref")) {
                this.tempViewAttribute.setFontRef(this.getText());
            } else if (string3.equalsIgnoreCase("Font_Color")) {
                this.tempViewAttribute.setFontColor(this.getText());
            } else if (string3.equalsIgnoreCase("Comment") || string3.equalsIgnoreCase("Note")) {
                this.tempViewAttribute.setComment(this.getText());
            } else if (string3.equalsIgnoreCase("View_Expression")) {
                this.tempViewAttribute.setViewExpression(this.getText());
            }
        } else if (string3.equalsIgnoreCase("Trigger")) {
            this.tempView.addViewTrigger(this.tempViewTrigger);
        } else if (this.stack.search("TriggerProps") != -1) {
            if (string3.equalsIgnoreCase("Definition")) {
                this.tempViewTrigger.setDefinition(this.getText());
            } else if (string3.equalsIgnoreCase("Schema_Name")) {
                this.tempViewTrigger.setSchemaName(this.getText());
            } else if (string3.equalsIgnoreCase("Type")) {
                this.tempViewTrigger.setType(this.getText());
            } else if (string3.equalsIgnoreCase("Trigger_Status")) {
                this.tempViewTrigger.setStatus(this.getText());
            } else if (string3.equalsIgnoreCase("Trigger_Fire_Type")) {
                this.tempViewTrigger.setFireType(this.getText());
            } else if (string3.equalsIgnoreCase("Trigger_Scope")) {
                this.tempViewTrigger.setScope(this.getText());
            } else if (string3.equalsIgnoreCase("Trigger_Old")) {
                this.tempViewTrigger.setOldAs(this.getText());
            } else if (string3.equalsIgnoreCase("Trigger_New")) {
                this.tempViewTrigger.setNewAs(this.getText());
            } else if (string3.equalsIgnoreCase("Trigger_Body")) {
                this.tempViewTrigger.setBody(this.getText());
            }
        }
    }

    private void parseView() {
        Object object;
        if (this.createLogical && !"true".equalsIgnoreCase(this.tempView.getPhysicalOnly()) && !"true".equalsIgnoreCase(this.tempView.getHideInLogical()) && !"".equalsIgnoreCase(this.tempView.getName()) && "17".equalsIgnoreCase(this.tempView.getType())) {
            object = this.logical.getEntityViewSet().createEntityView(this.deriveObjectID(ID_PREFIX_ENTITY_VIEW, this.tempViewID));
            ((DesignObject)object).setName(this.tempView.getName());
            this.logicalObjects.put(this.tempViewID, object);
            if (!"".equals(this.tempView.getDefinition())) {
                ((ModelIDObject)object).setComment(this.tempView.getDefinition());
            }
            if (!"".equals(this.tempView.getComment())) {
                ((ModelIDObject)object).setNotes(this.tempView.getComment());
            }
            this.setFontAndColor((DesignObject)object, this.tempView.getBgColorVal(), this.tempView.getOutlineColorVal(), this.tempView.getNameFontID(), this.tempView.getNameColorVal());
            this.logicalViews2.add(this.tempView);
        }
        if (this.createRelational && !"true".equalsIgnoreCase(this.tempView.getLogicalOnly()) && !"true".equalsIgnoreCase(this.tempView.getHideInPhysical()) && !"".equalsIgnoreCase(this.tempView.getName())) {
            object = this.tempView.getName();
            if (!"".equalsIgnoreCase(this.tempView.getPhysicalName())) {
                object = this.tempView.getPhysicalName();
            }
            if ("17".equalsIgnoreCase(this.tempView.getType())) {
                TableView tableView = this.relational.getTableViewSet().createTableView(this.deriveObjectID(ID_PREFIX_TABLE_VIEW, this.tempViewID));
                tableView.setName((String)object);
                this.relationalObjects.put(this.tempViewID, tableView);
                if (!"".equals(this.tempView.getSchemaName())) {
                    this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempView.getSchemaName(), tableView));
                }
                if (!"".equals(this.tempView.getDefinition())) {
                    tableView.setComment(this.tempView.getDefinition());
                }
                if (!"".equals(this.tempView.getComment())) {
                    tableView.setNotes(this.tempView.getComment());
                }
                if (!"".equals(this.tempView.getSQL())) {
                    tableView.setUserDefinedSQL(this.tempView.getSQL());
                }
                this.setFontAndColor(tableView, this.tempView.getBgColorVal(), this.tempView.getOutlineColorVal(), this.tempView.getNameFontID(), this.tempView.getNameColorVal());
                this.relationalViews2.add(this.tempView);
                if (this.oracleStorage != null) {
                    TableViewProxyOracle tableViewProxyOracle = (TableViewProxyOracle)this.oracleStorage.getTableViewProxySet().getProxy(tableView.getObjectID());
                    if (tableViewProxyOracle != null && !"".equals(this.tempView.getSchemaName())) {
                        this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempView.getSchemaName(), tableViewProxyOracle));
                    }
                    for (Object object2 : this.tempView.getViewTriggers()) {
                        Object object3 = this.oracleStorage.getTriggerSet().createTrigger(this.deriveObjectID(ID_PREFIX_TRIGGER, ((TempTrigger)object2).getID()));
                        ((StorageObject)object3).setName(((TempTrigger)object2).getName());
                        ((TriggerOracle)object3).setView(tableViewProxyOracle);
                        this.parseTrigger((TempTrigger)object2, (TriggerOracle)object3);
                        if ("".equals(((TempTrigger)object2).getSchemaName())) continue;
                        this.schemaWaitingList.add(new SchemaWaitingListEntry(((TempTrigger)object2).getSchemaName(), object3));
                    }
                    for (Object object3 : this.tempView.getStoredProcedureRefs()) {
                        this.storedProcedureWaitingList.add(new StoredProcedureWaitingListEntry((String)object3, tableViewProxyOracle));
                    }
                    for (String string : this.tempView.getFunctionRefs()) {
                        this.functionWaitingList.add(new FunctionWaitingListEntry(string, tableViewProxyOracle));
                    }
                }
            }
        }
    }

    private void parseEntityViews2() {
        for (TempView tempView : this.logicalViews2) {
            String string = tempView.getID();
            EntityView entityView = (EntityView)this.logicalObjects.get(string);
            if (entityView == null) continue;
            this.parseViewAttributes2(tempView, entityView);
        }
    }

    private void parseTableViews2() {
        for (TempView tempView : this.relationalViews2) {
            String string = tempView.getID();
            TableView tableView = (TableView)this.relationalObjects.get(string);
            if (tableView == null) continue;
            this.parseViewColumns2(tempView, tableView);
        }
    }

    private void parseViewAttributes2(TempView tempView, EntityView entityView) {
        for (TempViewAttribute tempViewAttribute : tempView.getViewAttributes()) {
            Attribute attribute;
            String string = tempViewAttribute.getID();
            if ("true".equalsIgnoreCase(tempViewAttribute.getHideInLogical())) continue;
            AttributeView attributeView = (AttributeView)entityView.createContainedObject(this.deriveObjectID(ID_PREFIX_ATTRIBUTE_VIEW, string));
            attributeView.setName(tempViewAttribute.getName());
            if (!"".equals(tempViewAttribute.getViewExpression())) {
                attributeView.setExpression(tempViewAttribute.getViewExpression());
                attributeView.setEntityAlias(entityView.getName());
            } else if (!"".equals(tempViewAttribute.getParentAttrRef()) && (attribute = (Attribute)this.logicalObjects.get(tempViewAttribute.getParentAttrRef())) != null) {
                attributeView.setReferencedAttribute(attribute);
                attributeView.setDataType(attribute.getDataType().toString());
                attributeView.setEntity((Entity)attribute.getContainer());
                entityView.addToContainers(attribute.getContainer(), attribute.getContainer().getName());
            }
            this.setAttributeFontAndColor(entityView, tempViewAttribute.getFontRef(), tempViewAttribute.getFontColor(), true);
        }
    }

    private void parseViewColumns2(TempView tempView, TableView tableView) {
        for (TempViewAttribute tempViewAttribute : tempView.getViewAttributes()) {
            Column column;
            String string = tempViewAttribute.getID();
            if ("true".equalsIgnoreCase(tempViewAttribute.getHideInPhysical())) continue;
            ColumnView columnView = (ColumnView)tableView.createContainedObject(this.deriveObjectID(ID_PREFIX_COLUMN_VIEW, string));
            if (!"".equals(tempViewAttribute.getPhysicalName())) {
                columnView.setName(tempViewAttribute.getPhysicalName());
            } else {
                columnView.setName(tempViewAttribute.getName());
            }
            if (!"".equals(tempViewAttribute.getViewExpression())) {
                columnView.setExpression(tempViewAttribute.getViewExpression());
                columnView.setTableAlias(tableView.getName());
            } else if (!"".equals(tempViewAttribute.getParentAttrRef()) && (column = (Column)this.relationalObjects.get(tempViewAttribute.getParentAttrRef())) != null) {
                columnView.setReferencedColumn(column);
                columnView.setDataType(column.getDataType().toString());
                columnView.setTable((Table)column.getContainer());
                tableView.addToContainers(column.getContainer(), column.getContainer().getName());
            }
            this.setAttributeFontAndColor(tableView, tempViewAttribute.getFontRef(), tempViewAttribute.getFontColor(), false);
        }
    }

    private void startSequences(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("Sequence_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportSequences"), PROGRESS_INCREMENT);
        } else if (string3.equalsIgnoreCase("Sequence")) {
            this.tempSequenceID = attributes.getValue("id");
            this.tempSequence = new TempSequence(this.tempSequenceID, attributes.getValue("name"));
        }
    }

    private void endSequences(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Sequence")) {
            if (this.createRelational) {
                this.parseSequence();
            }
        } else if (string3.equalsIgnoreCase("Schema_Name")) {
            this.tempSequence.setSchemaName(this.getText());
        } else if (string3.equalsIgnoreCase("Definition")) {
            this.tempSequence.setDefinition(this.getText());
        } else if (string3.equalsIgnoreCase("Increment_By")) {
            this.tempSequence.setIncrementBy(this.getText());
        } else if (string3.equalsIgnoreCase("Cache_Capacity")) {
            this.tempSequence.setCacheCapacity(this.getText());
        } else if (string3.equalsIgnoreCase("Is_Cache_On")) {
            this.tempSequence.setIsCacheOn(this.getText());
        } else if (string3.equalsIgnoreCase("Is_Cycle_On")) {
            this.tempSequence.setIsCycleOn(this.getText());
        } else if (string3.equalsIgnoreCase("Is_Max")) {
            this.tempSequence.setIsMax(this.getText());
        } else if (string3.equalsIgnoreCase("Is_Min")) {
            this.tempSequence.setIsMin(this.getText());
        } else if (string3.equalsIgnoreCase("Max_Value")) {
            this.tempSequence.setMaxValue(this.getText());
        } else if (string3.equalsIgnoreCase("Min_Value")) {
            this.tempSequence.setMinValue(this.getText());
        } else if (string3.equalsIgnoreCase("Order_On")) {
            this.tempSequence.setOrderOn(this.getText());
        } else if (string3.equalsIgnoreCase("Starting_Value")) {
            this.tempSequence.setStartingValue(this.getText());
        }
    }

    private void parseSequence() {
        if (this.oracleStorage != null) {
            SequenceOracle sequenceOracle = this.oracleStorage.getSequenceSet().createSequence(this.deriveObjectID(ID_PREFIX_SEQUENCE, this.tempSequenceID));
            sequenceOracle.setName(this.tempSequence.getName());
            if (!"".equals(this.tempSequence.getDefinition())) {
                sequenceOracle.setComment(this.tempSequence.getDefinition());
            }
            if (!"".equals(this.tempSequence.getStartingValue())) {
                sequenceOracle.setStartWith(this.tempSequence.getStartingValue());
            }
            if (!"".equals(this.tempSequence.getIncrementBy())) {
                sequenceOracle.setIncrementBy(this.tempSequence.getIncrementBy());
            }
            if ("true".equalsIgnoreCase(this.tempSequence.getIsMax()) && !"".equals(this.tempSequence.getMaxValue())) {
                sequenceOracle.setMaxValue(this.tempSequence.getMaxValue());
            }
            if ("true".equalsIgnoreCase(this.tempSequence.getIsMin()) && !"".equals(this.tempSequence.getMinValue())) {
                sequenceOracle.setMinValue(this.tempSequence.getMinValue());
            }
            if ("true".equalsIgnoreCase(this.tempSequence.getIsCycleOn())) {
                sequenceOracle.setCycle("YES");
            } else {
                sequenceOracle.setCycle("NO");
            }
            if ("true".equalsIgnoreCase(this.tempSequence.getIsCacheOn())) {
                sequenceOracle.setNoCache("NO");
            } else {
                sequenceOracle.setNoCache("YES");
            }
            if (!"".equals(this.tempSequence.getCacheCapacity())) {
                sequenceOracle.setCache(this.tempSequence.getCacheCapacity());
            }
            if ("true".equalsIgnoreCase(this.tempSequence.getOrderOn())) {
                sequenceOracle.setOrder("YES");
            } else {
                sequenceOracle.setOrder("NO");
            }
            if (!"".equals(this.tempSequence.getSchemaName())) {
                this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempSequence.getSchemaName(), sequenceOracle));
            }
        }
    }

    private void startFonts(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("Font_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportFonts"), PROGRESS_INCREMENT);
            this.fonts = new TreeMap();
        } else if (string3.equalsIgnoreCase("Font")) {
            this.tempFontID = attributes.getValue("id");
            this.tempFont = new TempFont(this.tempFontID, attributes.getValue("name"));
        }
    }

    private void endFonts(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Font")) {
            Font font = new Font(this.tempFont.getName(), this.tempFont.getStyle(), this.tempFont.getSize());
            this.fonts.put(this.tempFontID, font);
        } else if (string3.equalsIgnoreCase("Font_Size")) {
            try {
                this.tempFont.setSize(Integer.parseInt(this.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string3.equalsIgnoreCase("Is_Font_Bold")) {
            if ("true".equalsIgnoreCase(this.getText())) {
                this.tempFont.setStyle(this.tempFont.getStyle() | 1);
            }
        } else if (string3.equalsIgnoreCase("Is_Font_Italic") && "true".equalsIgnoreCase(this.getText())) {
            this.tempFont.setStyle(this.tempFont.getStyle() | 2);
        }
    }

    private void startDefaultFontsAndColors(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("Default_Fonts_And_Colors_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportDefaultFontsAndColors"), PROGRESS_INCREMENT);
        } else if (string3.equalsIgnoreCase("Default_Fonts_And_Colors")) {
            this.defaultNameFontID = "";
            this.defaultNameColor = "";
            this.defaultFillColor = "";
            this.defaultOutlineColor = "";
            this.defaultAttributeFontID = "";
            this.defaultAttributeColor = "";
        }
    }

    private void endDefaultFontsAndColors(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Default_Entity_Name_Font_Ref")) {
            this.defaultNameFontID = this.getText();
        } else if (string3.equalsIgnoreCase("Default_Entity_Name_Color")) {
            this.defaultNameColor = this.getText();
        } else if (string3.equalsIgnoreCase("Default_Entity_Fill_Color")) {
            this.defaultFillColor = this.getText();
        } else if (string3.equalsIgnoreCase("Default_Entity_Outline_Color")) {
            this.defaultOutlineColor = this.getText();
        } else if (string3.equalsIgnoreCase("Default_Owned_Attribute_Font_Ref")) {
            this.defaultAttributeFontID = this.getText();
        } else if (string3.equalsIgnoreCase("Default_Owned_Attribute_Color")) {
            this.defaultAttributeColor = this.getText();
        }
    }

    private void startOraclePackages(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("Oracle_Package_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportOraclePackages"), PROGRESS_INCREMENT);
        } else if (string3.equalsIgnoreCase("Oracle_Package")) {
            this.tempOraclePackageID = attributes.getValue("id");
            this.tempOraclePackage = new TempPLSQLSource(this.tempOraclePackageID, attributes.getValue("name"));
        }
    }

    private void endOraclePackages(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Oracle_Package")) {
            if (this.oracleStorage != null) {
                this.parseOraclePackage();
            }
        } else if (string3.equalsIgnoreCase("Definition")) {
            this.tempOraclePackage.setDefinition(this.getText());
        } else if (string3.equalsIgnoreCase("Schema_Name")) {
            this.tempOraclePackage.setSchemaName(this.getText());
        } else if (string3.equalsIgnoreCase("Type")) {
            this.tempOraclePackage.setType(this.getText());
        } else if (string3.equalsIgnoreCase("Template_Code")) {
            this.tempOraclePackage.setCodeKeyword("PACKAGE BODY");
            this.tempOraclePackage.setTemplateCode(this.getText());
        } else if (string3.equalsIgnoreCase("Template_Specification")) {
            this.tempOraclePackage.setSpecKeyword("PACKAGE");
            this.tempOraclePackage.setTemplateSpec(this.getText());
        }
    }

    private void parseOraclePackage() {
        PackageOracle packageOracle = (PackageOracle)this.oracleStorage.getPackageSet().createElement(this.deriveObjectID(ID_PREFIX_PACKAGE, this.tempOraclePackageID));
        if (!"".equals(this.tempOraclePackage.getTemplateSpec())) {
            packageOracle.setSource(this.tempOraclePackage.getTemplateSpec());
        }
        if (!"".equals(this.tempOraclePackage.getTemplateCode())) {
            packageOracle.setBodySource(this.tempOraclePackage.getTemplateCode());
        }
        packageOracle.setName(this.tempOraclePackage.getName());
        if (!"".equals(this.tempOraclePackage.getDefinition())) {
            packageOracle.setComment(this.tempOraclePackage.getDefinition());
        }
        if (!"".equals(this.tempOraclePackage.getSchemaName())) {
            this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempOraclePackage.getSchemaName(), packageOracle));
        }
    }

    private void startFunctions(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("Function_Groups")) {
            this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportFunctions"), PROGRESS_INCREMENT);
        } else if (string3.equalsIgnoreCase("Function")) {
            this.tempFunctionID = attributes.getValue("id");
            this.tempFunction = new TempPLSQLSource(this.tempFunctionID, attributes.getValue("name"));
        }
    }

    private void endFunctions(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Function")) {
            if (this.oracleStorage != null) {
                this.parseFunction();
            }
        } else if (string3.equalsIgnoreCase("Definition")) {
            this.tempFunction.setDefinition(this.getText());
        } else if (string3.equalsIgnoreCase("Schema_Name")) {
            this.tempFunction.setSchemaName(this.getText());
        } else if (string3.equalsIgnoreCase("Type")) {
            this.tempFunction.setType(this.getText());
        } else if (string3.equalsIgnoreCase("Template_Code")) {
            this.tempFunction.setCodeKeyword("FUNCTION");
            this.tempFunction.setTemplateCode(this.getText());
        }
    }

    private void parseFunction() {
        FunctionOracle functionOracle = (FunctionOracle)this.oracleStorage.getFunctionSet().createElement(this.deriveObjectID(ID_PREFIX_FUNCTION, this.tempFunctionID));
        if (!"".equals(this.tempFunction.getTemplateCode())) {
            functionOracle.setSource(this.tempFunction.getTemplateCode());
        }
        functionOracle.setName(this.tempFunction.getName());
        if (!"".equals(this.tempFunction.getDefinition())) {
            functionOracle.setComment(this.tempFunction.getDefinition());
        }
        if (!"".equals(this.tempFunction.getSchemaName())) {
            this.schemaWaitingList.add(new SchemaWaitingListEntry(this.tempFunction.getSchemaName(), functionOracle));
        }
        this.functions.put(this.tempFunctionID, functionOracle);
    }

    private void startTransformScratchObjects(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("Transform_Scratch_Object_Groups")) {
            if (this.scratchGroupStack.isEmpty()) {
                this.monitorProgress(Messages.getString("ERSAXParserv7x.ImportTransformScratchObjects"), PROGRESS_INCREMENT);
            }
            this.scratchGroupStack.push(attributes.getValue("id"));
        } else if (string3.equalsIgnoreCase("Transform_Scratch_Object")) {
            this.tempScratchObjectID = attributes.getValue("id");
            this.tempScratchObject = new TempScratchObject(this.tempScratchObjectID, attributes.getValue("name"));
            if (!this.scratchObjectStack.isEmpty()) {
                String string4 = (String)this.scratchObjectStack.peek();
                this.tempScratchObject.setParentRef(string4);
                TempScratchObject tempScratchObject = (TempScratchObject)this.scratchObjects.get(string4);
                tempScratchObject.addChildRef(this.tempScratchObjectID);
            }
            this.scratchObjects.put(this.tempScratchObjectID, this.tempScratchObject);
            this.scratchObjectStack.push(this.tempScratchObjectID);
        }
    }

    private void endTransformScratchObjects(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("Transform_Scratch_Object_Groups")) {
            this.scratchGroupStack.pop();
            if (this.scratchGroupStack.isEmpty()) {
                this.parseInheritanceRelations();
            }
        } else if (string3.equalsIgnoreCase("Transform_Scratch_Object")) {
            Domain domain;
            if (this.tempScratchObject.getName().equalsIgnoreCase("%AttDomain") && !"".equals(this.tempScratchObject.getParentDomainRef()) && !this.domains.isEmpty() && (domain = (Domain)this.domains.get(this.tempScratchObject.getParentDomainRef())) != null) {
                this.tempScratchObject.setName(domain.getName());
            }
            if (this.tempScratchObject.getSourceOfTransforms().isEmpty() && this.tempScratchObject.getTargetOfTransforms().isEmpty()) {
                this.scratchObjects.remove(this.tempScratchObjectID);
            }
            this.scratchObjectStack.pop();
            if (this.scratchObjectStack.isEmpty()) {
                this.parseScratchObject(this.tempScratchObject);
            } else {
                this.tempScratchObjectID = (String)this.scratchObjectStack.peek();
                this.tempScratchObject = (TempScratchObject)this.scratchObjects.get(this.tempScratchObjectID);
            }
        } else if (string3.equalsIgnoreCase("Source_Of_Transforms_Ref")) {
            this.tempScratchObject.addSourceOfTransform(this.getText());
        } else if (string3.equalsIgnoreCase("Target_Of_Transforms_Ref")) {
            this.tempScratchObject.addTargetOfTransform(this.getText());
        } else if (string3.equalsIgnoreCase("Type")) {
            this.tempScratchObject.setType(this.getText());
        } else if (string3.equalsIgnoreCase("Physical_Name")) {
            this.tempScratchObject.setPhysicalName(this.getText());
        } else if (string3.equalsIgnoreCase("Parent_To_Child_Verb_Phrase")) {
            this.tempScratchObject.setParentToChildVerbPhrase(this.getText());
        } else if (string3.equalsIgnoreCase("Child_To_Parent_Verb_Phrase")) {
            this.tempScratchObject.setChildToParentVerbPhrase(this.getText());
        } else if (string3.equalsIgnoreCase("Cardinality")) {
            this.tempScratchObject.setCardinality(this.getText());
        } else if (string3.equalsIgnoreCase("Null_Option_Type")) {
            this.tempScratchObject.setNullOptionType(this.getText());
        } else if (string3.equalsIgnoreCase("Logical_Data_Type")) {
            this.tempScratchObject.setLogicalDataType(this.getText());
        } else if (string3.equalsIgnoreCase("Physical_Data_Type")) {
            this.tempScratchObject.setPhysicalDataType(this.getText());
        } else if (string3.equalsIgnoreCase("Parent_Domain_Ref")) {
            this.tempScratchObject.setParentDomainRef(this.getText());
        } else if (string3.equalsIgnoreCase("Parent_Entity_Ref")) {
            this.tempScratchObject.setParentEntityRef(this.getText());
        } else if (string3.equalsIgnoreCase("Child_Entity_Ref")) {
            this.tempScratchObject.setChildEntityRef(this.getText());
        } else if (string3.equalsIgnoreCase("Key_Group_Ref")) {
            this.tempScratchObject.setKeyGroupRef(this.getText());
        } else if (string3.equalsIgnoreCase("Scratch_Parent_Entity_Ref")) {
            this.tempScratchObject.setScratchParentEntityRef(this.getText());
        } else if (string3.equalsIgnoreCase("Scratch_Child_Entity_Ref")) {
            this.tempScratchObject.setScratchChildEntityRef(this.getText());
        } else if (string3.equalsIgnoreCase("Scratch_Key_Group_Ref")) {
            this.tempScratchObject.setScratchKeyGroupRef(this.getText());
        } else if (string3.equalsIgnoreCase("Key_Group_Type")) {
            this.tempScratchObject.setKeyGroupType(this.getText());
        }
    }

    private void parseScratchObject(TempScratchObject tempScratchObject) {
        boolean bl;
        boolean bl2 = !tempScratchObject.getSourceOfTransforms().isEmpty();
        boolean bl3 = bl = !tempScratchObject.getTargetOfTransforms().isEmpty();
        if (bl2 || bl) {
            if ("9".equalsIgnoreCase(tempScratchObject.getType())) {
                String string = tempScratchObject.getScratchParentEntityRef();
                String string2 = tempScratchObject.getScratchChildEntityRef();
                if (!"".equals(string) && !"".equals(string2)) {
                    IHObject iHObject = new IHObject(tempScratchObject.getID(), tempScratchObject.getName(), string, string2);
                    if (!"".equals(tempScratchObject.getPhysicalName())) {
                        iHObject.setPhysicalName(tempScratchObject.getPhysicalName());
                    }
                    this.inheritanceObjects.add(iHObject);
                }
            } else if ("2".equalsIgnoreCase(tempScratchObject.getType()) || "4".equalsIgnoreCase(tempScratchObject.getType()) || "7".equalsIgnoreCase(tempScratchObject.getType())) {
                if (bl2) {
                    this.createRelationFromScratch(tempScratchObject);
                } else {
                    this.createForeignKeyFromScratch(tempScratchObject);
                }
            } else if (!"3".equalsIgnoreCase(tempScratchObject.getType()) && "".equals(tempScratchObject.getType())) {
                if (bl2) {
                    this.createEntityFromScratch(tempScratchObject);
                } else {
                    this.createTableFromScratch(tempScratchObject);
                }
            }
        }
    }

    private void createEntityFromScratch(TempScratchObject tempScratchObject) {
        if (this.createLogical) {
            Entity entity = this.logical.getEntitySet().createEntity(this.deriveObjectID(ID_PREFIX_ENTITY, tempScratchObject.getID()));
            entity.setName(tempScratchObject.getName());
            this.logicalObjects.put(tempScratchObject.getID(), entity);
            this.createAttributesFromScratch(tempScratchObject, entity);
            this.createKeysFromScratch(tempScratchObject, entity);
            this.setScratchFontAndColor(entity);
        }
    }

    private void createAttributesFromScratch(TempScratchObject tempScratchObject, Entity entity) {
        for (String string : tempScratchObject.getChildRefs()) {
            TempScratchObject tempScratchObject2 = (TempScratchObject)this.scratchObjects.get(string);
            if (tempScratchObject2 == null || "".equals(tempScratchObject2.getType()) || "1".equalsIgnoreCase(tempScratchObject2.getType())) continue;
            Attribute attribute = entity.createAttribute(tempScratchObject2.getName());
            attribute.setObjectID(this.deriveObjectID(ID_PREFIX_ATTRIBUTE, tempScratchObject2.getID()));
            this.logicalObjects.put(tempScratchObject2.getID(), attribute);
            boolean bl = false;
            if (!"".equals(tempScratchObject2.getLogicalDataType())) {
                bl = this.parseDataType(attribute, tempScratchObject2.getLogicalDataType());
            }
            if (!"".equals(tempScratchObject2.getParentDomainRef())) {
                if (this.domains.isEmpty()) {
                    this.domainWaitingList.add(new DomainWaitingListEntry(attribute, tempScratchObject2.getParentDomainRef(), bl));
                } else {
                    Domain domain = (Domain)this.domains.get(tempScratchObject2.getParentDomainRef());
                    if (!(domain == null || domain.getName().equalsIgnoreCase("<root>") || domain.getName().equalsIgnoreCase("<default>") || domain.getName().equalsIgnoreCase("<unknown>") || domain.getName().equalsIgnoreCase("Unknown") || bl)) {
                        attribute.setDomain(domain);
                        attribute.setUse((short)0);
                        if (!this.usedDomains.contains(domain.getObjectID())) {
                            this.usedDomains.add(domain.getObjectID());
                        }
                    }
                }
            }
            this.setScratchAttributeFontAndColor(attribute, true);
        }
    }

    private void createKeysFromScratch(TempScratchObject tempScratchObject, Entity entity) {
        for (String string : tempScratchObject.getChildRefs()) {
            TempScratchObject tempScratchObject2 = (TempScratchObject)this.scratchObjects.get(string);
            if (tempScratchObject2 == null || "".equals(tempScratchObject2.getKeyGroupType()) || tempScratchObject2.getKeyGroupType().toUpperCase().startsWith("IF")) continue;
            CandidateKey candidateKey = entity.createCandidateKey(this.deriveObjectID(ID_PREFIX_CANDIDATE_KEY, string));
            candidateKey.setName(tempScratchObject2.getName());
            this.logicalObjects.put(string, candidateKey);
            for (String string2 : tempScratchObject.getChildRefs()) {
                Attribute attribute;
                TempScratchObject tempScratchObject3 = (TempScratchObject)this.scratchObjects.get(string2);
                if (tempScratchObject3 == null) continue;
                if ("0".equals(tempScratchObject3.getType()) && tempScratchObject2.getKeyGroupType().equalsIgnoreCase("PK")) {
                    attribute = (Attribute)this.logicalObjects.get(string2);
                    if (attribute == null) continue;
                    candidateKey.add(attribute);
                    continue;
                }
                if (!"100".equals(tempScratchObject3.getType()) || tempScratchObject2.getKeyGroupType().equalsIgnoreCase("PK") || (attribute = (Attribute)this.logicalObjects.get(string2)) == null) continue;
                candidateKey.add(attribute);
            }
            if (!tempScratchObject2.getKeyGroupType().equalsIgnoreCase("PK")) continue;
            candidateKey.makePK();
        }
    }

    private void createTableFromScratch(TempScratchObject tempScratchObject) {
        if (this.createRelational) {
            Table table = this.relational.getTableSet().createTable(this.deriveObjectID(ID_PREFIX_TABLE, tempScratchObject.getID()));
            table.setName(tempScratchObject.getName());
            this.relationalObjects.put(tempScratchObject.getID(), table);
            this.createColumnsFromScratch(tempScratchObject, table);
            this.createIndexesFromScratch(tempScratchObject, table);
            this.setScratchFontAndColor(table);
        }
    }

    private void createColumnsFromScratch(TempScratchObject tempScratchObject, Table table) {
        for (String string : tempScratchObject.getChildRefs()) {
            TempScratchObject tempScratchObject2 = (TempScratchObject)this.scratchObjects.get(string);
            if (tempScratchObject2 == null || "".equals(tempScratchObject2.getType()) || "1".equalsIgnoreCase(tempScratchObject2.getType())) continue;
            Column column = table.createColumn(tempScratchObject2.getName(), this.deriveObjectID(ID_PREFIX_COLUMN, tempScratchObject2.getID()));
            this.relationalObjects.put(tempScratchObject2.getID(), column);
            boolean bl = false;
            if (!"".equals(tempScratchObject2.getPhysicalDataType())) {
                bl = this.parsePhysicalDataType(column, tempScratchObject2.getPhysicalDataType());
            }
            if (!bl && !"".equals(tempScratchObject2.getLogicalDataType())) {
                bl = this.parseDataType(column, tempScratchObject2.getLogicalDataType());
            }
            if (!"".equals(tempScratchObject2.getParentDomainRef())) {
                if (this.domains.isEmpty()) {
                    this.domainWaitingList.add(new DomainWaitingListEntry(column, tempScratchObject2.getParentDomainRef(), bl));
                } else {
                    Domain domain = (Domain)this.domains.get(tempScratchObject2.getParentDomainRef());
                    if (!(domain == null || domain.getName().equalsIgnoreCase("<root>") || domain.getName().equalsIgnoreCase("<default>") || domain.getName().equalsIgnoreCase("<unknown>") || domain.getName().equalsIgnoreCase("Unknown") || bl)) {
                        column.setDomain(domain);
                        column.setUse((short)0);
                        if (!this.usedDomains.contains(domain.getObjectID())) {
                            this.usedDomains.add(domain.getObjectID());
                        }
                    }
                }
            }
            this.setScratchAttributeFontAndColor(column, false);
        }
    }

    private void createIndexesFromScratch(TempScratchObject tempScratchObject, Table table) {
        for (String string : tempScratchObject.getChildRefs()) {
            Object object2;
            TempScratchObject tempScratchObject2 = (TempScratchObject)this.scratchObjects.get(string);
            if (tempScratchObject2 == null || "".equals(tempScratchObject2.getKeyGroupType()) || tempScratchObject2.getKeyGroupType().toUpperCase().startsWith("IF")) continue;
            Index index = table.createIndex(this.deriveObjectID(ID_PREFIX_INDEX, string));
            index.setName(tempScratchObject2.getName());
            this.relationalObjects.put(string, index);
            for (Object object2 : tempScratchObject.getChildRefs()) {
                Column column;
                TempScratchObject tempScratchObject3 = (TempScratchObject)this.scratchObjects.get(object2);
                if (tempScratchObject3 == null) continue;
                if ("0".equals(tempScratchObject3.getType()) && tempScratchObject2.getKeyGroupType().equalsIgnoreCase("PK")) {
                    column = (Column)this.relationalObjects.get(object2);
                    if (column == null) continue;
                    index.add(column);
                    continue;
                }
                if (!"100".equals(tempScratchObject3.getType()) || tempScratchObject2.getKeyGroupType().equalsIgnoreCase("PK") || (column = (Column)this.relationalObjects.get(object2)) == null) continue;
                index.add(column);
            }
            if (tempScratchObject2.getKeyGroupType().equalsIgnoreCase("PK")) {
                index.makePK();
            } else if (tempScratchObject2.getKeyGroupType().toUpperCase().startsWith("AK")) {
                index.setIndexState("Unique Constraint");
            }
            if (this.oracleStorage == null || (object2 = (IndexProxyOracle)this.oracleStorage.getIndexProxySet().getProxy(index.getObjectID())) == null) continue;
            ((RelationalObjectProxy)object2).setName(tempScratchObject2.getName());
        }
    }

    private void createRelationFromScratch(TempScratchObject tempScratchObject) {
        if (this.createLogical) {
            String string = !"".equals(tempScratchObject.getParentEntityRef()) ? tempScratchObject.getParentEntityRef() : tempScratchObject.getScratchParentEntityRef();
            String string2 = !"".equals(tempScratchObject.getChildEntityRef()) ? tempScratchObject.getChildEntityRef() : tempScratchObject.getScratchChildEntityRef();
            DesignObject designObject = (DesignObject)this.logicalObjects.get(string);
            DesignObject designObject2 = (DesignObject)this.logicalObjects.get(string2);
            if (designObject != null && designObject2 != null && designObject instanceof Entity && designObject2 instanceof Entity) {
                TVRelation tVRelation;
                Relation relation = this.logical.getRelationSet().createRelation(this.deriveObjectID(ID_PREFIX_RELATION, tempScratchObject.getID()));
                if (!"".equals(tempScratchObject.getName())) {
                    relation.setName(tempScratchObject.getName());
                }
                relation.setSourceEntity((Entity)designObject);
                relation.setTargetEntity((Entity)designObject2);
                boolean bl = false;
                boolean bl2 = true;
                boolean bl3 = true;
                int n = 1;
                int n2 = 1;
                String string3 = tempScratchObject.getCardinality();
                if (!"".equals(tempScratchObject.getType()) && !"".equals(tempScratchObject.getCardinality())) {
                    if ("7".equals(tempScratchObject.getType())) {
                        bl = false;
                        bl3 = !"101".equals(tempScratchObject.getNullOptionType());
                        bl2 = !"-2".equals(tempScratchObject.getCardinality());
                        n2 = "-1".equals(tempScratchObject.getCardinality()) ? 1 : 0;
                    } else if ("2".equals(tempScratchObject.getType())) {
                        bl = true;
                        bl3 = false;
                        bl2 = !"-2".equals(tempScratchObject.getCardinality());
                        n = 1;
                        n2 = "-1".equals(tempScratchObject.getCardinality()) ? 1 : 0;
                    } else if ("4".equals(tempScratchObject.getType())) {
                        bl = false;
                        bl2 = true;
                        bl3 = true;
                        n = 0;
                        n2 = 0;
                    }
                    relation.setIdentifying(bl);
                    relation.setOptionalSource(bl2);
                    relation.setOptionalTarget(bl3);
                    relation.setFireCardinalityChange(false);
                    relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[n]);
                    relation.setFireCardinalityChange(true);
                    relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[n2]);
                    relation.setNameOnSource(tempScratchObject.getParentToChildVerbPhrase());
                    relation.setNameOnTarget(tempScratchObject.getChildToParentVerbPhrase());
                }
                if ((tVRelation = (TVRelation)relation.getTopView()) != null) {
                    tVRelation.addConnection();
                    tVRelation.resetEdgeParams();
                }
                this.logicalObjects.put(tempScratchObject.getID(), relation);
            }
        }
    }

    private void createForeignKeyFromScratch(TempScratchObject tempScratchObject) {
        if (this.createRelational) {
            String string;
            KeyObject keyObject;
            String string2 = !"".equals(tempScratchObject.getParentEntityRef()) ? tempScratchObject.getParentEntityRef() : tempScratchObject.getScratchParentEntityRef();
            String string3 = !"".equals(tempScratchObject.getChildEntityRef()) ? tempScratchObject.getChildEntityRef() : tempScratchObject.getScratchChildEntityRef();
            DesignObject designObject = (DesignObject)this.relationalObjects.get(string2);
            DesignObject designObject2 = (DesignObject)this.relationalObjects.get(string3);
            if (designObject != null && designObject2 != null && designObject instanceof Table && designObject2 instanceof Table && (keyObject = (KeyObject)this.relationalObjects.get(string = !"".equals(tempScratchObject.getKeyGroupRef()) ? tempScratchObject.getKeyGroupRef() : tempScratchObject.getScratchKeyGroupRef())) != null) {
                FKIndexAssociation fKIndexAssociation = ((Table)designObject2).addFK(keyObject);
                fKIndexAssociation.setObjectID(this.deriveObjectID(ID_PREFIX_FK_INDEX_ASSOCIATION, tempScratchObject.getID()));
                if (!"".equals(tempScratchObject.getPhysicalName())) {
                    fKIndexAssociation.setName(tempScratchObject.getPhysicalName());
                } else if (!"".equals(tempScratchObject.getName())) {
                    fKIndexAssociation.setName(tempScratchObject.getName());
                }
                this.relationalObjects.put(tempScratchObject.getID(), fKIndexAssociation);
            }
        }
    }

    private void initWaitingLists() {
        this.domainWaitingList = new ArrayList();
        this.schemaWaitingList = new ArrayList();
        this.storedProcedureWaitingList = new ArrayList();
        this.functionWaitingList = new ArrayList();
        this.tablespaceWaitingList = new ArrayList();
        this.defaultValueWaitingList = new ArrayList();
        this.validationRuleWaitingList = new ArrayList();
        this.fontWaitingList = new ArrayList();
        this.transformWaitingList = new ArrayList();
    }

    private void resolveWaitingLists() {
        this.resolveDomainWaitingList();
        this.resolveSchemaWaitingList();
        this.resolveStoredProcedureWaitingList();
        this.resolveFunctionWaitingList();
        this.resolveTablespaceWaitingList();
        this.resolveDefaultValueWaitingList();
        this.resolveValidationRuleWaitingList();
        this.resolveFontWaitingList();
        this.resolveTransformWaitingList();
    }

    private void resolveDomainWaitingList() {
        for (Object object : this.domainWaitingList) {
            Domain domain = (Domain)this.domains.get(((DomainWaitingListEntry)object).getParentDomainRef());
            if (domain == null || domain.getName().equalsIgnoreCase("<root>") || domain.getName().equalsIgnoreCase("<default>") || domain.getName().equalsIgnoreCase("<unknown>") || domain.getName().equalsIgnoreCase("Unknown")) continue;
            ContainedObjectWithDomain containedObjectWithDomain = (ContainedObjectWithDomain)((DomainWaitingListEntry)object).getDesignObject();
            if (((DomainWaitingListEntry)object).isDatatypeOK()) continue;
            containedObjectWithDomain.setDomain(domain);
            containedObjectWithDomain.setUse((short)0);
            if (this.usedDomains.contains(domain.getObjectID())) continue;
            this.usedDomains.add(domain.getObjectID());
        }
        for (Object object : this.domains.values()) {
            if (this.usedDomains.contains(((ModelIDObject)object).getObjectID())) continue;
            this.design.getDomainSet().remove((DesignObject)object);
        }
    }

    private void resolveSchemaWaitingList() {
        for (Object object : this.schemaWaitingList) {
            Object object2 = ((SchemaWaitingListEntry)object).getDesignObject();
            if (object2 == null || !(object2 instanceof Table) && !(object2 instanceof TableView) && !(object2 instanceof Index)) continue;
            this.parseSchema(((SchemaWaitingListEntry)object).getSchemaName(), (DesignObject)object2);
        }
        for (Object object2 : this.schemaWaitingList) {
            Object object = ((SchemaWaitingListEntry)object2).getProxyObject();
            if (object == null || !(object instanceof TableProxyOracle) && !(object instanceof TableViewProxyOracle) && !(object instanceof IndexProxyOracle)) continue;
            this.parseProxySchema(((SchemaWaitingListEntry)object2).getSchemaName(), (RelationalObjectProxy)object);
        }
        for (Object object : this.schemaWaitingList) {
            StorageObject storageObject = ((SchemaWaitingListEntry)object).getStorageObject();
            if (storageObject == null || !(storageObject instanceof SequenceOracle) && !(storageObject instanceof TriggerOracle) && !(storageObject instanceof StoredProcedureOracle) && !(storageObject instanceof PackageOracle) && !(storageObject instanceof FunctionOracle)) continue;
            this.parseStorageSchema(((SchemaWaitingListEntry)object).getSchemaName(), storageObject);
        }
    }

    private void resolveStoredProcedureWaitingList() {
        for (StoredProcedureWaitingListEntry storedProcedureWaitingListEntry : this.storedProcedureWaitingList) {
            StoredProcedureOracle storedProcedureOracle = (StoredProcedureOracle)this.storedProcedures.get(storedProcedureWaitingListEntry.getStoredProcedureRef());
            RelationalObjectProxy relationalObjectProxy = storedProcedureWaitingListEntry.getObjectProxy();
            if (storedProcedureOracle != null && relationalObjectProxy != null && !(relationalObjectProxy instanceof TableProxyOracle) && !(relationalObjectProxy instanceof TableViewProxyOracle)) continue;
        }
    }

    private void resolveFunctionWaitingList() {
        for (FunctionWaitingListEntry functionWaitingListEntry : this.functionWaitingList) {
            FunctionOracle functionOracle = (FunctionOracle)this.functions.get(functionWaitingListEntry.getFunctionRef());
            RelationalObjectProxy relationalObjectProxy = functionWaitingListEntry.getObjectProxy();
            if (functionOracle != null && relationalObjectProxy != null && !(relationalObjectProxy instanceof TableProxyOracle) && !(relationalObjectProxy instanceof TableViewProxyOracle)) continue;
        }
    }

    private void resolveTablespaceWaitingList() {
        for (TablespaceWaitingListEntry tablespaceWaitingListEntry : this.tablespaceWaitingList) {
            PartitionListOracle partitionListOracle;
            ListStorageTemplatePartitionOracle listStorageTemplatePartitionOracle;
            ListPartitionOracle listPartitionOracle;
            HashPartitionOracle hashPartitionOracle;
            PartitionOracle partitionOracle;
            IndexProxyOracle indexProxyOracle;
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)this.tablespaces.get(tablespaceWaitingListEntry.getTablespaceRef());
            if (tableSpaceOracle == null) continue;
            TableProxyOracle tableProxyOracle = tablespaceWaitingListEntry.getTableProxy();
            if (tableProxyOracle != null) {
                tableProxyOracle.setTableSpace(tableSpaceOracle);
                tableSpaceOracle.addTable(tableProxyOracle);
            }
            if ((indexProxyOracle = tablespaceWaitingListEntry.getIndexProxy()) != null) {
                indexProxyOracle.setTableSpace(tableSpaceOracle);
            }
            if ((partitionOracle = tablespaceWaitingListEntry.getPartition()) != null) {
                partitionOracle.setTableSpace(tableSpaceOracle);
            }
            if ((hashPartitionOracle = tablespaceWaitingListEntry.getHashPartition()) != null) {
                hashPartitionOracle.setTableSpace(tableSpaceOracle);
            }
            if ((listPartitionOracle = tablespaceWaitingListEntry.getListPartition()) != null) {
                listPartitionOracle.setTablespace(tableSpaceOracle);
            }
            if ((listStorageTemplatePartitionOracle = tablespaceWaitingListEntry.getSubListPartition()) != null) {
                listStorageTemplatePartitionOracle.setTablespace(tableSpaceOracle);
            }
            if ((partitionListOracle = tablespaceWaitingListEntry.getPartitionList()) == null) continue;
            if ("HASH BY QUANTITY".equalsIgnoreCase(partitionListOracle.getPartitionType())) {
                partitionListOracle.setHashPTableSpaces(tableSpaceOracle.getObjectID());
                continue;
            }
            partitionListOracle.setSubPartitionsTableSpaces(tableSpaceOracle.getObjectID());
        }
    }

    private void resolveDefaultValueWaitingList() {
        for (DefaultValueWaitingListEntry defaultValueWaitingListEntry : this.defaultValueWaitingList) {
            String string = (String)this.defaultValues.get(defaultValueWaitingListEntry.getDefaultValueRef());
            if (string == null) continue;
            ContainedObjectWithDomain containedObjectWithDomain = (ContainedObjectWithDomain)defaultValueWaitingListEntry.getDesignObject();
            containedObjectWithDomain.setUsesDefaultValue(true);
            containedObjectWithDomain.setDefaultValue(string);
        }
    }

    private void resolveValidationRuleWaitingList() {
        for (ValidationRuleWaitingListEntry validationRuleWaitingListEntry : this.validationRuleWaitingList) {
            if (validationRuleWaitingListEntry.isTableLevel()) {
                ValidationRuleHolder validationRuleHolder = (ValidationRuleHolder)this.validationRules.get(validationRuleWaitingListEntry.getValidationRuleRef());
                if (validationRuleHolder == null || validationRuleHolder.getType() != 0) continue;
                Table table = (Table)validationRuleWaitingListEntry.getDesignObject();
                TableLevelConstraint tableLevelConstraint = table.createCheckConstraint(validationRuleHolder.getName(), validationRuleHolder.getRule());
                table.addCheckConstraint(tableLevelConstraint);
                continue;
            }
            ((ContainedObjectWithDomain)validationRuleWaitingListEntry.getDesignObject()).setUseDomainConstraints(false);
            this.applyValidationRule((ConstrainedObject)((Object)validationRuleWaitingListEntry.getDesignObject()), validationRuleWaitingListEntry.getValidationRuleRef());
        }
    }

    private void resolveFontWaitingList() {
        for (FontWaitingListEntry fontWaitingListEntry : this.fontWaitingList) {
            Object object;
            Font font = null;
            if (!"".equals(fontWaitingListEntry.getFontRef())) {
                font = (Font)this.fonts.get(fontWaitingListEntry.getFontRef());
            } else {
                object = "";
                object = fontWaitingListEntry.isAttribute() ? this.defaultAttributeFontID : this.defaultNameFontID;
                if (!"".equals(object)) {
                    font = (Font)this.fonts.get(object);
                }
            }
            if (font == null || !(fontWaitingListEntry.getDesignObject() instanceof EditableFonts)) continue;
            object = ((EditableFonts)((Object)fontWaitingListEntry.getDesignObject())).getFontObject(fontWaitingListEntry.getFontType());
            ((FontObject)object).setFont(font);
        }
    }

    private void resolveTransformWaitingList() {
        for (TransformWaitingListEntry transformWaitingListEntry : this.transformWaitingList) {
            TempRollUpTransform tempRollUpTransform = (TempRollUpTransform)this.rollUpTransforms.get(transformWaitingListEntry.getTransformRef());
            if (tempRollUpTransform == null) continue;
            boolean bl = transformWaitingListEntry.isSourceOfTransform();
            String string = bl ? transformWaitingListEntry.getDesignObjectRef() : transformWaitingListEntry.getScratchObjectRef();
            String string2 = bl ? transformWaitingListEntry.getScratchObjectRef() : transformWaitingListEntry.getDesignObjectRef();
            this.parseRollUpTransform(tempRollUpTransform, string, string2, bl);
        }
    }

    private void resolveSubjectAreas() {
        for (TempSubjectArea tempSubjectArea : this.subjectAreas) {
            this.parseSubjectArea(tempSubjectArea);
        }
    }

    private void resolveDesignModels() {
        DataTypesDesign dataTypesDesign = this.design.getDataTypesDesign();
        if (dataTypesDesign != null && dataTypesDesign.getMainView() != null) {
            dataTypesDesign.getMainView().setName(dataTypesDesign.getName());
        }
    }

    private class TransformWaitingListEntry {
        private boolean sourceOfTransform;
        private String transformRef;
        private String designObjectRef;
        private String scratchObjectRef;

        public TransformWaitingListEntry(boolean bl, String string, String string2) {
            this.sourceOfTransform = bl;
            this.transformRef = string;
            this.designObjectRef = string2;
            this.scratchObjectRef = "";
        }

        public boolean isSourceOfTransform() {
            return this.sourceOfTransform;
        }

        public String getTransformRef() {
            return this.transformRef;
        }

        public String getDesignObjectRef() {
            return this.designObjectRef;
        }

        public void setScratchObjectRef(String string) {
            this.scratchObjectRef = string;
        }

        public String getScratchObjectRef() {
            return this.scratchObjectRef;
        }
    }

    private class FontWaitingListEntry {
        private DesignObject designObject;
        private String fontRef;
        private String fontType;
        private boolean isAttribute;

        public FontWaitingListEntry(DesignObject designObject, String string, String string2, boolean bl) {
            this.designObject = designObject;
            this.fontRef = string;
            this.fontType = string2;
            this.isAttribute = bl;
        }

        public DesignObject getDesignObject() {
            return this.designObject;
        }

        public String getFontRef() {
            return this.fontRef;
        }

        public String getFontType() {
            return this.fontType;
        }

        public boolean isAttribute() {
            return this.isAttribute;
        }
    }

    private class ValidationRuleWaitingListEntry {
        private DesignObject designObject;
        private String validationRuleRef;
        private boolean isTableLevel;

        public ValidationRuleWaitingListEntry(DesignObject designObject, String string, boolean bl) {
            this.designObject = designObject;
            this.validationRuleRef = string;
            this.isTableLevel = bl;
        }

        public DesignObject getDesignObject() {
            return this.designObject;
        }

        public String getValidationRuleRef() {
            return this.validationRuleRef;
        }

        public boolean isTableLevel() {
            return this.isTableLevel;
        }
    }

    private class DefaultValueWaitingListEntry {
        private DesignObject designObject;
        private String defaultValueRef;

        public DefaultValueWaitingListEntry(DesignObject designObject, String string) {
            this.designObject = designObject;
            this.defaultValueRef = string;
        }

        public DesignObject getDesignObject() {
            return this.designObject;
        }

        public String getDefaultValueRef() {
            return this.defaultValueRef;
        }
    }

    private class TablespaceWaitingListEntry {
        private String tablespaceRef;
        private TableProxyOracle tableProxy;
        private IndexProxyOracle indexProxy;
        private PartitionOracle partition;
        private HashPartitionOracle hashPartition;
        private ListPartitionOracle listPartition;
        private ListStorageTemplatePartitionOracle subListPartition;
        private PartitionListOracle partitionList;

        public TablespaceWaitingListEntry(String string, Object object) {
            this.tablespaceRef = string;
            if (object instanceof TableProxyOracle) {
                this.tableProxy = (TableProxyOracle)object;
            } else if (object instanceof IndexProxyOracle) {
                this.indexProxy = (IndexProxyOracle)object;
            } else if (object instanceof PartitionOracle) {
                this.partition = (PartitionOracle)object;
            } else if (object instanceof HashPartitionOracle) {
                this.hashPartition = (HashPartitionOracle)object;
            } else if (object instanceof ListPartitionOracle) {
                this.listPartition = (ListPartitionOracle)object;
            } else if (object instanceof ListStorageTemplatePartitionOracle) {
                this.subListPartition = (ListStorageTemplatePartitionOracle)object;
            } else if (object instanceof PartitionListOracle) {
                this.partitionList = (PartitionListOracle)object;
            }
        }

        public String getTablespaceRef() {
            return this.tablespaceRef;
        }

        public TableProxyOracle getTableProxy() {
            return this.tableProxy;
        }

        public IndexProxyOracle getIndexProxy() {
            return this.indexProxy;
        }

        public PartitionOracle getPartition() {
            return this.partition;
        }

        public HashPartitionOracle getHashPartition() {
            return this.hashPartition;
        }

        public ListPartitionOracle getListPartition() {
            return this.listPartition;
        }

        public ListStorageTemplatePartitionOracle getSubListPartition() {
            return this.subListPartition;
        }

        public PartitionListOracle getPartitionList() {
            return this.partitionList;
        }
    }

    private class FunctionWaitingListEntry {
        private String functionRef;
        private RelationalObjectProxy objectProxy;

        public FunctionWaitingListEntry(String string, RelationalObjectProxy relationalObjectProxy) {
            this.functionRef = string;
            this.objectProxy = relationalObjectProxy;
        }

        public String getFunctionRef() {
            return this.functionRef;
        }

        public RelationalObjectProxy getObjectProxy() {
            return this.objectProxy;
        }
    }

    private class StoredProcedureWaitingListEntry {
        private String storedProcedureRef;
        private RelationalObjectProxy objectProxy;

        public StoredProcedureWaitingListEntry(String string, RelationalObjectProxy relationalObjectProxy) {
            this.storedProcedureRef = string;
            this.objectProxy = relationalObjectProxy;
        }

        public String getStoredProcedureRef() {
            return this.storedProcedureRef;
        }

        public RelationalObjectProxy getObjectProxy() {
            return this.objectProxy;
        }
    }

    private class SchemaWaitingListEntry {
        private String schemaName;
        private Object object;

        public SchemaWaitingListEntry(String string, Object object) {
            this.schemaName = string;
            this.object = object;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public DesignObject getDesignObject() {
            if (this.object instanceof DesignObject) {
                return (DesignObject)this.object;
            }
            return null;
        }

        public RelationalObjectProxy getProxyObject() {
            if (this.object instanceof RelationalObjectProxy) {
                return (RelationalObjectProxy)this.object;
            }
            return null;
        }

        public StorageObject getStorageObject() {
            if (this.object instanceof StorageObject) {
                return (StorageObject)this.object;
            }
            return null;
        }
    }

    private class DomainWaitingListEntry {
        private DesignObject designObject;
        private String parentDomainRef;
        private boolean datatypeOK;

        public DomainWaitingListEntry(DesignObject designObject, String string, boolean bl) {
            this.designObject = designObject;
            this.parentDomainRef = string;
            this.datatypeOK = bl;
        }

        public DesignObject getDesignObject() {
            return this.designObject;
        }

        public String getParentDomainRef() {
            return this.parentDomainRef;
        }

        public boolean isDatatypeOK() {
            return this.datatypeOK;
        }
    }

    private class TempScratchObject {
        private String id;
        private String name;
        private String parentRef;
        private String type;
        private String physicalName;
        private String parentToChildVerbPhrase;
        private String childToParentVerbPhrase;
        private String cardinality;
        private String nullOptionType;
        private String logicalDataType;
        private String physicalDataType;
        private String parentDomainRef;
        private String parentEntityRef;
        private String childEntityRef;
        private String keyGroupRef;
        private String scratchParentEntityRef;
        private String scratchChildEntityRef;
        private String scratchKeyGroupRef;
        private String keyGroupType;
        private List sourceOfTransforms;
        private List targetOfTransforms;
        private List childRefs;

        public TempScratchObject(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.parentRef = "";
            this.type = "";
            this.physicalName = "";
            this.parentToChildVerbPhrase = "";
            this.childToParentVerbPhrase = "";
            this.cardinality = "";
            this.nullOptionType = "";
            this.logicalDataType = "";
            this.physicalDataType = "";
            this.parentDomainRef = "";
            this.parentEntityRef = "";
            this.childEntityRef = "";
            this.keyGroupRef = "";
            this.scratchParentEntityRef = "";
            this.scratchChildEntityRef = "";
            this.scratchKeyGroupRef = "";
            this.keyGroupType = "";
            this.sourceOfTransforms = new ArrayList();
            this.targetOfTransforms = new ArrayList();
            this.childRefs = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setParentRef(String string) {
            this.parentRef = string;
        }

        public String getParentRef() {
            return this.parentRef;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getType() {
            return this.type;
        }

        public void setPhysicalName(String string) {
            if (!string.startsWith("%")) {
                this.physicalName = string;
            }
        }

        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setParentToChildVerbPhrase(String string) {
            this.parentToChildVerbPhrase = string;
        }

        public String getParentToChildVerbPhrase() {
            return this.parentToChildVerbPhrase;
        }

        public void setChildToParentVerbPhrase(String string) {
            this.childToParentVerbPhrase = string;
        }

        public String getChildToParentVerbPhrase() {
            return this.childToParentVerbPhrase;
        }

        public void setCardinality(String string) {
            this.cardinality = string;
        }

        public String getCardinality() {
            return this.cardinality;
        }

        public void setNullOptionType(String string) {
            this.nullOptionType = string;
        }

        public String getNullOptionType() {
            return this.nullOptionType;
        }

        public void setLogicalDataType(String string) {
            this.logicalDataType = string;
        }

        public String getLogicalDataType() {
            return this.logicalDataType;
        }

        public void setPhysicalDataType(String string) {
            this.physicalDataType = string;
        }

        public String getPhysicalDataType() {
            return this.physicalDataType;
        }

        public void setParentDomainRef(String string) {
            this.parentDomainRef = string;
        }

        public String getParentDomainRef() {
            return this.parentDomainRef;
        }

        public void setParentEntityRef(String string) {
            this.parentEntityRef = string;
        }

        public String getParentEntityRef() {
            return this.parentEntityRef;
        }

        public void setChildEntityRef(String string) {
            this.childEntityRef = string;
        }

        public String getChildEntityRef() {
            return this.childEntityRef;
        }

        public void setKeyGroupRef(String string) {
            this.keyGroupRef = string;
        }

        public String getKeyGroupRef() {
            return this.keyGroupRef;
        }

        public void setScratchParentEntityRef(String string) {
            this.scratchParentEntityRef = string;
        }

        public String getScratchParentEntityRef() {
            return this.scratchParentEntityRef;
        }

        public void setScratchChildEntityRef(String string) {
            this.scratchChildEntityRef = string;
        }

        public String getScratchChildEntityRef() {
            return this.scratchChildEntityRef;
        }

        public void setScratchKeyGroupRef(String string) {
            this.scratchKeyGroupRef = string;
        }

        public String getScratchKeyGroupRef() {
            return this.scratchKeyGroupRef;
        }

        public void setKeyGroupType(String string) {
            this.keyGroupType = string;
        }

        public String getKeyGroupType() {
            return this.keyGroupType;
        }

        public void initSourceOfTransforms() {
            this.sourceOfTransforms = new ArrayList();
        }

        public List getSourceOfTransforms() {
            return this.sourceOfTransforms;
        }

        public String getSourceOfTransform(int n) {
            return (String)this.sourceOfTransforms.get(n);
        }

        public void addSourceOfTransform(String string) {
            this.sourceOfTransforms.add(string);
        }

        public void initTargetOfTransforms() {
            this.targetOfTransforms = new ArrayList();
        }

        public List getTargetOfTransforms() {
            return this.targetOfTransforms;
        }

        public String getTargetOfTransform(int n) {
            return (String)this.targetOfTransforms.get(n);
        }

        public void addTargetOfTransform(String string) {
            this.targetOfTransforms.add(string);
        }

        public void initChildRefs() {
            this.childRefs = new ArrayList();
        }

        public List getChildRefs() {
            return this.childRefs;
        }

        public String getChildRef(int n) {
            return (String)this.childRefs.get(n);
        }

        public void addChildRef(String string) {
            this.childRefs.add(string);
        }
    }

    private class TempFont {
        private String id;
        private String name;
        private int style;
        private int size;

        public TempFont(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.style = 0;
            this.size = 10;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getStyle() {
            return this.style;
        }

        public void setStyle(int n) {
            this.style = n;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int n) {
            this.size = n;
        }
    }

    private class TempSequence {
        private String id;
        private String name;
        private String schemaName;
        private String definition;
        private String cacheCapacity;
        private String startingValue;
        private String incrementBy;
        private String maxValue;
        private String minValue;
        private String isCacheOn;
        private String isCycleOn;
        private String isMax;
        private String isMin;
        private String orderOn;

        public TempSequence(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.schemaName = "";
            this.definition = "";
            this.cacheCapacity = "";
            this.startingValue = "";
            this.incrementBy = "";
            this.maxValue = "";
            this.minValue = "";
            this.isCacheOn = "";
            this.isCycleOn = "";
            this.isMax = "";
            this.isMin = "";
            this.orderOn = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setSchemaName(String string) {
            this.schemaName = string;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setDefinition(String string) {
            this.definition = string;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setCacheCapacity(String string) {
            this.cacheCapacity = string;
        }

        public String getCacheCapacity() {
            return this.cacheCapacity;
        }

        public void setStartingValue(String string) {
            this.startingValue = string;
        }

        public String getStartingValue() {
            return this.startingValue;
        }

        public void setIncrementBy(String string) {
            this.incrementBy = string;
        }

        public String getIncrementBy() {
            return this.incrementBy;
        }

        public void setMaxValue(String string) {
            this.maxValue = string;
        }

        public String getMaxValue() {
            return this.maxValue;
        }

        public void setMinValue(String string) {
            this.minValue = string;
        }

        public String getMinValue() {
            return this.minValue;
        }

        public void setIsCacheOn(String string) {
            this.isCacheOn = string;
        }

        public String getIsCacheOn() {
            return this.isCacheOn;
        }

        public void setIsCycleOn(String string) {
            this.isCycleOn = string;
        }

        public String getIsCycleOn() {
            return this.isCycleOn;
        }

        public void setIsMax(String string) {
            this.isMax = string;
        }

        public String getIsMax() {
            return this.isMax;
        }

        public void setIsMin(String string) {
            this.isMin = string;
        }

        public String getIsMin() {
            return this.isMin;
        }

        public void setOrderOn(String string) {
            this.orderOn = string;
        }

        public String getOrderOn() {
            return this.orderOn;
        }
    }

    private class TempViewAttribute {
        private String id;
        private String name;
        private String type;
        private String physicalName;
        private String hideInLogical;
        private String hideInPhysical;
        private String parentAttrRef;
        private String parentRelRef;
        private String parentDomRef;
        private String logicalDatatype;
        private String physicalDatatype;
        private String definition;
        private String nullOptionType;
        private String fontRef;
        private String fontColor;
        private String comment;
        private String viewExpression;

        public TempViewAttribute(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.type = "";
            this.physicalName = "";
            this.hideInLogical = "";
            this.hideInPhysical = "";
            this.parentAttrRef = "";
            this.parentRelRef = "";
            this.parentDomRef = "";
            this.logicalDatatype = "";
            this.physicalDatatype = "";
            this.definition = "";
            this.nullOptionType = "";
            this.fontRef = "";
            this.fontColor = "";
            this.comment = "";
            this.viewExpression = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getType() {
            return this.type;
        }

        public void setPhysicalName(String string) {
            if (!string.startsWith("%")) {
                this.physicalName = string;
            }
        }

        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setHideInLogical(String string) {
            this.hideInLogical = string;
        }

        public String getHideInLogical() {
            return this.hideInLogical;
        }

        public void setHideInPhysical(String string) {
            this.hideInPhysical = string;
        }

        public String getHideInPhysical() {
            return this.hideInPhysical;
        }

        public void setParentAttrRef(String string) {
            this.parentAttrRef = string;
        }

        public String getParentAttrRef() {
            return this.parentAttrRef;
        }

        public void setParentRelRef(String string) {
            this.parentRelRef = string;
        }

        public String getParentRelRef() {
            return this.parentRelRef;
        }

        public void setParentDomRef(String string) {
            this.parentDomRef = string;
        }

        public String getParentDomRef() {
            return this.parentDomRef;
        }

        public void setLogicalDatatype(String string) {
            this.logicalDatatype = string;
        }

        public String getLogicalDatatype() {
            return this.logicalDatatype;
        }

        public void setPhysicalDatatype(String string) {
            this.physicalDatatype = string;
        }

        public String getPhysicalDatatype() {
            return this.physicalDatatype;
        }

        public void setDefinition(String string) {
            this.definition = string;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setNullOptionType(String string) {
            this.nullOptionType = string;
        }

        public String getNullOptionType() {
            return this.nullOptionType;
        }

        public void setFontRef(String string) {
            this.fontRef = string;
        }

        public String getFontRef() {
            return this.fontRef;
        }

        public void setFontColor(String string) {
            this.fontColor = string;
        }

        public String getFontColor() {
            return this.fontColor;
        }

        public void setComment(String string) {
            this.comment = "".equals(this.comment) ? string : this.comment.concat(StringUtilities.NEWLINE).concat(string);
        }

        public String getComment() {
            return this.comment;
        }

        public void setViewExpression(String string) {
            this.viewExpression = string;
        }

        public String getViewExpression() {
            return this.viewExpression;
        }
    }

    private class TempView {
        private String id;
        private String name;
        private String type;
        private String physicalName;
        private String schemaName;
        private String physicalOnly;
        private String logicalOnly;
        private String hideInLogical;
        private String hideInPhysical;
        private String definition;
        private String bgColorVal;
        private String outlineColorVal;
        private String nameFontID;
        private String nameColorVal;
        private String comment;
        private String sql;
        private List viewAttributes;
        private List viewTriggers;
        private List storedProcedureRefs;
        private List functionRefs;

        public TempView(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.type = "";
            this.physicalName = "";
            this.schemaName = "";
            this.physicalOnly = "";
            this.logicalOnly = "";
            this.hideInLogical = "";
            this.hideInPhysical = "";
            this.definition = "";
            this.bgColorVal = "";
            this.outlineColorVal = "";
            this.nameFontID = "";
            this.nameColorVal = "";
            this.comment = "";
            this.sql = "";
            this.viewAttributes = new ArrayList();
            this.viewTriggers = new ArrayList();
            this.storedProcedureRefs = new ArrayList();
            this.functionRefs = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getType() {
            return this.type;
        }

        public void setPhysicalName(String string) {
            if (!string.startsWith("%")) {
                this.physicalName = string;
            }
        }

        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setSchemaName(String string) {
            this.schemaName = string;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setPhysicalOnly(String string) {
            this.physicalOnly = string;
        }

        public String getPhysicalOnly() {
            return this.physicalOnly;
        }

        public void setLogicalOnly(String string) {
            this.logicalOnly = string;
        }

        public String getLogicalOnly() {
            return this.logicalOnly;
        }

        public void setHideInLogical(String string) {
            this.hideInLogical = string;
        }

        public String getHideInLogical() {
            return this.hideInLogical;
        }

        public void setHideInPhysical(String string) {
            this.hideInPhysical = string;
        }

        public String getHideInPhysical() {
            return this.hideInPhysical;
        }

        public void setDefinition(String string) {
            this.definition = string;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setBgColorVal(String string) {
            this.bgColorVal = string;
        }

        public String getBgColorVal() {
            return this.bgColorVal;
        }

        public void setOutlineColorVal(String string) {
            this.outlineColorVal = string;
        }

        public String getOutlineColorVal() {
            return this.outlineColorVal;
        }

        public void setNameFontID(String string) {
            this.nameFontID = string;
        }

        public String getNameFontID() {
            return this.nameFontID;
        }

        public void setNameColorVal(String string) {
            this.nameColorVal = string;
        }

        public String getNameColorVal() {
            return this.nameColorVal;
        }

        public void setComment(String string) {
            this.comment = "".equals(this.comment) ? string : this.comment.concat(StringUtilities.NEWLINE).concat(string);
        }

        public String getComment() {
            return this.comment;
        }

        public void setSQL(String string) {
            this.sql = string;
        }

        public String getSQL() {
            return this.sql;
        }

        public void initViewAttributes() {
            this.viewAttributes = new ArrayList();
        }

        public List getViewAttributes() {
            return this.viewAttributes;
        }

        public TempViewAttribute getViewAttribute(int n) {
            return (TempViewAttribute)this.viewAttributes.get(n);
        }

        public void addViewAttribute(TempViewAttribute tempViewAttribute) {
            this.viewAttributes.add(tempViewAttribute);
        }

        public void initViewTriggers() {
            this.viewTriggers = new ArrayList();
        }

        public List getViewTriggers() {
            return this.viewTriggers;
        }

        public TempTrigger getViewTrigger(int n) {
            return (TempTrigger)this.viewTriggers.get(n);
        }

        public void addViewTrigger(TempTrigger tempTrigger) {
            this.viewTriggers.add(tempTrigger);
        }

        public void initStoredProcedureRefs() {
            this.storedProcedureRefs = new ArrayList();
        }

        public List getStoredProcedureRefs() {
            return this.storedProcedureRefs;
        }

        public String getStoredProcedureRef(int n) {
            return (String)this.storedProcedureRefs.get(n);
        }

        public void addStoredProcedureRef(String string) {
            this.storedProcedureRefs.add(string);
        }

        public void initFunctionRefs() {
            this.functionRefs = new ArrayList();
        }

        public List getFunctionRefs() {
            return this.functionRefs;
        }

        public String getFunctionRef(int n) {
            return (String)this.functionRefs.get(n);
        }

        public void addFunctionRef(String string) {
            this.functionRefs.add(string);
        }
    }

    private class TempRollUpSubTransform {
        private String id;
        private String name;
        private String childTableRef;
        private String scratchChildTableRef;
        private List subSourceAssociations;
        private List subTargetAssociations;

        public TempRollUpSubTransform(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.childTableRef = "";
            this.scratchChildTableRef = "";
            this.subSourceAssociations = new ArrayList();
            this.subTargetAssociations = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getChildTableRef() {
            return this.childTableRef;
        }

        public void setChildTableRef(String string) {
            this.childTableRef = string;
        }

        public String getScratchChildTableRef() {
            return this.scratchChildTableRef;
        }

        public void setScratchChildTableRef(String string) {
            this.scratchChildTableRef = string;
        }

        public void initSubSourceAssociations() {
            this.subSourceAssociations = new ArrayList();
        }

        public List getSubSourceAssociations() {
            return this.subSourceAssociations;
        }

        public String getSubSourceAssociation(int n) {
            return (String)this.subSourceAssociations.get(n);
        }

        public void addSubSourceAssociation(String string) {
            this.subSourceAssociations.add(string);
        }

        public void initSubTargetAssociations() {
            this.subTargetAssociations = new ArrayList();
        }

        public List getSubTargetAssociations() {
            return this.subTargetAssociations;
        }

        public String getSubTargetAssociation(int n) {
            return (String)this.subTargetAssociations.get(n);
        }

        public void addSubTargetAssociation(String string) {
            this.subTargetAssociations.add(string);
        }
    }

    private class TempRollUpTransform {
        private String id;
        private String name;
        private String parentTableRef;
        private String scratchParentTableRef;
        private String denormalizedTableRef;
        private String scratchDenormalizedTableRef;
        private List sourceAssociations;
        private List targetAssociations;
        private List tempRollUpSubTransforms;

        public TempRollUpTransform(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.parentTableRef = "";
            this.scratchParentTableRef = "";
            this.denormalizedTableRef = "";
            this.scratchDenormalizedTableRef = "";
            this.sourceAssociations = new ArrayList();
            this.targetAssociations = new ArrayList();
            this.tempRollUpSubTransforms = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getParentTableRef() {
            return this.parentTableRef;
        }

        public void setParentTableRef(String string) {
            this.parentTableRef = string;
        }

        public String getScratchParentTableRef() {
            return this.scratchParentTableRef;
        }

        public void setScratchParentTableRef(String string) {
            this.scratchParentTableRef = string;
        }

        public String getDenormalizedTableRef() {
            return this.denormalizedTableRef;
        }

        public void setDenormalizedTableRef(String string) {
            this.denormalizedTableRef = string;
        }

        public String getScratchDenormalizedTableRef() {
            return this.scratchDenormalizedTableRef;
        }

        public void setScratchDenormalizedTableRef(String string) {
            this.scratchDenormalizedTableRef = string;
        }

        public void initSourceAssociations() {
            this.sourceAssociations = new ArrayList();
        }

        public List getSourceAssociations() {
            return this.sourceAssociations;
        }

        public String getSourceAssociation(int n) {
            return (String)this.sourceAssociations.get(n);
        }

        public void addSourceAssociation(String string) {
            this.sourceAssociations.add(string);
        }

        public void initTargetAssociations() {
            this.targetAssociations = new ArrayList();
        }

        public List getTargetAssociations() {
            return this.targetAssociations;
        }

        public String getTargetAssociation(int n) {
            return (String)this.targetAssociations.get(n);
        }

        public void addTargetAssociation(String string) {
            this.targetAssociations.add(string);
        }

        public void initTempRollUpSubTransforms() {
            this.tempRollUpSubTransforms = new ArrayList();
        }

        public List getTempRollUpSubTransforms() {
            return this.tempRollUpSubTransforms;
        }

        public TempRollUpSubTransform getTempRollUpSubTransform(int n) {
            return (TempRollUpSubTransform)this.tempRollUpSubTransforms.get(n);
        }

        public void addTempRollUpSubTransform(TempRollUpSubTransform tempRollUpSubTransform) {
            this.tempRollUpSubTransforms.add(tempRollUpSubTransform);
        }
    }

    private class TempMTMTransform {
        private String id;
        private String name;
        private String associationTableRef;
        private String relationshipRef_1;
        private String relationshipRef_2;

        public TempMTMTransform(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.associationTableRef = "";
            this.relationshipRef_1 = "";
            this.relationshipRef_2 = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getAssociationTableRef() {
            return this.associationTableRef;
        }

        public void setAssociationTableRef(String string) {
            this.associationTableRef = string;
        }

        public String getRelationshipRef_1() {
            return this.relationshipRef_1;
        }

        public void setRelationshipRef_1(String string) {
            this.relationshipRef_1 = string;
        }

        public String getRelationshipRef_2() {
            return this.relationshipRef_2;
        }

        public void setRelationshipRef_2(String string) {
            this.relationshipRef_2 = string;
        }
    }

    private class TempPLSQLSource {
        private String id;
        private String name;
        private String definition;
        private String type;
        private String schemaName;
        private String codeKeyword;
        private String specKeyword;
        private String templateCode;
        private String templateSpec;

        public TempPLSQLSource(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.definition = "";
            this.type = "";
            this.schemaName = "";
            this.codeKeyword = "";
            this.specKeyword = "";
            this.templateCode = "";
            this.templateSpec = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setDefinition(String string) {
            this.definition = string;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public void setSchemaName(String string) {
            this.schemaName = string;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setCodeKeyword(String string) {
            this.codeKeyword = string;
        }

        public String getCodeKeyword() {
            return this.codeKeyword;
        }

        public void setSpecKeyword(String string) {
            this.specKeyword = string;
        }

        public String getSpecKeyword() {
            return this.specKeyword;
        }

        public void setTemplateCode(String string) {
            this.templateCode = string;
        }

        public String getTemplateCode() {
            return this.templateCode;
        }

        public String getTemplateCodeBody() {
            return this.trimSource(this.templateCode, this.codeKeyword);
        }

        public void setTemplateSpec(String string) {
            this.templateSpec = string;
        }

        public String getTemplateSpec() {
            return this.templateSpec;
        }

        public String getTemplateSpecBody() {
            return this.trimSource(this.templateSpec, this.specKeyword);
        }

        private String trimSource(String string, String string2) {
            String string3 = string.trim();
            if (string3.toUpperCase().startsWith("CREATE")) {
                string3 = string3.substring(6).trim();
            }
            if (string3.toUpperCase().startsWith("OR")) {
                string3 = string3.substring(2).trim();
            }
            if (string3.toUpperCase().startsWith("REPLACE")) {
                string3 = string3.substring(7).trim();
            }
            return string3;
        }
    }

    private class TempValidationRule {
        private String id;
        private String name;
        private String definition;
        private String userRule;
        private String minValue;
        private String maxValue;
        private int type;
        private List validValueNames;
        private List validValueDefinitions;

        public TempValidationRule(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.definition = "";
            this.userRule = "";
            this.minValue = "";
            this.maxValue = "";
            this.type = 0;
            this.validValueNames = new ArrayList();
            this.validValueDefinitions = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setDefinition(String string) {
            this.definition = string;
        }

        public String getUserRule() {
            return this.userRule;
        }

        public void setUserRule(String string) {
            this.userRule = string;
        }

        public String getMinValue() {
            return this.minValue;
        }

        public void setMinValue(String string) {
            this.minValue = string;
        }

        public String getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(String string) {
            this.maxValue = string;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int n) {
            this.type = n;
        }

        public String getValidValueName(int n) {
            return (String)this.validValueNames.get(n);
        }

        public void addValidValueName(String string) {
            this.validValueNames.add(string);
        }

        public String getValidValueDefinition(int n) {
            return (String)this.validValueDefinitions.get(n);
        }

        public void addValidValueDefinition(String string) {
            this.validValueDefinitions.add(string);
        }

        public void setValidValueDefinition(String string) {
            this.validValueDefinitions.set(this.getValidValuesSize() - 1, string);
        }

        public void initValidValues() {
            this.validValueNames = new ArrayList();
            this.validValueDefinitions = new ArrayList();
        }

        public int getValidValuesSize() {
            return this.validValueNames.size();
        }
    }

    private class ValidationRuleHolder {
        private int type = 0;
        private String rule;
        private String minValue;
        private String maxValue;
        private String definition;
        private String name;
        private Map valueList = new TreeMap();

        public ValidationRuleHolder(int n) {
            this.type = n;
            this.rule = "";
            this.minValue = "";
            this.maxValue = "";
            this.definition = "";
            this.name = "";
        }

        public String getRule() {
            return this.rule;
        }

        public void setRule(String string) {
            this.rule = string;
        }

        public String getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(String string) {
            this.maxValue = string;
        }

        public String getMinValue() {
            return this.minValue;
        }

        public void setMinValue(String string) {
            this.minValue = string;
        }

        public int getType() {
            return this.type;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setDefinition(String string) {
            this.definition = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public Map getValueList() {
            return this.valueList;
        }

        public void addValue(String string, String string2) {
            this.valueList.put(string, string2);
        }
    }

    private class TempDefaultValue {
        private String id;
        private String name;
        private int builtIn;
        private String serverValue;

        public TempDefaultValue(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.builtIn = 0;
            this.serverValue = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getBuiltIn() {
            return this.builtIn;
        }

        public void setBuiltIn(int n) {
            this.builtIn = n;
        }

        public String getServerValue() {
            return this.serverValue;
        }

        public void setServerValue(String string) {
            this.serverValue = string;
        }
    }

    private class TempRelationship {
        private String id;
        private String name;
        private String physicalName;
        private String hideInLogical;
        private String hideInPhysical;
        private String parentEntityRef;
        private String childEntityRef;
        private String parentToChildVerbPhrase;
        private String childToParentVerbPhrase;
        private String type;
        private String cardinality;
        private String nullOptionType;
        private String parentDeleteRule;
        private String comment;
        private String refKey;

        public TempRelationship(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.physicalName = "";
            this.hideInLogical = "";
            this.hideInPhysical = "";
            this.parentEntityRef = "";
            this.childEntityRef = "";
            this.parentToChildVerbPhrase = "";
            this.childToParentVerbPhrase = "";
            this.type = "";
            this.cardinality = "";
            this.nullOptionType = "";
            this.parentDeleteRule = "";
            this.comment = "";
            this.refKey = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setPhysicalName(String string) {
            if (!string.startsWith("%")) {
                this.physicalName = string;
            }
        }

        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setHideInLogical(String string) {
            this.hideInLogical = string;
        }

        public String getHideInLogical() {
            return this.hideInLogical;
        }

        public void setHideInPhysical(String string) {
            this.hideInPhysical = string;
        }

        public String getHideInPhysical() {
            return this.hideInPhysical;
        }

        public void setParentEntityRef(String string) {
            this.parentEntityRef = string;
        }

        public String getParentEntityRef() {
            return this.parentEntityRef;
        }

        public void setChildEntityRef(String string) {
            this.childEntityRef = string;
        }

        public String getChildEntityRef() {
            return this.childEntityRef;
        }

        public void setParentToChildVerbPhrase(String string) {
            this.parentToChildVerbPhrase = string;
        }

        public String getParentToChildVerbPhrase() {
            return this.parentToChildVerbPhrase;
        }

        public void setChildToParentVerbPhrase(String string) {
            this.childToParentVerbPhrase = string;
        }

        public String getChildToParentVerbPhrase() {
            return this.childToParentVerbPhrase;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getType() {
            return this.type;
        }

        public void setCardinality(String string) {
            this.cardinality = string;
        }

        public String getCardinality() {
            return this.cardinality;
        }

        public void setNullOptionType(String string) {
            this.nullOptionType = string;
        }

        public String getNullOptionType() {
            return this.nullOptionType;
        }

        public void setParentDeleteRule(String string) {
            this.parentDeleteRule = string;
        }

        public String getParentDeleteRule() {
            return this.parentDeleteRule;
        }

        public void setComment(String string) {
            this.comment = "".equals(this.comment) ? string : this.comment.concat(StringUtilities.NEWLINE).concat(string);
        }

        public String getComment() {
            return this.comment;
        }

        public String getRefKey() {
            return this.refKey;
        }

        public void setRefKey(String string) {
            this.refKey = string;
        }
    }

    protected class IHObject {
        private String id;
        private String name;
        private String parentID;
        private String childID;
        private String physicalName;
        private String parentDeleteRule;
        private String comment;

        public IHObject(String string, String string2, String string3, String string4) {
            this.id = string;
            this.name = string2;
            this.parentID = string3;
            this.childID = string4;
            this.physicalName = "";
            this.parentDeleteRule = "";
            this.comment = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getChildID() {
            return this.childID;
        }

        public String getParentID() {
            return this.parentID;
        }

        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setPhysicalName(String string) {
            this.physicalName = string;
        }

        public String getParentDeleteRule() {
            return this.parentDeleteRule;
        }

        public void setParentDeleteRule(String string) {
            this.parentDeleteRule = string;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String string) {
            this.comment = string;
        }
    }

    private class TempDrawingObject {
        private String id;
        private String name;
        private String type;
        private String modelObjectRef;
        private Rectangle locationRectangle;
        private String anchorPoint;
        private String fixedSizePoint;
        private String text;
        private String fontRef;
        private String fontColor;
        private String fillColor;
        private String outlineColor;
        private String outlineStyle;
        private List pathCoordinates;

        public TempDrawingObject(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.type = "";
            this.modelObjectRef = "";
            this.locationRectangle = new Rectangle();
            this.anchorPoint = "";
            this.fixedSizePoint = "";
            this.text = "";
            this.fontRef = "";
            this.fontColor = "";
            this.fillColor = "";
            this.outlineColor = "";
            this.outlineStyle = "";
            this.pathCoordinates = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getType() {
            return this.type;
        }

        public void setModelObjectRef(String string) {
            this.modelObjectRef = string;
        }

        public String getModelObjectRef() {
            return this.modelObjectRef;
        }

        public void setLocationRectangle(String string) {
            this.locationRectangle = ERSAXParserv7x.this.parseCoordinates(string);
        }

        public Rectangle getLocationRectangle() {
            return this.locationRectangle;
        }

        public void setAnchorPoint(String string) {
            this.anchorPoint = string;
        }

        public String getAnchorPoint() {
            return this.anchorPoint;
        }

        public void setFixedSizePoint(String string) {
            this.fixedSizePoint = string;
        }

        public String getFixedSizePoint() {
            return this.fixedSizePoint;
        }

        public void setText(String string) {
            this.text = string;
        }

        public String getText() {
            return this.text;
        }

        public void setFontRef(String string) {
            this.fontRef = string;
        }

        public String getFontRef() {
            return this.fontRef;
        }

        public void setFontColor(String string) {
            this.fontColor = string;
        }

        public String getFontColor() {
            return this.fontColor;
        }

        public void setFillColor(String string) {
            this.fillColor = string;
        }

        public String getFillColor() {
            return this.fillColor;
        }

        public void setOutlineColor(String string) {
            this.outlineColor = string;
        }

        public String getOutlineColor() {
            return this.outlineColor;
        }

        public void setOutlineStyle(String string) {
            this.outlineStyle = string;
        }

        public String getOutlineStyle() {
            return this.outlineStyle;
        }

        public void initPathCoordinates() {
            this.pathCoordinates = new ArrayList();
        }

        public List getPathCoordinates() {
            return this.pathCoordinates;
        }

        public String getPathCoordinate(int n) {
            return (String)this.pathCoordinates.get(n);
        }

        public void addPathCoordinate(String string) {
            this.pathCoordinates.add(string);
        }

        public void copyFrom(TempDrawingObject tempDrawingObject) {
            this.type = tempDrawingObject.getType();
            this.modelObjectRef = tempDrawingObject.getModelObjectRef();
            this.locationRectangle = tempDrawingObject.getLocationRectangle();
            this.anchorPoint = tempDrawingObject.getAnchorPoint();
            this.fixedSizePoint = tempDrawingObject.getFixedSizePoint();
            this.text = tempDrawingObject.getText();
            this.fontRef = tempDrawingObject.getFontRef();
            this.fontColor = tempDrawingObject.getFontColor();
            this.fillColor = tempDrawingObject.getFillColor();
            this.outlineColor = tempDrawingObject.getOutlineColor();
            this.outlineStyle = tempDrawingObject.getOutlineStyle();
            this.pathCoordinates = tempDrawingObject.getPathCoordinates();
        }
    }

    private class TempStoredDisplay {
        private String id;
        private String name;
        private List drawingObjects;

        public TempStoredDisplay(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.drawingObjects = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void initDrawingObjects() {
            this.drawingObjects = new ArrayList();
        }

        public List getDrawingObjects() {
            return this.drawingObjects;
        }

        public TempDrawingObject getDrawingObject(int n) {
            return (TempDrawingObject)this.drawingObjects.get(n);
        }

        public void addDrawingObject(TempDrawingObject tempDrawingObject) {
            this.drawingObjects.add(tempDrawingObject);
        }
    }

    private class TempSubjectArea {
        private String id;
        private String name;
        private boolean isMain;
        private List storedDisplays;

        public TempSubjectArea(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.isMain = false;
            this.storedDisplays = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setIsMain(String string) {
            this.isMain = "true".equalsIgnoreCase(string);
        }

        public boolean isMain() {
            return this.isMain;
        }

        public void initTempStoredDisplays() {
            this.storedDisplays = new ArrayList();
        }

        public List getTempStoredDisplays() {
            return this.storedDisplays;
        }

        public TempStoredDisplay getStoredDisplay(int n) {
            return (TempStoredDisplay)this.storedDisplays.get(n);
        }

        public void addStoredDisplay(TempStoredDisplay tempStoredDisplay) {
            this.storedDisplays.add(tempStoredDisplay);
        }
    }

    private class TempOracleTablespace {
        private String id;
        private String name;
        private String type;
        private String systemType;
        private String compressType;
        private String extentManagementType;
        private String localExtentManagementType;
        private String segmentManagementType;
        private String storageFileType;
        private String maxExtentType;
        private String definition;
        private int dataBlockSize;
        private int extentSize;
        private int initialExtentSize;
        private int nextExtentSize;
        private int minimumExtent;
        private int minExtents;
        private int maxExtents;
        private int percentIncrease;
        private boolean isOffline;
        private boolean isReadOnly;
        private boolean noLogging;
        private boolean forceLogging;
        private boolean canFlashback;
        private boolean retentionGuarantee;

        public TempOracleTablespace(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.type = "";
            this.systemType = "";
            this.compressType = "";
            this.extentManagementType = "";
            this.localExtentManagementType = "";
            this.segmentManagementType = "";
            this.storageFileType = "";
            this.maxExtentType = "";
            this.definition = "";
            this.dataBlockSize = 0;
            this.extentSize = 0;
            this.initialExtentSize = 0;
            this.nextExtentSize = 0;
            this.minimumExtent = 0;
            this.minExtents = 0;
            this.maxExtents = 0;
            this.percentIncrease = 0;
            this.isOffline = false;
            this.isReadOnly = false;
            this.noLogging = false;
            this.forceLogging = false;
            this.canFlashback = false;
            this.retentionGuarantee = false;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getType() {
            return this.type;
        }

        public void setSystemType(String string) {
            this.systemType = string;
        }

        public String getSystemType() {
            return this.systemType;
        }

        public void setCompressType(String string) {
            this.compressType = string;
        }

        public String getCompressType() {
            return this.compressType;
        }

        public void setExtentManagementType(String string) {
            this.extentManagementType = string;
        }

        public String getExtentManagementType() {
            return this.extentManagementType;
        }

        public void setLocalExtentManagementType(String string) {
            this.localExtentManagementType = string;
        }

        public String getLocalExtentManagementType() {
            return this.localExtentManagementType;
        }

        public void setSegmentManagementType(String string) {
            this.segmentManagementType = string;
        }

        public String getSegmentManagementType() {
            return this.segmentManagementType;
        }

        public void setStorageFileType(String string) {
            this.storageFileType = string;
        }

        public String getStorageFileType() {
            return this.storageFileType;
        }

        public void setMaxExtentType(String string) {
            this.maxExtentType = string;
        }

        public String getMaxExtentType() {
            return this.maxExtentType;
        }

        public void setDefinition(String string) {
            this.definition = string;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setDataBlockSize(String string) {
            this.dataBlockSize = ERSAXParserv7x.this.calculateSize(string);
        }

        public int getDataBlockSize() {
            return this.dataBlockSize;
        }

        public void setExtentSize(String string) {
            this.extentSize = ERSAXParserv7x.this.calculateSize(string);
        }

        public int getExtentSize() {
            return this.extentSize;
        }

        public void setInitialExtentSize(String string) {
            this.initialExtentSize = ERSAXParserv7x.this.calculateSize(string);
        }

        public int getInitialExtentSize() {
            return this.initialExtentSize;
        }

        public void setNextExtentSize(String string) {
            this.nextExtentSize = ERSAXParserv7x.this.calculateSize(string);
        }

        public int getNextExtentSize() {
            return this.nextExtentSize;
        }

        public void setMinimumExtent(String string) {
            this.minimumExtent = ERSAXParserv7x.this.calculateSize(string);
        }

        public int getMinimumExtent() {
            return this.minimumExtent;
        }

        public void setMinExtents(String string) {
            try {
                this.minExtents = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getMinExtents() {
            return this.minExtents;
        }

        public void setMaxExtents(String string) {
            try {
                this.maxExtents = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getMaxExtents() {
            return this.maxExtents;
        }

        public void setPercentIncrease(String string) {
            try {
                this.percentIncrease = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getPercentIncrease() {
            return this.percentIncrease;
        }

        public void setIsOffline(String string) {
            this.isOffline = "true".equalsIgnoreCase(string);
        }

        public boolean isOffline() {
            return this.isOffline;
        }

        public void setIsReadOnly(String string) {
            this.isReadOnly = "true".equalsIgnoreCase(string);
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        public void setNoLogging(String string) {
            this.noLogging = "true".equalsIgnoreCase(string);
        }

        public boolean noLogging() {
            return this.noLogging;
        }

        public void setForceLogging(String string) {
            this.forceLogging = "true".equalsIgnoreCase(string);
        }

        public boolean forceLogging() {
            return this.forceLogging;
        }

        public void setCanFlashback(String string) {
            this.canFlashback = "true".equalsIgnoreCase(string);
        }

        public boolean canFlashback() {
            return this.canFlashback;
        }

        public void setRetentionGuarantee(String string) {
            this.retentionGuarantee = "true".equalsIgnoreCase(string);
        }

        public boolean retentionGuarantee() {
            return this.retentionGuarantee;
        }
    }

    private class TempDomain {
        private String id;
        private String name;
        private String logicalDatatype;
        private String physicalDatatype;
        private String parentDomainRef;
        private String validationRuleRef;

        public TempDomain(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.logicalDatatype = "";
            this.physicalDatatype = "";
            this.parentDomainRef = "";
            this.validationRuleRef = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setLogicalDatatype(String string) {
            this.logicalDatatype = string;
        }

        public String getLogicalDatatype() {
            return this.logicalDatatype;
        }

        public void setPhysicalDatatype(String string) {
            this.physicalDatatype = string;
        }

        public String getPhysicalDatatype() {
            return this.physicalDatatype;
        }

        public void setParentDomainRef(String string) {
            this.parentDomainRef = string;
        }

        public String getParentDomainRef() {
            return this.parentDomainRef;
        }

        public void setValidationRuleRef(String string) {
            this.validationRuleRef = string;
        }

        public String getValidationRuleRef() {
            return this.validationRuleRef;
        }
    }

    private class TempSubPartitionInfo {
        private String id;
        private String name;
        private String subTablespaceRef;
        private List subPartitionValues;

        public TempSubPartitionInfo(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.subTablespaceRef = "";
            this.subPartitionValues = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setSubTablespaceRef(String string) {
            this.subTablespaceRef = string;
        }

        public String getSubTablespaceRef() {
            return this.subTablespaceRef;
        }

        public void initSubPartitionValues() {
            this.subPartitionValues = new ArrayList();
        }

        public List getSubPartitionValues() {
            return this.subPartitionValues;
        }

        public String getSubPartitionValue(int n) {
            return (String)this.subPartitionValues.get(n);
        }

        public void addSubPartitionValue(String string) {
            this.subPartitionValues.add(string);
        }
    }

    private class TempPartitionInfo {
        private String id;
        private String name;
        private int partHashQuantity;
        private List partitionValues;
        private List tablespaceRefs;
        private List subPartitionInfos;

        public TempPartitionInfo(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.partHashQuantity = 0;
            this.partitionValues = new ArrayList();
            this.tablespaceRefs = new ArrayList();
            this.subPartitionInfos = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setPartHashQuantity(String string) {
            try {
                this.partHashQuantity = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getPartHashQuantity() {
            return this.partHashQuantity;
        }

        public void initPartitionValues() {
            this.partitionValues = new ArrayList();
        }

        public List getPartitionValues() {
            return this.partitionValues;
        }

        public String getPartitionValue(int n) {
            return (String)this.partitionValues.get(n);
        }

        public void addPartitionValue(String string) {
            this.partitionValues.add(string);
        }

        public void initTablespaceRefs() {
            this.tablespaceRefs = new ArrayList();
        }

        public List getTablespaceRefs() {
            return this.tablespaceRefs;
        }

        public String getTablespaceRef(int n) {
            return (String)this.tablespaceRefs.get(n);
        }

        public void addTablespaceRef(String string) {
            this.tablespaceRefs.add(string);
        }

        public void setTablespaceRefs(List list) {
            this.tablespaceRefs = list;
        }

        public void initSubPartitionInfos() {
            this.subPartitionInfos = new ArrayList();
        }

        public List getSubPartitionInfos() {
            return this.subPartitionInfos;
        }

        public TempSubPartitionInfo getSubPartitionInfo(int n) {
            return (TempSubPartitionInfo)this.subPartitionInfos.get(n);
        }

        public void addSubPartitionInfo(TempSubPartitionInfo tempSubPartitionInfo) {
            this.subPartitionInfos.add(tempSubPartitionInfo);
        }
    }

    private class TempPartition {
        private String id;
        private String name;
        private String partitionType;
        private String compositePartitionType;
        private String compositeListColumnRef;
        private String hashType;
        private int hashQuantity;
        private List columnRefs;
        private List hashColumnRefs;
        private List tablespaceRefs;
        private List partitionInfos;

        public TempPartition(String string, String string2, String string3) {
            this.id = string;
            this.name = string2;
            this.partitionType = string3;
            this.compositePartitionType = "";
            this.compositeListColumnRef = "";
            this.hashType = "";
            this.hashQuantity = 0;
            this.columnRefs = new ArrayList();
            this.hashColumnRefs = new ArrayList();
            this.tablespaceRefs = new ArrayList();
            this.partitionInfos = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getPartitionType() {
            return this.partitionType;
        }

        public void setCompositePartitionType(String string) {
            this.compositePartitionType = string;
        }

        public String getCompositePartitionType() {
            return this.compositePartitionType;
        }

        public void setCompositeListColumnRef(String string) {
            this.compositeListColumnRef = string;
        }

        public String getCompositeListColumnRef() {
            return this.compositeListColumnRef;
        }

        public void setHashType(String string) {
            this.hashType = string;
        }

        public String getHashType() {
            return this.hashType;
        }

        public void setHashQuantity(String string) {
            try {
                this.hashQuantity = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getHashQuantity() {
            return this.hashQuantity;
        }

        public void initColumnRefs() {
            this.columnRefs = new ArrayList();
        }

        public List getColumnRefs() {
            return this.columnRefs;
        }

        public String getColumnRef(int n) {
            return (String)this.columnRefs.get(n);
        }

        public void addColumnRef(String string) {
            this.columnRefs.add(string);
        }

        public void initHashColumnRefs() {
            this.hashColumnRefs = new ArrayList();
        }

        public List getHashColumnRefs() {
            return this.hashColumnRefs;
        }

        public String getHashColumnRef(int n) {
            return (String)this.hashColumnRefs.get(n);
        }

        public void addHashColumnRef(String string) {
            this.hashColumnRefs.add(string);
        }

        public void initTablespaceRefs() {
            this.tablespaceRefs = new ArrayList();
        }

        public List getTablespaceRefs() {
            return this.tablespaceRefs;
        }

        public String getTablespaceRef(int n) {
            return (String)this.tablespaceRefs.get(n);
        }

        public void addTablespaceRef(String string) {
            this.tablespaceRefs.add(string);
        }

        public void initPartitionInfos() {
            this.partitionInfos = new ArrayList();
        }

        public List getPartitionInfos() {
            return this.partitionInfos;
        }

        public TempPartitionInfo getPartitionInfo(int n) {
            return (TempPartitionInfo)this.partitionInfos.get(n);
        }

        public void addPartitionInfo(TempPartitionInfo tempPartitionInfo) {
            this.partitionInfos.add(tempPartitionInfo);
        }
    }

    private class TempTrigger {
        private String id;
        private String name;
        private String definition;
        private String schemaName;
        private String type;
        private String status;
        private String fireType;
        private String scope;
        private String oldAs;
        private String newAs;
        private String body;
        private String when;
        private List columnRefs;

        public TempTrigger(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.definition = "";
            this.schemaName = "";
            this.type = "";
            this.status = "";
            this.fireType = "";
            this.scope = "";
            this.oldAs = "";
            this.newAs = "";
            this.body = "";
            this.when = "";
            this.columnRefs = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setDefinition(String string) {
            this.definition = string;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setSchemaName(String string) {
            this.schemaName = string;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getType() {
            return this.type;
        }

        public void setStatus(String string) {
            this.status = string;
        }

        public String getStatus() {
            return this.status;
        }

        public void setFireType(String string) {
            this.fireType = string;
        }

        public String getFireType() {
            return this.fireType;
        }

        public void setScope(String string) {
            this.scope = string;
        }

        public String getScope() {
            return this.scope;
        }

        public void setOldAs(String string) {
            this.oldAs = string;
        }

        public String getOldAs() {
            return this.oldAs;
        }

        public void setNewAs(String string) {
            this.newAs = string;
        }

        public String getNewAs() {
            return this.newAs;
        }

        public void setBody(String string) {
            this.body = string;
        }

        public String getBody() {
            return this.body;
        }

        public void setWhen(String string) {
            this.when = string;
        }

        public String getWhen() {
            return this.when;
        }

        public void initColumnRefs() {
            this.columnRefs = new ArrayList();
        }

        public List getColumnRefs() {
            return this.columnRefs;
        }

        public String getColumnRef(int n) {
            return (String)this.columnRefs.get(n);
        }

        public void addColumnRef(String string) {
            this.columnRefs.add(string);
        }
    }

    private class TempPhysicalStorage {
        private String id;
        private String name;
        private String tablespaceRef;
        private String bufferPool;
        private String maxExtentType;
        private int initialExtentSize;
        private int nextExtentSize;
        private int freeListGroups;
        private int freeLists;
        private int initialTransactions;
        private int maxExtents;
        private int minExtents;
        private int percentFree;
        private int percentIncrease;
        private int percentUsed;
        private boolean noLogging;

        public TempPhysicalStorage(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.tablespaceRef = "";
            this.bufferPool = "";
            this.maxExtentType = "";
            this.initialExtentSize = 0;
            this.nextExtentSize = 0;
            this.freeListGroups = 0;
            this.freeLists = 0;
            this.initialTransactions = 0;
            this.maxExtents = 0;
            this.minExtents = 0;
            this.percentFree = 0;
            this.percentIncrease = 0;
            this.percentUsed = 0;
            this.noLogging = false;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setTablespaceRef(String string) {
            this.tablespaceRef = string;
        }

        public String getTablespaceRef() {
            return this.tablespaceRef;
        }

        public void setBufferPool(String string) {
            this.bufferPool = string;
        }

        public String getBufferPool() {
            return this.bufferPool;
        }

        public void setMaxExtentType(String string) {
            this.maxExtentType = string;
        }

        public String getMaxExtentType() {
            return this.maxExtentType;
        }

        public void setInitialExtentSize(String string) {
            this.initialExtentSize = ERSAXParserv7x.this.calculateSize(string);
        }

        public int getInitialExtentSize() {
            return this.initialExtentSize;
        }

        public void setNextExtentSize(String string) {
            this.nextExtentSize = ERSAXParserv7x.this.calculateSize(string);
        }

        public int getNextExtentSize() {
            return this.nextExtentSize;
        }

        public void setFreeListGroups(String string) {
            try {
                this.freeListGroups = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getFreeListGroups() {
            return this.freeListGroups;
        }

        public void setFreeLists(String string) {
            try {
                this.freeLists = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getFreeLists() {
            return this.freeLists;
        }

        public void setInitialTransactions(String string) {
            try {
                this.initialTransactions = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getInitialTransactions() {
            return this.initialTransactions;
        }

        public void setMaxExtents(String string) {
            try {
                this.maxExtents = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getMaxExtents() {
            return this.maxExtents;
        }

        public void setMinExtents(String string) {
            try {
                this.minExtents = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getMinExtents() {
            return this.minExtents;
        }

        public void setPercentFree(String string) {
            try {
                this.percentFree = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getPercentFree() {
            return this.percentFree;
        }

        public void setPercentIncrease(String string) {
            try {
                this.percentIncrease = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getPercentIncrease() {
            return this.percentIncrease;
        }

        public void setPercentUsed(String string) {
            try {
                this.percentUsed = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getPercentUsed() {
            return this.percentUsed;
        }

        public void setNoLogging(String string) {
            this.noLogging = "true".equalsIgnoreCase(string);
        }

        public boolean noLogging() {
            return this.noLogging;
        }
    }

    private class TempKeyMember {
        private String id;
        private String name;
        private String attributeRef;
        private String sortOrder;

        public TempKeyMember(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.attributeRef = "";
            this.sortOrder = "";
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setAttributeRef(String string) {
            this.attributeRef = string;
        }

        public String getAttributeRef() {
            return this.attributeRef;
        }

        public void setSortOrder(String string) {
            this.sortOrder = string;
        }

        public String getSortOrder() {
            return this.sortOrder;
        }
    }

    private class TempKey {
        private String id;
        private String name;
        private String physicalName;
        private String type;
        private String definition;
        private List keyMembers;

        public TempKey(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.physicalName = "";
            this.type = "";
            this.definition = "";
            this.keyMembers = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setPhysicalName(String string) {
            if (!string.startsWith("%")) {
                this.physicalName = string;
            }
        }

        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getType() {
            return this.type;
        }

        public void setDefinition(String string) {
            this.definition = string;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void initKeyMembers() {
            this.keyMembers = new ArrayList();
        }

        public List getKeyMembers() {
            return this.keyMembers;
        }

        public TempKeyMember getKeyMember(int n) {
            return (TempKeyMember)this.keyMembers.get(n);
        }

        public void addKeyMember(TempKeyMember tempKeyMember) {
            this.keyMembers.add(tempKeyMember);
        }
    }

    private class TempAttribute {
        private String id;
        private String name;
        private String physicalName;
        private String hideInLogical;
        private String hideInPhysical;
        private String parentAttrRef;
        private String parentRelRef;
        private String parentDomRef;
        private String logicalDataType;
        private String physicalDataType;
        private String definition;
        private String nullOptionType;
        private String validRuleRef;
        private String defaultRef;
        private String fontRef;
        private String fontColor;
        private String comment;
        private List sourceOfTransforms;
        private List targetOfTransforms;
        private String viewExpression;
        private String logicalRef;
        private String physicalRef;

        public TempAttribute(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.physicalName = "";
            this.hideInLogical = "";
            this.hideInPhysical = "";
            this.parentAttrRef = "";
            this.parentRelRef = "";
            this.parentDomRef = "";
            this.logicalDataType = "";
            this.physicalDataType = "";
            this.definition = "";
            this.nullOptionType = "";
            this.validRuleRef = "";
            this.defaultRef = "";
            this.fontRef = "";
            this.fontColor = "";
            this.comment = "";
            this.viewExpression = "";
            this.sourceOfTransforms = new ArrayList();
            this.targetOfTransforms = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setPhysicalName(String string) {
            if (!string.startsWith("%")) {
                this.physicalName = string;
            }
        }

        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setHideInLogical(String string) {
            this.hideInLogical = string;
        }

        public String getHideInLogical() {
            return this.hideInLogical;
        }

        public void setHideInPhysical(String string) {
            this.hideInPhysical = string;
        }

        public String getHideInPhysical() {
            return this.hideInPhysical;
        }

        public void setParentAttrRef(String string) {
            this.parentAttrRef = string;
        }

        public String getParentAttrRef() {
            return this.parentAttrRef;
        }

        public void setParentRelRef(String string) {
            this.parentRelRef = string;
        }

        public String getParentRelRef() {
            return this.parentRelRef;
        }

        public void setParentDomRef(String string) {
            this.parentDomRef = string;
        }

        public String getParentDomRef() {
            return this.parentDomRef;
        }

        public void setLogicalDataType(String string) {
            this.logicalDataType = string;
        }

        public String getLogicalDataType() {
            return this.logicalDataType;
        }

        public void setPhysicalDataType(String string) {
            this.physicalDataType = string;
        }

        public String getPhysicalDataType() {
            return this.physicalDataType;
        }

        public void setDefinition(String string) {
            this.definition = string;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setNullOptionType(String string) {
            this.nullOptionType = string;
        }

        public String getNullOptionType() {
            return this.nullOptionType;
        }

        public void setValidRuleRef(String string) {
            this.validRuleRef = string;
        }

        public String getValidRuleRef() {
            return this.validRuleRef;
        }

        public void setDefaultRef(String string) {
            this.defaultRef = string;
        }

        public String getDefaultRef() {
            return this.defaultRef;
        }

        public void setFontRef(String string) {
            this.fontRef = string;
        }

        public String getFontRef() {
            return this.fontRef;
        }

        public void setFontColor(String string) {
            this.fontColor = string;
        }

        public String getFontColor() {
            return this.fontColor;
        }

        public void setComment(String string) {
            this.comment = "".equals(this.comment) ? string : this.comment.concat(StringUtilities.NEWLINE).concat(string);
        }

        public String getComment() {
            return this.comment;
        }

        public void setViewExpression(String string) {
            this.viewExpression = string;
        }

        public String getViewExpression() {
            return this.viewExpression;
        }

        public void initSourceOfTransforms() {
            this.sourceOfTransforms = new ArrayList();
        }

        public List getSourceOfTransforms() {
            return this.sourceOfTransforms;
        }

        public String getSourceOfTransform(int n) {
            return (String)this.sourceOfTransforms.get(n);
        }

        public void addSourceOfTransform(String string) {
            this.sourceOfTransforms.add(string);
        }

        public void initTargetOfTransforms() {
            this.targetOfTransforms = new ArrayList();
        }

        public List getTargetOfTransforms() {
            return this.targetOfTransforms;
        }

        public String getTargetOfTransform(int n) {
            return (String)this.targetOfTransforms.get(n);
        }

        public void addTargetOfTransform(String string) {
            this.targetOfTransforms.add(string);
        }

        public String getLogicalRef() {
            return this.logicalRef;
        }

        public void setLogicalRef(String string) {
            this.logicalRef = string;
        }

        public String getPhysicalRef() {
            return this.physicalRef;
        }

        public void setPhysicalRef(String string) {
            this.physicalRef = string;
        }
    }

    private class TempEntity {
        private String id;
        private String name;
        private String type;
        private String physicalName;
        private String schemaName;
        private String physicalOnly;
        private String logicalOnly;
        private String hideInLogical;
        private String hideInPhysical;
        private String definition;
        private String bgColorVal;
        private String outlineColorVal;
        private String nameFontID;
        private String nameColorVal;
        private String compressType;
        private String comment;
        private String partitionType;
        private String compositeType;
        private List sourceOfTransforms;
        private List targetOfTransforms;
        private List attributes;
        private List keys;
        private List validRuleRefs;
        private List physicalStorages;
        private List triggers;
        private List storedProcedureRefs;
        private List functionRefs;
        private List partitions;
        private List<String> columnsOrder = new ArrayList<String>();
        private List<String> attributesOrder = new ArrayList<String>();

        public TempEntity(String string, String string2) {
            this.id = string;
            this.name = string2;
            this.type = "";
            this.physicalName = "";
            this.schemaName = "";
            this.physicalOnly = "";
            this.logicalOnly = "";
            this.hideInLogical = "";
            this.hideInPhysical = "";
            this.definition = "";
            this.bgColorVal = "";
            this.outlineColorVal = "";
            this.nameFontID = "";
            this.nameColorVal = "";
            this.compressType = "";
            this.comment = "";
            this.partitionType = "";
            this.compositeType = "";
            this.sourceOfTransforms = new ArrayList();
            this.targetOfTransforms = new ArrayList();
            this.attributes = new ArrayList();
            this.keys = new ArrayList();
            this.validRuleRefs = new ArrayList();
            this.physicalStorages = new ArrayList();
            this.triggers = new ArrayList();
            this.storedProcedureRefs = new ArrayList();
            this.functionRefs = new ArrayList();
            this.partitions = new ArrayList();
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getType() {
            return this.type;
        }

        public void setPhysicalName(String string) {
            if (!string.startsWith("%")) {
                this.physicalName = string;
            }
        }

        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setSchemaName(String string) {
            this.schemaName = string;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setPhysicalOnly(String string) {
            this.physicalOnly = string;
        }

        public String getPhysicalOnly() {
            return this.physicalOnly;
        }

        public void setLogicalOnly(String string) {
            this.logicalOnly = string;
        }

        public String getLogicalOnly() {
            return this.logicalOnly;
        }

        public void setHideInLogical(String string) {
            this.hideInLogical = string;
        }

        public String getHideInLogical() {
            return this.hideInLogical;
        }

        public void setHideInPhysical(String string) {
            this.hideInPhysical = string;
        }

        public String getHideInPhysical() {
            return this.hideInPhysical;
        }

        public void setDefinition(String string) {
            this.definition = string;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setBgColorVal(String string) {
            this.bgColorVal = string;
        }

        public String getBgColorVal() {
            return this.bgColorVal;
        }

        public void setOutlineColorVal(String string) {
            this.outlineColorVal = string;
        }

        public String getOutlineColorVal() {
            return this.outlineColorVal;
        }

        public void setNameFontID(String string) {
            this.nameFontID = string;
        }

        public String getNameFontID() {
            return this.nameFontID;
        }

        public void setNameColorVal(String string) {
            this.nameColorVal = string;
        }

        public String getNameColorVal() {
            return this.nameColorVal;
        }

        public void setCompressType(String string) {
            this.compressType = string;
        }

        public String getCompressType() {
            return this.compressType;
        }

        public void setComment(String string) {
            this.comment = "".equals(this.comment) ? string : this.comment.concat(StringUtilities.NEWLINE).concat(string);
        }

        public String getComment() {
            return this.comment;
        }

        public void setPartitionType(String string) {
            this.partitionType = string;
        }

        public String getPartitionType() {
            return this.partitionType;
        }

        public void setCompositeType(String string) {
            this.compositeType = string;
        }

        public String getCompositeType() {
            return this.compositeType;
        }

        public void initSourceOfTransforms() {
            this.sourceOfTransforms = new ArrayList();
        }

        public List getSourceOfTransforms() {
            return this.sourceOfTransforms;
        }

        public String getSourceOfTransform(int n) {
            return (String)this.sourceOfTransforms.get(n);
        }

        public void addSourceOfTransform(String string) {
            this.sourceOfTransforms.add(string);
        }

        public void initTargetOfTransforms() {
            this.targetOfTransforms = new ArrayList();
        }

        public List getTargetOfTransforms() {
            return this.targetOfTransforms;
        }

        public String getTargetOfTransform(int n) {
            return (String)this.targetOfTransforms.get(n);
        }

        public void addTargetOfTransform(String string) {
            this.targetOfTransforms.add(string);
        }

        public void initAttributes() {
            this.attributes = new ArrayList();
        }

        public List getAttributes() {
            return this.attributes;
        }

        public TempAttribute getAttribute(int n) {
            return (TempAttribute)this.attributes.get(n);
        }

        public void addAttribute(TempAttribute tempAttribute) {
            this.attributes.add(tempAttribute);
        }

        public void initKeys() {
            this.keys = new ArrayList();
        }

        public List getKeys() {
            return this.keys;
        }

        public TempKey getKey(int n) {
            return (TempKey)this.keys.get(n);
        }

        public void addKey(TempKey tempKey) {
            this.keys.add(tempKey);
        }

        public void initValidRuleRefs() {
            this.validRuleRefs = new ArrayList();
        }

        public List getValidRuleRefs() {
            return this.validRuleRefs;
        }

        public String getValidRuleRef(int n) {
            return (String)this.validRuleRefs.get(n);
        }

        public void addValidRuleRef(String string) {
            this.validRuleRefs.add(string);
        }

        public void initPhysicalStorages() {
            this.physicalStorages = new ArrayList();
        }

        public List getPhysicalStorages() {
            return this.physicalStorages;
        }

        public TempPhysicalStorage getPhysicalStorage(int n) {
            return (TempPhysicalStorage)this.physicalStorages.get(n);
        }

        public void addPhysicalStorage(TempPhysicalStorage tempPhysicalStorage) {
            this.physicalStorages.add(tempPhysicalStorage);
        }

        public void initTriggers() {
            this.triggers = new ArrayList();
        }

        public List getTriggers() {
            return this.triggers;
        }

        public TempTrigger getTrigger(int n) {
            return (TempTrigger)this.triggers.get(n);
        }

        public void addTrigger(TempTrigger tempTrigger) {
            this.triggers.add(tempTrigger);
        }

        public void initStoredProcedureRefs() {
            this.storedProcedureRefs = new ArrayList();
        }

        public List getStoredProcedureRefs() {
            return this.storedProcedureRefs;
        }

        public String getStoredProcedureRef(int n) {
            return (String)this.storedProcedureRefs.get(n);
        }

        public void addStoredProcedureRef(String string) {
            this.storedProcedureRefs.add(string);
        }

        public void initFunctionRefs() {
            this.functionRefs = new ArrayList();
        }

        public List getFunctionRefs() {
            return this.functionRefs;
        }

        public String getFunctionRef(int n) {
            return (String)this.functionRefs.get(n);
        }

        public void addFunctionRef(String string) {
            this.functionRefs.add(string);
        }

        public void initPartitions() {
            this.partitions = new ArrayList();
        }

        public List getPartitions() {
            return this.partitions;
        }

        public TempPartition getPartition(int n) {
            return (TempPartition)this.partitions.get(n);
        }

        public void addPartition(TempPartition tempPartition) {
            this.partitions.add(tempPartition);
        }

        public List<String> getColumnsOrder() {
            return this.columnsOrder;
        }

        public List<String> getAttributesOrder() {
            return this.attributesOrder;
        }
    }

    private class FKElement {
        private String id;
        private String parentAttributeID;
        private String parentRelationshipID;
        private String logicalRef;
        private String physicalRef;

        public FKElement(String string, String string2, String string3) {
            this.id = string;
            this.parentAttributeID = string2;
            this.parentRelationshipID = string3;
        }

        public String getID() {
            return this.id;
        }

        public String getParentAttributeID() {
            return this.parentAttributeID;
        }

        public String getParentRelationshipID() {
            return this.parentRelationshipID;
        }

        public String getLogicalRef() {
            return this.logicalRef;
        }

        public void setLogicalRef(String string) {
            this.logicalRef = string;
        }

        public String getPhysicalRef() {
            return this.physicalRef;
        }

        public void setPhysicalRef(String string) {
            this.physicalRef = string;
        }
    }
}

