/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.domains;

import java.util.List;
import oracle.dbtools.crest.imports.domains.DomainPropertiesComparator;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;

public class DomainsImporter {
    private Design design;

    public DomainsImporter(Design design) {
        this.design = design;
    }

    public void importDomains(List list, String string) {
        for (EngineeringObjectSelection engineeringObjectSelection : list) {
            if (!engineeringObjectSelection.isSelected()) continue;
            this.processDomain(engineeringObjectSelection, string);
        }
    }

    private void processDomain(EngineeringObjectSelection engineeringObjectSelection, String string) {
        Domain domain = (Domain)engineeringObjectSelection.getObject();
        if (ModelIdObjectSelection.STATE_NEW == engineeringObjectSelection.getStatus()) {
            Domain domain2 = this.design.getDomainSet().createDomain(domain.getObjectID());
            domain2.setOwnerDesign(this.design);
            domain.copyTo(domain2);
            domain2.setFileName(string);
            domain2.setImportedId(domain.getObjectID());
        } else {
            DomainPropertiesComparator domainPropertiesComparator = (DomainPropertiesComparator)engineeringObjectSelection.getPropertiesComparator();
            domainPropertiesComparator.copySelectedProperties();
            ((Domain)engineeringObjectSelection.getCorrespondentNode().getObject()).setImportedId(domain.getObjectID());
            ((Domain)engineeringObjectSelection.getCorrespondentNode().getObject()).setFileName(string);
        }
    }
}

