/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.domains;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.AbstractConstraint;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;

public class DomainPropertiesComparator
extends EngPropertiesComparator {
    private Domain left_co;
    private Domain right_co;
    private static String LOGICAL_AND_DATA_TYPES = "Logical Type / Data Type";

    DomainPropertiesComparator(Domain domain, Domain domain2) {
        super(domain, domain2);
        this.left_co = domain;
        this.right_co = domain2;
        this.initPropertiesList();
    }

    private static String getType(Domain domain) {
        String string = domain.getDataType().toString();
        return string;
    }

    private void processDataType(Domain domain, Domain domain2) {
        String string = domain != null ? domain.getLogicalDatatype().getName() : "";
        String string2 = domain2 != null ? domain2.getLogicalDatatype().getName() : "";
        String string3 = domain != null ? DomainPropertiesComparator.getType(domain) : "";
        String string4 = domain2 != null ? DomainPropertiesComparator.getType(domain2) : "";
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(LOGICAL_AND_DATA_TYPES);
        engPropertyHolder.setLeftValue(string + " / " + string3);
        engPropertyHolder.setRightValue(string2 + " / " + string4);
        if (domain != null && domain2 != null && !string3.equalsIgnoreCase(string4)) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(SYNONYM);
        engPropertyHolder.setLeftValue(this.left_co != null ? this.left_co.getSynonym() : "");
        engPropertyHolder.setRightValue(this.right_co != null ? this.right_co.getSynonym() : "");
        if (this.left_co != null && this.right_co != null && !this.left_co.getSynonym().equals(this.right_co.getSynonym())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        this.processDataType(this.left_co, this.right_co);
        this.propertiesList.add(this.createCheckConstrPH());
        this.propertiesList.add(this.createRangeConstrPH());
        this.propertiesList.add(this.createLOVConstraintPH());
        this.initCommentsAndNotes();
    }

    @Override
    protected void copyPropertiesFromLeftToRight() {
        if (this.left_co != null && this.right_co != null) {
            this.right_co.setTemporaryWriteable(true);
            super.copyPropertiesFromLeftToRight();
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(LOGICAL_AND_DATA_TYPES)) {
                    this.right_co.setLogicalDatatype(this.left_co.getLogicalDatatype());
                    this.right_co.setDataTypeParameter("precision", this.left_co.getDataTypeParameter("precision"));
                    this.right_co.setDataTypeParameter("scale", this.left_co.getDataTypeParameter("scale"));
                    this.right_co.setDataTypeParameter("size", this.left_co.getDataTypeParameter("size"));
                    continue;
                }
                if (engPropertyHolder.getName().equals(SYNONYM)) {
                    this.right_co.setSynonym(this.left_co.getSynonym());
                    continue;
                }
                if (engPropertyHolder.getName().equals(CHECK_CONSTRAINT)) {
                    DomainPropertiesComparator.copyCheckConstrant(this.left_co, this.right_co);
                    continue;
                }
                if (engPropertyHolder.getName().equals(RANGE_CONSTRAINT)) {
                    DomainPropertiesComparator.copyRangeConstrant(this.left_co, this.right_co);
                    continue;
                }
                if (!engPropertyHolder.getName().equals(LOV_CONSTRAINT)) continue;
                DomainPropertiesComparator.copyLOVConstrant(this.left_co, this.right_co);
            }
            this.right_co.setTemporaryWriteable(false);
        }
    }

    private EngPropertyHolder createCheckConstrPH() {
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(CHECK_CONSTRAINT);
        if (this.left_co != null && this.left_co.getCheck() != null) {
            CheckConstraint checkConstraint = this.left_co.getCheck();
            engPropertyHolder.setLeftValue(checkConstraint.toString());
        } else {
            engPropertyHolder.setLeftValue("");
        }
        if (this.right_co != null && this.right_co.getCheck() != null) {
            CheckConstraint checkConstraint = this.right_co.getCheck();
            engPropertyHolder.setRightValue(checkConstraint.toString());
        } else {
            engPropertyHolder.setRightValue("");
        }
        if (this.left_co != null && this.right_co != null && (this.left_co.getCheck() != null && this.right_co.getCheck() == null || this.left_co.getCheck() == null && this.right_co.getCheck() != null || (this.left_co.getCheck() != null || this.right_co.getCheck() != null) && !this.left_co.getCheck().equals(this.right_co.getCheck()))) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        return engPropertyHolder;
    }

    private EngPropertyHolder createLOVConstraintPH() {
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(LOV_CONSTRAINT);
        ConstraintEnumeration constraintEnumeration = null;
        if (this.left_co != null && this.left_co.getValueList() != null) {
            constraintEnumeration = this.left_co.getValueList();
            engPropertyHolder.setLeftValue(constraintEnumeration.toString());
        } else {
            engPropertyHolder.setLeftValue("");
        }
        ConstraintEnumeration constraintEnumeration2 = null;
        if (this.right_co != null && this.right_co.getValueList() != null) {
            constraintEnumeration2 = this.right_co.getValueList();
            engPropertyHolder.setRightValue(constraintEnumeration2.toString());
        } else {
            engPropertyHolder.setRightValue("");
        }
        if (this.left_co != null && this.right_co != null && (constraintEnumeration != null && constraintEnumeration2 == null || constraintEnumeration == null && constraintEnumeration2 != null || constraintEnumeration != null && constraintEnumeration2 != null && !constraintEnumeration.equals(constraintEnumeration2))) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        return engPropertyHolder;
    }

    private EngPropertyHolder createRangeConstrPH() {
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(RANGE_CONSTRAINT);
        if (this.left_co != null) {
            engPropertyHolder.setLeftValue(this.getAVTsToString(this.left_co));
        } else {
            engPropertyHolder.setLeftValue("");
        }
        if (this.right_co != null) {
            engPropertyHolder.setRightValue(this.getAVTsToString(this.right_co));
        } else {
            engPropertyHolder.setRightValue("");
        }
        if (this.left_co != null && this.right_co != null && !this.haveEqualAVTs(this.left_co, this.right_co)) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        return engPropertyHolder;
    }

    private String getAVTsToString(Domain domain) {
        StringBuffer stringBuffer = new StringBuffer();
        for (AVT aVT : domain.getAVTs()) {
            stringBuffer.append(aVT.toString()).append("\n ");
        }
        return stringBuffer.toString();
    }

    private boolean haveEqualAVTs(Domain domain, Domain domain2) {
        Object[] objectArray;
        Object[] objectArray2 = domain.getAVTs().toArray();
        if (objectArray2.length != (objectArray = domain2.getAVTs().toArray()).length) {
            return false;
        }
        for (int i = 0; i < objectArray2.length; ++i) {
            if (objectArray2[i].equals(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    public static void copyCheckConstrant(Domain domain, Domain domain2) {
        CheckConstraint checkConstraint = domain.getCheck();
        if (checkConstraint == null) {
            domain2.setCheck(null);
            return;
        }
        CheckConstraint checkConstraint2 = domain2.getCheck();
        if (checkConstraint2 == null) {
            checkConstraint2 = new CheckConstraint();
            checkConstraint2.setDesign(domain2.getDesign());
        }
        domain2.setCheck(checkConstraint2);
        checkConstraint.copyTo(checkConstraint2);
    }

    public static void copyLOVConstrant(Domain domain, Domain domain2) {
        ConstraintEnumeration constraintEnumeration = domain.getValueList();
        if (constraintEnumeration == null) {
            domain2.setValueList(null);
            return;
        }
        ConstraintEnumeration constraintEnumeration2 = domain2.getValueList();
        if (constraintEnumeration2 == null) {
            constraintEnumeration2 = new ConstraintEnumeration();
            constraintEnumeration2.setDesign(domain2.getDesign());
        }
        domain2.setValueList(constraintEnumeration2);
        ((AbstractConstraint)constraintEnumeration).copyTo(constraintEnumeration2);
    }

    public static void copyRangeConstrant(Domain domain, Domain domain2) {
        domain2.setAVTSortOrder(domain.getAVTSortOrder());
        Iterator iterator = domain.getAVTs().iterator();
        domain2.clearAVTs();
        while (iterator.hasNext()) {
            AVT aVT = (AVT)iterator.next();
            AVT aVT2 = new AVT(aVT.getBeginValue(), aVT.getEndValue(), aVT.getDescription());
            domain2.addAVT(aVT2);
        }
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
    }
}

