/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ParseException;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.SequenceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateSequenceUDBv81
extends DDLStatementHandler {
    private String userName;
    private String line;
    private static final Logger LOGGER = new Logger(SHCreateSequenceUDBv81.class);

    public SHCreateSequenceUDBv81(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateSequenceUDBv81.clearCR(string);
        this.line = string;
        if (Token.startsWithString(string2, "create sequence")) {
            this.parseSequence(string2);
        } else {
            this.nextHandler(string);
        }
    }

    public void parseSequence(String string) {
        SequenceUDBv81 sequenceUDBv81;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDBv81 storageDesignUDBv81 = (StorageDesignUDBv81)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignUDBv81 != null && (sequenceUDBv81 = (SequenceUDBv81)storageDesignUDBv81.getSequenceSet().createSequence()) != null) {
            try {
                this.initName(sequenceUDBv81);
                this.initOwner(sequenceUDBv81, storageDesignUDBv81);
                this.initDataType(sequenceUDBv81);
                this.initStartWith(sequenceUDBv81);
                this.initIncrementBy(sequenceUDBv81);
                this.initMaxValue(sequenceUDBv81);
                this.initMinValue(sequenceUDBv81);
                this.initCycle(sequenceUDBv81);
                this.initCache(sequenceUDBv81);
                this.initOrder(sequenceUDBv81);
                this.importLog.incrementImportedStatements();
                this.design.getRelationalDesign().stampModelObjectDDL(sequenceUDBv81);
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string + " for UDB 8.1 failed!", exception);
                this.importLog.addFailedStatement(SHCreateSequenceUDBv81.FormatCR(this.line, "\n"));
            }
        }
    }

    private void initName(SequenceUDBv81 sequenceUDBv81) {
        String string = Token.getTokenAfter(this.statement, "SEQUENCE").trim();
        int n = string.indexOf(46);
        if (n > 0) {
            this.userName = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "SEQUENCE"), '.');
            string = Token.getValAfterCharacter(Token.getTokenAfter(this.statement, "SEQUENCE"), '.');
        }
        sequenceUDBv81.setName(string);
    }

    private void initOwner(SequenceUDBv81 sequenceUDBv81, StorageDesignUDBv81 storageDesignUDBv81) {
        if (this.userName != null) {
            SchemaUDBv81 schemaUDBv81 = (SchemaUDBv81)storageDesignUDBv81.getSchemaSet().getByName(this.userName);
            if (schemaUDBv81 == null) {
                schemaUDBv81 = (SchemaUDBv81)storageDesignUDBv81.getSchemaSet().createSchema();
                schemaUDBv81.setName(this.userName);
                this.design.getRelationalDesign().stampModelObjectDDL(schemaUDBv81);
            }
            sequenceUDBv81.setSchema(schemaUDBv81);
        }
    }

    private void initDataType(SequenceUDBv81 sequenceUDBv81) throws ParseException {
        if (!Token.hasString(this.statement, "AS")) {
            this.importLog.addWarning("Wrong datatype in statement " + this.statement);
            throw new ParseException("wrong format in SHCreateSequenceDB2v80.initDataType: ");
        }
        String string = Token.getTokenAfter(this.statement, "AS").trim();
        sequenceUDBv81.setDatatype(string);
    }

    private void initStartWith(SequenceUDBv81 sequenceUDBv81) throws ParseException {
        if (Token.hasString(this.statement, "START")) {
            String string = Token.getTokenAfter(this.statement, "WITH").trim();
            try {
                int n = Integer.parseInt(string);
                sequenceUDBv81.setStartWith(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong START WITH format in statement " + this.statement);
                throw new ParseException("wrong format in SHCreateSequenceDB2v80.initStartWith : " + numberFormatException.getMessage());
            }
        } else {
            this.importLog.addWarning("Wrong START WITH format in statement " + this.statement);
            throw new ParseException("wrong format in SHCreateSequenceDB2v80.initStartWith : ");
        }
    }

    private void initIncrementBy(SequenceUDBv81 sequenceUDBv81) {
        if (Token.hasToken(this.statement, "BY")) {
            String string = Token.getTokenAfter(this.statement, "BY").trim();
            try {
                int n = Integer.parseInt(string);
                sequenceUDBv81.setIncrementBy(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong INCREMENT BY format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSequenceDB2v80.initIncrementBy : " + numberFormatException.getMessage());
            }
        }
    }

    private void initMaxValue(SequenceUDBv81 sequenceUDBv81) {
        if (Token.hasToken(this.statement, "MAXVALUE")) {
            if (!Token.getTokenBefore(this.statement, "MAXVALUE").equalsIgnoreCase("NO")) {
                String string = Token.getTokenAfter(this.statement, "MAXVALUE").trim();
                try {
                    Integer.parseInt(string);
                    sequenceUDBv81.setMaxValue(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.importLog.addWarning("Wrong MAX VALUE format in statement " + this.statement);
                    LOGGER.error("wrong format in SHCreateSequenceOracle.initMaxValue : " + numberFormatException.getMessage());
                }
            } else {
                sequenceUDBv81.setMaxValue("NO");
            }
        } else {
            sequenceUDBv81.setMaxValue("NO");
        }
    }

    private void initMinValue(SequenceUDBv81 sequenceUDBv81) {
        if (Token.hasToken(this.statement, "MINVALUE")) {
            if (!Token.getTokenBefore(this.statement, "MINVALUE").equalsIgnoreCase("NO")) {
                String string = Token.getTokenAfter(this.statement, "MINVALUE").trim();
                try {
                    Integer.parseInt(string);
                    sequenceUDBv81.setMinValue(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.importLog.addWarning("Wrong MIN VALUE format in statement " + this.statement);
                    LOGGER.error("wrong format in SHCreateSequenceDB2v80.initMinValue : " + numberFormatException.getMessage());
                }
            } else {
                sequenceUDBv81.setMinValue("NO");
            }
        } else {
            sequenceUDBv81.setMinValue("NO");
        }
    }

    private void initCycle(SequenceUDBv81 sequenceUDBv81) {
        if (Token.hasToken(this.statement, "CYCLE")) {
            if (!Token.getTokenBefore(this.statement, "CYCLE").equalsIgnoreCase("NO")) {
                sequenceUDBv81.setCycle("YES");
            } else {
                sequenceUDBv81.setCycle("NO");
            }
        } else {
            sequenceUDBv81.setCycle("NO");
        }
    }

    private void initCache(SequenceUDBv81 sequenceUDBv81) {
        if (Token.hasToken(this.statement, "CACHE")) {
            if (!Token.getTokenBefore(this.statement, "CACHE").equalsIgnoreCase("NO")) {
                String string = Token.getTokenAfter(this.statement, "CACHE").trim();
                try {
                    int n = Integer.parseInt(string);
                    sequenceUDBv81.setCache(n);
                }
                catch (NumberFormatException numberFormatException) {
                    this.importLog.addWarning("Wrong CACHE format in statement " + this.statement);
                    LOGGER.error("wrong format in SHCreateSequenceDB2v80.initCache : " + numberFormatException.getMessage());
                }
            } else {
                sequenceUDBv81.setCache(0);
            }
        } else {
            sequenceUDBv81.setCache(0);
        }
    }

    private void initOrder(SequenceUDBv81 sequenceUDBv81) {
        if (Token.hasToken(this.statement, "ORDER")) {
            if (!Token.getTokenBefore(this.statement, "ORDER").equalsIgnoreCase("NO")) {
                sequenceUDBv81.setOrder("YES");
            } else {
                sequenceUDBv81.setOrder("NO");
            }
        } else {
            sequenceUDBv81.setOrder("NO");
        }
    }
}

