/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.DataBaseUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDatabaseUDBv81
extends DDLStatementHandler {
    private DataBaseUDBv81 database;
    private static final Logger LOGGER = new Logger(SHCreateDatabaseUDBv81.class);

    public SHCreateDatabaseUDBv81(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateDatabaseUDBv81.clearCR(string);
        if ((Token.startsWithString(string2, "create database") || Token.startsWithString(string2, "create db ")) && !Token.startsWithString(string2, "create database partition group")) {
            try {
                this.parseDatabase(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for UDB 8.1 failed!", exception);
                this.importLog.addFailedStatement(SHCreateDatabaseUDBv81.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseDatabase(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDBv81 storageDesignUDBv81 = (StorageDesignUDBv81)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignUDBv81 != null) {
            this.database = (DataBaseUDBv81)storageDesignUDBv81.getDataBaseSet().createDataBase();
            String string2 = this.initDatabaseName();
            this.database.setName(string2);
            this.initOnPath();
            this.initAlias();
            this.initCodeSet();
            this.initTerritory();
            this.initCollate();
            this.initNumSegs();
            this.initDFTExtentSize();
            this.initCatalogTableSpace();
            this.initUserTableSpace();
            this.initTempTableSpace();
            this.initWith();
            this.initAutoConfigure();
            this.design.getRelationalDesign().stampModelObjectDDL(this.database);
        }
    }

    private String initDatabaseName() {
        return Token.getNameAfterToken(this.statement, "DATABASE", '\"', '\"').trim();
    }

    private void initOnPath() {
        if (Token.hasToken(this.statement, "ON")) {
            String string = Token.getTokenAfter(this.statement, "ON");
            this.database.setOnPath(string);
        }
    }

    private void initAlias() {
        if (Token.hasToken(this.statement, "ALIAS")) {
            String string = Token.getTokenAfter(this.statement, "ALIAS");
            this.database.setAlias(string);
        }
    }

    private void initCodeSet() {
        if (Token.hasToken(this.statement, "CODESET")) {
            String string = Token.getTokenAfter(this.statement, "CODESET");
            this.database.setCodeSet(string);
        }
    }

    private void initTerritory() {
        if (Token.hasToken(this.statement, "TERRITORY")) {
            String string = Token.getTokenAfter(this.statement, "TERRITORY");
            this.database.setTerritory(string);
        }
    }

    private void initCollate() {
        if (Token.hasToken(this.statement, "COLLATE")) {
            String string = Token.getStringAfterToken(this.statement, "COLLATE");
            string = Token.getTokenAfter(string, "USING");
            String[] stringArray = DataBaseUDBv81.getAvailableCollatingSequences();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                this.database.setCollatingSequence(stringArray[i]);
                break;
            }
        }
    }

    private void initNumSegs() {
        if (Token.hasToken(this.statement, "NUMSEGS")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "NUMSEGS"));
                this.database.setSegmentNumber(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong NUMSEGS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseUDB.initNumSegs : " + numberFormatException.getMessage());
            }
        }
    }

    private void initDFTExtentSize() {
        if (Token.hasToken(this.statement, "DFT_EXTENT_SZ")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "DFT_EXTENT_SZ"));
                this.database.setDefaultExtentSize(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong DFT_EXTENT_SZ format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseUDB.initDFTExtentSize : " + numberFormatException.getMessage());
            }
        }
    }

    private void initCatalogTableSpace() {
        if (Token.hasToken(this.statement, "CATALOG")) {
            String string = this.statement.substring(this.statement.indexOf("CATALOG") + "CATALOG".length()).trim();
            TableSpaceUDB tableSpaceUDB = ((StorageDesignUDBv81)this.database.getStorageDesign()).getTableSpaceSet().createTableSpace();
            this.database.setCatalogTableSpace(tableSpaceUDB);
            tableSpaceUDB.setName("CatalogTS_For_" + this.database.getName());
            this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceUDB);
            if (Token.hasToken(string, "USER")) {
                string = string.substring(0, string.indexOf("USER")).trim();
            } else if (Token.hasToken(string, "TEMPORARY")) {
                string = string.substring(0, string.indexOf("TEMPORARY")).trim();
            }
            this.initTableSpaceOptions(string, tableSpaceUDB);
        }
    }

    private void initUserTableSpace() {
        if (Token.hasToken(this.statement, "USER")) {
            String string = this.statement.substring(this.statement.indexOf("USER") + "USER".length()).trim();
            TableSpaceUDB tableSpaceUDB = ((StorageDesignUDBv81)this.database.getStorageDesign()).getTableSpaceSet().createTableSpace();
            this.database.setUserTableSpace(tableSpaceUDB);
            tableSpaceUDB.setName("UserTS_For_" + this.database.getName());
            this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceUDB);
            if (Token.hasToken(string, "TEMPORARY")) {
                string = string.substring(0, string.indexOf("TEMPORARY")).trim();
            }
            this.initTableSpaceOptions(string, tableSpaceUDB);
        }
    }

    private void initTempTableSpace() {
        if (Token.hasToken(this.statement, "TEMPORARY")) {
            String string = this.statement.substring(this.statement.indexOf("TEMPORARY") + "TEMPORARY".length()).trim();
            TableSpaceUDB tableSpaceUDB = ((StorageDesignUDBv81)this.database.getStorageDesign()).getTableSpaceSet().createTableSpace();
            tableSpaceUDB.setName("TempTS_For_" + this.database.getName());
            this.database.setTemporaryTableSpace(tableSpaceUDB);
            this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceUDB);
            this.initTableSpaceOptions(string, tableSpaceUDB);
        }
    }

    private void initTableSpaceOptions(String string, TableSpaceUDB tableSpaceUDB) {
        String string2;
        String string3;
        tableSpaceUDB.setDBDefOnly(true);
        if (Token.hasToken(string, "BY")) {
            string3 = Token.getTokenAfter(string, "BY").trim();
            tableSpaceUDB.setManagedBy(string3);
        }
        if (Token.hasToken(string, "USING") && Token.getTokenAfter(string, "USING").trim().startsWith("(")) {
            string3 = string;
            while (string3.indexOf("USING") > -1 && Token.getTokenAfter(string, "USING").trim().startsWith("(")) {
                String string4 = Token.getValBetweenBrackets(string3, 1);
                string3 = Token.getValAfterBrackets(string3, 1);
                ContainerUDB containerUDB = ((StorageDesignUDB)tableSpaceUDB.getStorageDesign()).getContainerSet().createContainer();
                this.design.getRelationalDesign().stampModelObjectDDL(containerUDB);
                if (containerUDB == null) continue;
                containerUDB.setTableSpace(tableSpaceUDB);
                containerUDB.setContainers(string4);
            }
        }
        if (Token.hasToken(string, "EXTENTSIZE")) {
            tableSpaceUDB.setExtentSize(Token.getTokenAfter(string, "EXTENTSIZE"));
        }
        if (Token.hasToken(string, "PREFETCHSIZE")) {
            tableSpaceUDB.setPrefetchSize(Token.getTokenAfter(string, "PREFETCHSIZE"));
        }
        if (Token.hasToken(string, "OVERHEAD")) {
            try {
                float f = Float.parseFloat(Token.getTokenAfter(string, "OVERHEAD"));
                tableSpaceUDB.setOverhead(f);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong OVERHEAD format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseUDB.initTableSpaceOptions : " + numberFormatException.getMessage());
            }
        }
        if (Token.hasToken(string, "TRANSFERRATE")) {
            try {
                float f = Float.parseFloat(Token.getTokenAfter(string, "TRANSFERRATE"));
                tableSpaceUDB.setTransferRate(f);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong TRANSFERRATE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseUDB.initTableSpaceOptions : " + numberFormatException.getMessage());
            }
        }
        if (Token.hasToken(string, "RECOVERY") && "ON".equalsIgnoreCase(string2 = Token.getTokenAfter(string, "RECOVERY").trim())) {
            tableSpaceUDB.setDroppedTableRecovery(true);
        }
    }

    private void initWith() {
        if (Token.hasToken(this.statement, "WITH")) {
            String string = Token.getStringAfterToken(this.statement, "WITH");
            if (!"".equalsIgnoreCase(string = Token.getValBetweenDoubleQuotes(string))) {
                this.database.setCommentInRDBMS(string);
            }
        }
    }

    private void initAutoConfigure() {
        if (Token.hasToken(this.statement, "AUTOCONFIGURE")) {
            String string;
            this.database.setAutoConfigure(true);
            String string2 = Token.getStringAfterToken(this.statement, "AUTOCONFIGURE");
            if (Token.hasToken(this.statement, "APPLY")) {
                string2 = Token.getStringBefore(this.statement, "APPLY");
                string = Token.getStringAfterToken(this.statement, "APPLY");
                if (string.toUpperCase().indexOf("DB ONLY") > -1) {
                    this.database.setApplyChanges("DB ONLY");
                } else if (string.toUpperCase().indexOf("DB AND DBM") > -1) {
                    this.database.setApplyChanges("DB AND DBM");
                } else if (string.toUpperCase().indexOf("NONE") > -1) {
                    this.database.setApplyChanges("NONE");
                }
            }
            string = "";
            if (Token.hasToken(string2, "mem_percent")) {
                this.database.setUseMemPercent(true);
                string = Token.getTokenAfter(string2, "mem_percent");
                try {
                    this.database.setMemPercent(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    this.importLog.addWarning("Wrong MEM_PERCENT format in statement " + this.statement);
                    LOGGER.error("Wrong syntax near MEM_PERCENT: " + numberFormatException.getMessage());
                }
            }
            if (Token.hasToken(string2, "workload_type")) {
                this.database.setUseWorkloadType(true);
                string = Token.getTokenAfter(string2, "workload_type");
                this.database.setWorkloadType(string);
            }
            if (Token.hasToken(string2, "num_stmts")) {
                this.database.setUseNumStmts(true);
                string = Token.getTokenAfter(string2, "num_stmts");
                try {
                    this.database.setNumStmts(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    this.importLog.addWarning("Wrong NUM_STMTS format in statement " + this.statement);
                    LOGGER.error("Wrong syntax near NUM_STMTS: " + numberFormatException.getMessage());
                }
            }
            if (Token.hasToken(string2, "tpm")) {
                this.database.setUseTpm(true);
                string = Token.getTokenAfter(string2, "tpm");
                try {
                    this.database.setTpm(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    this.importLog.addWarning("Wrong TRM format in statement " + this.statement);
                    LOGGER.error("Wrong syntax near TPM: " + numberFormatException.getMessage());
                }
            }
            if (Token.hasToken(string2, "admin_property")) {
                this.database.setUseAdminProperty(true);
                string = Token.getTokenAfter(string2, "admin_property");
                this.database.setAdminProperty(string);
            }
            if (Token.hasToken(string2, "num_local_apps")) {
                this.database.setUseNumLocalApps(true);
                string = Token.getTokenAfter(string2, "num_local_apps");
                try {
                    this.database.setNumLocalApps(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    this.importLog.addWarning("Wrong NUM_LOCAL_APPS format in statement " + this.statement);
                    LOGGER.error("Wrong syntax near NUM_LOCAL_APPS: " + numberFormatException.getMessage());
                }
            }
            if (Token.hasToken(string2, "num_remote_apps")) {
                this.database.setUseNumRemoteApps(true);
                string = Token.getTokenAfter(string2, "num_remote_apps");
                try {
                    this.database.setNumRemoteApps(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    this.importLog.addWarning("Wrong NUM_REMOTE_APPS format in statement " + this.statement);
                    LOGGER.error("Wrong syntax near NUM_REMOTE_APPS: " + numberFormatException.getMessage());
                }
            }
            if (Token.hasToken(string2, "isolation")) {
                this.database.setUseIsolation(true);
                string = Token.getTokenAfter(string2, "isolation");
                this.database.setIsolation(string);
            }
            if (Token.hasToken(string2, "bp_resizeable")) {
                this.database.setUseBpResizeable(true);
                string = Token.getTokenAfter(string2, "bp_resizeable");
                this.database.setBpResizeable(string);
            }
        }
    }
}

