/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.BufferPoolUDBv81;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateBufferPoolUDBv81
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateBufferPoolUDBv81.class);

    public SHCreateBufferPoolUDBv81(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateBufferPoolUDBv81.clearCR(string);
        if (Token.startsWithString(string2, "create bufferpool")) {
            try {
                this.parseBufferPool(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCreateBufferPoolUDBv81.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseBufferPool(String string) {
        this.statement = string;
        String string2 = Token.getQuotedNameAfterToken(this.statement, "BUFFERPOOL").trim();
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
        BufferPoolUDBv81 bufferPoolUDBv81 = (BufferPoolUDBv81)storageDesignUDB.getBufferPoolSet().createBufferPool();
        if (bufferPoolUDBv81 != null) {
            bufferPoolUDBv81.setName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(bufferPoolUDBv81);
            if (Token.getTokenAfter(this.statement, string2).trim().equalsIgnoreCase("IMMEDIATE")) {
                bufferPoolUDBv81.setCreateImmediate("YES");
            } else if (Token.getTokenAfter(this.statement, string2).trim().equalsIgnoreCase("DEFERRED")) {
                bufferPoolUDBv81.setCreateImmediate("NO");
            }
            if (string.toUpperCase().indexOf("NODEGROUP") > -1) {
                String string3 = string.substring(string.toUpperCase().indexOf("NODEGROUP") + 24);
                string3 = Token.getStringBefore(string3, "SIZE").trim();
                bufferPoolUDBv81.setScope(string3);
            } else if (string.toUpperCase().indexOf("DATABASE PARTITION GROUP") > -1) {
                String string4 = string.substring(string.toUpperCase().indexOf("DATABASE PARTITION GROUP") + 24);
                string4 = Token.getStringBefore(string4, "SIZE").trim();
                bufferPoolUDBv81.setScope(string4);
            }
            this.initSize(bufferPoolUDBv81);
            this.initPageSize(bufferPoolUDBv81);
            this.initExtendedStorage(bufferPoolUDBv81);
        }
    }

    private void initSize(BufferPoolUDBv81 bufferPoolUDBv81) {
        if (Token.hasToken(this.statement, "SIZE")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "SIZE"));
                bufferPoolUDBv81.setSize(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateBufferPoolUDBv81.initSize : " + numberFormatException.getMessage());
            }
            if (Token.hasToken(this.statement, "EXCEPT") && Token.hasCloseAndOpenBrackets(this.statement)) {
                String string = Token.getValBetweenBrackets(this.statement).trim();
                bufferPoolUDBv81.setNodesWithDiffSize(string);
            }
        }
    }

    private void initPageSize(BufferPoolUDBv81 bufferPoolUDBv81) {
        if (Token.hasToken(this.statement, "PAGESIZE")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "PAGESIZE"));
                if (!Token.getTokenAfter(this.statement, "" + n).equalsIgnoreCase("K")) {
                    n /= 1024;
                }
                bufferPoolUDBv81.setPageSize(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PAGESIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateBufferPoolUDBv81.initPageSize : " + numberFormatException.getMessage());
            }
        }
    }

    private void initExtendedStorage(BufferPoolUDBv81 bufferPoolUDBv81) {
        if (this.statement.toUpperCase().indexOf("EXTENDED STORAGE") > -1 && this.statement.toUpperCase().indexOf("NOT EXTENDED STORAGE") == -1) {
            bufferPoolUDBv81.setExtendedStorage(true);
        }
    }
}

