/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateDistinctTypeUDB;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHColumnElementsUDBv81;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;

public class DomainHandlerReadDDLUDBv81
implements StatementsConstants {
    private DomainFactory factory = new DomainFactory();
    private Design design;
    private LogicalDatatypeFactory factoryLogical;

    public DomainHandlerReadDDLUDBv81(Design design) {
        this.design = design;
        this.factoryLogical = new LogicalDatatypeFactory();
    }

    public void createDomains(LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            String string = DDLStatementHandler.clearCR((String)iterator.next());
            if (Token.startsWithString(string, "create distinct type")) {
                SHCreateDistinctTypeUDB sHCreateDistinctTypeUDB = new SHCreateDistinctTypeUDB(this.design, this.factoryLogical);
                sHCreateDistinctTypeUDB.parseDistinctType(string);
            }
            boolean bl = false;
            if (string.indexOf("AS ( SELECT") > -1 || string.indexOf("AS (SELECT") > -1) {
                bl = true;
            }
            if (!Token.startsWithString(string, "create table") || bl) continue;
            ArrayList arrayList = this.getColumns(string);
            for (String string2 : arrayList) {
                this.createOneDomain(string2);
            }
        }
    }

    private ArrayList getColumns(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = Token.getValBetweenBrackets(string, 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (Token.hasOpenBracket(string3)) {
                StringBuffer stringBuffer = new StringBuffer(string3);
                while (Token.hasOpenBracket(string3) && stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(", ").append(stringTokenizer.nextToken().trim());
                    string3 = stringBuffer.toString();
                }
            }
            arrayList.add(string3.trim());
        }
        return arrayList;
    }

    private void createOneDomain(String string) {
        Map map;
        String string2;
        SHColumnElementsUDBv81 sHColumnElementsUDBv81 = new SHColumnElementsUDBv81();
        boolean bl = false;
        if (Token.hasToken(string, "AS") && Token.hasToken(string, "SELECT")) {
            bl = true;
        }
        if (!"".equalsIgnoreCase(string2 = (String)(map = sHColumnElementsUDBv81.getElementsColumn(string, bl)).get("columnname"))) {
            String string3 = (String)map.get("datatype");
            String[] stringArray = new String[]{(String)map.get("precision"), (String)map.get("scale"), (String)map.get("size")};
            if (string3 != null) {
                String string4 = StandardDatatypeNames.getUsedDatatypeName(string3);
                LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignUDBv81.RDBMS_TYPE, string4);
                this.factory.getInstance(this.design, logicalDatatype, null, 2, stringArray, null);
            }
        }
    }
}

