/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.CreateTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.NameElements;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.udb.AggregateFunctionsUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHColumnElementsUDB;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.ConstraintType;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTableUDB
extends DDLStatementHandler
implements SectionConstants,
CreateTableHandler {
    private Table table = null;
    private RDBMSSite site = null;
    private StorageDesignUDB storageDesign = null;
    private TableProxyUDB tableProxy = null;
    private boolean createDomainsDuringImport;
    private String tableName;
    private String ownerName = null;
    private ArrayList columns;
    protected List fkList;
    protected List refAtColumnList;
    protected List tableNodeList = new ArrayList();
    private boolean dataCapture;
    private String outSideBrackets;
    private String inSideBrackets;
    private String afterColumns;
    private static final String NOT_FEDERATED = "NOT FEDERATED";
    private boolean failed = false;
    private static final Logger LOGGER = new Logger(SHCreateTableUDB.class);

    public SHCreateTableUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        block5: {
            String string2 = SHCreateTableUDB.clearCR(string);
            if (Token.startsWithString(string2, "create table") || Token.startsWithString(string2, "create summary table")) {
                try {
                    this.fkList = new ArrayList();
                    this.refAtColumnList = new ArrayList();
                    this.parseTable(string2);
                    FKRefNode fKRefNode = new FKRefNode();
                    fKRefNode.processedTable = this.table;
                    fKRefNode.fkStatements = this.fkList;
                    fKRefNode.refAtColumns = this.refAtColumnList;
                    this.tableNodeList.add(fKRefNode);
                    if (this.failed) {
                        this.importLog.addFailedStatement(SHCreateTableUDB.FormatCR(string, "\n"));
                        break block5;
                    }
                    this.importLog.incrementImportedStatements();
                }
                catch (Exception exception) {
                    LOGGER.error(" Parsing " + string2 + " for UDB failed!", exception);
                    this.importLog.addFailedStatement(SHCreateTableUDB.FormatCR(string, "\n"));
                }
            } else {
                this.nextHandler(string);
            }
        }
    }

    public void parseTable(String string) {
        this.setStatement(string);
        if (Token.hasCloseAndOpenBrackets(string)) {
            this.inSideBrackets = Token.getValBetweenBrackets(this.statement, 1).trim();
            this.outSideBrackets = Token.getValAfterBrackets(this.statement, 1).trim();
            this.afterColumns = string.substring(string.indexOf(41) + 1).trim();
        }
        this.ownerName = null;
        this.tableName = this.initTableName();
        this.table = this.design.getDesign().getRelationalDesign().createTable();
        if (this.ownerName != null && !"".equals(this.ownerName)) {
            this.table.setSchema(this.ownerName);
        }
        this.table.setName(this.tableName);
        this.design.getRelationalDesign().stampModelObjectDDL(this.table);
        this.site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignUDB)this.design.getStorageDesign(this.site);
        this.tableProxy = (TableProxyUDB)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        this.createDomainsDuringImport = this.storageDesign.getDesign().getAppView().getSettings().isCreateDomainsDuringImport();
        boolean bl = false;
        if (string.toUpperCase().indexOf("AS (SELECT") > -1 || string.toUpperCase().indexOf("AS ( SELECT") > -1) {
            if (string.toUpperCase().indexOf("AS (SELECT") > -1) {
                this.inSideBrackets = Token.getStringBefore(string, "AS (SELECT");
            } else if (string.toUpperCase().indexOf("AS ( SELECT") > -1) {
                this.inSideBrackets = Token.getStringBefore(string, "AS ( SELECT");
            }
            this.inSideBrackets = Token.getValBetweenBrackets(this.inSideBrackets);
            if (!this.initCols()) {
                this.initCol();
            }
            this.processSummaryQuery();
        } else if (Token.getTokenAfter(string, this.tableName).trim().equalsIgnoreCase("OF")) {
            String string2;
            StructuredType structuredType;
            bl = true;
            String string3 = Token.getStringAfterToken(string, "OF").trim();
            String string4 = Token.getFirstToken(string3).trim();
            int n = string4.indexOf(46);
            if (n > 0) {
                string4 = Token.getValAfterCharacter(string4, '.');
            }
            if ((structuredType = (StructuredType)this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string4)) != null) {
                this.table.setBasedOnStructuredType(structuredType);
                if (this.tableProxy.getIndexes().size() > 0) {
                    this.tableProxy.getIndexes().removeAll();
                }
            } else {
                LOGGER.error("Unable to find required Structured Type: " + string4);
            }
            if (Token.hasToken(string, "HIERARCHY")) {
                string2 = Token.getTokenAfter(string, "HIERARCHY").trim();
                this.tableProxy.setHierarchyName(string2);
            } else if (Token.hasToken(string, "UNDER")) {
                Table table;
                string2 = Token.getTokenAfter(string, "UNDER").trim();
                n = string2.indexOf(46);
                if (n > 0) {
                    string2 = Token.getValAfterCharacter(string2, '.');
                }
                if ((table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(string2)) != null) {
                    ContainerView containerView = (ContainerView)table.getTopView();
                    ContainerView containerView2 = (ContainerView)this.table.getTopView();
                    if (containerView != null && containerView2 != null) {
                        TypeSubstitution typeSubstitution = this.design.getDesign().getRelationalDesign().createTypeSubstitution();
                        this.design.getRelationalDesign().stampModelObjectDDL(typeSubstitution);
                        typeSubstitution.setChildCV(containerView2);
                        typeSubstitution.setParentCV(containerView);
                        typeSubstitution.addToAllDPVs();
                    }
                }
            }
            if (Token.hasString(string, "REF IS")) {
                string2 = Token.getStringAfter(string, "REF IS").trim();
                string2 = Token.getFirstToken(string2).trim();
                this.table.getOidElement().setName(string2);
            }
        } else {
            this.columns = this.initColumns();
            for (int i = 0; i < this.columns.size(); ++i) {
                Object object;
                String string5;
                String string6;
                Map map = (Map)this.columns.get(i);
                boolean bl2 = (Boolean)map.get("IS_CONSTRAINT");
                if (!bl2) {
                    CharSequence charSequence;
                    Object object2;
                    String string7;
                    Object object3;
                    Object object4;
                    Object object5;
                    String string8;
                    string6 = (String)map.get("columnname");
                    string6 = Token.getName(string6);
                    Column column = this.table.createColumn(string6);
                    this.design.getRelationalDesign().stampModelObjectDDL(column);
                    String string9 = (String)map.get("datatype");
                    if (string9 != null) {
                        string8 = (String)map.get("scale");
                        string5 = (String)map.get("size");
                        String string10 = (String)map.get("precision");
                        object = new String[]{string10, string8, string5};
                        object5 = StandardDatatypeNames.getUsedDatatypeName(string9);
                        object4 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), (String)object5);
                        if (this.createDomainsDuringImport) {
                            object3 = null;
                            string7 = (String)map.get("typename");
                            if (string7 != null) {
                                object2 = this.design.getDesign().getDomainSet();
                                object3 = (Domain)((DesignObjectSet)object2).getByName(string7);
                            }
                            object2 = "";
                            if (object3 == null) {
                                object2 = DomainFactory.createDomainName((LogicalDatatype)object4, (String[])object);
                                object3 = this.getCorrespondingDomain((String)object2);
                            }
                            if (object3 != null) {
                                column.setDomain((Domain)object3);
                            } else {
                                charSequence = new StringBuffer("domain is null in SHCreateTableUDB.parseTable : ");
                                charSequence.append((String)object2);
                                LOGGER.error(charSequence.toString());
                                this.importLog.addError("Null domain occurred while creating " + this.tableName);
                            }
                        } else {
                            column.setLogicalDatatype((LogicalDatatype)object4);
                            column.setUse((short)1);
                            column.setDataTypeParameter("scale", string8);
                            column.setDataTypeParameter("precision", string10);
                            column.setDataTypeParameter("size", string5);
                        }
                    } else {
                        string8 = (String)map.get(NameElements.COL_STRUCTURED_TYPE);
                        if (string8 != null && !"".equalsIgnoreCase(string8)) {
                            boolean bl3 = Token.hasToken(string8, "REF");
                            int n = (string8 = bl3 ? Token.getTokenAfter(string8, "REF") : Token.getFirstToken(string8)).indexOf(46);
                            if (n > 0) {
                                string8 = Token.getValAfterCharacter(string8, '.');
                            }
                            if ((object = (StructuredType)this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string8)) != null) {
                                column.setStructuredType((StructuredType)object);
                                column.setUse((short)3);
                                if (bl3) {
                                    column.setReference(true);
                                }
                            }
                        }
                    }
                    boolean bl4 = (Boolean)map.get("NOT NULL");
                    column.setNullsAllowed(!bl4);
                    string5 = (String)map.get("DEFAULT");
                    boolean bl5 = (Boolean)map.get("PRIMARY KEY");
                    if (bl5) {
                        object = this.table.createIndex();
                        ((Index)object).add(column);
                        ((KeyObject)object).makePK();
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
                    } else {
                        boolean bl6 = (Boolean)map.get("UNIQUE");
                        if (bl6) {
                            object5 = this.table.createIndex();
                            ((Index)object5).add(column);
                            ((Index)object5).setIndexState("Unique Constraint");
                            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object5);
                        }
                    }
                    if (this.storageDesign != null) {
                        String string11;
                        boolean bl7;
                        ColumnProxyUDB columnProxyUDB = (ColumnProxyUDB)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
                        object5 = (String)map.get("FOR");
                        if (object5 != null && "BIT".equalsIgnoreCase((String)object5)) {
                            columnProxyUDB.setForBitData(true);
                        }
                        object4 = ColumnProxyUDB.getDefaultValueChoices();
                        if (string5 != null) {
                            boolean bl8 = (Boolean)map.get("IS DEFAULT");
                            columnProxyUDB.setDefault(bl8);
                            if (string5.equalsIgnoreCase(object4[2]) || string5.equalsIgnoreCase(object4[3])) {
                                columnProxyUDB.setDefaultValue(string5);
                            } else {
                                columnProxyUDB.setDefaultValue(object4[1]);
                                columnProxyUDB.setDefaultValueConstant(string5);
                                column.setDefaultValue(string5);
                            }
                        }
                        if (string9 != null && string9.equalsIgnoreCase("BLOB")) {
                            boolean bl9 = (Boolean)map.get("NOT LOGGED");
                            columnProxyUDB.setLogging(bl9 ? "NOT LOGGED" : "LOGGED");
                            boolean bl10 = (Boolean)map.get("COMPACT");
                            columnProxyUDB.setCompact(bl10 ? "YES" : "NO");
                        }
                        if (string9 != null && string9.equalsIgnoreCase("DATALINK") && (bl7 = ((Boolean)map.get("INTEGRITY")).booleanValue())) {
                            columnProxyUDB.setLinkControl("FILE");
                            string7 = (String)map.get("READ");
                            columnProxyUDB.setReadPermission(string7);
                            object2 = (String)map.get("WRITE");
                            columnProxyUDB.setWritePermission((String)object2);
                            charSequence = (String)map.get("RECOVERY");
                            if ("YES".equalsIgnoreCase((String)charSequence)) {
                                columnProxyUDB.setRecovery("YES");
                            }
                            string11 = (String)map.get("UNLINK");
                            columnProxyUDB.setOnUnlink(string11);
                        }
                        if ((object3 = (String)map.get("GENERATED")) != null) {
                            columnProxyUDB.setUseIdentity(true);
                            for (int j = 0; j < ColumnProxyUDB.getGenerateValues().length; ++j) {
                                object2 = ColumnProxyUDB.getGenerateValues()[j];
                                if (!((String)object3).equalsIgnoreCase((String)object2)) continue;
                                columnProxyUDB.setGenerate((String)object2);
                                break;
                            }
                            if ((string7 = (String)map.get("START")) != null) {
                                columnProxyUDB.setStartWith(string7);
                            }
                            if ((object2 = (String)map.get("INCREMENT")) != null) {
                                try {
                                    int n = Integer.parseInt((String)object2);
                                    columnProxyUDB.setIncrementBy(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    LOGGER.error("wrong Format for Increment value in SHCreateTableUDB -> Init Identity: ");
                                    this.importLog.addWarning("Wrong INCREMENT format in statement " + string);
                                }
                            }
                            if ((charSequence = (String)map.get("CACHE")) != null) {
                                columnProxyUDB.setCache((String)charSequence);
                            }
                            if ((string11 = (String)map.get("GENERATION_EXPRESSION")) != null) {
                                column.setComputed(true);
                                column.setFormulaDesc(string11);
                            }
                        }
                    }
                    if ((object = (String)map.get("REFERENCES")) != null) {
                        object5 = new RefAtColNode();
                        int n = ((String)object).indexOf(46);
                        if (n > 0) {
                            object = Token.getValAfterCharacter((String)object, '.');
                        }
                        ((RefAtColNode)object5).onDelete = (String)map.get("ON DELETE");
                        ((RefAtColNode)object5).columnName = (String)map.get("columnname");
                        ((RefAtColNode)object5).refColumn = (String)map.get("REFERENCED_COLUMN");
                        ((RefAtColNode)object5).referencedTable = object;
                        this.refAtColumnList.add(object5);
                    }
                    object5 = (String)map.get("CONSTRAINT");
                    object4 = (String)map.get("CHECK");
                    if (object4 == null) continue;
                    this.initCheckConstraint((String)object4, (String)object5, column);
                    continue;
                }
                string6 = (String)map.get("CONSTRAINT_NAME");
                boolean bl11 = (Boolean)map.get("PRIMARY KEY");
                if (bl11) {
                    Index index = this.table.createIndex();
                    this.design.getRelationalDesign().stampModelObjectDDL(index);
                    if (!"".equalsIgnoreCase(string6)) {
                        index.setName(string6);
                    } else {
                        if (this.tableName.length() > 125) {
                            this.tableName = this.tableName.substring(0, 125);
                        }
                        index.setName(this.tableName + "_PK");
                    }
                    String string12 = (String)map.get("CONSTRAINT_VALUE");
                    try {
                        SHCreateTableUDB.setColumnsForIndexPK(index, string12, this.importLog);
                        index.makePK();
                    }
                    catch (ObjectDoesNotExistException objectDoesNotExistException) {
                        StringBuffer stringBuffer = new StringBuffer(objectDoesNotExistException.getMessage());
                        stringBuffer.append(" in SHCreateTableUDB.parseTable:PRIMARY KEY");
                        LOGGER.error(stringBuffer.toString());
                        this.importLog.addError("Columns for primary key " + index.getName() + " don't exist.");
                        this.failed = true;
                    }
                    continue;
                }
                boolean bl12 = (Boolean)map.get("UNIQUE");
                if (bl12) {
                    Index index = this.table.createIndex();
                    this.design.getRelationalDesign().stampModelObjectDDL(index);
                    if (!"".equalsIgnoreCase(string6)) {
                        index.setName(string6);
                    } else {
                        if (this.tableName.length() > 123) {
                            this.tableName = this.tableName.substring(0, 123);
                        }
                        index.setName(this.tableName + "_UK" + this.table.getUKeys().size());
                    }
                    string5 = (String)map.get("CONSTRAINT_VALUE");
                    try {
                        SHCreateTableUDB.setColumnsForIndexPK(index, string5, this.importLog);
                        index.setIndexState("Unique Constraint");
                    }
                    catch (ObjectDoesNotExistException objectDoesNotExistException) {
                        object = new StringBuffer(objectDoesNotExistException.getMessage());
                        ((StringBuffer)object).append(" in SHCreateTableUDB.parseTable:UNIQUE");
                        LOGGER.error(((StringBuffer)object).toString());
                        this.importLog.addError("Columns for unique key " + index.getName() + " don't exist.");
                        this.failed = true;
                    }
                    index.setIndexState("Unique Constraint");
                    continue;
                }
                boolean bl13 = (Boolean)map.get("CHECK");
                if (!bl13) continue;
                string5 = (String)map.get("CONSTRAINT_VALUE");
                if (this.tableName.length() > 13) {
                    this.tableName = this.tableName.substring(0, 13);
                }
                if (this.tableName.length() > 123) {
                    this.tableName = this.tableName.substring(0, 123);
                }
                TableLevelConstraint tableLevelConstraint = this.table.createCheckConstraint(this.tableName + "_CK" + this.table.getCheckConstraints().size(), string5);
                if (!"".equalsIgnoreCase(string6)) {
                    tableLevelConstraint.setName(string6);
                }
                this.table.addCheckConstraint(tableLevelConstraint);
                this.design.getRelationalDesign().stampModelObjectDDL(tableLevelConstraint);
            }
        }
        if (this.tableProxy != null) {
            this.initOwner();
            if (!bl) {
                this.initFederated();
                this.initTableSpace();
                this.initIndexTableSpace();
                this.initLongTableSpace();
                this.initDataCapture();
                this.initPartitioningKey();
                this.initHashing();
                this.initLoggedInitially();
            }
        }
    }

    private void processSummaryQuery() {
        String string = Token.getStringAfter(this.afterColumns, "AS ( SELECT");
        if (string.equalsIgnoreCase("")) {
            string = Token.getStringAfter(this.afterColumns, "AS (SELECT");
        }
        if (!string.equalsIgnoreCase("")) {
            this.tableProxy.setSummaryQuery("YES");
            string = Token.getStringAfterToken(this.afterColumns, "AS");
            String string2 = Token.getValBetweenBrackets(string, 1);
            this.tableProxy.setSummaryQueryDefinition(string2);
            string = Token.getStringAfter(string, string2).trim();
            string = Token.cutFirstToken(string);
            if (string.toUpperCase().startsWith("DEFINITION ONLY")) {
                this.tableProxy.setSummaryStatus("DEFINITION ONLY");
                this.processCopyOption(string.substring(15).trim());
            } else {
                this.processRefreshableOptions(string);
            }
        }
    }

    private void processRefreshableOptions(String string) {
        if (string.toUpperCase().startsWith("DATA INITIALLY DEFERRED")) {
            if (Token.hasString(string, "ENABLE")) {
                this.tableProxy.setSummaryQueryOptimization("ENABLE");
            } else {
                this.tableProxy.setSummaryQueryOptimization("DISABLE");
            }
            if (Token.hasString(string, "IMMEDIATE")) {
                this.tableProxy.setSummaryRefreshOptions("IMMEDIATE");
            } else {
                this.tableProxy.setSummaryQueryOptimization("DEFERRED");
            }
            if (Token.hasString(string, "MAINTAINED BY USER")) {
                this.tableProxy.setSummaryMaintenance("BY USER");
            } else {
                this.tableProxy.setSummaryMaintenance("BY SYSTEM");
            }
        }
    }

    private void processCopyOption(String string) {
        if (Token.hasString(string, "INCLUDING COLUMN DEFAULTS") || Token.hasString(string, "INCLUDING DEFAULTS")) {
            this.tableProxy.setSummaryCopyColumnDefaults("INCLUDING");
        } else if (Token.hasString(string, "EXCLUDING COLUMN DEFAULTS") || Token.hasString(string, "EXCLUDING DEFAULTS")) {
            this.tableProxy.setSummaryCopyColumnDefaults("EXCLUDING");
        } else {
            this.tableProxy.setSummaryCopyColumnDefaults("NONE");
        }
        if (Token.hasString(string, "INCLUDING IDENTITY")) {
            this.tableProxy.setSummaryIdentityColumn("INCLUDING");
        } else {
            this.tableProxy.setSummaryIdentityColumn("EXCLUDING");
        }
    }

    private String initTableName() {
        String string = Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"').trim();
        if (string.indexOf(40) > -1) {
            string = Token.getStringBefore(string, "(").trim();
        }
        if (string.indexOf(46) > -1) {
            this.ownerName = string.substring(0, string.indexOf(46)).trim();
            string = string.substring(string.indexOf(46) + 1).trim();
        }
        return string;
    }

    public static void setColumnsForIndexPK(Index index, String string, ImportLogger importLogger) throws ObjectDoesNotExistException {
        if (index != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken().trim();
                arrayList.add(Token.removeQuotes(string2).toUpperCase());
            }
            for (String string3 : arrayList) {
                Column column = (Column)index.getTable().getElementByName(string3);
                if (column != null) {
                    index.add(column);
                    continue;
                }
                importLogger.addError("Column for index " + index.getName() + " doesn't exist.");
                throw new ObjectDoesNotExistException("Column");
            }
        }
    }

    private ArrayList initColumns() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = this.inSideBrackets;
        SHColumnElementsUDB sHColumnElementsUDB = new SHColumnElementsUDB();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken().trim();
            if (Token.hasOpenBracketNoClose(string2)) {
                object = new StringBuffer(string2);
                while (Token.hasOpenBracketNoClose(string2) && stringTokenizer.hasMoreTokens()) {
                    ((StringBuffer)object).append(", ").append(stringTokenizer.nextToken().trim());
                    string2 = ((StringBuffer)object).toString().trim();
                }
            }
            if (Boolean.TRUE.equals((object = sHColumnElementsUDB.getElementsColumn(string2.trim(), Token.hasToken(this.statement, "AS") && Token.hasToken(this.statement, "SELECT"))).get("IS_CONSTRAINT")) && string2.toUpperCase().indexOf("FOREIGN") > -1) {
                this.fkList.add(string2);
                continue;
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    private boolean initCols() {
        String string = this.inSideBrackets;
        string = Token.getNamesOnly(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken().trim();
            if (Token.hasOpenBracketNoClose(string2)) {
                object = new StringBuffer(string2);
                while (Token.hasOpenBracketNoClose(string2) && stringTokenizer.hasMoreTokens()) {
                    ((StringBuffer)object).append(", ").append(stringTokenizer.nextToken().trim());
                    string2 = ((StringBuffer)object).toString().trim();
                }
            }
            object = this.table.createColumn(string2);
            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
        }
        return false;
    }

    public void initCol() {
        if (Token.hasToken(this.statement, "AS")) {
            String string;
            this.table.setTypeID(this.storageDesign.getDesign().getDLSettings().getClassificationTypeByName(ContainerObject.TYPE_SUMMARY).getTypeID());
            String string2 = Token.getStringAfter(this.statement, "SELECT").trim();
            if (Token.hasToken(this.statement, "FROM")) {
                int n = string2.indexOf("FROM");
                string = string2.substring(0, n);
                while (Token.tokenNumber(string, "(") > Token.tokenNumber(string, ")")) {
                    n = string2.indexOf("FROM", n + 1);
                    string = string2.substring(0, n);
                }
                string2 = string;
            }
            if (Token.getFirstToken(string2).equalsIgnoreCase("ALL")) {
                string2 = Token.getStringAfterToken(string2, "ALL").trim();
            }
            if (Token.getFirstToken(string2).equalsIgnoreCase("DISTINCT")) {
                string2 = Token.getStringAfterToken(string2, "DISTINCT").trim();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            string = null;
            String string3 = null;
            block1: while (stringTokenizer.hasMoreTokens()) {
                Column column;
                Table table;
                String string4;
                StringTokenizer stringTokenizer2;
                int n;
                Column column2;
                int n2;
                string = stringTokenizer.nextToken().trim();
                string3 = null;
                StringBuffer stringBuffer = new StringBuffer(string);
                while (Token.tokenNumber(string, "(") > Token.tokenNumber(string, ")") && stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(",").append(stringTokenizer.nextToken().trim());
                    string = stringBuffer.toString().trim();
                }
                if (Token.hasToken(string, "AS")) {
                    n2 = string.lastIndexOf(" AS ");
                    string3 = string.substring(n2);
                    string3 = Token.cutFirstToken(string3);
                    string3 = Token.removeQuotes(string3);
                    string = string.substring(0, n2);
                    Token.removeQuotes(string);
                }
                if ((string = Token.encodeQuotedString(string)).indexOf(" ") > -1) {
                    if (string.charAt(string.length() - 1) == '\"') {
                        string3 = string.substring(0, string.length() - 1);
                        n2 = string3.lastIndexOf(34);
                        string3 = string3.substring(n2) + "\"";
                        string = string.substring(0, n2 - 1);
                    } else if (string.charAt(string.length() - 1) == '\'') {
                        string3 = string.substring(0, string.length() - 1);
                        n2 = string3.lastIndexOf(39);
                        string3 = string3.substring(n2) + "'";
                        string = string.substring(0, n2 - 1);
                    } else {
                        String string5 = Token.getLastToken(string);
                        if (string5.indexOf(41) == -1 && !string5.equalsIgnoreCase("END")) {
                            string3 = string5;
                            string = string.substring(0, string.lastIndexOf(string5)).trim();
                        }
                    }
                }
                string = Token.removeQuotes(Token.decodeQuotedString(string));
                String string6 = null;
                String string7 = null;
                if (!Token.hasCloseAndOpenBrackets(string) && string.indexOf(43) == -1 && string.indexOf(45) == -1 && string.indexOf(42) == -1 && string.indexOf(47) == -1 && string.indexOf(58) == -1 && string.indexOf("||") == -1 && !Token.hasToken(string, "CONCAT") && string.indexOf(46) > -1) {
                    if (string.indexOf(46) > -1) {
                        string7 = string.substring(0, string.indexOf(46));
                        string = string.substring(string.lastIndexOf(46) + 1);
                        if (string7.indexOf(46) > -1) {
                            string7 = string7.substring(string7.lastIndexOf(46) + 1);
                        }
                    }
                } else {
                    string6 = string;
                }
                if (string3 != null && !string3.equalsIgnoreCase("")) {
                    column2 = this.table.createColumn(Token.getNamesOnly(string3));
                    this.design.getRelationalDesign().stampModelObjectDDL(column2);
                    if (string6 != null) {
                        if (this.isAggregateFunction(string6)) {
                            column2.setSourceType("Aggregate");
                        } else {
                            column2.setSourceType("Derived");
                        }
                        column2.setFormulaDesc(string6);
                        continue;
                    }
                    if (!Token.hasToken(this.statement, "FROM")) continue;
                    string2 = Token.getStringAfter(this.statement, "FROM").trim();
                    n = -1;
                    if (Token.hasToken(string2, "WHERE")) {
                        n = string2.indexOf("WHERE");
                    } else if (Token.hasToken(string2, "GROUP")) {
                        n = string2.indexOf("GROUP");
                    }
                    if (n > -1) {
                        string2 = string2.substring(0, n);
                    }
                    stringTokenizer2 = new StringTokenizer(string2, ",");
                    while (stringTokenizer2.hasMoreTokens()) {
                        string4 = stringTokenizer2.nextToken().trim();
                        if (string4.indexOf(46) > -1) {
                            string4 = string4.substring(string4.lastIndexOf(46) + 1);
                        }
                        if (!Token.hasToken(string4, string7)) continue;
                        string4 = string4.startsWith("\"") ? Token.getValBetweenDoubleQuotes(string4).trim() : Token.getFirstToken(string4);
                        table = (Table)this.storageDesign.getPhysicalDesign().getTableSet().getByName(string4);
                        if (table == null || (column = (Column)table.getElementByName(string)) == null) continue;
                        column2.setDomain(column.getDomain());
                        continue block1;
                    }
                    continue;
                }
                if (string.equalsIgnoreCase("") || string.equalsIgnoreCase("*")) continue;
                column2 = this.table.createColumn(string);
                this.design.getRelationalDesign().stampModelObjectDDL(column2);
                if (!Token.hasToken(this.statement, "FROM")) continue;
                string2 = Token.getStringAfter(this.statement, "FROM").trim();
                n = -1;
                if (Token.hasToken(string2, "WHERE")) {
                    n = string2.indexOf("WHERE");
                } else if (Token.hasToken(string2, "GROUP")) {
                    n = string2.indexOf("GROUP");
                }
                if (n > -1) {
                    string2 = string2.substring(0, n);
                }
                stringTokenizer2 = new StringTokenizer(string2, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    string4 = stringTokenizer2.nextToken().trim();
                    if (string4.indexOf(46) > -1) {
                        string4 = string4.substring(string4.lastIndexOf(46) + 1);
                    }
                    if (!Token.hasToken(string4, string7)) continue;
                    string4 = string4.startsWith("\"") ? Token.getValBetweenDoubleQuotes(string4).trim() : Token.getFirstToken(string4);
                    table = (Table)this.storageDesign.getPhysicalDesign().getTableSet().getByName(string4);
                    if (table == null || (column = (Column)table.getElementByName(string)) == null) continue;
                    column2.setDomain(column.getDomain());
                    continue block1;
                }
            }
        }
    }

    private boolean isAggregateFunction(String string) {
        String[] stringArray = AggregateFunctionsUDB.FUNCTIONS_V8;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string.toUpperCase().startsWith(string2.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    private boolean getDataCapture() {
        String string = Token.getTokenAfter(this.outSideBrackets, "CAPTURE");
        return string.equalsIgnoreCase("CHANGES");
    }

    private void initCheckConstraint(String string, String string2, Column column) {
        Object object;
        CheckConstraint checkConstraint = new CheckConstraint();
        RDBMSTypeSet rDBMSTypeSet = this.design.getRDBMSTypeSet();
        Iterator iterator = rDBMSTypeSet.iterator();
        while (iterator.hasNext()) {
            object = (RDBMSType)iterator.next();
            if (object != StorageDesignUDBv71.RDBMS_TYPE) continue;
            checkConstraint.add((ConstraintType)object, string);
        }
        if (!"".equalsIgnoreCase(string2) && string2 != null) {
            checkConstraint.setName(string2);
            column.setConstraintName(string2);
        } else {
            object = column.getName();
            if (((String)object).length() > 25) {
                object = ((String)object).substring(0, 25);
            }
            string2 = (String)object + "_CHCK";
            checkConstraint.setName(string2);
            column.setConstraintName(string2);
        }
        column.setUseDomainConstraints(false);
        column.setCheck(checkConstraint);
    }

    public Table getTable() {
        return this.table;
    }

    private Domain getCorrespondingDomain(String string) {
        Domain domain = null;
        DomainSet domainSet = this.design.getDesign().getDomainSet();
        Iterator iterator = domainSet.iterator();
        while (iterator.hasNext()) {
            Domain domain2 = (Domain)iterator.next();
            if (!domain2.getName().equalsIgnoreCase(string)) continue;
            domain = domain2;
            return domain;
        }
        return domain;
    }

    private TableSpaceUDB getTableSpace(String string) {
        TableSpaceUDB tableSpaceUDB = null;
        TableSpaceSetUDB tableSpaceSetUDB = this.storageDesign.getTableSpaceSet();
        Iterator iterator = tableSpaceSetUDB.iterator();
        while (iterator.hasNext()) {
            TableSpaceUDB tableSpaceUDB2 = (TableSpaceUDB)iterator.next();
            if (!tableSpaceUDB2.getName().equalsIgnoreCase(string)) continue;
            tableSpaceUDB = tableSpaceUDB2;
            break;
        }
        return tableSpaceUDB;
    }

    private void initTableSpace() {
        if (Token.hasToken(this.outSideBrackets, "IN")) {
            TableSpaceUDB tableSpaceUDB;
            String string = Token.getTokenAfter(this.outSideBrackets, "IN").trim();
            if (string.indexOf(46) > 0) {
                string = Token.getValAfterCharacter(string, '.');
            }
            if ((tableSpaceUDB = this.getTableSpace(string = Token.removeQuotes(string))) == null) {
                tableSpaceUDB = this.storageDesign.getTableSpaceSet().createTableSpace();
                tableSpaceUDB.setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceUDB);
            }
            if (tableSpaceUDB != null) {
                this.tableProxy.setTableSpace(tableSpaceUDB);
            } else {
                LOGGER.error("Tablespace " + string + " does not exist in statement " + this.statement);
                this.importLog.addWarning("Tablespace " + string + " does not exist in statement " + this.statement);
            }
        }
    }

    private void initIndexTableSpace() {
        if (Token.hasToken(this.outSideBrackets, "INDEX")) {
            TableSpaceUDB tableSpaceUDB;
            String string = this.outSideBrackets;
            while (!Token.getFirstToken(string).equalsIgnoreCase("INDEX")) {
                string = Token.cutFirstToken(string);
            }
            String string2 = Token.getTokenAfter(string, "IN").trim();
            if (string2.indexOf(46) > 0) {
                string2 = Token.getValAfterCharacter(string2, '.');
            }
            if ((tableSpaceUDB = this.getTableSpace(string2)) != null) {
                this.tableProxy.setIndexInTableSpace(tableSpaceUDB);
            }
        }
    }

    private void initLongTableSpace() {
        if (Token.hasToken(this.outSideBrackets, "LONG")) {
            TableSpaceUDB tableSpaceUDB;
            String string = this.outSideBrackets;
            while (!Token.getFirstToken(string).equalsIgnoreCase("LONG")) {
                string = Token.cutFirstToken(string);
            }
            String string2 = Token.getTokenAfter(string, "IN").trim();
            if (string2.indexOf(46) > 0) {
                string2 = Token.getValAfterCharacter(string2, '.');
            }
            if ((tableSpaceUDB = this.getTableSpace(string2)) != null) {
                this.tableProxy.setLongInTableSpace(tableSpaceUDB);
            }
        }
    }

    private void initOwner() {
        if (this.ownerName != null) {
            SchemaUDB schemaUDB = (SchemaUDB)this.storageDesign.getSchemaSet().getByName(this.ownerName);
            if (schemaUDB == null) {
                schemaUDB = this.storageDesign.getSchemaSet().createSchema();
                schemaUDB.setName(this.ownerName);
                this.design.getRelationalDesign().stampModelObjectDDL(schemaUDB);
            }
            if (schemaUDB != null) {
                this.tableProxy.setSchema(schemaUDB);
            } else {
                OwnerUDB ownerUDB = (OwnerUDB)((StorageDesignUDB)this.tableProxy.getStorageDesign()).getOwnerSet().getByName(this.ownerName);
                if (ownerUDB == null) {
                    ownerUDB = (OwnerUDB)((StorageDesignUDB)this.tableProxy.getStorageDesign()).getOwnerSet().createElement(null);
                    ownerUDB.setName(this.ownerName);
                    this.design.getRelationalDesign().stampModelObjectDDL(ownerUDB);
                }
                this.tableProxy.setOwner(ownerUDB);
            }
        } else if (this.getOwner() != null) {
            this.tableProxy.setOwner((OwnerUDB)this.getOwner());
        }
    }

    private void initFederated() {
        if (Token.hasString(this.statement.toUpperCase(), "FEDERATED")) {
            this.tableProxy.setFederated("FEDERATED");
        } else if (Token.hasString(this.statement.toUpperCase(), NOT_FEDERATED)) {
            this.tableProxy.setFederated(NOT_FEDERATED);
        }
    }

    private void initDataCapture() {
        this.dataCapture = this.getDataCapture();
        this.tableProxy.setDataCapture(this.dataCapture ? "CHANGES" : "NONE");
    }

    private void initPartitioningKey() {
        if (Token.hasToken(this.outSideBrackets, "PARTITIONING")) {
            String string = this.outSideBrackets;
            while (!Token.getFirstToken(string).equalsIgnoreCase("PARTITIONING")) {
                string = Token.cutFirstToken(string);
            }
            string = Token.getValBetweenBrackets(string, 1).trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.tableProxy.setPartitioningKey(stringTokenizer.nextToken().trim());
            }
        }
    }

    private void initHashing() {
        if (Token.hasToken(this.outSideBrackets, "HASHING")) {
            this.tableProxy.setPartKeyHashing(true);
        }
    }

    private void initLoggedInitially() {
        if (Token.hasToken(this.outSideBrackets, "INITIALLY")) {
            this.tableProxy.setInitialLogging(false);
        }
    }

    private Table getReferencedTable(String string) throws ObjectDoesNotExistException {
        TableSet tableSet = this.design.getDesign().getRelationalDesign().getTableSet();
        Table table = (Table)tableSet.getByName(string);
        if (table != null) {
            return table;
        }
        this.importLog.addError("Table with name " + string + " does not exist.");
        throw new ObjectDoesNotExistException("Table with name " + string);
    }

    private void addForeignKey(String string, Table table) {
        block15: {
            Table table2;
            ArrayList<Column> arrayList;
            String string2;
            block16: {
                String string3;
                string2 = null;
                if (Token.hasToken(string, "CONSTRAINT")) {
                    string2 = Token.getTokenAfter(string, "CONSTRAINT");
                } else {
                    if (this.tableName.length() > 123) {
                        this.tableName = this.tableName.substring(0, 123);
                    }
                    string2 = this.tableName + "_FK" + this.table.getFKAssociationsCount();
                }
                int n = string.indexOf(41);
                String string4 = string.substring(0, n + 1).trim();
                String string5 = Token.getValBetweenBrackets(string4);
                List list = this.getColumnNames(string5);
                arrayList = new ArrayList<Column>();
                Column[] columnArray = (Column[])table.getElements();
                for (String string6 : list) {
                    for (int i = 0; i < columnArray.length; ++i) {
                        string3 = columnArray[i].getName().trim();
                        if (!string6.equalsIgnoreCase(string3)) continue;
                        arrayList.add(columnArray[i]);
                    }
                }
                int n2 = string.toUpperCase().indexOf("REFERENCES");
                string = string.substring(n2);
                String string7 = Token.getTokenAfter(string, "REFERENCES");
                string3 = this.getNameFor(string7);
                table2 = this.getTableFor(string3 = Token.removeQuotes(string3));
                if (table2 == null) break block15;
                boolean bl = Token.hasString(string, "(");
                if (!bl) break block16;
                String string8 = Token.getValBetweenBrackets(string);
                List list2 = this.getColumnNames(string8);
                FKIndexAssociationReference fKIndexAssociationReference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                Index index = this.getUniqueIndexForColumnNames(table2, list2);
                if (index == null) break block15;
                FKIndexAssociation fKIndexAssociation = table.addFK(index, null, fKIndexAssociationReference);
                this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                if (string2 != null) {
                    fKIndexAssociation.setName(string2);
                    fKIndexAssociation.getLocalFKIndex().setName(string2);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fKIndexAssociation, arrayList, index);
                } else {
                    this.fixFKColumns(fKIndexAssociation, arrayList, index);
                }
                boolean bl2 = Token.hasToken(string, "DELETE");
                if (!bl2) break block15;
                String string9 = Token.getTokenAfter(string, "DELETE").trim();
                String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string9.equalsIgnoreCase(stringArray[i])) continue;
                    fKIndexAssociation.setDeleteRule(stringArray[i]);
                    break block15;
                }
                break block15;
            }
            FKIndexAssociationReference fKIndexAssociationReference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
            Index index = (Index)table2.getPK();
            if (index != null) {
                FKIndexAssociation fKIndexAssociation = table.addFK(index, null, fKIndexAssociationReference);
                this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                if (string2 != null) {
                    fKIndexAssociation.setName(string2);
                    fKIndexAssociation.getLocalFKIndex().setName(string2);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fKIndexAssociation, arrayList, index);
                } else {
                    this.fixFKColumns(fKIndexAssociation, arrayList, index);
                }
                boolean bl = Token.hasToken(string, "DELETE");
                if (bl) {
                    String string10 = Token.getTokenAfter(string, "DELETE").trim();
                    String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string10.equalsIgnoreCase(stringArray[i])) continue;
                        fKIndexAssociation.setDeleteRule(stringArray[i]);
                        break;
                    }
                }
            }
        }
    }

    private List getColumnNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            string2 = Token.removeQuotes(string2);
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    private String getNameFor(String string) {
        int n = string.indexOf(46);
        if (n > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = null;
            do {
                String string3;
                string2 = string3 = stringTokenizer.nextToken().trim();
            } while (stringTokenizer.hasMoreTokens());
            int n2 = string2.indexOf(59);
            if (n2 > 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        int n3 = string.indexOf(59);
        if (n3 > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private Table getTableFor(String string) {
        Table table = null;
        TableSet tableSet = this.design.getDesign().getRelationalDesign().getTableSet();
        Iterator iterator = tableSet.iterator();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.getName().equalsIgnoreCase(string)) continue;
            table = table2;
            break;
        }
        return table;
    }

    private void replaceAllColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            if (column.isPartOfFKIndexAssociation(fKIndexAssociation)) continue;
            Column column2 = (Column)index2.getElements()[n];
            fKIndexAssociation.swapAndRemoveFKColumn(column2, column, columnArray[n]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            column.addFKAssociation(columnArray[n], fKIndexAssociation);
            index2.add(column);
        }
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getName().equalsIgnoreCase((String)list.get(i))) continue;
            return false;
        }
        return true;
    }

    private Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && this.isIndexForColumnNames(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }

    Column getColumnByName(Table table, String string) {
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            if (!columnArray[i].getName().equalsIgnoreCase(string)) continue;
            return columnArray[i];
        }
        return null;
    }

    private void processRefAtColumn(RefAtColNode refAtColNode, Table table) {
        String string = this.getNameFor(refAtColNode.referencedTable);
        Table table2 = null;
        try {
            table2 = this.getReferencedTable(string);
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            LOGGER.error("Unknown reference table in statement " + this.statement, objectDoesNotExistException);
            this.importLog.addError("Unknown reference table in statement " + this.statement);
        }
        if (table2 != null) {
            Index index;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (refAtColNode.refColumn != null) {
                arrayList.add(refAtColNode.refColumn);
                index = this.getUniqueIndexForColumnNames(table2, arrayList);
            } else {
                index = (Index)table2.getPK();
            }
            if (index != null) {
                FKIndexAssociation fKIndexAssociation = table.addFK(index);
                this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                ArrayList<Column> arrayList2 = new ArrayList<Column>();
                Column column = this.getColumnByName(table, refAtColNode.columnName);
                if (column != null) {
                    arrayList2.add(column);
                    if (this.design.getDesign().isPropagatePKChahges()) {
                        this.replaceAllColumns(fKIndexAssociation, arrayList2, index);
                    } else {
                        this.fixFKColumns(fKIndexAssociation, arrayList2, index);
                    }
                    if (refAtColNode.onDelete != null) {
                        String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!refAtColNode.onDelete.equalsIgnoreCase(stringArray[i])) continue;
                            fKIndexAssociation.setDeleteRule(stringArray[i]);
                            break;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void processForeignKeys() {
        for (FKRefNode fKRefNode : this.tableNodeList) {
            Object object2;
            for (Object object2 : fKRefNode.fkStatements) {
                this.addForeignKey((String)object2, fKRefNode.processedTable);
            }
            object2 = fKRefNode.refAtColumns.iterator();
            while (object2.hasNext()) {
                this.processRefAtColumn((RefAtColNode)object2.next(), fKRefNode.processedTable);
            }
        }
    }

    class FKRefNode {
        Table processedTable;
        List fkStatements;
        List refAtColumns;

        FKRefNode() {
        }
    }

    class RefAtColNode {
        String columnName;
        String referencedTable;
        String refColumn;
        String onDelete;

        RefAtColNode() {
        }
    }
}

