/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateTriggerUDB;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StoredProcedureUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateStoredProcedureUDB
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateTriggerUDB.class);

    public SHCreateStoredProcedureUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateStoredProcedureUDB.clearCR(string);
        if (Token.startsWithString(string2, "create procedure")) {
            try {
                this.parseStoredProcedure(string2, string);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCreateStoredProcedureUDB.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseStoredProcedure(String string, String string2) {
        StoredProcedureUDB storedProcedureUDB;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignUDB != null && (storedProcedureUDB = storageDesignUDB.getStoredProcedureSet().createStoredProcedure()) != null) {
            this.initStoredProcedureName(storageDesignUDB, storedProcedureUDB, string);
            this.initBody(storedProcedureUDB, string2, string);
            this.design.getRelationalDesign().stampModelObjectDDL(storedProcedureUDB);
        }
    }

    private void initStoredProcedureName(StorageDesignUDB storageDesignUDB, StoredProcedureUDB storedProcedureUDB, String string) {
        String string2 = Token.getQuotedNameAfterToken(string, "PROCEDURE").trim();
        if (string2.indexOf(46) > -1) {
            String string3 = string2.substring(0, string2.indexOf(46)).trim();
            SchemaUDB schemaUDB = (SchemaUDB)storageDesignUDB.getSchemaSet().getByName(string3);
            if (schemaUDB == null) {
                schemaUDB = storageDesignUDB.getSchemaSet().createSchema();
                schemaUDB.setName(string3);
                this.design.getRelationalDesign().stampModelObjectDDL(schemaUDB);
            }
            storedProcedureUDB.setSchema(schemaUDB);
            storedProcedureUDB.setOwner(schemaUDB.getOwner());
            string2 = string2.substring(string2.indexOf(46) + 1);
        }
        storedProcedureUDB.setName(string2);
    }

    private void initBody(StoredProcedureUDB storedProcedureUDB, String string, String string2) {
        String string3 = Token.getStringAfter(string, Token.getQuotedNameAfterToken(string2, "PROCEDURE").trim());
        if (string3.startsWith("\"")) {
            string3 = string3.substring(1).trim();
        }
        storedProcedureUDB.setBody(string3);
    }
}

