/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateNodeGroupUDB
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateNodeGroupUDB.class);

    public SHCreateNodeGroupUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateNodeGroupUDB.clearCR(string);
        if (Token.startsWithString(string2, "create nodegroup")) {
            try {
                this.parseNodeGroup(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCreateNodeGroupUDB.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseNodeGroup(String string) {
        this.statement = string;
        String string2 = Token.getNameAfterToken(this.statement, "NODEGROUP", '\"', '\"').trim();
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
        NodeGroupUDB nodeGroupUDB = storageDesignUDB.getNodeGroupSet().createNodeGroup();
        if (nodeGroupUDB != null) {
            nodeGroupUDB.setName(string2);
            String string3 = Token.getTokenAfter(this.statement, "ON").trim();
            if (string3.equalsIgnoreCase("NODES")) {
                nodeGroupUDB.setScope("ON SOME NODES");
                if (Token.hasCloseAndOpenBrackets(this.statement)) {
                    String string4 = Token.getValBetweenBrackets(this.statement).trim();
                    nodeGroupUDB.setNodeNumbers(string4);
                }
            }
        }
    }
}

