/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.AliasUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateAliasUDB
extends DDLStatementHandler {
    private String schemaName = null;
    private static final Logger LOGGER = new Logger(SHCreateAliasUDB.class);

    public SHCreateAliasUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateAliasUDB.clearCR(string);
        if (Token.startsWithString(string2, "create alias") || Token.startsWithString(string2, "create synonym")) {
            try {
                this.parseAlias(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCreateAliasUDB.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseAlias(String string) {
        this.statement = string;
        String string2 = this.initAliasName();
        String string3 = this.getNameOnly(Token.getTokenAfter(this.statement, "FOR").trim());
        Table table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(string3);
        TableView tableView = null;
        if (table == null) {
            tableView = (TableView)this.design.getDesign().getRelationalDesign().getTableViewSet().getByName(string3);
        }
        if (table != null || tableView != null) {
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
            AliasUDB aliasUDB = storageDesignUDB.getAliasSet().createAlias();
            aliasUDB.setName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(aliasUDB);
            this.initSchema(aliasUDB, storageDesignUDB);
            if (table != null) {
                TableProxyUDB tableProxyUDB = (TableProxyUDB)storageDesignUDB.getTableProxySet().getProxy(table.getObjectID());
                aliasUDB.setReferencedObject(tableProxyUDB);
            } else if (tableView != null) {
                TableViewProxyUDB tableViewProxyUDB = (TableViewProxyUDB)storageDesignUDB.getTableViewProxySet().getProxy(tableView.getObjectID());
                aliasUDB.setReferencedObject(tableViewProxyUDB);
            }
        } else {
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
            AliasUDB aliasUDB = storageDesignUDB.getAliasSet().createAlias();
            aliasUDB.setName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(aliasUDB);
            this.initSchema(aliasUDB, storageDesignUDB);
            SchemaUDB schemaUDB = (SchemaUDB)storageDesignUDB.getSchemaSet().getByName(string3);
            if (schemaUDB != null) {
                aliasUDB.setReferencedObject(schemaUDB);
            } else {
                AliasUDB aliasUDB2 = (AliasUDB)storageDesignUDB.getAliasSet().getByName(string3);
                if (aliasUDB2 != null) {
                    aliasUDB.setReferencedObject(aliasUDB2);
                }
            }
        }
    }

    private String initAliasName() {
        String string = Token.getTokenAfter(this.statement, "ALIAS").trim();
        int n = string.indexOf(46);
        if (n > 0) {
            this.schemaName = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "ALIAS"), '.');
            string = Token.getValAfterCharacter(Token.getTokenAfter(this.statement, "ALIAS"), '.');
        }
        return string;
    }

    private void initSchema(AliasUDB aliasUDB, StorageDesignUDB storageDesignUDB) {
        SchemaUDB schemaUDB;
        if (this.schemaName != null && (schemaUDB = (SchemaUDB)storageDesignUDB.getSchemaSet().getByName(this.schemaName)) != null) {
            aliasUDB.setSchema(schemaUDB);
        }
    }
}

