/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.AliasUDB;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StoredProcedureUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCommentOnUDB
extends DDLStatementHandler {
    protected static final Logger LOGGER = new Logger(SHCommentOnUDB.class);

    public SHCommentOnUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCommentOnUDB.clearCR(string);
        if (Token.startsWithString(string2, "comment on")) {
            try {
                this.parseCommentOn(string2, string);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for UDB failed!", exception);
                this.importLog.addFailedStatement(SHCommentOnUDB.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseCommentOn(String string, String string2) {
        String string3 = this.getNameOnly(Token.getTokenAfter(string, "ON").trim());
        String string4 = Token.getStringAfter(string2, "IS");
        string4 = Token.getValBetweenQuotationMarks(string4);
        if (string3.trim().equalsIgnoreCase("ALIAS")) {
            string3 = Token.getStringAfter(string, "ALIAS");
            string3 = Token.getStringBefore(string3, "IS");
            string3 = this.getNameOnly(string3.trim());
            string3 = Token.getName(string3);
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
            AliasUDB aliasUDB = (AliasUDB)storageDesignUDB.getAliasSet().getByName(string3);
            if (aliasUDB != null) {
                aliasUDB.setCommentInRDBMS(string4);
            }
        } else if (string3.trim().equalsIgnoreCase("COLUMN")) {
            LongNameObject longNameObject;
            string3 = Token.getStringAfter(string, "COLUMN");
            string3 = Token.getStringBefore(string3, "IS");
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
            String string5 = null;
            if (stringTokenizer.countTokens() == 3) {
                stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
            } else if (stringTokenizer.countTokens() == 2) {
                string5 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
            }
            DesignObject designObject = null;
            TableView tableView = null;
            if (string5 != null) {
                longNameObject = (Table)this.design.getRelationalDesign().getTableSet().getByName(string5);
                if (longNameObject != null) {
                    designObject = longNameObject.getElementByName(string3);
                } else {
                    tableView = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(string5);
                    if (tableView != null) {
                        designObject = tableView.getElementByName(string3);
                    }
                }
                if (designObject == null) {
                    designObject = this.design.getRelationalDesign().getColumnSet().getByName(string3);
                }
            } else {
                designObject = this.design.getRelationalDesign().getColumnSet().getByName(string3);
            }
            if (designObject != null) {
                if (tableView != null) {
                    designObject.setCommentInRDBMS(string4);
                } else {
                    longNameObject = this.design.getSelectedRDBMSSite();
                    StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign((RDBMSSite)longNameObject);
                    ColumnProxyUDB columnProxyUDB = (ColumnProxyUDB)storageDesignUDB.getColumnProxySet().getProxy(designObject.getObjectID());
                    if (columnProxyUDB != null) {
                        designObject.setCommentInRDBMS(string4);
                        columnProxyUDB.setCommentInRDBMS(string4);
                    }
                }
            }
        } else if (string3.trim().equalsIgnoreCase("PROCEDURE")) {
            string3 = Token.getStringAfter(string, "PROCEDURE");
            string3 = Token.getStringBefore(string3, "IS");
            string3 = this.getNameOnly(string3.trim());
            string3 = Token.getName(string3);
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
            StoredProcedureUDB storedProcedureUDB = (StoredProcedureUDB)storageDesignUDB.getStoredProcedureSet().getByName(string3);
            if (storedProcedureUDB != null) {
                storedProcedureUDB.setCommentInRDBMS(string4);
            }
        } else if (string3.trim().equalsIgnoreCase("TABLE")) {
            string3 = Token.getStringAfter(string, "TABLE");
            string3 = Token.getStringBefore(string3, "IS");
            string3 = this.getNameOnly(string3.trim());
            string3 = Token.getName(string3);
            Table table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(string3);
            TableView tableView = (TableView)this.design.getDesign().getRelationalDesign().getTableViewSet().getByName(string3);
            if (table != null) {
                table.setCommentInRDBMS(string4);
            } else if (tableView != null) {
                tableView.setCommentInRDBMS(string4);
            }
        } else if (string3.trim().equalsIgnoreCase("TABLESPACE")) {
            string3 = Token.getStringAfter(string, "TABLESPACE");
            string3 = Token.getStringBefore(string3, "IS");
            string3 = this.getNameOnly(string3.trim());
            string3 = Token.getName(string3);
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
            TableSpaceUDB tableSpaceUDB = (TableSpaceUDB)storageDesignUDB.getTableSpaceSet().getByName(string3);
            if (tableSpaceUDB != null) {
                tableSpaceUDB.setCommentInRDBMS(string4);
            }
        } else if (string3.trim().equalsIgnoreCase("TRIGGER")) {
            string3 = Token.getStringAfter(string, "TRIGGER");
            string3 = Token.getStringBefore(string3, "IS");
            string3 = this.getNameOnly(string3.trim());
            string3 = Token.getName(string3);
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
            TriggerUDB triggerUDB = (TriggerUDB)storageDesignUDB.getTriggerSet().getByName(string3);
            if (triggerUDB != null) {
                triggerUDB.setCommentInRDBMS(string4);
            }
        } else if (string3.trim().equalsIgnoreCase("NODEGROUP")) {
            string3 = Token.getStringAfter(string, "NODEGROUP");
            string3 = Token.getStringBefore(string3, "IS");
            string3 = this.getNameOnly(string3.trim());
            string3 = Token.getName(string3);
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
            NodeGroupUDB nodeGroupUDB = (NodeGroupUDB)storageDesignUDB.getNodeGroupSet().getByName(string3);
            if (nodeGroupUDB != null) {
                nodeGroupUDB.setCommentInRDBMS(string4);
            }
        } else if (string3.trim().equalsIgnoreCase("SCHEMA")) {
            string3 = Token.getStringAfter(string, "SCHEMA");
            string3 = Token.getStringBefore(string3, "IS");
            string3 = this.getNameOnly(string3.trim());
            string3 = Token.getName(string3);
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
            SchemaUDB schemaUDB = (SchemaUDB)storageDesignUDB.getSchemaSet().getByName(string3);
            if (schemaUDB != null) {
                schemaUDB.setCommentInRDBMS(string4);
            }
        }
    }
}

