/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.XMLSchemaCollectionSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateXMLCollectionSqlServerv2k5
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateXMLCollectionSqlServerv2k5.class);
    private RDBMSSite site;
    private StorageDesignSqlServerv2k5 stoDesign;
    private String schemaName = "";
    private String line = "";

    public SHCreateXMLCollectionSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        this.line = string;
        String string2 = SHCreateXMLCollectionSqlServerv2k5.clearCR(string);
        if (Token.startsWithString(string2, "create xml schema collection")) {
            try {
                this.parseXmlCollection(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
                this.importLog.addFailedStatement(SHCreateXMLCollectionSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseXmlCollection(String string) {
        this.statement = string;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.site);
        this.schemaName = "";
        String string2 = this.initName();
        XMLSchemaCollectionSqlServerv2k5 xMLSchemaCollectionSqlServerv2k5 = (XMLSchemaCollectionSqlServerv2k5)this.stoDesign.getXmlSchemaCollectionSet().createType();
        if (xMLSchemaCollectionSqlServerv2k5 != null) {
            Object object;
            xMLSchemaCollectionSqlServerv2k5.setName(string2);
            xMLSchemaCollectionSqlServerv2k5.setDatabase(this.getCurrentDB());
            this.design.getRelationalDesign().stampModelObjectDDL(xMLSchemaCollectionSqlServerv2k5);
            if (!this.schemaName.equals("") && (object = (SchemaSqlServerv2k5)xMLSchemaCollectionSqlServerv2k5.getDatabase().getSchemas().getByName(this.schemaName)) != null) {
                xMLSchemaCollectionSqlServerv2k5.setSchema((SchemaSqlServer)object);
            }
            object = Token.getStringAfterToken(this.line, "AS");
            xMLSchemaCollectionSqlServerv2k5.setSchemaDefinition(SHCreateXMLCollectionSqlServerv2k5.FormatCR((String)object, "\n"));
        }
    }

    private String initName() {
        String string = Token.getTokenAfter(this.statement, "COLLECTION").trim();
        String string2 = string.startsWith("[") ? Token.getNameAfterToken(this.statement, "COLLECTION", '[', ']').trim() : Token.getNameAfterToken(this.statement, "COLLECTION", '\"', '\"').trim();
        int n = string2.indexOf(46);
        if (n > 0) {
            this.schemaName = Token.getValBeforeCharacter(string2, '.');
            string2 = Token.getValAfterCharacter(Token.getTokenAfter(this.statement, "COLLECTION"), '.');
        }
        return string2;
    }
}

