/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateViewSqlServer;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateViewSqlServerv2k5
extends SHCreateViewSqlServer {
    private static final String VIEW_METADATA = "VIEW_METADATA";
    private static final Logger LOGGER = new Logger(SHCreateViewSqlServer.class);
    private AbstractView view;
    private TableViewProxySqlServerv2k5 viewProxy;
    private StorageDesignSqlServerv2k5 storageDesign;
    private String schemaName = "";
    private String userDefined;

    public SHCreateViewSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateViewSqlServerv2k5.clearCR(string);
        if (Token.startsWithString(string2, "create view")) {
            try {
                this.userDefined = SHCreateViewSqlServerv2k5.FormatCR(string, "\n");
                this.createView(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHCreateViewSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void createView(String string) {
        this.statement = string;
        this.view = this.design.getRelationalDesign().getTableViewSet().createTableView(null);
        String string2 = this.initName();
        if (this.schemaName != null && !"".equals(this.schemaName)) {
            this.view.setSchema(this.schemaName);
        }
        this.view.setName(string2);
        this.design.getRelationalDesign().stampModelObjectDDL(this.view);
        this.initUserDefinedSql();
        if (!this.initCols()) {
            this.initCol();
        }
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null) {
            this.viewProxy = (TableViewProxySqlServerv2k5)this.storageDesign.getTableViewProxySet().getProxy(this.view.getObjectID());
            if (this.viewProxy != null) {
                this.initUserAndDB();
                this.initEncription();
                this.initSchemaBinding();
                this.initViewMetadata();
                this.initCheckOptions();
                this.viewProxy.setDefinition(this.userDefined);
            }
        }
    }

    private void initUserDefinedSql() {
        this.view.setUserDefinedSQL(this.userDefined);
        this.view.setUserDefined(true);
        this.view.setSyntaxProvider("MSSQL");
    }

    private String initName() {
        String string = Token.getTokenAfter(this.statement, "VIEW").trim();
        String string2 = string.startsWith("[") ? Token.getNameAfterToken(this.statement, "VIEW", '[', ']').trim() : Token.getNameAfterToken(this.statement, "VIEW", '\"', '\"').trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        if (stringTokenizer.countTokens() == 2) {
            this.schemaName = stringTokenizer.nextToken().trim();
            string2 = stringTokenizer.nextToken().trim();
        }
        return string2;
    }

    @Override
    public boolean initCols() {
        String string = Token.getStringBefore(this.statement, " as select ");
        if (!Token.hasToken(string, "OF") && Token.hasCloseAndOpenBrackets(string)) {
            String string2 = Token.getValBetweenBrackets(string, 1);
            if (!"".equalsIgnoreCase(string2)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                String string3 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = Token.removeQuotes(stringTokenizer.nextToken());
                    AbstractViewElement abstractViewElement = this.view.createViewElement(this.design.getDesign().getLogicalDesign().getMainDPVPlaceHolder().getDesignPart());
                    abstractViewElement.setName(string3);
                    abstractViewElement.setDesign(this.design);
                    abstractViewElement.setContainer(this.view);
                    this.design.getRelationalDesign().stampModelObjectDDL(abstractViewElement);
                    this.view.add(abstractViewElement);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void initCol() {
        if (this.statement.toLowerCase().trim().indexOf(" as select ") > -1) {
            String string;
            String string2 = Token.getStringAfter(this.statement, "as select").trim();
            if (Token.hasToken(this.statement, "FROM")) {
                int n = string2.toUpperCase().indexOf("FROM");
                string = string2.substring(0, n);
                while (Token.tokenNumber(string, "(") > Token.tokenNumber(string, ")")) {
                    n = string2.toUpperCase().indexOf("FROM", n + 1);
                    string = string2.substring(0, n);
                }
                string2 = string;
            }
            if (Token.getFirstToken(string2).equalsIgnoreCase("ALL")) {
                string2 = Token.getStringAfterToken(string2, "ALL").trim();
            }
            if (Token.getFirstToken(string2).equalsIgnoreCase("DISTINCT")) {
                string2 = Token.getStringAfterToken(string2, "DISTINCT").trim();
            }
            if (Token.getFirstToken(string2).equalsIgnoreCase("TOP")) {
                string2 = Token.cutFirstToken(string2);
                string2 = Token.cutFirstToken(string2);
            }
            if (Token.getFirstToken(string2).equalsIgnoreCase("PERCENT")) {
                string2 = Token.cutFirstToken(string2);
            }
            if (string2.toUpperCase().startsWith("WITH TIES")) {
                string2 = string2.substring(9).trim();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            string = null;
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().trim();
                string3 = null;
                StringBuffer stringBuffer = new StringBuffer(string);
                while (Token.tokenNumber(string, "(") > Token.tokenNumber(string, ")") && stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(",").append(stringTokenizer.nextToken().trim());
                    string = stringBuffer.toString().trim();
                }
                if (Token.hasToken(string, "AS")) {
                    string3 = Token.getNameAfterToken(string, "AS", '[', ']');
                    string = Token.getStringBeforeToken(string, "AS");
                }
                string = Token.encodeQuotedString(string);
                if ((string = Token.encodeSquareBracketsString(string)).indexOf(" ") > -1) {
                    if (string.charAt(string.length() - 1) == '\"') {
                        string3 = string.substring(0, string.length() - 1);
                        int n = string3.lastIndexOf(34);
                        string3 = string3.substring(n) + "\"";
                        string = string.substring(0, n - 1);
                    } else if (string.charAt(string.length() - 1) == '\'') {
                        string3 = string.substring(0, string.length() - 1);
                        int n = string3.lastIndexOf(39);
                        string3 = string3.substring(n) + "'";
                        string = string.substring(0, n - 1);
                    } else {
                        String string4 = Token.getLastToken(string);
                        if (string4.indexOf(41) == -1 && !string4.equalsIgnoreCase("END")) {
                            string3 = string4;
                            string = string.substring(0, string.lastIndexOf(string4)).trim();
                        }
                    }
                }
                if (!(Token.hasCloseAndOpenBrackets(string) || string.indexOf(43) != -1 || string.indexOf(45) != -1 || string.indexOf(42) != -1 || string.indexOf(47) != -1 || string.indexOf(37) != -1 || string.indexOf(38) != -1 || string.indexOf(124) != -1 || string.indexOf(94) != -1 || Token.hasToken(string, "OR") || Token.hasToken(string, "BETWEEN") || Token.hasToken(string, "AND") || string.indexOf(46) <= -1 || (string = string.substring(string.indexOf(46) + 1)).indexOf(46) <= -1)) {
                    string = string.substring(string.indexOf(46) + 1);
                }
                if ((string = Token.removeQuotes(Token.decodeQuotedString(string))).equalsIgnoreCase("") || string.equalsIgnoreCase("*")) continue;
                AbstractViewElement abstractViewElement = this.view.createViewElement(this.design.getDesign().getLogicalDesign().getMainDPVPlaceHolder().getDesignPart());
                if (string3 != null) {
                    abstractViewElement.setName(string3);
                } else {
                    abstractViewElement.setName(string);
                }
                abstractViewElement.setDesign(this.design);
                abstractViewElement.setExpression(string);
                abstractViewElement.setContainer(this.view);
                this.design.getRelationalDesign().stampModelObjectDDL(abstractViewElement);
                this.view.add(abstractViewElement);
                if (string3 != null) {
                    string3 = Token.removeQuotes(Token.decodeQuotedString(string3));
                    abstractViewElement.setAlias(string3);
                    continue;
                }
                abstractViewElement.setAlias(abstractViewElement.getName());
            }
        }
    }

    private void initUserAndDB() {
        DataBaseSqlServerv2k5 dataBaseSqlServerv2k5 = null;
        if (!this.schemaName.equalsIgnoreCase("")) {
            SchemaSqlServerv2k5 schemaSqlServerv2k5 = (SchemaSqlServerv2k5)this.storageDesign.getSchemaSet().getByName(this.schemaName);
            if (schemaSqlServerv2k5 != null) {
                this.viewProxy.setSchema(schemaSqlServerv2k5);
                dataBaseSqlServerv2k5 = (DataBaseSqlServerv2k5)schemaSqlServerv2k5.getDatabase();
            } else {
                dataBaseSqlServerv2k5 = (DataBaseSqlServerv2k5)this.storageDesign.getDataBaseSet().getByName(this.schemaName);
            }
        }
        if (dataBaseSqlServerv2k5 == null) {
            dataBaseSqlServerv2k5 = (DataBaseSqlServerv2k5)this.getCurrentDB();
        }
        this.viewProxy.setDataBase(dataBaseSqlServerv2k5);
    }

    private void initEncription() {
        if (this.statement.toUpperCase().indexOf("ENCRYPTION") > -1) {
            this.viewProxy.setEncryption("YES");
        } else {
            this.viewProxy.setEncryption("NO");
        }
    }

    private void initSchemaBinding() {
        if (this.statement.toUpperCase().indexOf("SCHEMABINDING") > -1) {
            this.viewProxy.setSchemaBinding("YES");
        } else {
            this.viewProxy.setSchemaBinding("NO");
        }
    }

    private void initViewMetadata() {
        if (this.statement.toUpperCase().indexOf(VIEW_METADATA) > -1) {
            this.viewProxy.setViewMetaData("YES");
        } else {
            this.viewProxy.setViewMetaData("NO");
        }
    }

    private void initCheckOptions() {
        if (this.statement.toUpperCase().indexOf("WITH CHECK OPTION") > -1) {
            this.viewProxy.setCheckOption(true);
        } else {
            this.viewProxy.setCheckOption(false);
        }
    }

    @Override
    public void setView(AbstractView abstractView) {
        this.view = abstractView;
    }
}

