/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.ParseException;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateStoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StoredProcedureSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateStoredProcedureSqlServerv2k5
extends SHCreateStoredProcedureSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateStoredProcedureSqlServerv2k5.class);

    public SHCreateStoredProcedureSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateStoredProcedureSqlServerv2k5.clearCR(string);
        if (Token.startsWithString(string2, "create proc") || Token.startsWithString(string2, "create procedure")) {
            this.parseStoredProcedure(string2, string);
        } else {
            this.nextHandler(string);
        }
    }

    private void parseStoredProcedure(String string, String string2) {
        StoredProcedureSqlServerv2k5 storedProcedureSqlServerv2k5;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k5 != null && (storedProcedureSqlServerv2k5 = (StoredProcedureSqlServerv2k5)storageDesignSqlServerv2k5.getStoredProcedureSet().createStoredProcedure()) != null) {
            try {
                this.design.getRelationalDesign().stampModelObjectDDL(storedProcedureSqlServerv2k5);
                this.initStoredProcedureName(storageDesignSqlServerv2k5, storedProcedureSqlServerv2k5, string);
                this.initBody(storedProcedureSqlServerv2k5, string2, string);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(string + " Error parsing stored procedure for SqlServer!");
                this.importLog.addFailedStatement(SHCreateStoredProcedureSqlServerv2k5.FormatCR(string2, "\n"));
            }
        }
    }

    private void initStoredProcedureName(StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5, StoredProcedureSqlServerv2k5 storedProcedureSqlServerv2k5, String string) throws ParseException {
        try {
            String string2;
            int n = 1;
            String string3 = Token.getToken(string, n);
            while (!("".equalsIgnoreCase(string3) || string3.equalsIgnoreCase("PROCEDURE") || string3.equalsIgnoreCase("PROC"))) {
                string3 = Token.getToken(string, ++n);
            }
            if ((string2 = Token.getToken(string, ++n)).indexOf(46) > -1) {
                String string4 = string2.substring(0, string2.indexOf(46));
                string4 = Token.getValBetweenSquareBrackets(string4);
                SchemaSqlServerv2k5 schemaSqlServerv2k5 = (SchemaSqlServerv2k5)storageDesignSqlServerv2k5.getSchemaSet().getByName(string4);
                if (schemaSqlServerv2k5 != null) {
                    storedProcedureSqlServerv2k5.setSchema(schemaSqlServerv2k5);
                }
                string2 = string2.substring(string2.indexOf(46) + 1);
            }
            storedProcedureSqlServerv2k5.setName(string2);
            storedProcedureSqlServerv2k5.setDatabase(this.getCurrentDB());
        }
        catch (Exception exception) {
            LOGGER.error(string + " Error parsing stored procedure name (SqlServer)! ");
            this.importLog.addError("Error parsing stored procedure name for SqlServer " + string);
            throw new ParseException();
        }
    }

    private void initBody(StoredProcedureSqlServerv2k5 storedProcedureSqlServerv2k5, String string, String string2) {
        int n = 1;
        String string3 = Token.getToken(string2, n);
        while (!("".equalsIgnoreCase(string3) || string3.equalsIgnoreCase("PROCEDURE") || string3.equalsIgnoreCase("PROC"))) {
            string3 = Token.getToken(string2, ++n);
        }
        String string4 = Token.getToken(string2, ++n);
        storedProcedureSqlServerv2k5.setBody(Token.getStringAfter(string, string4));
    }
}

