/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateDatabaseSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreatePartitionSchemeSqlServerv2k5
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateDatabaseSqlServer.class);
    private StorageDesignSqlServerv2k5 storageDesign;

    public SHCreatePartitionSchemeSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreatePartitionSchemeSqlServerv2k5.clearCR(string);
        if (Token.startsWithString(string2, "create partition scheme")) {
            try {
                this.parseScheme(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
                this.importLog.addFailedStatement(SHCreatePartitionSchemeSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseScheme(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null) {
            String string2 = Token.getTokenAfter(string, "SCHEME");
            string = Token.cutTokenFromFront(this.statement, string2);
            String string3 = Token.getTokenAfter(string, "PARTITION");
            PartitionFunctionSqlServerv2k5 partitionFunctionSqlServerv2k5 = (PartitionFunctionSqlServerv2k5)((DataBaseSqlServerv2k5)this.getCurrentDB()).getPartitionFunction().getByName(string3);
            if (partitionFunctionSqlServerv2k5 != null) {
                PartitionSchemeSqlServerv2k5 partitionSchemeSqlServerv2k5 = (PartitionSchemeSqlServerv2k5)this.storageDesign.getPartitionSchemeSet().createPartitionScheme();
                partitionSchemeSqlServerv2k5.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(partitionSchemeSqlServerv2k5);
                partitionSchemeSqlServerv2k5.setPartitionFunction(partitionFunctionSqlServerv2k5);
                this.initFileGroup(partitionSchemeSqlServerv2k5, Token.getStringAfter(string, string3));
            }
        }
    }

    private void initFileGroup(PartitionSchemeSqlServerv2k5 partitionSchemeSqlServerv2k5, String string) {
        if (Token.hasToken(string, "ALL")) {
            partitionSchemeSqlServerv2k5.setMappingType(PartitionSchemeSqlServer.getMapTypeChoices()[1]);
        }
        String string2 = Token.getValBetweenBrackets(string);
        String[] stringArray = string2.split(",");
        PartitionFunctionSqlServerv2k5 partitionFunctionSqlServerv2k5 = (PartitionFunctionSqlServerv2k5)partitionSchemeSqlServerv2k5.getPartitionFunction();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            FileGroupSqlServerv2k5 fileGroupSqlServerv2k5 = (FileGroupSqlServerv2k5)this.getCurrentDB().getFilegroups().getByName(string3);
            if (2 * i <= partitionFunctionSqlServerv2k5.getBValuesSet().size() - 2) {
                String string4 = (String)partitionFunctionSqlServerv2k5.getBValuesSet().get(2 * i);
                partitionSchemeSqlServerv2k5.setMappingTable(string4);
            } else {
                partitionSchemeSqlServerv2k5.setMappingTable("MAXVALUE");
            }
            if (fileGroupSqlServerv2k5 != null) {
                partitionSchemeSqlServerv2k5.setMappingTable(fileGroupSqlServerv2k5.getName());
                partitionSchemeSqlServerv2k5.setSingleFileGroup(fileGroupSqlServerv2k5);
                continue;
            }
            partitionSchemeSqlServerv2k5.setMappingTable("");
        }
    }
}

