/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateIndexSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.SecondaryXmlIndexSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexOnViewSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PKProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SecondaryXmlIndexSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UniqueProxySqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateIndexSqlServerv2k5
extends SHCreateIndexSqlServer {
    private Index index;
    private Table table;
    private TableViewProxySqlServerv2k5 viewProxy;
    private String indexName = "";
    private StorageDesignSqlServerv2k5 stoDesign;
    private TableView view;
    private IndexOnViewSqlServerv2k5 iov;
    private RDBMSSite site;
    private static final Logger LOGGER = new Logger(SHCreateIndexSqlServer.class);

    public SHCreateIndexSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateIndexSqlServerv2k5.clearCR(string);
        if (Token.startsWithString(string2, "create index") || Token.startsWithString(string2, "create unique index") || Token.startsWithString(string2, "create unique clustered index") || Token.startsWithString(string2, "create unique nonclustered index") || Token.startsWithString(string2, "create clustered index") || Token.startsWithString(string2, "create nonclustered index") || Token.startsWithString(string2, "create primary xml index") || Token.startsWithString(string2, "create xml index")) {
            this.index = null;
            this.indexName = "";
            try {
                this.parseIndex(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
                this.importLog.addFailedStatement(SHCreateIndexSqlServerv2k5.FormatCR(string, "\n"));
            }
            this.index = null;
            this.table = null;
            this.viewProxy = null;
            this.indexName = "";
            this.stoDesign = null;
            this.view = null;
            this.iov = null;
        } else {
            this.nextHandler(string);
        }
    }

    private void parseIndex(String string) {
        this.statement = string;
        if (this.isPK()) {
            this.parsePK(string);
        } else if (this.isUK()) {
            this.parseUK(string);
        } else if (this.isIOV()) {
            this.parseIOV(string);
        } else if (this.isSecondaryXMLIndex()) {
            this.parseSecondaryXMLIndex(string);
        } else {
            this.parseInd();
        }
    }

    @Override
    public void parseInd() {
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            this.setColumnForIndex();
            if (this.index != null && this.index.getName().equals(this.indexName)) {
                IndexProxySqlServerv2k5 indexProxySqlServerv2k5;
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && (indexProxySqlServerv2k5 = (IndexProxySqlServerv2k5)this.stoDesign.getIndexProxySet().getProxy(this.index.getObjectID())) != null) {
                    this.initClustered(indexProxySqlServerv2k5);
                    this.initPadIndex(indexProxySqlServerv2k5);
                    this.initFillFactor(indexProxySqlServerv2k5);
                    this.initIgnoreDupKey(indexProxySqlServerv2k5);
                    this.initStatisticNoRecompute(indexProxySqlServerv2k5);
                    this.initSortInTempDB(indexProxySqlServerv2k5);
                    this.initIncludeColumn(indexProxySqlServerv2k5);
                    this.initFileGroup(indexProxySqlServerv2k5);
                }
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            LOGGER.error("", objectDoesNotExistException);
            this.importLog.addError("Setting columns to index " + this.indexName + " failed.");
        }
    }

    private void initFileGroup(IndexProxySqlServerv2k5 indexProxySqlServerv2k5) {
        int n = Token.getCloseBracketIndex(this.statement);
        String string = this.statement.substring(n + 1);
        if (Token.getCloseBracketIndex(string) > -1) {
            string = string.substring(Token.getCloseBracketIndex(string) + 1);
        }
        if (Token.startsWithString(string, "ON")) {
            String string2 = Token.getTokenAfter(string, "ON");
            string2 = Token.getValBetweenDoubleQuotes(string2).trim();
            FileGroupSqlServerv2k5 fileGroupSqlServerv2k5 = (FileGroupSqlServerv2k5)this.stoDesign.getFileGroupSet().getByName(string2);
            if (fileGroupSqlServerv2k5 == null) {
                PartitionSchemeSqlServerv2k5 partitionSchemeSqlServerv2k5 = (PartitionSchemeSqlServerv2k5)this.stoDesign.getPartitionSchemeSet().getByName(string2);
                if (partitionSchemeSqlServerv2k5 != null) {
                    String string3 = Token.getStringAfter(this.statement, string2);
                    string3 = Token.getValBetweenBrackets(string3);
                    Column column = (Column)this.design.getRelationalDesign().getColumnSet().getByName(string3);
                    if (column != null) {
                        ColumnProxySqlServerv2k5 columnProxySqlServerv2k5 = (ColumnProxySqlServerv2k5)this.stoDesign.getColumnProxySet().getProxy(column.getObjectID());
                        indexProxySqlServerv2k5.setPartitioningColumn(columnProxySqlServerv2k5);
                    }
                }
            } else {
                indexProxySqlServerv2k5.setFilegroup(fileGroupSqlServerv2k5);
            }
        }
    }

    private void initIncludeColumn(IndexProxySqlServerv2k5 indexProxySqlServerv2k5) {
        String string;
        if (Token.hasToken(this.statement, "INCLUDE") && Token.hasCloseAndOpenBrackets(string = Token.getStringAfter(this.statement, "INCLUDE"))) {
            String string2 = Token.getValBetweenBrackets(string, 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                Column column = (Column)this.table.getElementByName(string3.trim());
                if (column == null) continue;
                indexProxySqlServerv2k5.setIncludeColumns(column.getObjectID());
            }
        }
    }

    private void initClustered(IndexProxy indexProxy) {
        if (Token.hasToken(this.statement, "CLUSTERED")) {
            indexProxy.setClustered(true);
        } else {
            indexProxy.setClustered(false);
        }
    }

    @Override
    public void parseIOV(String string) {
        this.statement = string;
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            this.setColumnForIndex();
            if (this.view != null) {
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && this.iov != null) {
                    this.initPadIndex(this.iov);
                    this.initFillFactor(this.iov);
                    this.initIgnoreDupKey(this.iov);
                    this.initSortInTempDB(this.iov);
                    this.initStatisticNoRecompute(this.iov);
                }
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            LOGGER.error("", objectDoesNotExistException);
            this.importLog.addError("Setting columns to index " + this.indexName + " failed.");
        }
    }

    @Override
    public void parsePK(String string) {
        this.statement = string;
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            this.setColumnForIndex();
            if (this.table != null) {
                PKProxySqlServerv2k5 pKProxySqlServerv2k5;
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && (pKProxySqlServerv2k5 = new PKProxySqlServerv2k5(this.index, (StorageDesign)this.stoDesign)) != null) {
                    this.initClustered(pKProxySqlServerv2k5);
                    this.initFillFactorPK(pKProxySqlServerv2k5);
                    this.initFileGroupPK(pKProxySqlServerv2k5);
                }
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            LOGGER.error("", objectDoesNotExistException);
            this.importLog.addError("Setting columns to index " + this.indexName + " failed.");
        }
    }

    private boolean isIOV() {
        String string = this.getName();
        this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(string);
        return this.table == null;
    }

    private boolean isPK() {
        return Token.hasToken(this.statement, "ADD") && Token.hasToken(this.statement, "PRIMARY");
    }

    private String getIndexOption(String string) {
        String string2 = Token.getStringAfter(this.statement, string);
        if (string2.startsWith("=")) {
            String string3 = Token.getFirstToken(string2.substring(1).trim());
            int n = string3.indexOf(44);
            if (n > -1) {
                string3 = string3.substring(0, n);
            }
            return string3;
        }
        return "";
    }

    private void initSortInTempDB(IndexOnViewSqlServerv2k5 indexOnViewSqlServerv2k5) {
        if (this.getIndexOption("SORT_IN_TEMPDB").equalsIgnoreCase("ON")) {
            indexOnViewSqlServerv2k5.setSortInTempDB("YES");
        }
    }

    private void initStatisticNoRecompute(IndexOnViewSqlServerv2k5 indexOnViewSqlServerv2k5) {
        if (this.getIndexOption("STATISTICS_NORECOMPUTE").equalsIgnoreCase("ON")) {
            indexOnViewSqlServerv2k5.setRecomputeStatistics("NO");
        }
    }

    private void initIgnoreDupKey(IndexOnViewSqlServerv2k5 indexOnViewSqlServerv2k5) {
        if (this.getIndexOption("IGNORE_DUP_KEY").equalsIgnoreCase("ON")) {
            indexOnViewSqlServerv2k5.setIgnoreDupKey("YES");
        }
    }

    private void initFillFactor(IndexOnViewSqlServerv2k5 indexOnViewSqlServerv2k5) {
        String string = this.getIndexOption("FILLFACTOR");
        if (!string.equals("")) {
            try {
                indexOnViewSqlServerv2k5.setFillFactor(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("", numberFormatException);
                this.importLog.addWarning("Fill factor is unknown on index on view " + indexOnViewSqlServerv2k5.getName());
            }
        }
    }

    private void initPadIndex(IndexOnViewSqlServerv2k5 indexOnViewSqlServerv2k5) {
        if (this.getIndexOption("PAD_INDEX").equalsIgnoreCase("ON")) {
            indexOnViewSqlServerv2k5.setPadIndex("YES");
        }
    }

    private void initSortInTempDB(IndexProxySqlServerv2k5 indexProxySqlServerv2k5) {
        if (this.getIndexOption("SORT_IN_TEMPDB").equalsIgnoreCase("ON")) {
            indexProxySqlServerv2k5.setSortInTempDB("YES");
        }
    }

    private void initStatisticNoRecompute(IndexProxySqlServerv2k5 indexProxySqlServerv2k5) {
        if (this.getIndexOption("STATISTICS_NORECOMPUTE").equalsIgnoreCase("ON")) {
            indexProxySqlServerv2k5.setRecomputeStatistics("OFF");
        }
    }

    private void initIgnoreDupKey(IndexProxySqlServerv2k5 indexProxySqlServerv2k5) {
        if (this.getIndexOption("IGNORE_DUP_KEY").equalsIgnoreCase("ON")) {
            indexProxySqlServerv2k5.setIgnoreDupKey("YES");
        }
    }

    private void initFillFactor(IndexProxySqlServerv2k5 indexProxySqlServerv2k5) {
        String string = this.getIndexOption("FILLFACTOR");
        if (!string.equals("")) {
            try {
                indexProxySqlServerv2k5.setFillFactor(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("", numberFormatException);
                this.importLog.addWarning("Fill factor is unknown on index " + indexProxySqlServerv2k5.getName());
            }
        }
    }

    private void initPadIndex(IndexProxySqlServerv2k5 indexProxySqlServerv2k5) {
        if (this.getIndexOption("PAD_INDEX").equalsIgnoreCase("ON")) {
            indexProxySqlServerv2k5.setPadIndex("YES");
        }
    }

    private String initIndexName() {
        String string = Token.getTokenAfter(this.statement, "INDEX").trim();
        String string2 = string.startsWith("[") ? Token.getNameAfterToken(this.statement, "INDEX", '[', ']').trim() : Token.getNameAfterToken(this.statement, "INDEX", '\"', '\"').trim();
        int n = string2.indexOf(46);
        if (n > 0) {
            string2 = Token.getValAfterCharacter(Token.getTokenAfter(this.statement, "INDEX"), '.');
        }
        return string2;
    }

    private void constructIndex() {
        String string = this.getName();
        this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(string);
        if (this.table == null) {
            this.view = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(string);
            this.viewProxy = (TableViewProxySqlServerv2k5)((TableViewProxySetSqlServerv2k5)this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).getTableViewProxySet()).getByName(string);
        }
        if (this.table != null) {
            Index[] indexArray = (Index[])this.table.getKeys();
            for (int i = 0; i < indexArray.length; ++i) {
                Index index = indexArray[i];
                if (!index.getName().equalsIgnoreCase(this.indexName)) continue;
                this.index = index;
                break;
            }
            if (this.index == null || !this.index.getName().equalsIgnoreCase(this.indexName)) {
                this.index = this.table.createIndex();
                this.index.setName(this.indexName);
                this.design.getRelationalDesign().stampModelObjectDDL(this.index);
            }
        } else if (this.viewProxy != null) {
            this.iov = (IndexOnViewSqlServerv2k5)((StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.design.getSelectedRDBMSSite())).getIndexOnViewSet().createIndexOnView();
            this.iov.setName(this.indexName);
            this.iov.setView(this.viewProxy);
            this.design.getRelationalDesign().stampModelObjectDDL(this.iov);
        }
    }

    private void initUnique() {
        boolean bl;
        if (!this.index.isPK() && (bl = Token.hasToken(this.statement, "UNIQUE"))) {
            this.index.setIndexState("Unique Constraint");
        }
    }

    private void setColumnForIndex() throws ObjectDoesNotExistException {
        block13: {
            Map map;
            block12: {
                map = null;
                if (this.table == null) break block12;
                map = this.getColumnsForTable();
                if (map.size() <= 0) break block13;
                String string = Token.getValBetweenBrackets(this.statement, 1);
                if ("".equalsIgnoreCase(string.trim())) {
                    return;
                }
                boolean bl = Token.hasCloseAndOpenBrackets(string);
                if (bl) {
                    this.index.setIndexExpression(string);
                    return;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    Column column;
                    String string2 = stringTokenizer.nextToken().trim();
                    string2 = Token.getValBetweenSquareBrackets(string2);
                    string2 = Token.getNamesOnly(string2);
                    String string3 = "ASC";
                    int n = string2.indexOf(" ");
                    if (n > 0) {
                        try {
                            if (string2.substring(n + 1).trim().equalsIgnoreCase("DESC")) {
                                string3 = "DESC";
                            }
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                        string2 = string2.substring(0, n);
                    }
                    if ((column = (Column)map.get(string2 = Token.getValBetweenSquareBrackets(string2))) != null) {
                        try {
                            this.index.add(column);
                            this.index.setColumnSortOrder(column, string3);
                        }
                        catch (Exception exception) {
                            LOGGER.error("Exception occured while adding column to index!" + this.statement);
                            this.importLog.addError("Error in adding column " + column + " to index " + this.indexName);
                        }
                        continue;
                    }
                    throw new ObjectDoesNotExistException("Column");
                }
                break block13;
            }
            if (this.viewProxy != null && (map = this.getColumnsForView()).size() > 0) {
                String string = Token.getValBetweenBrackets(this.statement, 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken().trim();
                    int n = string4.indexOf(" ");
                    if (n <= 0) continue;
                    string4 = string4.substring(0, n);
                }
            }
        }
    }

    private String getName() {
        String string = Token.getQuotedNameAfterToken(this.statement, "ON");
        int n = string.indexOf(46);
        if (n > 0) {
            string = Token.getValAfterCharacter(string, '.');
        }
        if (string.indexOf(40) > -1) {
            string = string.substring(0, string.indexOf(40));
        }
        return Token.getValBetweenSquareBrackets(string);
    }

    private Map getColumnsForTable() {
        HashMap<String, Column> hashMap = new HashMap<String, Column>();
        if (this.table != null) {
            Column[] columnArray = (Column[])this.table.getElements();
            for (int i = 0; i < columnArray.length; ++i) {
                hashMap.put(columnArray[i].getName(), columnArray[i]);
            }
        }
        return hashMap;
    }

    private Map getColumnsForView() {
        HashMap<String, ColumnView> hashMap = new HashMap<String, ColumnView>();
        if (this.viewProxy != null) {
            ColumnView[] columnViewArray = (ColumnView[])this.view.getElements();
            for (int i = 0; i < columnViewArray.length; ++i) {
                hashMap.put(columnViewArray[i].getName(), columnViewArray[i]);
            }
        }
        return hashMap;
    }

    @Override
    public void parseUK(String string) {
        this.statement = string;
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            this.initUnique();
            this.setColumnForIndex();
            if (this.table != null) {
                UniqueProxySqlServerv2k5 uniqueProxySqlServerv2k5;
                this.site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.site);
                if (this.stoDesign != null && (uniqueProxySqlServerv2k5 = new UniqueProxySqlServerv2k5(this.index, (StorageDesign)this.stoDesign)) != null) {
                    this.initClustered(uniqueProxySqlServerv2k5);
                    this.initFillFactorUK(uniqueProxySqlServerv2k5);
                    this.initFileGroupUK(uniqueProxySqlServerv2k5);
                }
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            LOGGER.error("", objectDoesNotExistException);
            this.importLog.addError("Error in creating unique key " + this.indexName);
        }
    }

    private void initFileGroupUK(UniqueProxySqlServerv2k5 uniqueProxySqlServerv2k5) {
        if (Token.hasToken(this.statement, "ON")) {
            String string = Token.getTokenAfter(this.statement, "ON");
            string = Token.getValBetweenQuotationMarks(string);
            uniqueProxySqlServerv2k5.setFilegroup((FileGroupSqlServerv2k5)this.stoDesign.getFileGroupSet().getByName(string));
        }
    }

    private void initFillFactorUK(UniqueProxySqlServerv2k5 uniqueProxySqlServerv2k5) {
        String string = this.getIndexOption("FILLFACTOR");
        if (!string.equals("")) {
            try {
                uniqueProxySqlServerv2k5.setFillFactor(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("", numberFormatException);
                this.importLog.addWarning("Unknown fill factor of unique key " + uniqueProxySqlServerv2k5.getName());
            }
        }
    }

    private boolean isUK() {
        return Token.hasToken(this.statement, "UNIQUE") && !this.isIOV();
    }

    private void initFileGroupPK(PKProxySqlServerv2k5 pKProxySqlServerv2k5) {
        if (Token.hasToken(this.statement, "ON")) {
            String string = Token.getTokenAfter(this.statement, "ON");
            string = Token.getValBetweenQuotationMarks(string);
            pKProxySqlServerv2k5.setFilegroup((FileGroupSqlServerv2k5)this.stoDesign.getFileGroupSet().getByName(string));
        }
    }

    private void initFillFactorPK(PKProxySqlServerv2k5 pKProxySqlServerv2k5) {
        String string = this.getIndexOption("FILLFACTOR");
        if (!string.equals("")) {
            try {
                pKProxySqlServerv2k5.setFillFactor(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("", numberFormatException);
                this.importLog.addWarning("Unknown fill factor of primary key " + pKProxySqlServerv2k5.getName());
            }
        }
    }

    private void parseSecondaryXMLIndex(String string) {
        Object object;
        this.indexName = this.initIndexName();
        String string2 = "";
        if (Token.hasString(string.toLowerCase(), "using xml index")) {
            object = Token.getStringAfter(string.toLowerCase(), "using xml index");
            string2 = Token.getFirstToken((String)object);
        }
        if (string2 != "") {
            this.site = this.design.getSelectedRDBMSSite();
            this.stoDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(this.site);
            if (this.stoDesign != null) {
                object = (SecondaryXmlIndexSqlServerv2k5)this.stoDesign.getSecondaryXmlIndexSetv2k5().createXmlIndex();
                ((StorageObject)object).setName(this.indexName);
                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
                String string3 = this.getName();
                this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(string3);
                if (this.table != null) {
                    Index index = (Index)((ContainerObjectPlaceHolder)this.table.getIndexes().getByName(string2)).getObject();
                    IndexProxySqlServerv2k5 indexProxySqlServerv2k5 = (IndexProxySqlServerv2k5)this.stoDesign.getIndexProxySet().getProxy(index.getObjectID());
                    ((SecondaryXmlIndexSqlServer)object).setPrimaryXmlIndex(indexProxySqlServerv2k5);
                }
            }
        }
    }

    private boolean isSecondaryXMLIndex() {
        return !Token.hasToken(this.statement, "PRIMARY") && Token.hasToken(this.statement, "XML");
    }
}

