/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateDatabaseSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataFileSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDatabaseSqlServerv2k5
extends SHCreateDatabaseSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateDatabaseSqlServer.class);
    private DataBaseSqlServerv2k5 db;

    public SHCreateDatabaseSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateDatabaseSqlServerv2k5.clearCR(string);
        if (Token.startsWithString(string2, "create database")) {
            try {
                this.parseDatabase(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
                this.importLog.addFailedStatement(SHCreateDatabaseSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    @Override
    public void parseDatabase(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k5 != null) {
            this.db = (DataBaseSqlServerv2k5)storageDesignSqlServerv2k5.getDataBaseSet().createDataBase();
            if (this.db != null) {
                if (Token.hasToken(this.statement, "ON") && !Token.getTokenBefore(this.statement, "ON").equalsIgnoreCase("LOG")) {
                    ((StorageObjectCollection)this.db.getChild(0)).removeAll();
                }
                String string2 = this.initDatabaseName();
                this.db.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(this.db);
                this.initOn(this.db, storageDesignSqlServerv2k5);
                this.initLogOn(this.db, storageDesignSqlServerv2k5);
                this.initCollate();
            }
        }
    }

    private String initDatabaseName() {
        String string = Token.getTokenAfter(this.statement, "DATABASE").trim();
        String string2 = string.startsWith("[") ? Token.getNameAfterToken(this.statement, "DATABASE", '[', ']').trim() : Token.getNameAfterToken(this.statement, "DATABASE", '\"', '\"').trim();
        return string2;
    }

    private void initOn(DataBaseSqlServerv2k5 dataBaseSqlServerv2k5, StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5) {
        if (Token.hasToken(this.statement, "ON") && !Token.getTokenBefore(this.statement, "ON").equalsIgnoreCase("LOG")) {
            String string = Token.getStringAfter(this.statement, "ON").trim();
            if (Token.hasString(string, "LOG ON")) {
                string = string.substring(0, string.toUpperCase().indexOf("LOG ON"));
            }
            FileGroupSqlServerv2k5 fileGroupSqlServerv2k5 = null;
            DataFileSqlServerv2k5 dataFileSqlServerv2k5 = null;
            String string2 = Token.getStringBefore(string, "FILEGROUP").trim();
            string = string.substring(string2.length());
            if ("".equalsIgnoreCase(string2)) {
                string2 = string;
            }
            String string3 = "";
            boolean bl = true;
            while (!string2.equalsIgnoreCase("")) {
                Object object;
                if (string2.toUpperCase().startsWith("FILEGROUP")) {
                    string2 = string2.substring(10);
                }
                string3 = Token.getTokenBefore(string2, "(");
                string2 = string2.substring(string3.length());
                if (string3.equalsIgnoreCase("")) {
                    string3 = "PRIMARY";
                }
                String string4 = Token.getValBetweenSquareBrackets(string3.trim());
                fileGroupSqlServerv2k5 = (FileGroupSqlServerv2k5)storageDesignSqlServerv2k5.getFileGroupSet().getByName(string4);
                if (fileGroupSqlServerv2k5 == null || fileGroupSqlServerv2k5.getDataBase() != dataBaseSqlServerv2k5) {
                    fileGroupSqlServerv2k5 = (FileGroupSqlServerv2k5)storageDesignSqlServerv2k5.getFileGroupSet().createFileGroup();
                    this.design.getRelationalDesign().stampModelObjectDDL(fileGroupSqlServerv2k5);
                    fileGroupSqlServerv2k5.setDataBase(dataBaseSqlServerv2k5);
                    fileGroupSqlServerv2k5.setName(Token.getValBetweenSquareBrackets(string3.trim()));
                    object = (StorageObjectCollection)dataBaseSqlServerv2k5.getChild(0);
                    fileGroupSqlServerv2k5.setParent(object);
                    ((StorageObjectCollection)object).add(fileGroupSqlServerv2k5);
                }
                while (!string2.equalsIgnoreCase("") && Token.hasCloseAndOpenBrackets(string2) && !Token.getValBetweenBrackets(string2, 1).trim().equalsIgnoreCase("")) {
                    object = Token.getValBetweenBrackets(string2, 1);
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
                    String string5 = "";
                    dataFileSqlServerv2k5 = (DataFileSqlServerv2k5)storageDesignSqlServerv2k5.getDataFileSet().createDataFile();
                    this.design.getRelationalDesign().stampModelObjectDDL(dataFileSqlServerv2k5);
                    dataFileSqlServerv2k5.setFileGroup(fileGroupSqlServerv2k5);
                    StorageObjectCollection storageObjectCollection = (StorageObjectCollection)fileGroupSqlServerv2k5.getChild(0);
                    dataFileSqlServerv2k5.setParent(storageObjectCollection);
                    storageObjectCollection.add(dataFileSqlServerv2k5);
                    if (stringTokenizer.hasMoreTokens()) {
                        string5 = stringTokenizer.nextToken();
                        string5 = this.initLogName(dataFileSqlServerv2k5, stringTokenizer, string5);
                        string5 = this.initLogFileName(dataFileSqlServerv2k5, stringTokenizer, string5);
                        string5 = this.initLogSize(dataFileSqlServerv2k5, stringTokenizer, string5);
                        string5 = this.initLogMaxSize(dataFileSqlServerv2k5, stringTokenizer, string5);
                        this.initLogFileGrouth(dataFileSqlServerv2k5, string5);
                    }
                    string2 = string2.trim().substring(((String)object).length() + 2);
                }
                if (string.trim().toUpperCase().startsWith("FILEGROUP")) {
                    object = string.trim().substring(10);
                    if (Token.hasToken((String)object, "FILEGROUP")) {
                        object = Token.getStringBefore((String)object, "FILEGROUP");
                    }
                    string2 = "FILEGROUP " + (String)object;
                } else {
                    string2 = Token.getStringBefore(string, "FILEGROUP").trim();
                }
                if ("".equalsIgnoreCase(string2)) continue;
                if ((string = string.trim().substring(string2.length()).trim()).startsWith(",")) {
                    string = string.substring(1).trim();
                }
                if (!string2.equalsIgnoreCase("") || string.equalsIgnoreCase("") || string.equalsIgnoreCase(")") || !bl) continue;
                string2 = string;
                bl = false;
            }
        }
    }

    private void initLogOn(DataBaseSqlServerv2k5 dataBaseSqlServerv2k5, StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5) {
        if (Token.hasToken(this.statement, "LOG") && Token.getTokenAfter(this.statement, "LOG").trim().equalsIgnoreCase("ON")) {
            String string = Token.getStringAfter(this.statement, "LOG ON").trim();
            DataFileSqlServerv2k5 dataFileSqlServerv2k5 = null;
            if (Token.hasString(string, "COLLATE")) {
                string = Token.getStringBefore(string, "COLLATE");
            }
            while (!string.equalsIgnoreCase("") && !Token.getValBetweenBrackets(string, 1).trim().equalsIgnoreCase("")) {
                String string2 = Token.getValBetweenBrackets(string, 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                String string3 = "";
                dataFileSqlServerv2k5 = (DataFileSqlServerv2k5)storageDesignSqlServerv2k5.getDataFileSet().createDataFile();
                this.design.getRelationalDesign().stampModelObjectDDL(dataFileSqlServerv2k5);
                dataFileSqlServerv2k5.setDataBase(dataBaseSqlServerv2k5);
                StorageObjectCollection storageObjectCollection = (StorageObjectCollection)dataBaseSqlServerv2k5.getChild(1);
                dataFileSqlServerv2k5.setParent(storageObjectCollection);
                storageObjectCollection.add(dataFileSqlServerv2k5);
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    string3 = this.initLogName(dataFileSqlServerv2k5, stringTokenizer, string3);
                    string3 = this.initLogFileName(dataFileSqlServerv2k5, stringTokenizer, string3);
                    string3 = this.initLogSize(dataFileSqlServerv2k5, stringTokenizer, string3);
                    string3 = this.initLogMaxSize(dataFileSqlServerv2k5, stringTokenizer, string3);
                    this.initLogFileGrouth(dataFileSqlServerv2k5, string3);
                }
                string = string.trim().substring(string2.length() + 2);
            }
        }
    }

    private String initLogName(DataFileSqlServerv2k5 dataFileSqlServerv2k5, StringTokenizer stringTokenizer, String string) {
        if (string.trim().toUpperCase().startsWith("NAME")) {
            String string2 = Token.getStringAfter(string, "NAME").trim();
            if ((string2 = Token.getStringAfter(string2, "=").trim()).startsWith("N'")) {
                string2 = string2.substring(1);
            }
            if (string2.startsWith("'")) {
                string2 = Token.getValBetweenQuotationMarks(string2);
            }
            dataFileSqlServerv2k5.setName(Token.getValBetweenSquareBrackets(string2));
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        return string;
    }

    private String initLogFileName(DataFileSqlServerv2k5 dataFileSqlServerv2k5, StringTokenizer stringTokenizer, String string) {
        if (string.trim().toUpperCase().startsWith("FILENAME")) {
            String string2 = Token.getStringAfter(string, "FILENAME").trim();
            if ((string2 = Token.getStringAfter(string2, "=").trim()).startsWith("N'")) {
                string2 = string2.substring(1);
            }
            if (string2.startsWith("'")) {
                string2 = Token.getValBetweenQuotationMarks(string2);
            }
            dataFileSqlServerv2k5.setFileName(Token.getValBetweenSquareBrackets(string2));
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        return string;
    }

    private String initLogSize(DataFileSqlServerv2k5 dataFileSqlServerv2k5, StringTokenizer stringTokenizer, String string) {
        if (string.trim().toUpperCase().startsWith("SIZE")) {
            String string2 = Token.getStringAfter(string, "SIZE");
            string2 = Token.getStringAfter(string2, "=").trim();
            try {
                dataFileSqlServerv2k5.setInitialSize(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("Wrong format:", numberFormatException);
                this.importLog.addWarning("Unknown initialial size of file " + dataFileSqlServerv2k5.getName());
            }
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        return string;
    }

    private String initLogMaxSize(DataFileSqlServerv2k5 dataFileSqlServerv2k5, StringTokenizer stringTokenizer, String string) {
        if (string.trim().toUpperCase().startsWith("MAXSIZE")) {
            String string2 = Token.getStringAfter(string, "MAXSIZE");
            if ((string2 = Token.getStringAfter(string2, "=").trim()).equalsIgnoreCase("UNLIMITED")) {
                dataFileSqlServerv2k5.setIsUnlimited(true);
            } else {
                try {
                    dataFileSqlServerv2k5.setMaxSize(Integer.parseInt(string2));
                    dataFileSqlServerv2k5.setIsUnlimited(false);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("", numberFormatException);
                    this.importLog.addWarning("Unknown max size of file " + dataFileSqlServerv2k5.getName());
                }
            }
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        return string;
    }

    private void initLogFileGrouth(DataFileSqlServerv2k5 dataFileSqlServerv2k5, String string) {
        if (string.trim().toUpperCase().startsWith("FILEGROWTH")) {
            String string2 = Token.getStringAfter(string, "FILEGROWTH").trim();
            string2 = Token.getStringAfter(string, "=").trim();
            if (Token.hasString(string2, "%")) {
                dataFileSqlServerv2k5.setGrowthMethod("By Percent");
                string2 = string2.substring(0, string2.length() - 1).trim();
            } else {
                dataFileSqlServerv2k5.setGrowthMethod("In MegaBytes");
            }
            try {
                dataFileSqlServerv2k5.setGrowthValue(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("Wrong format:", numberFormatException);
                this.importLog.addWarning("Unknown filegrowth of file " + dataFileSqlServerv2k5.getName());
            }
        }
    }

    private void initCollate() {
        if (Token.hasToken(this.statement, "COLLATE")) {
            String string = Token.getStringAfter(this.statement, "COLLATE");
            this.db.setCollationName(string);
        }
    }
}

