/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHAddDataTypeSqlServer;
import oracle.dbtools.crest.model.datatype.NotStandartDataTypeNames;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.DistinctTypeSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UsedUserDefinedDatav2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserDefinedTypeSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHAddDataTypeSqlServerv2k5
extends SHAddDataTypeSqlServer {
    private static final String ZERO = "0";
    private static final Logger LOGGER = new Logger(SHAddDataTypeSqlServerv2k5.class);
    private UsedUserDefinedDatav2k5 type;
    private UserDefinedTypeSqlServerv2k5 userDT;
    private LogicalDatatypeFactory factoryLogical;

    public SHAddDataTypeSqlServerv2k5(Design design, LogicalDatatypeFactory logicalDatatypeFactory) {
        super(design, logicalDatatypeFactory);
        this.factoryLogical = logicalDatatypeFactory;
    }

    public SHAddDataTypeSqlServerv2k5(Design design) {
        super(design);
        this.factoryLogical = new LogicalDatatypeFactory();
    }

    @Override
    public void handle(String string) {
        String string2 = SHAddDataTypeSqlServerv2k5.clearCR(string);
        if (Token.startsWithString(string2, "create type ") && !Token.hasToken(string2, "EXTERNAL")) {
            try {
                this.addDataType(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHAddDataTypeSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    @Override
    public void addDataType(String string) {
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k5 != null) {
            this.type = (UsedUserDefinedDatav2k5)storageDesignSqlServerv2k5.getUsedUserDefinedDataSet().createUsedUserDefinedData();
            if (this.type != null) {
                this.design.getRelationalDesign().stampModelObjectDDL(this.type);
                String string2 = Token.getTokenAfter(string, "TYPE");
                String string3 = Token.getValBeforeCharacter(string2, '.');
                SchemaSqlServerv2k5 schemaSqlServerv2k5 = null;
                if (!string3.equals("")) {
                    string2 = Token.getValAfterCharacter(string2, '.');
                    schemaSqlServerv2k5 = (SchemaSqlServerv2k5)storageDesignSqlServerv2k5.getSchemaSet().getByName(string3);
                }
                String string4 = Token.getStringAfter(string, "FROM");
                if (!string2.equals("")) {
                    this.type.setName(string2);
                    this.type.setSchema(schemaSqlServerv2k5);
                    this.type.setDatabase(this.getCurrentDB());
                    this.userDT = (UserDefinedTypeSqlServerv2k5)storageDesignSqlServerv2k5.getUserDefinedTypeSet().createType();
                    this.userDT.setName(string2);
                    this.design.getRelationalDesign().stampModelObjectDDL(this.userDT);
                    this.type.setUserDefinedType(this.userDT);
                    if (Token.hasString(string4, "NOT NULL")) {
                        string4 = Token.getStringBefore(string4, "NOT NULL");
                        this.userDT.setNullType("NOT NULL");
                    }
                    if (Token.hasToken(string4, "NULL")) {
                        string4 = Token.getStringBefore(string4, "NULL");
                        this.userDT.setNullType("NULL");
                    }
                    Iterator iterator = storageDesignSqlServerv2k5.getDesign().getDomainSet().iterator();
                    DesignObject designObject = null;
                    while (iterator.hasNext()) {
                        Domain domain = (Domain)iterator.next();
                        if (!domain.getDataType().toString().equalsIgnoreCase(string4) || !this.compareDataTypes(domain, string4)) continue;
                        designObject = domain;
                        break;
                    }
                    if (designObject != null) {
                        this.userDT.setDomain(designObject.getName());
                        NotStandartDataTypeNames.addNotStandartDataType(designObject.getName());
                        NotStandartDataTypeNames.addNotStandartSynonym(designObject.getName(), string4);
                    } else {
                        this.createDistinctType(string2, string4);
                        this.userDT.setUsedUserDataType(string2);
                        NotStandartDataTypeNames.addNotStandartDataType(string2);
                        NotStandartDataTypeNames.addNotStandartSynonym(string2, string4);
                    }
                }
            }
        }
    }

    private void createDistinctType(String string, String string2) {
        Map map;
        String string3;
        String string4 = string2;
        int n = string4.indexOf(40);
        if (n > -1) {
            string4 = string4.substring(0, n).trim();
        }
        if (this.checkBuildinDatatype(string4) && (string3 = (String)(map = this.parseBuildinDatatype(string2)).get("datatype")) != null) {
            String string5 = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(string3);
            LogicalDatatype logicalDatatype = null;
            logicalDatatype = this.factoryLogical.searchLogicalDatatype(this.design, string5);
            DistinctTypeSet distinctTypeSet = this.design.getDesign().getDataTypesDesign().getDistinctTypeSet();
            DistinctType distinctType = distinctTypeSet.createDistinctType(null);
            distinctType.setName(string);
            this.design.getRelationalDesign().stampModelObjectDDL(distinctType);
            if (logicalDatatype != null) {
                distinctType.setLogicalDataType(logicalDatatype);
            } else {
                LogicalDatatype logicalDatatype2 = this.design.getDesign().getLogicalDatatypeSet().createLogicalDatatype(null);
                this.design.getRelationalDesign().stampModelObjectDDL(logicalDatatype2);
                distinctType.setLogicalDataType(logicalDatatype2);
            }
            distinctType.setFilePath(this.design.getDesign().getFileName());
        }
    }

    private boolean checkBuildinDatatype(String string) {
        String[] stringArray = StandardDatatypeNames.getAllPossibleDatatypes("SQL Server 2005");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private Map parseBuildinDatatype(String string) {
        String string2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = string;
        int n = string.indexOf(40);
        if (n > -1) {
            string3 = string.substring(0, n).trim();
        }
        if ((string2 = StandardDatatypeNames.getUsedDatatypeName(string3)) != null) {
            String string4 = Token.cutTokenFromFront(string, string3);
            hashMap.put("datatype", string2);
            if (!string4.equalsIgnoreCase("")) {
                boolean bl = Token.hasCloseAndOpenBrackets(string4);
                if (bl) {
                    bl = Token.getValBeforeBrackets(string4).trim().equalsIgnoreCase("");
                }
                if (bl) {
                    String string5 = Token.getValBetweenBrackets(string4, 1);
                    int n2 = string5.indexOf(",");
                    if (n2 != -1) {
                        hashMap.put("size", ZERO);
                        hashMap.put("precision", string5.substring(0, n2).trim());
                        hashMap.put("scale", string5.substring(n2 + 1).trim());
                    } else if (string2.equals("DECIMAL")) {
                        hashMap.put("size", ZERO);
                        hashMap.put("scale", ZERO);
                        hashMap.put("precision", string5.trim());
                    } else if (string2.equalsIgnoreCase("NUMERIC")) {
                        if (n2 != -1) {
                            hashMap.put("size", ZERO);
                            hashMap.put("precision", string5.substring(0, n2).trim());
                            hashMap.put("scale", string5.substring(n2 + 1).trim());
                        } else {
                            hashMap.put("size", ZERO);
                            hashMap.put("precision", string5.trim());
                            hashMap.put("scale", ZERO);
                        }
                    } else {
                        hashMap.put("scale", ZERO);
                        hashMap.put("precision", ZERO);
                        hashMap.put("size", string5.trim());
                    }
                }
            }
        } else {
            LOGGER.error("datatype " + string + " is unknown!");
            this.importLog.addError("Datatype " + string + " is unknown");
        }
        return hashMap;
    }

    private boolean compareDataTypes(Domain domain, String string) {
        String string2;
        if (string.equalsIgnoreCase("INT")) {
            string = "INTEGER";
        }
        if (Token.hasCloseAndOpenBrackets(string2 = domain.getDataType().toString()) && Token.hasCloseAndOpenBrackets(string)) {
            String string3 = string2.substring(string2.indexOf(40)).trim();
            String string4 = string2.substring(0, string2.indexOf(40)).trim();
            String string5 = string2.substring(string.indexOf(40)).trim();
            String string6 = string2.substring(0, string.indexOf(40)).trim();
            return string3.equalsIgnoreCase(string5) && string4.equalsIgnoreCase(string6);
        }
        return string2.equalsIgnoreCase(string);
    }
}

