/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateRoleSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SCHCreateSchemaSqlServerv2k5
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateRoleSqlServer.class);

    public SCHCreateSchemaSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SCHCreateSchemaSqlServerv2k5.clearCR(string);
        if (Token.startsWithString(string2, "create schema")) {
            try {
                this.createSchema(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SCHCreateSchemaSqlServerv2k5.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void createSchema(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k5 != null) {
            String string2 = Token.getTokenAfter(string, "SCHEMA");
            SchemaSqlServerv2k5 schemaSqlServerv2k5 = (SchemaSqlServerv2k5)storageDesignSqlServerv2k5.getSchemaSet().createSchema();
            schemaSqlServerv2k5.setName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(schemaSqlServerv2k5);
            if (Token.hasToken(string, "AUTHORIZATION")) {
                String string3 = Token.getTokenAfter(string, "AUTHORIZATION");
                UserSqlServerv2k5 userSqlServerv2k5 = (UserSqlServerv2k5)this.getCurrentDB().getUsers().getByName(string3);
                if (userSqlServerv2k5 != null && schemaSqlServerv2k5 != null) {
                    schemaSqlServerv2k5.setOwner(userSqlServerv2k5);
                }
            }
            schemaSqlServerv2k5.setDatabase(this.getCurrentDB());
        }
    }
}

