/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.sqlserver.DomainHandlerReadDDLSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHAddDataTypeSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHColumnElementsSqlServerv2k5;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class DomainHandlerReadDDLSqlServerv2k5
implements StatementsConstants {
    private DomainFactory factory = new DomainFactory();
    private Design design;
    private LogicalDatatypeFactory factoryLogical;
    private static final Logger LOGGER = new Logger(DomainHandlerReadDDLSqlServer.class);

    public DomainHandlerReadDDLSqlServerv2k5(Design design) {
        this.design = design;
        this.factoryLogical = new LogicalDatatypeFactory();
    }

    public void createDomains(LinkedList linkedList) {
        ArrayList arrayList = new ArrayList();
        for (Object e : linkedList) {
            Object object;
            String string = DDLStatementHandler.clearCR((String)e);
            if (Token.startsWithString(string, "exec sp_addtype")) {
                object = new SHAddDataTypeSqlServer(this.design, this.factoryLogical);
                try {
                    ((SHAddDataTypeSqlServer)object).addDataType(string);
                    arrayList.add(e);
                }
                catch (Exception exception) {
                    LOGGER.error("Parsing " + string + " for SQL Server failed!", exception);
                }
            }
            if (!Token.startsWithString(string, "create table")) continue;
            object = this.getColumns(string);
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                this.createOneDomain(string2);
            }
        }
        linkedList.removeAll(arrayList);
    }

    private ArrayList getColumns(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = Token.getValBetweenBrackets(string, 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (Token.hasOpenBracket(string3)) {
                StringBuffer stringBuffer = new StringBuffer(string3);
                while (Token.hasOpenBracket(string3) && stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(", ").append(stringTokenizer.nextToken().trim());
                    string3 = stringBuffer.toString();
                }
            }
            arrayList.add(string3.trim());
        }
        return arrayList;
    }

    private void createOneDomain(String string) {
        SHColumnElementsSqlServerv2k5 sHColumnElementsSqlServerv2k5 = new SHColumnElementsSqlServerv2k5(this.design);
        Map map = sHColumnElementsSqlServerv2k5.getElementsColumn(string);
        String string2 = (String)map.get("columnname");
        if (!"".equalsIgnoreCase(string2)) {
            String string3 = (String)map.get("datatype");
            String[] stringArray = new String[]{(String)map.get("precision"), (String)map.get("scale"), (String)map.get("size")};
            if (string3 != null) {
                String string4 = StandardDatatypeNames.getUsedDatatypeName(string3);
                LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignSqlServerv2k5.RDBMS_TYPE, string4);
                this.factory.getInstance(this.design, logicalDatatype, null, 2, stringArray, null);
            }
        }
    }
}

