/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHGrantPrivilegesSqlServer
extends DDLStatementHandlerSqlServer {
    private StorageDesignSqlServerv2k storageDesign;
    private static final Logger LOGGER = new Logger(SHGrantPrivilegesSqlServer.class);

    public SHGrantPrivilegesSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHGrantPrivilegesSqlServer.clearCR(string);
        if ((Token.startsWithString(string2, "grant") || Token.startsWithString(string2, "grant all")) && !Token.hasToken(string2, "ON")) {
            try {
                this.grantPrivileges(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHGrantPrivilegesSqlServer.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void grantPrivileges(String string) {
        this.statement = string.replaceAll("\"", "");
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null) {
            String string2 = Token.getStringAfter(this.statement, "GRANT").trim();
            string2 = Token.getStringBeforeToken(string2, "TO").trim();
            this.initTo(string2);
        }
    }

    private void initTo(String string) {
        String string2 = Token.getStringAfterToken(this.statement, "TO").trim();
        if (!string2.equalsIgnoreCase("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                String string4;
                StringTokenizer stringTokenizer2;
                AbstractStorageObjectSqlServer abstractStorageObjectSqlServer;
                string3 = stringTokenizer.nextToken().trim();
                string3 = Token.getValBetweenSquareBrackets(string3);
                DataBaseSqlServer dataBaseSqlServer = this.getCurrentDB();
                StorageObjectCollection storageObjectCollection = dataBaseSqlServer.getUsers();
                StorageObjectCollection storageObjectCollection2 = dataBaseSqlServer.getRoles();
                if (storageObjectCollection.getByName(string3) != null) {
                    abstractStorageObjectSqlServer = (UserSqlServer)storageObjectCollection.getByName(string3);
                    stringTokenizer2 = new StringTokenizer(string, ",");
                    string4 = null;
                    while (stringTokenizer2.hasMoreTokens()) {
                        string4 = stringTokenizer2.nextToken().trim();
                        ((UserSqlServer)abstractStorageObjectSqlServer).setSystemPrivileges(string4);
                    }
                    continue;
                }
                if (storageObjectCollection2.getByName(string3) == null) continue;
                abstractStorageObjectSqlServer = (RoleSqlServer)storageObjectCollection2.getByName(string3);
                stringTokenizer2 = new StringTokenizer(string, ",");
                string4 = null;
                while (stringTokenizer2.hasMoreTokens()) {
                    string4 = stringTokenizer2.nextToken().trim();
                    ((RoleSqlServer)abstractStorageObjectSqlServer).setSystemPrivileges(string4);
                }
            }
        } else {
            LOGGER.error("SHGrantPrivilegesSqlServer.initTo(): wrong syntax!");
            this.importLog.addError("Error in setting TO objects of permission " + this.statement);
        }
    }
}

