/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHGrantPermissionsSqlServer
extends DDLStatementHandlerSqlServer {
    private PermissionsSqlServer permissions;
    private StorageDesignSqlServerv2k storageDesign;
    private TableProxySqlServer table = null;
    private TableViewProxySqlServer view = null;
    private DataBaseSqlServer db = null;
    private static final Logger LOGGER = new Logger(SHGrantPermissionsSqlServer.class);

    public SHGrantPermissionsSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHGrantPermissionsSqlServer.clearCR(string);
        if (Token.startsWithString(string2, "GRANT") && Token.hasToken(string2, "ON")) {
            try {
                this.grantPermissions(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHGrantPermissionsSqlServer.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void grantPermissions(String string) {
        this.statement = string.replaceAll("\"", "");
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null) {
            RelationalObjectProxy relationalObjectProxy = this.initOn();
            ArrayList arrayList = this.initUsersAndRoles();
            if (relationalObjectProxy != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (this.getPermissionForUser((StorageObject)arrayList.get(i), relationalObjectProxy) != null) {
                        this.permissions = this.getPermissionForUser((StorageObject)arrayList.get(i), relationalObjectProxy);
                    } else {
                        this.permissions = this.storageDesign.getPermissionsSet().createPermissions();
                        this.design.getRelationalDesign().stampModelObjectDDL(this.permissions);
                    }
                    if (this.permissions == null) continue;
                    this.initPrivileges();
                    this.initOnObject(relationalObjectProxy);
                    this.initTo(arrayList.get(i));
                    this.initAs();
                }
            }
        }
    }

    private PermissionsSqlServer getPermissionForUser(StorageObject storageObject, RelationalObjectProxy relationalObjectProxy) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        PermissionsSqlServer permissionsSqlServer = null;
        while (iterator.hasNext()) {
            permissionsSqlServer = (PermissionsSqlServer)iterator.next();
            if (permissionsSqlServer.getUser() != storageObject && permissionsSqlServer.getRole() != storageObject || permissionsSqlServer.getTable() != relationalObjectProxy && permissionsSqlServer.getView() != relationalObjectProxy) continue;
            return permissionsSqlServer;
        }
        return null;
    }

    private ArrayList initUsersAndRoles() {
        ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
        String string = Token.getStringAfter(this.statement, "TO").trim();
        if (string.toLowerCase().indexOf(" as ") > -1) {
            string = Token.getStringBefore(string, "AS").trim();
        }
        if (string.toLowerCase().indexOf(" with ") > -1) {
            string = Token.getStringBefore(string, "WITH").trim();
        }
        if (!string.equalsIgnoreCase("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = null;
            if (this.table != null) {
                this.db = this.table.getDatabase();
            } else if (this.view != null) {
                this.db = this.view.getDataBase();
            }
            if (this.db != null) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken().trim();
                    string2 = Token.getValBetweenSquareBrackets(string2);
                    StorageObjectCollection storageObjectCollection = this.db.getUsers();
                    StorageObjectCollection storageObjectCollection2 = this.db.getRoles();
                    if (storageObjectCollection.getByName(string2) != null) {
                        arrayList.add(storageObjectCollection.getByName(string2));
                        continue;
                    }
                    if (storageObjectCollection2.getByName(string2) == null) continue;
                    arrayList.add(storageObjectCollection2.getByName(string2));
                }
            }
        }
        return arrayList;
    }

    private void initPrivileges() {
        Object object;
        String string = Token.getStringAfter(this.statement.toUpperCase(), "GRANT");
        if (Token.hasCloseAndOpenBrackets(string = Token.getStringBefore(string, "ON").trim())) {
            object = Token.getValBetweenBrackets(string).trim();
            string = Token.getStringBefore(string, "(").trim();
            this.initColumns((String)object, string);
        }
        if (this.statement.toUpperCase().indexOf("WITH GRANT OPTION") > -1) {
            object = new StringTokenizer(string, ",");
            String string2 = null;
            while (((StringTokenizer)object).hasMoreTokens()) {
                string2 = ((StringTokenizer)object).nextToken().trim();
                this.permissions.setPrivilegesWithGrantOption(string2);
            }
        } else {
            object = new StringTokenizer(string, ",");
            String string3 = null;
            while (((StringTokenizer)object).hasMoreTokens()) {
                string3 = ((StringTokenizer)object).nextToken().trim();
                this.permissions.setPrivileges(string3);
            }
        }
    }

    private void initColumns(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken().trim();
            if ((string3.equalsIgnoreCase("") || this.table == null || this.table.getColumnProxyByName(string3) == null) && (this.view == null || this.view.getColumnProxyByName(string3) == null)) continue;
            string3 = string3 + ", " + string2;
            this.permissions.setColumnList(string3);
        }
    }

    private RelationalObjectProxy initOn() {
        String string = Token.getStringAfterToken(this.statement, "ON").trim();
        string = Token.getStringBefore(string, "TO").trim();
        if (!(string = Token.getValBetweenSquareBrackets(string)).equalsIgnoreCase("")) {
            this.table = ((TableProxySetSqlServer)this.storageDesign.getTableProxySet()).getByName(string);
            if (this.table != null) {
                return this.table;
            }
            this.view = ((TableViewProxySetSqlServer)this.storageDesign.getTableViewProxySet()).getByName(string);
            if (this.view != null) {
                return this.view;
            }
        }
        LOGGER.error("SHGrantPermissionsSqlServer.initOn(): wrong syntax!");
        this.importLog.addError("Error in setting object of permission " + this.statement);
        return null;
    }

    private void initOnObject(RelationalObjectProxy relationalObjectProxy) {
        if (relationalObjectProxy instanceof TableProxySqlServer) {
            this.permissions.setTable((TableProxySqlServer)relationalObjectProxy);
        } else if (relationalObjectProxy instanceof TableViewProxySqlServer) {
            this.permissions.setView((TableViewProxySqlServer)relationalObjectProxy);
        }
    }

    private void initTo(Object object) {
        String string = Token.getStringAfter(this.statement.toUpperCase(), "TO").trim();
        if (string.toLowerCase().indexOf(" as ") > -1) {
            string = Token.getStringBefore(string, "AS").trim();
        }
        if (!string.equalsIgnoreCase("")) {
            if (this.table != null) {
                this.db = this.table.getDatabase();
            } else if (this.view != null) {
                this.db = this.view.getDataBase();
            }
            if (this.db != null) {
                if (object instanceof UserSqlServer) {
                    this.permissions.setUser((UserSqlServer)object);
                } else if (object instanceof RoleSqlServer) {
                    this.permissions.setRole((RoleSqlServer)object);
                }
            }
        } else {
            LOGGER.error("SHGrantPrivilegesSqlServer.initTo(): wrong syntax!");
            this.importLog.addError("Error in setting TO objects of permission " + this.statement);
        }
    }

    private void initAs() {
        if (this.statement.toLowerCase().indexOf(" as ") > -1) {
            StorageObjectCollection storageObjectCollection;
            String string = Token.getStringAfter(this.statement.toUpperCase(), "AS").trim();
            string = Token.getValBetweenSquareBrackets(string);
            if (this.db != null && (storageObjectCollection = this.db.getRoles()).getByName(string) != null) {
                this.permissions.setAsRole((RoleSqlServer)storageObjectCollection.getByName(string));
            }
        }
    }
}

