/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexOnViewSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.util.logging.Logger;

public class SHExtendedPropertiesSqlServer
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHExtendedPropertiesSqlServer.class);
    private String propertyName;
    private String propertyValue;
    private String object;
    private String objectName;
    private Table table;
    private TableProxySqlServer tableProxy;
    private TableView view;
    private TableViewProxySqlServer viewProxy;
    private ColumnProxySqlServer columnProxy;
    private IndexProxySqlServer indexProxy;
    private IndexOnViewSqlServer indexOnView;
    private String object2;
    private String objectName2;

    public SHExtendedPropertiesSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHExtendedPropertiesSqlServer.clearCR(string);
        if (Token.startsWithString(string2, "EXEC sp_addextendedproperty")) {
            try {
                this.createExtProperties(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHExtendedPropertiesSqlServer.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void createExtProperties(String string) {
        this.statement = string.replaceAll("\"", "");
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServer != null) {
            String string2 = Token.getStringAfter(this.statement, "sp_addextendedproperty").trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.equalsIgnoreCase("'MS_Description'")) {
                this.initComments(stringTokenizer, storageDesignSqlServer);
            } else if (stringTokenizer.countTokens() == 6) {
                this.initWithoutColumn(stringTokenizer, storageDesignSqlServer);
            } else if (stringTokenizer.countTokens() == 8) {
                this.initWithColumn(stringTokenizer, storageDesignSqlServer);
            }
        }
    }

    private void initComments(StringTokenizer stringTokenizer, StorageDesignSqlServer storageDesignSqlServer) {
        block33: {
            String string;
            block58: {
                block64: {
                    block65: {
                        ModelIDObject modelIDObject;
                        block62: {
                            block63: {
                                block59: {
                                    block60: {
                                        block61: {
                                            int n;
                                            block41: {
                                                block57: {
                                                    block49: {
                                                        block55: {
                                                            block56: {
                                                                ModelIDObject modelIDObject2;
                                                                block53: {
                                                                    block54: {
                                                                        block50: {
                                                                            block51: {
                                                                                block52: {
                                                                                    block42: {
                                                                                        RuleSqlServer ruleSqlServer;
                                                                                        block48: {
                                                                                            block47: {
                                                                                                block45: {
                                                                                                    block46: {
                                                                                                        block43: {
                                                                                                            block44: {
                                                                                                                block34: {
                                                                                                                    RuleSqlServer ruleSqlServer2;
                                                                                                                    block40: {
                                                                                                                        block39: {
                                                                                                                            block37: {
                                                                                                                                block38: {
                                                                                                                                    block35: {
                                                                                                                                        block36: {
                                                                                                                                            n = stringTokenizer.countTokens() + 1;
                                                                                                                                            string = stringTokenizer.nextToken().trim();
                                                                                                                                            string = Token.cutN(string);
                                                                                                                                            string = Token.getValBetweenQuotationMarks(string);
                                                                                                                                            if (n != 4) break block34;
                                                                                                                                            this.object = stringTokenizer.nextToken().trim();
                                                                                                                                            this.object = Token.cutN(this.object);
                                                                                                                                            this.objectName = stringTokenizer.nextToken().trim();
                                                                                                                                            this.objectName = Token.cutN(this.objectName);
                                                                                                                                            this.objectName = Token.getValBetweenQuotationMarks(this.objectName);
                                                                                                                                            if (!this.object.equalsIgnoreCase("'table'")) break block35;
                                                                                                                                            this.tableProxy = ((TableProxySetSqlServer)storageDesignSqlServer.getTableProxySet()).getByName(this.objectName);
                                                                                                                                            if (this.tableProxy == null) break block36;
                                                                                                                                            this.tableProxy.setCommentInRDBMS(string);
                                                                                                                                            this.tableProxy.setCommentInRDBMSChanged(true);
                                                                                                                                            break block33;
                                                                                                                                        }
                                                                                                                                        this.table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(this.objectName);
                                                                                                                                        if (this.table == null) break block33;
                                                                                                                                        this.table.setCommentInRDBMS(string);
                                                                                                                                        break block33;
                                                                                                                                    }
                                                                                                                                    if (!this.object.equalsIgnoreCase("'view'")) break block37;
                                                                                                                                    this.viewProxy = ((TableViewProxySetSqlServer)storageDesignSqlServer.getTableViewProxySet()).getByName(this.objectName);
                                                                                                                                    if (this.viewProxy == null) break block38;
                                                                                                                                    this.viewProxy.setCommentInRDBMS(string);
                                                                                                                                    this.viewProxy.setCommentInRDBMSChanged(true);
                                                                                                                                    break block33;
                                                                                                                                }
                                                                                                                                this.view = (TableView)this.design.getDesign().getRelationalDesign().getTableViewSet().getByName(this.objectName);
                                                                                                                                if (this.view == null) break block33;
                                                                                                                                this.view.setCommentInRDBMS(string);
                                                                                                                                break block33;
                                                                                                                            }
                                                                                                                            if (!this.object.equalsIgnoreCase("'procedure'")) break block39;
                                                                                                                            StoredProcedureSqlServer storedProcedureSqlServer = (StoredProcedureSqlServer)storageDesignSqlServer.getStoredProcedureSet().getByName(this.objectName);
                                                                                                                            if (storedProcedureSqlServer == null) break block33;
                                                                                                                            storedProcedureSqlServer.setCommentInRDBMS(string);
                                                                                                                            break block33;
                                                                                                                        }
                                                                                                                        if (!this.object.equalsIgnoreCase("'default'")) break block40;
                                                                                                                        DefaultSqlServer defaultSqlServer = (DefaultSqlServer)storageDesignSqlServer.getDefaultSet().getByName(this.objectName);
                                                                                                                        if (defaultSqlServer == null) break block33;
                                                                                                                        defaultSqlServer.setCommentInRDBMS(string);
                                                                                                                        break block33;
                                                                                                                    }
                                                                                                                    if (!this.object.equalsIgnoreCase("'rule'") || (ruleSqlServer2 = (RuleSqlServer)storageDesignSqlServer.getRuleSet().getByName(this.objectName)) == null) break block33;
                                                                                                                    ruleSqlServer2.setCommentInRDBMS(string);
                                                                                                                    break block33;
                                                                                                                }
                                                                                                                if (n != 6) break block41;
                                                                                                                this.object = stringTokenizer.nextToken().trim();
                                                                                                                this.object = Token.cutN(this.object);
                                                                                                                this.objectName = stringTokenizer.nextToken().trim();
                                                                                                                this.objectName = Token.cutN(this.objectName);
                                                                                                                this.objectName = Token.getValBetweenQuotationMarks(this.objectName);
                                                                                                                this.object2 = stringTokenizer.nextToken().trim();
                                                                                                                this.object2 = Token.cutN(this.object2);
                                                                                                                this.objectName2 = stringTokenizer.nextToken().trim();
                                                                                                                this.objectName2 = Token.cutN(this.objectName2);
                                                                                                                this.objectName2 = Token.getValBetweenQuotationMarks(this.objectName2);
                                                                                                                if (!this.object.equalsIgnoreCase("'user'") && !this.object.equalsIgnoreCase("'schema'")) break block42;
                                                                                                                if (!this.object2.equalsIgnoreCase("'table'")) break block43;
                                                                                                                this.tableProxy = ((TableProxySetSqlServer)storageDesignSqlServer.getTableProxySet()).getByName(this.objectName2);
                                                                                                                if (this.tableProxy == null) break block44;
                                                                                                                this.tableProxy.setCommentInRDBMS(string);
                                                                                                                this.tableProxy.setCommentInRDBMSChanged(true);
                                                                                                                break block33;
                                                                                                            }
                                                                                                            this.table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(this.objectName2);
                                                                                                            if (this.table == null) break block33;
                                                                                                            this.table.setCommentInRDBMS(string);
                                                                                                            break block33;
                                                                                                        }
                                                                                                        if (!this.object2.equalsIgnoreCase("'view'")) break block45;
                                                                                                        this.viewProxy = ((TableViewProxySetSqlServer)storageDesignSqlServer.getTableViewProxySet()).getByName(this.objectName2);
                                                                                                        if (this.viewProxy == null) break block46;
                                                                                                        this.viewProxy.setCommentInRDBMS(string);
                                                                                                        this.viewProxy.setCommentInRDBMSChanged(true);
                                                                                                        break block33;
                                                                                                    }
                                                                                                    this.view = (TableView)this.design.getDesign().getRelationalDesign().getTableViewSet().getByName(this.objectName2);
                                                                                                    if (this.view == null) break block33;
                                                                                                    this.view.setCommentInRDBMS(string);
                                                                                                    break block33;
                                                                                                }
                                                                                                if (!this.object2.equalsIgnoreCase("'procedure'")) break block47;
                                                                                                StoredProcedureSqlServer storedProcedureSqlServer = (StoredProcedureSqlServer)storageDesignSqlServer.getStoredProcedureSet().getByName(this.objectName2);
                                                                                                if (storedProcedureSqlServer == null) break block33;
                                                                                                storedProcedureSqlServer.setCommentInRDBMS(string);
                                                                                                break block33;
                                                                                            }
                                                                                            if (!this.object2.equalsIgnoreCase("'default'")) break block48;
                                                                                            DefaultSqlServer defaultSqlServer = (DefaultSqlServer)storageDesignSqlServer.getDefaultSet().getByName(this.getNameOnly(this.objectName2));
                                                                                            if (defaultSqlServer == null) break block33;
                                                                                            defaultSqlServer.setCommentInRDBMS(string);
                                                                                            break block33;
                                                                                        }
                                                                                        if (!this.object2.equalsIgnoreCase("'rule'") || (ruleSqlServer = (RuleSqlServer)storageDesignSqlServer.getRuleSet().getByName(this.objectName2)) == null) break block33;
                                                                                        ruleSqlServer.setCommentInRDBMS(string);
                                                                                        break block33;
                                                                                    }
                                                                                    if (!this.object.equalsIgnoreCase("'table'")) break block49;
                                                                                    this.tableProxy = ((TableProxySetSqlServer)storageDesignSqlServer.getTableProxySet()).getByName(this.objectName);
                                                                                    this.table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(this.objectName);
                                                                                    if (!this.object2.equalsIgnoreCase("'column'")) break block50;
                                                                                    if (this.tableProxy == null) break block51;
                                                                                    ColumnProxy columnProxy = this.tableProxy.getColumnProxyByName(this.objectName2);
                                                                                    if (columnProxy == null) break block52;
                                                                                    columnProxy.setCommentInRDBMS(string);
                                                                                    columnProxy.setCommentInRDBMSChanged(true);
                                                                                    break block33;
                                                                                }
                                                                                if (this.table == null) break block33;
                                                                                ContainedObject[] containedObjectArray = this.table.getElements();
                                                                                for (int i = 0; i < containedObjectArray.length; ++i) {
                                                                                    if (!containedObjectArray[i].getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                                    containedObjectArray[i].setCommentInRDBMS(string);
                                                                                    break block33;
                                                                                }
                                                                                break block33;
                                                                            }
                                                                            if (this.table == null) break block33;
                                                                            ContainedObject[] containedObjectArray = this.table.getElements();
                                                                            for (int i = 0; i < containedObjectArray.length; ++i) {
                                                                                if (!containedObjectArray[i].getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                                containedObjectArray[i].setCommentInRDBMS(string);
                                                                                break block33;
                                                                            }
                                                                            break block33;
                                                                        }
                                                                        if (!this.object2.equalsIgnoreCase("'index'")) break block53;
                                                                        if (this.tableProxy == null) break block54;
                                                                        IndexProxy[] indexProxyArray = this.tableProxy.getIndexProxies();
                                                                        boolean bl = false;
                                                                        for (int i = 0; i < indexProxyArray.length; ++i) {
                                                                            if (!indexProxyArray[i].getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                            indexProxyArray[i].setCommentInRDBMS(string);
                                                                            indexProxyArray[i].setCommentInRDBMSChanged(true);
                                                                            bl = true;
                                                                            break;
                                                                        }
                                                                        if (bl || this.table == null) break block33;
                                                                        Iterator iterator = this.table.getIndexes().iterator();
                                                                        while (iterator.hasNext()) {
                                                                            Index index = (Index)iterator.next();
                                                                            if (!index.getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                            index.setCommentInRDBMS(string);
                                                                            break block33;
                                                                        }
                                                                        break block33;
                                                                    }
                                                                    if (this.table == null) break block33;
                                                                    Iterator iterator = this.table.getIndexes().iterator();
                                                                    while (iterator.hasNext()) {
                                                                        Index index = (Index)iterator.next();
                                                                        if (!index.getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                        index.setCommentInRDBMS(string);
                                                                        break block33;
                                                                    }
                                                                    break block33;
                                                                }
                                                                if (!this.object2.equalsIgnoreCase("'constraint'")) break block55;
                                                                if (this.tableProxy == null) break block56;
                                                                boolean bl = false;
                                                                Iterator iterator = this.tableProxy.getPkeys().iterator();
                                                                while (iterator.hasNext()) {
                                                                    modelIDObject2 = (PKProxySqlServer)iterator.next();
                                                                    if (!((RelationalObjectProxy)modelIDObject2).getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                    modelIDObject2.setCommentInRDBMS(string);
                                                                    ((IndexProxy)modelIDObject2).setCommentInRDBMSChanged(true);
                                                                    bl = true;
                                                                    break;
                                                                }
                                                                if (!bl) {
                                                                    iterator = this.tableProxy.getUkeys().iterator();
                                                                    while (iterator.hasNext()) {
                                                                        modelIDObject2 = (UniqueProxySqlServer)iterator.next();
                                                                        if (!((RelationalObjectProxy)modelIDObject2).getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                        modelIDObject2.setCommentInRDBMS(string);
                                                                        ((IndexProxy)modelIDObject2).setCommentInRDBMSChanged(true);
                                                                        bl = true;
                                                                        break;
                                                                    }
                                                                }
                                                                if (!bl && this.table != null) {
                                                                    iterator = this.table.getPKeys().iterator();
                                                                    while (iterator.hasNext()) {
                                                                        modelIDObject2 = (Index)iterator.next();
                                                                        if (!((DesignObject)modelIDObject2).getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                        modelIDObject2.setCommentInRDBMS(string);
                                                                        break;
                                                                    }
                                                                }
                                                                if (bl || this.table == null) break block33;
                                                                iterator = this.table.getUKeys().iterator();
                                                                while (iterator.hasNext()) {
                                                                    modelIDObject2 = (Index)iterator.next();
                                                                    if (!((DesignObject)modelIDObject2).getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                    modelIDObject2.setCommentInRDBMS(string);
                                                                    break block33;
                                                                }
                                                                break block33;
                                                            }
                                                            if (this.table == null) break block33;
                                                            Iterator iterator = this.table.getPKeys().iterator();
                                                            while (iterator.hasNext()) {
                                                                Index index = (Index)iterator.next();
                                                                if (!index.getName().equalsIgnoreCase(this.objectName2)) continue;
                                                                index.setCommentInRDBMS(string);
                                                                break block33;
                                                            }
                                                            break block33;
                                                        }
                                                        if (!this.object2.equalsIgnoreCase("'trigger'") || this.tableProxy == null) break block33;
                                                        Iterator iterator = this.tableProxy.getTriggers().iterator();
                                                        while (iterator.hasNext()) {
                                                            TriggerSqlServer triggerSqlServer = (TriggerSqlServer)iterator.next();
                                                            if (!triggerSqlServer.getName().equalsIgnoreCase(this.objectName2)) continue;
                                                            triggerSqlServer.setCommentInRDBMS(string);
                                                            break block33;
                                                        }
                                                        break block33;
                                                    }
                                                    if (!this.object.equalsIgnoreCase("'view'")) break block33;
                                                    this.viewProxy = ((TableViewProxySetSqlServer)storageDesignSqlServer.getTableViewProxySet()).getByName(this.objectName);
                                                    if (this.viewProxy == null || !this.object2.equalsIgnoreCase("'index'")) break block57;
                                                    Iterator iterator = this.viewProxy.getIndexesOnView().iterator();
                                                    while (iterator.hasNext()) {
                                                        IndexOnViewSqlServer indexOnViewSqlServer = (IndexOnViewSqlServer)iterator.next();
                                                        if (!indexOnViewSqlServer.getName().equalsIgnoreCase(this.objectName2)) continue;
                                                        indexOnViewSqlServer.setCommentInRDBMS(string);
                                                        break block33;
                                                    }
                                                    break block33;
                                                }
                                                if (this.viewProxy == null || !this.object2.equalsIgnoreCase("'trigger'") || this.viewProxy == null) break block33;
                                                Iterator iterator = this.viewProxy.getTriggers().iterator();
                                                while (iterator.hasNext()) {
                                                    TriggerSqlServer triggerSqlServer = (TriggerSqlServer)iterator.next();
                                                    if (!triggerSqlServer.getName().equalsIgnoreCase(this.objectName2)) continue;
                                                    triggerSqlServer.setCommentInRDBMS(string);
                                                    break block33;
                                                }
                                                break block33;
                                            }
                                            if (n != 8) break block33;
                                            stringTokenizer.nextToken().trim();
                                            stringTokenizer.nextToken().trim();
                                            this.object = stringTokenizer.nextToken().trim();
                                            this.object = Token.cutN(this.object);
                                            this.objectName = stringTokenizer.nextToken().trim();
                                            this.objectName = Token.cutN(this.objectName);
                                            this.objectName = Token.getValBetweenQuotationMarks(this.objectName);
                                            this.object2 = stringTokenizer.nextToken().trim();
                                            this.object2 = Token.cutN(this.object2);
                                            this.objectName2 = stringTokenizer.nextToken().trim();
                                            this.objectName2 = Token.cutN(this.objectName2);
                                            this.objectName2 = Token.getValBetweenQuotationMarks(this.objectName2);
                                            if (!this.object.equalsIgnoreCase("'table'")) break block58;
                                            this.tableProxy = ((TableProxySetSqlServer)storageDesignSqlServer.getTableProxySet()).getByName(this.objectName);
                                            this.table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(this.objectName);
                                            if (!this.object2.equalsIgnoreCase("'column'")) break block59;
                                            if (this.tableProxy == null) break block60;
                                            ColumnProxy columnProxy = this.tableProxy.getColumnProxyByName(this.objectName2);
                                            if (columnProxy == null) break block61;
                                            columnProxy.setCommentInRDBMS(string);
                                            columnProxy.setCommentInRDBMSChanged(true);
                                            break block33;
                                        }
                                        if (this.table == null) break block33;
                                        ContainedObject[] containedObjectArray = this.table.getElements();
                                        for (int i = 0; i < containedObjectArray.length; ++i) {
                                            if (!containedObjectArray[i].getName().equalsIgnoreCase(this.objectName2)) continue;
                                            containedObjectArray[i].setCommentInRDBMS(string);
                                            break block33;
                                        }
                                        break block33;
                                    }
                                    if (this.table == null) break block33;
                                    ContainedObject[] containedObjectArray = this.table.getElements();
                                    for (int i = 0; i < containedObjectArray.length; ++i) {
                                        if (!containedObjectArray[i].getName().equalsIgnoreCase(this.objectName2)) continue;
                                        containedObjectArray[i].setCommentInRDBMS(string);
                                        break block33;
                                    }
                                    break block33;
                                }
                                if (!this.object2.equalsIgnoreCase("'index'")) break block62;
                                if (this.tableProxy == null) break block63;
                                IndexProxy[] indexProxyArray = this.tableProxy.getIndexProxies();
                                boolean bl = false;
                                for (int i = 0; i < indexProxyArray.length; ++i) {
                                    if (!indexProxyArray[i].getName().equalsIgnoreCase(this.objectName2)) continue;
                                    indexProxyArray[i].setCommentInRDBMS(string);
                                    indexProxyArray[i].setCommentInRDBMSChanged(true);
                                    bl = true;
                                    break;
                                }
                                if (bl || this.table == null) break block33;
                                Iterator iterator = this.table.getIndexes().iterator();
                                while (iterator.hasNext()) {
                                    Index index = (Index)iterator.next();
                                    if (!index.getName().equalsIgnoreCase(this.objectName2)) continue;
                                    index.setCommentInRDBMS(string);
                                    break block33;
                                }
                                break block33;
                            }
                            if (this.table == null) break block33;
                            Iterator iterator = this.table.getIndexes().iterator();
                            while (iterator.hasNext()) {
                                Index index = (Index)iterator.next();
                                if (!index.getName().equalsIgnoreCase(this.objectName2)) continue;
                                index.setCommentInRDBMS(string);
                                break block33;
                            }
                            break block33;
                        }
                        if (!this.object2.equalsIgnoreCase("'constraint'")) break block64;
                        if (this.tableProxy == null) break block65;
                        boolean bl = false;
                        Iterator iterator = this.tableProxy.getPkeys().iterator();
                        while (iterator.hasNext()) {
                            modelIDObject = (PKProxySqlServer)iterator.next();
                            if (!((RelationalObjectProxy)modelIDObject).getName().equalsIgnoreCase(this.objectName2)) continue;
                            modelIDObject.setCommentInRDBMS(string);
                            ((IndexProxy)modelIDObject).setCommentInRDBMSChanged(true);
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            iterator = this.tableProxy.getUkeys().iterator();
                            while (iterator.hasNext()) {
                                modelIDObject = (UniqueProxySqlServer)iterator.next();
                                if (!((RelationalObjectProxy)modelIDObject).getName().equalsIgnoreCase(this.objectName2)) continue;
                                modelIDObject.setCommentInRDBMS(string);
                                ((IndexProxy)modelIDObject).setCommentInRDBMSChanged(true);
                                bl = true;
                                break;
                            }
                        }
                        if (!bl && this.table != null) {
                            iterator = this.table.getPKeys().iterator();
                            while (iterator.hasNext()) {
                                modelIDObject = (Index)iterator.next();
                                if (!((DesignObject)modelIDObject).getName().equalsIgnoreCase(this.objectName2)) continue;
                                modelIDObject.setCommentInRDBMS(string);
                                break;
                            }
                        }
                        if (bl || this.table == null) break block33;
                        iterator = this.table.getUKeys().iterator();
                        while (iterator.hasNext()) {
                            modelIDObject = (Index)iterator.next();
                            if (!((DesignObject)modelIDObject).getName().equalsIgnoreCase(this.objectName2)) continue;
                            modelIDObject.setCommentInRDBMS(string);
                            break block33;
                        }
                        break block33;
                    }
                    if (this.table == null) break block33;
                    Iterator iterator = this.table.getPKeys().iterator();
                    while (iterator.hasNext()) {
                        Index index = (Index)iterator.next();
                        if (!index.getName().equalsIgnoreCase(this.objectName2)) continue;
                        index.setCommentInRDBMS(string);
                        break block33;
                    }
                    break block33;
                }
                if (!this.object2.equalsIgnoreCase("'trigger'") || this.tableProxy == null) break block33;
                Iterator iterator = this.tableProxy.getTriggers().iterator();
                while (iterator.hasNext()) {
                    TriggerSqlServer triggerSqlServer = (TriggerSqlServer)iterator.next();
                    if (!triggerSqlServer.getName().equalsIgnoreCase(this.objectName2)) continue;
                    triggerSqlServer.setCommentInRDBMS(string);
                    break block33;
                }
                break block33;
            }
            if (!this.object.equalsIgnoreCase("'view'")) break block33;
            this.viewProxy = ((TableViewProxySetSqlServer)storageDesignSqlServer.getTableViewProxySet()).getByName(this.objectName);
            if (this.viewProxy != null && this.object2.equalsIgnoreCase("'index'")) {
                Iterator iterator = this.viewProxy.getIndexesOnView().iterator();
                while (iterator.hasNext()) {
                    IndexOnViewSqlServer indexOnViewSqlServer = (IndexOnViewSqlServer)iterator.next();
                    if (!indexOnViewSqlServer.getName().equalsIgnoreCase(this.objectName2)) continue;
                    indexOnViewSqlServer.setCommentInRDBMS(string);
                    break;
                }
            } else if (this.viewProxy != null && this.object2.equalsIgnoreCase("'trigger'") && this.viewProxy != null) {
                Iterator iterator = this.viewProxy.getTriggers().iterator();
                while (iterator.hasNext()) {
                    TriggerSqlServer triggerSqlServer = (TriggerSqlServer)iterator.next();
                    if (!triggerSqlServer.getName().equalsIgnoreCase(this.objectName2)) continue;
                    triggerSqlServer.setCommentInRDBMS(string);
                    break;
                }
            }
        }
    }

    private void initWithoutColumn(StringTokenizer stringTokenizer, StorageDesignSqlServer storageDesignSqlServer) {
        this.propertyName = stringTokenizer.nextToken().trim();
        this.propertyName = Token.cutN(this.propertyName);
        this.propertyName = Token.getValBetweenQuotationMarks(this.propertyName);
        this.propertyValue = stringTokenizer.nextToken().trim();
        this.propertyValue = Token.cutN(this.propertyValue);
        this.propertyValue = Token.getValBetweenQuotationMarks(this.propertyValue);
        stringTokenizer.nextToken().trim();
        stringTokenizer.nextToken().trim();
        this.object = stringTokenizer.nextToken().trim();
        this.objectName = stringTokenizer.nextToken().trim();
        this.object = Token.cutN(this.object);
        this.objectName = Token.cutN(this.objectName);
        if (this.object.equalsIgnoreCase("'table'")) {
            this.setTableProps(this.propertyName, this.propertyValue, this.objectName.toUpperCase(), storageDesignSqlServer);
        } else if (this.object.equalsIgnoreCase("'view'")) {
            this.setViewProps(this.propertyName, this.propertyValue, this.objectName.toUpperCase(), storageDesignSqlServer);
        }
    }

    private void setIndexOnView(String string, String string2, String string3, StorageDesignSqlServer storageDesignSqlServer) {
        this.indexOnView = (IndexOnViewSqlServer)storageDesignSqlServer.getIndexOnViewSet().getByName(string3);
        this.indexOnView.setProps(string);
        this.indexOnView.setProps(string2);
    }

    private void setTableProps(String string, String string2, String string3, StorageDesignSqlServer storageDesignSqlServer) {
        this.table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(string3);
        this.tableProxy = (TableProxySqlServer)storageDesignSqlServer.getTableProxySet().getProxy(this.table.getObjectID());
        this.tableProxy.setProps(string);
        this.tableProxy.setProps(string2);
    }

    private void setViewProps(String string, String string2, String string3, StorageDesignSqlServer storageDesignSqlServer) {
        this.view = (TableView)this.design.getDesign().getRelationalDesign().getTableViewSet().getByName(string3);
        this.viewProxy = (TableViewProxySqlServer)storageDesignSqlServer.getTableViewProxySet().getProxy(this.view.getObjectID());
        this.viewProxy.setProps(string);
        this.viewProxy.setProps(string2);
    }

    private void initWithColumn(StringTokenizer stringTokenizer, StorageDesignSqlServer storageDesignSqlServer) {
        this.propertyName = stringTokenizer.nextToken().trim();
        this.propertyName = Token.cutN(this.propertyName);
        this.propertyName = Token.getValBetweenQuotationMarks(this.propertyName);
        this.propertyValue = stringTokenizer.nextToken().trim();
        this.propertyValue = Token.cutN(this.propertyValue);
        this.propertyValue = Token.getValBetweenQuotationMarks(this.propertyValue);
        stringTokenizer.nextToken().trim();
        stringTokenizer.nextToken().trim();
        this.object = stringTokenizer.nextToken().trim();
        this.objectName = stringTokenizer.nextToken().trim();
        this.object2 = stringTokenizer.nextToken().trim();
        this.objectName2 = stringTokenizer.nextToken().trim();
        this.object = Token.cutN(this.object);
        this.objectName = Token.cutN(this.objectName);
        this.object2 = Token.cutN(this.object2);
        this.objectName2 = Token.cutN(this.objectName2);
        this.objectName = Token.getValBetweenQuotationMarks(this.objectName);
        this.objectName2 = Token.getValBetweenQuotationMarks(this.objectName2);
        if (this.object.equalsIgnoreCase("'Schema-bound View'")) {
            this.setIndexOnView(this.propertyName, this.propertyValue, this.objectName2.toUpperCase(), storageDesignSqlServer);
        } else if (this.object2.equalsIgnoreCase("'column'")) {
            this.setColumnProps(this.propertyName, this.propertyValue, this.objectName2.toUpperCase(), storageDesignSqlServer);
        } else if (this.object2.equalsIgnoreCase("'index'")) {
            this.setTableIndexProps(this.propertyName, this.propertyValue, this.objectName2.toUpperCase(), storageDesignSqlServer);
        }
    }

    private void setTableIndexProps(String string, String string2, String string3, StorageDesignSqlServer storageDesignSqlServer) {
        this.indexProxy = (IndexProxySqlServer)storageDesignSqlServer.getIndexProxySet().getByName(string3);
        this.indexProxy.setProps(string);
        this.indexProxy.setProps(string2);
    }

    private void setColumnProps(String string, String string2, String string3, StorageDesignSqlServer storageDesignSqlServer) {
        this.columnProxy = ((ColumnProxySetSqlServer)storageDesignSqlServer.getColumnProxySet()).getByName(string3);
        this.columnProxy.setProps(string);
        this.columnProxy.setProps(string2);
    }
}

