/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateViewSqlServer
extends DDLStatementHandlerSqlServer {
    private static final String VIEW_METADATA = "VIEW_METADATA";
    private static final Logger LOGGER = new Logger(SHCreateViewSqlServer.class);
    private AbstractView view;
    private TableViewProxySqlServer viewProxy;
    private StorageDesignSqlServerv2k storageDesign;
    private String userName = "";
    private String userDefined;

    public SHCreateViewSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateViewSqlServer.clearCR(string);
        if (Token.startsWithString(string2, "create view")) {
            try {
                this.userDefined = SHCreateViewSqlServer.FormatCR(string, "\n");
                this.createView(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHCreateViewSqlServer.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void createView(String string) {
        this.statement = string;
        this.view = this.design.getRelationalDesign().getTableViewSet().createTableView(null);
        this.design.getRelationalDesign().stampModelObjectDDL(this.view);
        String string2 = this.initName();
        if (this.userName != null && !"".equals(this.userName)) {
            this.view.setSchema(this.userName);
        }
        this.view.setName(string2);
        this.initUserDefinedSql();
        if (!this.initCols()) {
            this.initCol();
        }
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null) {
            this.viewProxy = (TableViewProxySqlServer)this.storageDesign.getTableViewProxySet().getProxy(this.view.getObjectID());
            if (this.viewProxy != null) {
                this.initUserAndDB();
                this.initEncription();
                this.initSchemaBinding();
                this.initViewMetadata();
                this.initCheckOptions();
                this.viewProxy.setDefinition(this.userDefined);
            }
        }
    }

    private void initUserDefinedSql() {
        this.view.setUserDefinedSQL(this.userDefined);
        this.view.setUserDefined(true);
        this.view.setSyntaxProvider("MSSQL");
    }

    private String initName() {
        String string = Token.getTokenAfter(this.statement, "VIEW").trim();
        String string2 = string.startsWith("[") ? Token.getNameAfterToken(this.statement, "VIEW", '[', ']').trim() : Token.getNameAfterToken(this.statement, "VIEW", '\"', '\"').trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        if (stringTokenizer.countTokens() == 2) {
            this.userName = stringTokenizer.nextToken().trim();
            string2 = stringTokenizer.nextToken().trim();
        }
        return string2;
    }

    public boolean initCols() {
        String string = Token.getStringBefore(this.statement, " as select ");
        if (!Token.hasToken(string, "OF") && Token.hasCloseAndOpenBrackets(string)) {
            String string2 = Token.getValBetweenBrackets(string, 1);
            if (!"".equalsIgnoreCase(string2)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                String string3 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = Token.removeQuotes(stringTokenizer.nextToken());
                    AbstractViewElement abstractViewElement = this.view.createViewElement(this.design.getLogicalDesign().getMainDPVPlaceHolder().getDesignPart());
                    abstractViewElement.setName(string3);
                    abstractViewElement.setDesign(this.design);
                    abstractViewElement.setAlias(string3);
                    abstractViewElement.setContainer(this.view);
                    this.design.getRelationalDesign().stampModelObjectDDL(abstractViewElement);
                    this.view.add(abstractViewElement);
                }
            }
            return true;
        }
        return false;
    }

    public void initCol() {
        String string = Token.getStringAfter(this.statement, "AS SELECT").trim();
        if (string.equalsIgnoreCase("") && !this.isAsSelectOnly()) {
            string = Token.getStringAfter(this.statement, "SELECT").trim();
        }
        if (!string.equalsIgnoreCase("")) {
            String string2;
            if (Token.hasToken(this.statement, "FROM")) {
                int n = string.toUpperCase().indexOf("FROM");
                string2 = string.substring(0, n);
                while (Token.tokenNumber(string2, "(") > Token.tokenNumber(string2, ")")) {
                    n = string.toUpperCase().indexOf("FROM", n + 1);
                    string2 = string.substring(0, n);
                }
                string = string2;
            }
            if (Token.getFirstToken(string).equalsIgnoreCase("ALL")) {
                string = Token.getStringAfterToken(string, "ALL").trim();
            }
            if (Token.getFirstToken(string).equalsIgnoreCase("DISTINCT")) {
                string = Token.getStringAfterToken(string, "DISTINCT").trim();
            }
            if (Token.getFirstToken(string).equalsIgnoreCase("TOP")) {
                string = Token.cutFirstToken(string);
                string = Token.cutFirstToken(string);
            }
            if (Token.getFirstToken(string).equalsIgnoreCase("PERCENT")) {
                string = Token.cutFirstToken(string);
            }
            if (string.toUpperCase().startsWith("WITH TIES")) {
                string = string.substring(9).trim();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            string2 = null;
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                string3 = null;
                StringBuffer stringBuffer = new StringBuffer(string2);
                while (Token.tokenNumber(string2, "(") > Token.tokenNumber(string2, ")") && stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(",").append(stringTokenizer.nextToken().trim());
                    string2 = stringBuffer.toString().trim();
                }
                if (Token.hasToken(string2, "AS")) {
                    string3 = Token.getNameAfterToken(string2, "AS", '[', ']');
                    string2 = Token.getStringBeforeToken(string2, "AS");
                }
                string2 = Token.encodeQuotedString(string2);
                if ((string2 = Token.encodeSquareBracketsString(string2)).indexOf(" ") > -1) {
                    if (string2.charAt(string2.length() - 1) == '\"') {
                        string3 = string2.substring(0, string2.length() - 1);
                        int n = string3.lastIndexOf(34);
                        string3 = string3.substring(n) + "\"";
                        string2 = string2.substring(0, n - 1);
                    } else if (string2.charAt(string2.length() - 1) == '\'') {
                        string3 = string2.substring(0, string2.length() - 1);
                        int n = string3.lastIndexOf(39);
                        string3 = string3.substring(n) + "'";
                        string2 = string2.substring(0, n - 1);
                    } else {
                        String string4 = Token.getLastToken(string2);
                        if (string4.indexOf(41) == -1 && !string4.equalsIgnoreCase("END")) {
                            string3 = string4;
                            string2 = string2.substring(0, string2.lastIndexOf(string4)).trim();
                        }
                    }
                }
                if (!(Token.hasCloseAndOpenBrackets(string2) || string2.indexOf(43) != -1 || string2.indexOf(45) != -1 || string2.indexOf(42) != -1 || string2.indexOf(47) != -1 || string2.indexOf(37) != -1 || string2.indexOf(38) != -1 || string2.indexOf(124) != -1 || string2.indexOf(94) != -1 || Token.hasToken(string2, "OR") || Token.hasToken(string2, "BETWEEN") || Token.hasToken(string2, "AND") || string2.indexOf(46) <= -1 || (string2 = string2.substring(string2.indexOf(46) + 1)).indexOf(46) <= -1)) {
                    string2 = string2.substring(string2.indexOf(46) + 1);
                }
                if ((string2 = Token.removeQuotes(Token.decodeQuotedString(string2))).equalsIgnoreCase("") || string2.equalsIgnoreCase("*")) continue;
                AbstractViewElement abstractViewElement = this.view.createViewElement(this.design.getLogicalDesign().getMainDPVPlaceHolder().getDesignPart());
                this.design.getRelationalDesign().stampModelObjectDDL(abstractViewElement);
                if (string3 != null) {
                    abstractViewElement.setName(string3);
                } else {
                    abstractViewElement.setName(string2);
                }
                abstractViewElement.setDesign(this.design);
                abstractViewElement.setExpression(string2);
                abstractViewElement.setContainer(this.view);
                this.view.add(abstractViewElement);
                if (string3 != null) {
                    string3 = Token.removeQuotes(Token.decodeQuotedString(string3));
                    abstractViewElement.setAlias(string3);
                    continue;
                }
                abstractViewElement.setAlias(abstractViewElement.getName());
            }
        }
    }

    private void initUserAndDB() {
        DataBaseSqlServer dataBaseSqlServer = null;
        if (!this.userName.equalsIgnoreCase("")) {
            UserSqlServer userSqlServer = (UserSqlServer)this.storageDesign.getUserSet().getByName(this.userName);
            if (userSqlServer != null) {
                this.viewProxy.setUser(userSqlServer);
                dataBaseSqlServer = userSqlServer.getDatabase();
            } else {
                dataBaseSqlServer = (DataBaseSqlServer)this.storageDesign.getDataBaseSet().getByName(this.userName);
            }
        }
        if (dataBaseSqlServer == null) {
            dataBaseSqlServer = this.getCurrentDB();
        }
        this.viewProxy.setDataBase(dataBaseSqlServer);
    }

    private void initEncription() {
        if (this.statement.toUpperCase().indexOf("ENCRYPTION") > -1) {
            this.viewProxy.setEncryption("YES");
        } else {
            this.viewProxy.setEncryption("NO");
        }
    }

    private void initSchemaBinding() {
        if (this.statement.toUpperCase().indexOf("SCHEMABINDING") > -1) {
            this.viewProxy.setSchemaBinding("YES");
        } else {
            this.viewProxy.setSchemaBinding("NO");
        }
    }

    private void initViewMetadata() {
        if (this.statement.toUpperCase().indexOf(VIEW_METADATA) > -1) {
            this.viewProxy.setViewMetaData("YES");
        } else {
            this.viewProxy.setViewMetaData("NO");
        }
    }

    private void initCheckOptions() {
        if (this.statement.toLowerCase().indexOf("WITH CHECK OPTION") > -1) {
            this.viewProxy.setCheckOption(true);
        } else {
            this.viewProxy.setCheckOption(false);
        }
    }

    public void setView(AbstractView abstractView) {
        this.view = abstractView;
    }
}

