/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateRoleSqlServer
extends DDLStatementHandlerSqlServer {
    private static final String ROLENAME = "@rolename";
    private static final String MEMBERNAME = "@membername";
    private static final String PASSWORD = "@password";
    private static final String OWNERNAME = "@ownername";
    private static final Logger LOGGER = new Logger(SHCreateRoleSqlServer.class);

    public SHCreateRoleSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateRoleSqlServer.clearCR(string);
        if (Token.startsWithString(string2, "exec sp_addrole")) {
            try {
                this.createDBRole(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHCreateRoleSqlServer.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "exec sp_addapprole")) {
            try {
                this.createApplRole(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHCreateRoleSqlServer.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "exec sp_addrolemember")) {
            try {
                this.addRoleMember(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for SQL Server failed!", exception);
                this.importLog.addFailedStatement(SHCreateRoleSqlServer.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void createDBRole(String string) {
        RoleSqlServer roleSqlServer;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k storageDesignSqlServerv2k = (StorageDesignSqlServerv2k)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k != null && (roleSqlServer = storageDesignSqlServerv2k.getRoleSet().createRole()) != null) {
            this.design.getRelationalDesign().stampModelObjectDDL(roleSqlServer);
            roleSqlServer.setIsApplicationRole(false);
            String string2 = Token.getStringAfter(this.statement, "sp_addrole").trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            String string3 = "";
            if (stringTokenizer.countTokens() == 1) {
                string3 = stringTokenizer.nextToken().trim();
                if (string3.startsWith(ROLENAME)) {
                    string3 = Token.getStringAfter(string3, "=").trim();
                }
                if (string3.toUpperCase().startsWith("N'")) {
                    string3 = string3.substring(1);
                }
                if (string3.startsWith("'")) {
                    string3 = Token.getValBetweenQuotationMarks(string3);
                }
                string3 = Token.getValBetweenSquareBrackets(string3);
                roleSqlServer.setName(string3);
                roleSqlServer.setDatabase(this.getCurrentDB());
            } else if (stringTokenizer.countTokens() == 2) {
                string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                if (string3.startsWith(ROLENAME)) {
                    string3 = Token.getStringAfter(string3, "=").trim();
                }
                if (string3.toUpperCase().startsWith("N'")) {
                    string3 = string3.substring(1);
                }
                if (string3.startsWith("'")) {
                    string3 = Token.getValBetweenQuotationMarks(string3);
                }
                string3 = Token.getValBetweenSquareBrackets(string3);
                if (string4.startsWith(OWNERNAME)) {
                    string4 = Token.getStringAfter(string4, "=").trim();
                }
                if (string4.toUpperCase().startsWith("N'")) {
                    string4 = string4.substring(1);
                }
                if (string4.startsWith("'")) {
                    string4 = Token.getValBetweenQuotationMarks(string4);
                }
                string4 = Token.getValBetweenSquareBrackets(string4);
                roleSqlServer.setName(string3);
                roleSqlServer.setDatabase(this.getCurrentDB());
                StorageObjectCollection storageObjectCollection = (StorageObjectCollection)this.getCurrentDB().getChild(3);
                UserSqlServer userSqlServer = (UserSqlServer)storageObjectCollection.getByName(string4);
                roleSqlServer.setOwner(userSqlServer);
            } else {
                LOGGER.error("RoleSqlServer.createDBRole(): wrong syntax!");
                this.importLog.addWarning("Wrong syntax defining db role " + string2);
            }
        }
    }

    private void createApplRole(String string) {
        RoleSqlServer roleSqlServer;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k storageDesignSqlServerv2k = (StorageDesignSqlServerv2k)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k != null && (roleSqlServer = storageDesignSqlServerv2k.getRoleSet().createRole()) != null) {
            this.design.getRelationalDesign().stampModelObjectDDL(roleSqlServer);
            roleSqlServer.setIsApplicationRole(true);
            String string2 = Token.getStringAfter(this.statement, "sp_addapprole").trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.countTokens() == 2) {
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                if (string3.startsWith(ROLENAME)) {
                    string3 = Token.getStringAfter(string3, "=").trim();
                }
                if (string3.toUpperCase().startsWith("N'")) {
                    string3 = string3.substring(1);
                }
                if (string3.startsWith("'")) {
                    string3 = Token.getValBetweenQuotationMarks(string3);
                }
                string3 = Token.getValBetweenSquareBrackets(string3);
                if (string4.startsWith(PASSWORD)) {
                    string4 = Token.getStringAfter(string4, "=").trim();
                }
                if (string4.toUpperCase().startsWith("N'")) {
                    string4 = string4.substring(1);
                }
                if (string4.startsWith("'")) {
                    string4 = Token.getValBetweenQuotationMarks(string4);
                }
                roleSqlServer.setName(string3);
                roleSqlServer.encodePassword(string4);
                roleSqlServer.setDatabase(this.getCurrentDB());
            } else {
                LOGGER.error("RoleSqlServer.createApplRole(): wrong syntax!");
                this.importLog.addWarning("Wrong syntax in creating appl role " + string2);
            }
        }
    }

    private void addRoleMember(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k storageDesignSqlServerv2k = (StorageDesignSqlServerv2k)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k != null) {
            String string2 = Token.getStringAfter(this.statement, "sp_addrolemember").trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.countTokens() == 2) {
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                if (string3.startsWith(ROLENAME)) {
                    string3 = Token.getStringAfter(string3, "=").trim();
                }
                if (string3.toUpperCase().startsWith("N'")) {
                    string3 = string3.substring(1);
                }
                if (string3.startsWith("'")) {
                    string3 = Token.getValBetweenQuotationMarks(string3);
                }
                string3 = Token.getValBetweenSquareBrackets(string3);
                if (string4.startsWith(MEMBERNAME)) {
                    string4 = Token.getStringAfter(string4, "=").trim();
                }
                if (string4.toUpperCase().startsWith("N'")) {
                    string4 = string4.substring(1);
                }
                if (string4.startsWith("'")) {
                    string4 = Token.getValBetweenQuotationMarks(string4);
                }
                string4 = Token.getValBetweenSquareBrackets(string4);
                RoleSqlServer roleSqlServer = (RoleSqlServer)storageDesignSqlServerv2k.getRoleSet().getByName(string3);
                if (roleSqlServer != null && string4 != null && storageDesignSqlServerv2k.getUserSet().getByName(string4) != null) {
                    roleSqlServer.setUsers(string4);
                }
            } else {
                LOGGER.error("RoleSqlServer.addRoleMember(): wrong syntax!");
                this.importLog.addWarning("Wrong syntax in defining role member " + string2);
            }
        }
    }
}

