/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateLoginSqlServer
extends DDLStatementHandlerSqlServer {
    private static final String LOGINAME = "@loginame";
    private static final String PASSWD = "@passwd";
    private static final String DEFDB = "@defdb";
    private static final String DEFLANGUAGE = "@deflanguage";
    private static final String LANGUAGE = "@language";
    private static final String NAME_IN_DB = "@name_in_db";
    private RDBMSSite site;
    private StorageDesignSqlServerv2k stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateLoginSqlServer.class);

    public SHCreateLoginSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateLoginSqlServer.clearCR(string);
        if (Token.startsWithString(string2, "exec sp_addlogin")) {
            try {
                this.createSQLServerLogin(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
                this.importLog.addFailedStatement(SHCreateLoginSqlServer.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "exec sp_grantlogin")) {
            try {
                this.createWindowsLogin(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
                this.importLog.addFailedStatement(SHCreateLoginSqlServer.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "exec sp_defaultdb")) {
            try {
                this.initDefaultDB(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
                this.importLog.addFailedStatement(SHCreateLoginSqlServer.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "exec sp_defaultlanguage")) {
            try {
                this.initDefaultLanguage(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
                this.importLog.addFailedStatement(SHCreateLoginSqlServer.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "exec sp_grantdbaccess")) {
            try {
                this.initUsers(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
                this.importLog.addFailedStatement(SHCreateLoginSqlServer.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void createSQLServerLogin(String string) {
        LoginSqlServer loginSqlServer;
        this.statement = string;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null && (loginSqlServer = this.stoDesign.getLoginSet().createLogin()) != null) {
            loginSqlServer.setAuthentication("SQL Server");
            this.design.getRelationalDesign().stampModelObjectDDL(loginSqlServer);
            String string2 = Token.getStringAfter(this.statement, "sp_addlogin").trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            try {
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                String string5 = stringTokenizer.nextToken().trim();
                String string6 = stringTokenizer.nextToken().trim();
                if (string3.startsWith(LOGINAME)) {
                    string3 = Token.getStringAfter(string3, "=").trim();
                }
                if (string3.toUpperCase().startsWith("N'")) {
                    string3 = string3.substring(1);
                }
                if (string3.startsWith("'")) {
                    string3 = Token.getValBetweenQuotationMarks(string3);
                }
                string3 = Token.getValBetweenSquareBrackets(string3);
                if (string4.startsWith(PASSWD)) {
                    string4 = Token.getStringAfter(string4, "=").trim();
                }
                if (string4.toUpperCase().startsWith("N'")) {
                    string4 = string4.substring(1);
                }
                if (string4.startsWith("'")) {
                    string4 = Token.getValBetweenQuotationMarks(string4);
                }
                if (string5.startsWith(DEFDB)) {
                    string5 = Token.getStringAfter(string5, "=").trim();
                }
                if (string5.toUpperCase().startsWith("N'")) {
                    string5 = string5.substring(1);
                }
                if (string5.startsWith("'")) {
                    string5 = Token.getValBetweenQuotationMarks(string5);
                }
                string5 = Token.getValBetweenSquareBrackets(string5);
                if (string6.startsWith(DEFLANGUAGE)) {
                    string6 = Token.getStringAfter(string6, "=").trim();
                }
                if (string6.toUpperCase().startsWith("N'")) {
                    string6 = string6.substring(1);
                }
                if (string6.startsWith("'")) {
                    string6 = Token.getValBetweenQuotationMarks(string6);
                }
                loginSqlServer.setName(string3);
                loginSqlServer.setPassword(string4);
                loginSqlServer.setDefaultDatabase((DataBaseSqlServer)this.stoDesign.getDataBaseSet().getByName(string5));
                loginSqlServer.setLanguage(string6);
            }
            catch (NoSuchElementException noSuchElementException) {
                LOGGER.error("LoginSqlServer.createSQLServerLogin(): wrong syntax!", noSuchElementException);
                this.importLog.addError("Wrong syntax near " + string);
            }
        }
    }

    private void createWindowsLogin(String string) {
        LoginSqlServer loginSqlServer;
        this.statement = string;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null && (loginSqlServer = this.stoDesign.getLoginSet().createLogin()) != null) {
            loginSqlServer.setAuthentication("WINDOWS");
            this.design.getRelationalDesign().stampModelObjectDDL(loginSqlServer);
            String string2 = Token.getStringAfter(this.statement, "sp_grantlogin").trim();
            if (string2.startsWith(LOGINAME)) {
                string2 = Token.getStringAfter(string2, "=").trim();
            }
            if (string2.toUpperCase().startsWith("N'")) {
                string2 = string2.substring(1);
            }
            if (string2.startsWith("'")) {
                string2 = Token.getValBetweenQuotationMarks(string2);
            }
            string2 = Token.getValBetweenSquareBrackets(string2);
            loginSqlServer.setName(string2);
        }
    }

    private void initDefaultDB(String string) {
        this.statement = string;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null) {
            String string2 = Token.getStringAfter(this.statement, "sp_defaultdb").trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.countTokens() == 2) {
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                if (string3.startsWith(LOGINAME)) {
                    string3 = Token.getStringAfter(string3, "=").trim();
                }
                if (string3.toUpperCase().startsWith("N'")) {
                    string3 = string3.substring(1);
                }
                if (string3.startsWith("'")) {
                    string3 = Token.getValBetweenQuotationMarks(string3);
                }
                string3 = Token.getValBetweenSquareBrackets(string3);
                if (string4.startsWith(DEFDB)) {
                    string4 = Token.getStringAfter(string4, "=").trim();
                }
                if (string4.toUpperCase().startsWith("N'")) {
                    string4 = string4.substring(1);
                }
                if (string4.startsWith("'")) {
                    string4 = Token.getValBetweenQuotationMarks(string4);
                }
                string4 = Token.getValBetweenSquareBrackets(string4);
                LoginSqlServer loginSqlServer = (LoginSqlServer)this.stoDesign.getLoginSet().getByName(string3);
                if (loginSqlServer != null) {
                    loginSqlServer.setDefaultDatabase((DataBaseSqlServer)this.stoDesign.getDataBaseSet().getByName(string4));
                }
            } else {
                LOGGER.error("LoginSqlServer.initDefaultDB(): wrong syntax!");
                this.importLog.addWarning("Wrong syntax defining default db " + string2);
            }
        }
    }

    private void initDefaultLanguage(String string) {
        this.statement = string;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null) {
            String string2 = Token.getStringAfter(this.statement, "sp_defaultlanguage").trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            try {
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                if (string3.startsWith(LOGINAME)) {
                    string3 = Token.getStringAfter(string3, "=").trim();
                }
                if (string3.toUpperCase().startsWith("N'")) {
                    string3 = string3.substring(1);
                }
                if (string3.startsWith("'")) {
                    string3 = Token.getValBetweenQuotationMarks(string3);
                }
                string3 = Token.getValBetweenSquareBrackets(string3);
                if (string4.startsWith(LANGUAGE)) {
                    string4 = Token.getStringAfter(string4, "=").trim();
                }
                if (string4.toUpperCase().startsWith("N'")) {
                    string4 = string4.substring(1);
                }
                if (string4.startsWith("'")) {
                    string4 = Token.getValBetweenQuotationMarks(string4);
                }
                string4 = Token.getValBetweenSquareBrackets(string4);
                LoginSqlServer loginSqlServer = (LoginSqlServer)this.stoDesign.getLoginSet().getByName(string3);
                if (loginSqlServer != null) {
                    loginSqlServer.setLanguage(string4);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                LOGGER.error("LoginSqlServer.initDefaultLanguage(): wrong syntax!", noSuchElementException);
                this.importLog.addWarning("Wrong syntax defining default language " + string2);
            }
        }
    }

    private void initUsers(String string) {
        if (this.getCurrentDB() != null) {
            this.statement = string;
            this.site = this.design.getSelectedRDBMSSite();
            this.stoDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(this.site);
            if (this.stoDesign != null) {
                String string2 = Token.getStringAfter(this.statement, "sp_grantdbaccess").trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                if (stringTokenizer.countTokens() == 2) {
                    String string3 = stringTokenizer.nextToken().trim();
                    String string4 = stringTokenizer.nextToken().trim();
                    if (string3.startsWith(LOGINAME)) {
                        string3 = Token.getStringAfter(string3, "=").trim();
                    }
                    if (string3.toUpperCase().startsWith("N'")) {
                        string3 = string3.substring(1);
                    }
                    if (string3.startsWith("'")) {
                        string3 = Token.getValBetweenQuotationMarks(string3);
                    }
                    string3 = Token.getValBetweenSquareBrackets(string3);
                    if (string4.startsWith(NAME_IN_DB)) {
                        string4 = Token.getStringAfter(string4, "=").trim();
                    }
                    if (string4.toUpperCase().startsWith("N'")) {
                        string4 = string4.substring(1);
                    }
                    if (string4.startsWith("'")) {
                        string4 = Token.getValBetweenQuotationMarks(string4);
                    }
                    string4 = Token.getValBetweenSquareBrackets(string4);
                    LoginSqlServer loginSqlServer = (LoginSqlServer)this.stoDesign.getLoginSet().getByName(string3);
                    if (loginSqlServer != null && string4 != null && !string4.trim().equalsIgnoreCase("")) {
                        if (loginSqlServer.getUserSet().isEmpty()) {
                            UserSqlServer userSqlServer = this.stoDesign.getUserSet().createUser();
                            userSqlServer.setName(string4);
                            this.design.getRelationalDesign().stampModelObjectDDL(userSqlServer);
                            userSqlServer.setDatabase(this.getCurrentDB());
                            userSqlServer.setLogin(loginSqlServer);
                            loginSqlServer.setUsers(string4);
                        } else {
                            LoginSqlServer loginSqlServer2 = this.stoDesign.getLoginSet().createLogin();
                            if (loginSqlServer2 != null) {
                                loginSqlServer2.setAuthentication("WINDOWS");
                                loginSqlServer2.setName(string4);
                                this.design.getRelationalDesign().stampModelObjectDDL(loginSqlServer2);
                                UserSqlServer userSqlServer = this.stoDesign.getUserSet().createUser();
                                userSqlServer.setName(string4);
                                userSqlServer.setDatabase(this.getCurrentDB());
                                userSqlServer.setLogin(loginSqlServer2);
                                this.design.getRelationalDesign().stampModelObjectDDL(userSqlServer);
                                loginSqlServer2.setUsers(string4);
                            }
                        }
                    }
                } else if (stringTokenizer.countTokens() != 1) {
                    LOGGER.error("LoginSqlServer.initUsers(): wrong syntax!");
                    this.importLog.addWarning("Wrong syntax defining users " + string2);
                }
            }
        }
    }
}

