/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDatabaseSqlServer
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateDatabaseSqlServer.class);
    private DataBaseSqlServer db;

    public SHCreateDatabaseSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateDatabaseSqlServer.clearCR(string);
        if (Token.startsWithString(string2, "create database")) {
            try {
                this.parseDatabase(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
                this.importLog.addFailedStatement(SHCreateDatabaseSqlServer.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseDatabase(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k storageDesignSqlServerv2k = (StorageDesignSqlServerv2k)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignSqlServerv2k != null) {
            this.db = storageDesignSqlServerv2k.getDataBaseSet().createDataBase();
            if (this.db != null) {
                this.design.getRelationalDesign().stampModelObjectDDL(this.db);
                if (Token.hasToken(this.statement, "ON") && !Token.getTokenBefore(this.statement, "ON").equalsIgnoreCase("LOG")) {
                    ((StorageObjectCollection)this.db.getChild(0)).removeAll();
                }
                String string2 = this.initDatabaseName();
                this.db.setName(string2);
                this.initOn(this.db, storageDesignSqlServerv2k);
                this.initLogOn(this.db, storageDesignSqlServerv2k);
                this.initCollate();
            }
        }
    }

    private String initDatabaseName() {
        String string = Token.getTokenAfter(this.statement, "DATABASE").trim();
        String string2 = string.startsWith("[") ? Token.getNameAfterToken(this.statement, "DATABASE", '[', ']').trim() : Token.getNameAfterToken(this.statement, "DATABASE", '\"', '\"').trim();
        return string2;
    }

    private void initOn(DataBaseSqlServer dataBaseSqlServer, StorageDesignSqlServerv2k storageDesignSqlServerv2k) {
        if (Token.hasToken(this.statement, "ON") && !Token.getTokenBefore(this.statement, "ON").equalsIgnoreCase("LOG")) {
            String string = Token.getStringAfter(this.statement, "ON").trim();
            if (Token.hasString(string, "LOG ON")) {
                string = string.substring(0, string.toUpperCase().indexOf("LOG ON"));
            }
            FileGroupSqlServer fileGroupSqlServer = null;
            DataFileSqlServer dataFileSqlServer = null;
            String string2 = Token.getStringBefore(string, "FILEGROUP").trim();
            string = string.substring(string2.length());
            if ("".equalsIgnoreCase(string2)) {
                string2 = string;
            }
            String string3 = "";
            boolean bl = true;
            while (!string2.equalsIgnoreCase("")) {
                Object object;
                if (string2.toUpperCase().startsWith("FILEGROUP")) {
                    string2 = string2.substring(10);
                }
                string3 = Token.getTokenBefore(string2, "(");
                string2 = string2.substring(string3.length());
                if (string3.equalsIgnoreCase("")) {
                    string3 = "PRIMARY";
                }
                String string4 = Token.getValBetweenSquareBrackets(string3.trim());
                fileGroupSqlServer = (FileGroupSqlServer)storageDesignSqlServerv2k.getFileGroupSet().getByName(string4);
                if (fileGroupSqlServer == null || fileGroupSqlServer.getDataBase() != dataBaseSqlServer) {
                    fileGroupSqlServer = storageDesignSqlServerv2k.getFileGroupSet().createFileGroup();
                    this.design.getRelationalDesign().stampModelObjectDDL(fileGroupSqlServer);
                    fileGroupSqlServer.setDataBase(dataBaseSqlServer);
                    fileGroupSqlServer.setName(string4);
                    object = (StorageObjectCollection)dataBaseSqlServer.getChild(0);
                    fileGroupSqlServer.setParent(object);
                    ((StorageObjectCollection)object).add(fileGroupSqlServer);
                }
                while (!string2.equalsIgnoreCase("") && Token.hasCloseAndOpenBrackets(string2) && !Token.getValBetweenBrackets(string2, 1).trim().equalsIgnoreCase("")) {
                    object = Token.getValBetweenBrackets(string2, 1);
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
                    String string5 = "";
                    dataFileSqlServer = storageDesignSqlServerv2k.getDataFileSet().createDataFile();
                    this.design.getRelationalDesign().stampModelObjectDDL(dataFileSqlServer);
                    dataFileSqlServer.setFileGroup(fileGroupSqlServer);
                    StorageObjectCollection storageObjectCollection = (StorageObjectCollection)fileGroupSqlServer.getChild(0);
                    dataFileSqlServer.setParent(storageObjectCollection);
                    storageObjectCollection.add(dataFileSqlServer);
                    if (stringTokenizer.hasMoreTokens()) {
                        string5 = stringTokenizer.nextToken();
                        string5 = this.initLogName(dataFileSqlServer, stringTokenizer, string5);
                        string5 = this.initLogFileName(dataFileSqlServer, stringTokenizer, string5);
                        string5 = this.initLogSize(dataFileSqlServer, stringTokenizer, string5);
                        string5 = this.initLogMaxSize(dataFileSqlServer, stringTokenizer, string5);
                        this.initLogFileGrouth(dataFileSqlServer, string5);
                    }
                    string2 = string2.trim().substring(((String)object).length() + 2);
                }
                if (string.trim().toUpperCase().startsWith("FILEGROUP")) {
                    object = string.trim().substring(10);
                    string2 = "FILEGROUP " + Token.getStringBefore((String)object, "FILEGROUP");
                } else {
                    string2 = Token.getStringBefore(string, "FILEGROUP").trim();
                }
                if ("".equalsIgnoreCase(string2)) continue;
                if ((string = string.trim().substring(string2.length()).trim()).startsWith(",")) {
                    string = string.substring(1).trim();
                }
                if (!string2.equalsIgnoreCase("") || string.equalsIgnoreCase("") || string.equalsIgnoreCase(")") || !bl) continue;
                string2 = string;
                bl = false;
            }
        }
    }

    private void initLogOn(DataBaseSqlServer dataBaseSqlServer, StorageDesignSqlServerv2k storageDesignSqlServerv2k) {
        if (Token.hasToken(this.statement, "LOG") && Token.getTokenAfter(this.statement, "LOG").trim().equalsIgnoreCase("ON")) {
            String string = Token.getStringAfter(this.statement, "LOG ON").trim();
            DataFileSqlServer dataFileSqlServer = null;
            if (Token.hasString(string, "COLLATE")) {
                string = Token.getStringBefore(string, "COLLATE");
            }
            while (!string.equalsIgnoreCase("") && !Token.getValBetweenBrackets(string, 1).trim().equalsIgnoreCase("")) {
                String string2 = Token.getValBetweenBrackets(string, 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                String string3 = "";
                dataFileSqlServer = storageDesignSqlServerv2k.getDataFileSet().createDataFile();
                this.design.getRelationalDesign().stampModelObjectDDL(dataFileSqlServer);
                dataFileSqlServer.setDataBase(dataBaseSqlServer);
                StorageObjectCollection storageObjectCollection = (StorageObjectCollection)dataBaseSqlServer.getChild(1);
                dataFileSqlServer.setParent(storageObjectCollection);
                storageObjectCollection.add(dataFileSqlServer);
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    string3 = this.initLogName(dataFileSqlServer, stringTokenizer, string3);
                    string3 = this.initLogFileName(dataFileSqlServer, stringTokenizer, string3);
                    string3 = this.initLogSize(dataFileSqlServer, stringTokenizer, string3);
                    string3 = this.initLogMaxSize(dataFileSqlServer, stringTokenizer, string3);
                    this.initLogFileGrouth(dataFileSqlServer, string3);
                }
                string = string.trim().substring(string2.length() + 2);
            }
        }
    }

    private String initLogName(DataFileSqlServer dataFileSqlServer, StringTokenizer stringTokenizer, String string) {
        if (string.trim().toUpperCase().startsWith("NAME")) {
            String string2 = Token.getStringAfter(string, "NAME").trim();
            if ((string2 = Token.getStringAfter(string2, "=").trim()).startsWith("N'")) {
                string2 = string2.substring(1);
            }
            if (string2.startsWith("'")) {
                string2 = Token.getValBetweenQuotationMarks(string2);
            }
            dataFileSqlServer.setName(Token.getValBetweenSquareBrackets(string2));
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        return string;
    }

    private String initLogFileName(DataFileSqlServer dataFileSqlServer, StringTokenizer stringTokenizer, String string) {
        if (string.trim().toUpperCase().startsWith("FILENAME")) {
            String string2 = Token.getStringAfter(string, "FILENAME").trim();
            if ((string2 = Token.getStringAfter(string2, "=").trim()).startsWith("N'")) {
                string2 = string2.substring(1);
            }
            if (string2.startsWith("'")) {
                string2 = Token.getValBetweenQuotationMarks(string2);
            }
            dataFileSqlServer.setFileName(Token.getValBetweenSquareBrackets(string2));
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        return string;
    }

    private String initLogSize(DataFileSqlServer dataFileSqlServer, StringTokenizer stringTokenizer, String string) {
        if (string.trim().toUpperCase().startsWith("SIZE")) {
            String string2 = Token.getStringAfter(string, "SIZE");
            string2 = Token.getStringAfter(string2, "=").trim();
            try {
                dataFileSqlServer.setInitialSize(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("Wrong format:", numberFormatException);
                this.importLog.addWarning("Unknown initialial size of file " + dataFileSqlServer.getName());
            }
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        return string;
    }

    private String initLogMaxSize(DataFileSqlServer dataFileSqlServer, StringTokenizer stringTokenizer, String string) {
        if (string.trim().toUpperCase().startsWith("MAXSIZE")) {
            String string2 = Token.getStringAfter(string, "MAXSIZE");
            if ((string2 = Token.getStringAfter(string2, "=").trim()).equalsIgnoreCase("UNLIMITED")) {
                dataFileSqlServer.setIsUnlimited(true);
            } else {
                try {
                    dataFileSqlServer.setMaxSize(Integer.parseInt(string2));
                    dataFileSqlServer.setIsUnlimited(false);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("", numberFormatException);
                    this.importLog.addWarning("Unknown max size of file " + dataFileSqlServer.getName());
                }
            }
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        return string;
    }

    private void initLogFileGrouth(DataFileSqlServer dataFileSqlServer, String string) {
        if (string.trim().toUpperCase().startsWith("FILEGROWTH")) {
            String string2 = Token.getStringAfter(string, "FILEGROWTH").trim();
            string2 = Token.getStringAfter(string, "=").trim();
            if (Token.hasString(string2, "%")) {
                dataFileSqlServer.setGrowthMethod("By Percent");
                string2 = string2.substring(0, string2.length() - 1).trim();
            } else {
                dataFileSqlServer.setGrowthMethod("In MegaBytes");
            }
            try {
                dataFileSqlServer.setGrowthValue(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("Wrong format:", numberFormatException);
                this.importLog.addWarning("Unknown filegrowth of file " + dataFileSqlServer.getName());
            }
        }
    }

    private void initCollate() {
        if (Token.hasToken(this.statement, "COLLATE")) {
            String string = Token.getStringAfter(this.statement, "COLLATE");
            this.db.setCollationName(string);
        }
    }
}

