/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHAlterDatabaseSqlServer
extends DDLStatementHandlerSqlServer {
    private static final String ADD_FILE = "add file";
    private static final Logger LOGGER = new Logger(SHAlterDatabaseSqlServer.class);
    private DataBaseSqlServer db;
    private StorageDesignSqlServerv2k storageDesign;

    public SHAlterDatabaseSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHAlterDatabaseSqlServer.clearCR(string);
        if (Token.startsWithString(string2, "alter database")) {
            try {
                this.parseAlterDatabase(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHAlterDatabaseSqlServer.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseAlterDatabase(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null) {
            this.db = (DataBaseSqlServer)this.storageDesign.getDataBaseSet().getByName(this.initDatabaseName());
            if (this.db != null) {
                this.initFileGroup();
                this.initAddFile();
                this.initAddLogFile();
                this.initUserState();
                this.initCursorClose();
                this.initCursorDefault();
                this.initAutoClose();
                this.initAutoCreateStatistics();
                this.initAutoShrink();
                this.initAutoUpdateStatistics();
                this.initAnsiNulls();
                this.initAnsiPadding();
                this.initAnsiWarnings();
                this.initArithabort();
                this.initConcatNullYieldsNull();
                this.initNumericRoundAbort();
                this.initQuotedId();
                this.initRecursiveTriggers();
                this.initRecovery();
                this.initTornPageDetection();
            }
        }
    }

    private void initAddFile() {
        if (this.statement.toUpperCase().indexOf(ADD_FILE) > -1 && !this.statement.toLowerCase().substring(this.statement.toUpperCase().indexOf(ADD_FILE) + 8).startsWith("group")) {
            FileGroupSqlServer fileGroupSqlServer;
            String string = Token.getStringAfter(this.statement, ADD_FILE);
            String string2 = "";
            if (Token.hasString(string.toLowerCase(), "to filegroup ")) {
                string2 = Token.getStringAfter(string.toLowerCase(), "to filegroup ");
                string = string.substring(0, string.toLowerCase().indexOf("to filegroup "));
            }
            if (string2.equalsIgnoreCase("")) {
                string2 = "PRIMARY";
            }
            if ((fileGroupSqlServer = (FileGroupSqlServer)((StorageObjectCollection)this.db.getChild(0)).getByName(string2)) != null) {
                DataFileSqlServer dataFileSqlServer = null;
                while (!string.equalsIgnoreCase("") && Token.hasCloseAndOpenBrackets(string) && !Token.getValBetweenBrackets(string, 1).trim().equalsIgnoreCase("")) {
                    String string3 = Token.getValBetweenBrackets(string, 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                    String string4 = "";
                    if (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken();
                        if (string4.trim().toUpperCase().startsWith("NAME")) {
                            String string5 = Token.getStringAfter(string4, "NAME").trim();
                            if ((string5 = Token.getStringAfter(string5, "=").trim()).startsWith("N'")) {
                                string5 = string5.substring(1);
                            }
                            if (string5.startsWith("'")) {
                                string5 = Token.getValBetweenQuotationMarks(string5);
                            }
                            if ((dataFileSqlServer = (DataFileSqlServer)((StorageObjectCollection)fileGroupSqlServer.getChild(0)).getByName(string5)) == null) {
                                dataFileSqlServer = this.storageDesign.getDataFileSet().createDataFile();
                                this.design.getRelationalDesign().stampModelObjectDDL(dataFileSqlServer);
                                dataFileSqlServer.setFileGroup(fileGroupSqlServer);
                            }
                            dataFileSqlServer.setName(Token.getValBetweenSquareBrackets(string5));
                            if (stringTokenizer.hasMoreTokens()) {
                                string4 = stringTokenizer.nextToken();
                            }
                        }
                        string4 = this.initLogFileName(dataFileSqlServer, stringTokenizer, string4);
                        string4 = this.initLogSize(dataFileSqlServer, stringTokenizer, string4);
                        string4 = this.initLogMaxSize(dataFileSqlServer, stringTokenizer, string4);
                        this.initLogFileGrouth(dataFileSqlServer, string4);
                    }
                    string = string.trim().substring(string3.length() + 2);
                }
            }
        }
    }

    private void initAddLogFile() {
        if (this.statement.toLowerCase().indexOf("add log file ") > -1) {
            String string = Token.getStringAfter(this.statement.toLowerCase(), "add log file");
            DataFileSqlServer dataFileSqlServer = null;
            while (!string.equalsIgnoreCase("") && !Token.getValBetweenBrackets(string, 1).trim().equalsIgnoreCase("")) {
                String string2 = Token.getValBetweenBrackets(string, 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                String string3 = "";
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    if (string3.trim().toUpperCase().startsWith("NAME")) {
                        String string4 = Token.getStringAfter(string3, "NAME").trim();
                        if ((string4 = Token.getStringAfter(string4, "=").trim()).startsWith("N'")) {
                            string4 = string4.substring(1);
                        }
                        if (string4.startsWith("'")) {
                            string4 = Token.getValBetweenQuotationMarks(string4);
                        }
                        if ((dataFileSqlServer = (DataFileSqlServer)((StorageObjectCollection)this.db.getChild(1)).getByName(string4)) == null) {
                            dataFileSqlServer = this.storageDesign.getDataFileSet().createDataFile();
                            this.design.getRelationalDesign().stampModelObjectDDL(dataFileSqlServer);
                            dataFileSqlServer.setDataBase(this.db);
                        }
                        dataFileSqlServer.setName(Token.getValBetweenSquareBrackets(string4));
                        if (stringTokenizer.hasMoreTokens()) {
                            string3 = stringTokenizer.nextToken();
                        }
                    }
                    string3 = this.initLogFileName(dataFileSqlServer, stringTokenizer, string3);
                    string3 = this.initLogSize(dataFileSqlServer, stringTokenizer, string3);
                    string3 = this.initLogMaxSize(dataFileSqlServer, stringTokenizer, string3);
                    this.initLogFileGrouth(dataFileSqlServer, string3);
                }
                string = string.trim().substring(string2.length() + 2);
            }
        }
    }

    private void initFileGroup() {
        String string = "";
        if (this.statement.toLowerCase().indexOf("add filegroup ") > -1 && !(string = Token.getStringAfter(this.statement.toLowerCase(), "add filegroup ")).equalsIgnoreCase("")) {
            FileGroupSqlServer fileGroupSqlServer = this.storageDesign.getFileGroupSet().createFileGroup();
            this.design.getRelationalDesign().stampModelObjectDDL(fileGroupSqlServer);
            fileGroupSqlServer.setName(string);
            fileGroupSqlServer.setDataBase(this.db);
        }
    }

    private void initUserState() {
        if (Token.hasToken(this.statement, "SINGLE_USER")) {
            this.db.setUserState("SINGLE_USER");
        } else if (Token.hasToken(this.statement, "RESTRICTED_USER")) {
            this.db.setUserState("RESTRICTED_USER");
        } else if (Token.hasToken(this.statement, "MULTI_USER")) {
            this.db.setUserState("MULTI_USER");
        }
    }

    private void initCursorClose() {
        if (Token.hasToken(this.statement, "CURSOR_CLOSE_ON_COMMIT")) {
            String string = Token.getTokenAfter(this.statement, "CURSOR_CLOSE_ON_COMMIT");
            this.db.setCursorCloseOnCommit(string);
        }
    }

    private void initCursorDefault() {
        if (Token.hasToken(this.statement, "CURSOR_DEFAULT")) {
            String string = Token.getTokenAfter(this.statement, "CURSOR_DEFAULT");
            this.db.setCursorDefault(string);
        }
    }

    private void initAutoClose() {
        if (Token.hasToken(this.statement, "AUTO_CLOSE")) {
            String string = Token.getTokenAfter(this.statement, "AUTO_CLOSE");
            this.db.setAutoClose(string);
        }
    }

    private void initAutoCreateStatistics() {
        if (Token.hasToken(this.statement, "AUTO_CREATE_STATISTICS")) {
            String string = Token.getTokenAfter(this.statement, "AUTO_CREATE_STATISTICS");
            this.db.setAutoCreateStatistics(string);
        }
    }

    private void initAutoShrink() {
        if (Token.hasToken(this.statement, "AUTO_SHRINK")) {
            String string = Token.getTokenAfter(this.statement, "AUTO_SHRINK");
            this.db.setAutoShrink(string);
        }
    }

    private void initAutoUpdateStatistics() {
        if (Token.hasToken(this.statement, "AUTO_UPDATE_STATISTICS")) {
            String string = Token.getTokenAfter(this.statement, "AUTO_UPDATE_STATISTICS");
            this.db.setAutoUpdateStatistics(string);
        }
    }

    private void initAnsiNulls() {
        if (Token.hasToken(this.statement, "ANSI_NULLS")) {
            String string = Token.getTokenAfter(this.statement, "ANSI_NULLS");
            this.db.setAnsiNulls(string);
        }
    }

    private void initAnsiPadding() {
        if (Token.hasToken(this.statement, "ANSI_PADDING")) {
            String string = Token.getTokenAfter(this.statement, "ANSI_PADDING");
            this.db.setAnsiPadding(string);
        }
    }

    private void initAnsiWarnings() {
        if (Token.hasToken(this.statement, "ANSI_WARNINGS")) {
            String string = Token.getTokenAfter(this.statement, "ANSI_WARNINGS");
            this.db.setAnsiWarnings(string);
        }
    }

    private void initArithabort() {
        if (Token.hasToken(this.statement, "ARITHABORT")) {
            String string = Token.getTokenAfter(this.statement, "ARITHABORT");
            this.db.setArithabort(string);
        }
    }

    private void initConcatNullYieldsNull() {
        if (Token.hasToken(this.statement, "CONCAT_NULL_YIELDS_NULL")) {
            String string = Token.getTokenAfter(this.statement, "CONCAT_NULL_YIELDS_NULL");
            this.db.setConcatNullYieldsNull(string);
        }
    }

    private void initNumericRoundAbort() {
        if (Token.hasToken(this.statement, "NUMERIC_ROUNDABORT")) {
            String string = Token.getTokenAfter(this.statement, "NUMERIC_ROUNDABORT");
            this.db.setNumericRoundabort(string);
        }
    }

    private void initQuotedId() {
        if (Token.hasToken(this.statement, "QUOTED_IDENTIFIER")) {
            String string = Token.getTokenAfter(this.statement, "QUOTED_IDENTIFIER");
            this.db.setQuotedIdentifier(string);
        }
    }

    private void initRecursiveTriggers() {
        if (Token.hasToken(this.statement, "RECURSIVE_TRIGGERS")) {
            String string = Token.getTokenAfter(this.statement, "RECURSIVE_TRIGGERS");
            this.db.setRecursiveTriggers(string);
        }
    }

    private void initRecovery() {
        if (Token.hasToken(this.statement, "RECOVERY")) {
            String string = Token.getTokenAfter(this.statement, "RECOVERY");
            this.db.setRecovery(string);
        }
    }

    private void initTornPageDetection() {
        if (Token.hasToken(this.statement, "TORN_PAGE_DETECTION")) {
            String string = Token.getTokenAfter(this.statement, "TORN_PAGE_DETECTION");
            this.db.setTornPageDetection(string);
        }
    }

    private String initDatabaseName() {
        String string = Token.getTokenAfter(this.statement, "DATABASE").trim();
        String string2 = string.startsWith("[") ? Token.getNameAfterToken(this.statement, "DATABASE", '[', ']').trim() : Token.getNameAfterToken(this.statement, "DATABASE", '\"', '\"').trim();
        return string2;
    }

    private String initLogFileName(DataFileSqlServer dataFileSqlServer, StringTokenizer stringTokenizer, String string) {
        if (string.trim().toUpperCase().startsWith("FILENAME")) {
            String string2 = Token.getStringAfter(string.toUpperCase(), "FILENAME").trim();
            if ((string2 = Token.getStringAfter(string2, "=").trim()).startsWith("N'")) {
                string2 = string2.substring(1);
            }
            if (string2.startsWith("'")) {
                string2 = Token.getValBetweenQuotationMarks(string2);
            }
            dataFileSqlServer.setFileName(Token.getValBetweenSquareBrackets(string2));
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        return string;
    }

    private String initLogSize(DataFileSqlServer dataFileSqlServer, StringTokenizer stringTokenizer, String string) {
        if (string.trim().toUpperCase().startsWith("SIZE")) {
            String string2 = Token.getStringAfter(string, "SIZE");
            string2 = Token.getStringAfter(string2, "=").trim();
            try {
                dataFileSqlServer.setInitialSize(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("", numberFormatException);
            }
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        return string;
    }

    private String initLogMaxSize(DataFileSqlServer dataFileSqlServer, StringTokenizer stringTokenizer, String string) {
        if (string.trim().toUpperCase().startsWith("MAXSIZE")) {
            String string2 = Token.getStringAfter(string, "MAXSIZE");
            if ((string2 = Token.getStringAfter(string2, "=").trim()).equalsIgnoreCase("UNLIMITED")) {
                dataFileSqlServer.setIsUnlimited(true);
            } else {
                try {
                    dataFileSqlServer.setMaxSize(Integer.parseInt(string2));
                    dataFileSqlServer.setIsUnlimited(false);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("", numberFormatException);
                    this.importLog.addWarning("Max size of file " + dataFileSqlServer.getName() + " is unknown");
                }
            }
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        return string;
    }

    private void initLogFileGrouth(DataFileSqlServer dataFileSqlServer, String string) {
        if (string.trim().toUpperCase().startsWith("FILEGROWTH")) {
            String string2 = Token.getStringAfter(string, "FILEGROWTH").trim();
            string2 = Token.getStringAfter(string, "=").trim();
            if (Token.hasString(string2, "%")) {
                dataFileSqlServer.setGrowthMethod("By Percent");
                string2 = string2.substring(0, string2.length() - 1).trim();
            } else {
                dataFileSqlServer.setGrowthMethod("In MegaBytes");
            }
            try {
                dataFileSqlServer.setGrowthValue(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("", numberFormatException);
                this.importLog.addWarning("Growth value of file " + dataFileSqlServer.getName() + " is unknown");
            }
        }
    }
}

