/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.ddl.AlterTableHandler;
import oracle.dbtools.crest.imports.ddl.CreateTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;

public class DDLStatementHandlerSqlServer
extends DDLStatementHandler
implements StatementsConstants {
    private DataBaseSqlServer currentDB = null;
    protected DDLStatementHandlerSqlServer successor = null;

    public DDLStatementHandlerSqlServer(Design design) {
        super(design);
    }

    public void add(DDLStatementHandlerSqlServer dDLStatementHandlerSqlServer) {
        DDLStatementHandlerSqlServer dDLStatementHandlerSqlServer2 = this;
        while (dDLStatementHandlerSqlServer2.successor != null) {
            dDLStatementHandlerSqlServer2 = dDLStatementHandlerSqlServer2.successor;
        }
        dDLStatementHandlerSqlServer2.successor = dDLStatementHandlerSqlServer;
    }

    @Override
    public void handle(String string) {
        this.nextHandler(string);
    }

    @Override
    public void nextHandler(String string) {
        if (this.successor != null) {
            this.successor.setCurrentDB(this.getCurrentDB());
            this.successor.setImportLog(this.importLog);
            this.successor.handle(string);
        } else {
            this.importLog.addNotRecognized(DDLStatementHandlerSqlServer.FormatCR(string, "\n"));
        }
    }

    @Override
    public void setStatement(String string) {
        this.statement = string;
    }

    protected DataBaseSqlServer getCurrentDB() {
        return this.currentDB;
    }

    public void setCurrentDB(String string) {
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)this.design.getStorageDesign(rDBMSSite);
        DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getByName(string);
        if (dataBaseSqlServer == null) {
            dataBaseSqlServer = (DataBaseSqlServer)storageDesignSqlServer.getDataBaseSet().getNullInstance();
        }
        this.currentDB = dataBaseSqlServer;
    }

    protected void setCurrentDB(DataBaseSqlServer dataBaseSqlServer) {
        this.currentDB = dataBaseSqlServer;
    }

    @Override
    public CreateTableHandler getCreateTableHandler() {
        if (this instanceof CreateTableHandler) {
            return (CreateTableHandler)((Object)this);
        }
        if (this.successor != null) {
            return this.successor.getCreateTableHandler();
        }
        return null;
    }

    @Override
    public AlterTableHandler getAlterTableHandler() {
        if (this instanceof AlterTableHandler) {
            return (AlterTableHandler)((Object)this);
        }
        if (this.successor != null) {
            return this.successor.getAlterTableHandler();
        }
        return null;
    }
}

