/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataFileOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateUndoTablespaceOraclev9i
extends DDLStatementHandler {
    private UndoTablespaceOracle tableSpace;
    private RDBMSSite site;
    private StorageDesignOraclev9i stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateUndoTablespaceOraclev9i.class);

    public SHCreateUndoTablespaceOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateUndoTablespaceOraclev9i.clearCR(string);
        if (Token.startsWithString(string2, "create undo tablespace") || Token.startsWithString(string2, "create smallfile undo tablespace") || Token.startsWithString(string2, "create bigfile undo tablespace")) {
            try {
                this.parseTablespace(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateUndoTablespaceOraclev9i.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseTablespace(String string) {
        this.statement = string;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignOraclev9i)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null) {
            this.tableSpace = this.stoDesign.getUndoTablespaceSet().createTablespace();
            if (this.tableSpace != null) {
                this.initName();
                this.initFileType();
                this.initDataFiles();
                this.initRetention();
                this.design.getRelationalDesign().stampModelObjectDDL(this.tableSpace);
            }
        }
    }

    private void initFileType() {
        String string = Token.getTokenAfter(this.statement, "CREATE");
        if (!string.equalsIgnoreCase("UNDO")) {
            this.tableSpace.setFileType(string.toUpperCase());
        }
    }

    private void initName() {
        String string = Token.getQuotedNameAfterToken(this.statement, "TABLESPACE").trim();
        this.tableSpace.setName(string);
    }

    private void initDataFiles() {
        if (Token.hasToken(this.statement, "DATAFILE")) {
            String[] stringArray = new String[]{"MINIMUM EXTENT", "LOGGING", "NOLOGGING", "DEFAULT", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "EXTENT MANAGEMENT"};
            String string = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "DATAFILE"), stringArray);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                this.initDataFile(string2);
            }
        }
    }

    private void initDataFile(String string) {
        if (!"".equalsIgnoreCase(string)) {
            String string2;
            String string3;
            DataFileOraclev9i dataFileOraclev9i = (DataFileOraclev9i)this.stoDesign.getDataFileSet().createDataFile();
            this.design.getRelationalDesign().stampModelObjectDDL(dataFileOraclev9i);
            dataFileOraclev9i.setUndoTablespace(this.tableSpace);
            String string4 = Token.getValBetweenQuotes(string);
            if (string4 != "") {
                dataFileOraclev9i.setFileName(string4);
                this.tableSpace.setOracleManagesFiles("NO");
            } else {
                this.tableSpace.setOracleManagesFiles("YES");
            }
            if (Token.hasToken(string, "SIZE")) {
                string3 = Token.getTokenAfter(string, "SIZE");
                try {
                    long l = Long.parseLong(this.getNumberOnly(string3));
                    dataFileOraclev9i.setSize(l);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("wrong format in SHCreateTablespaceOracle.initDataFile!", numberFormatException);
                    this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                }
                string2 = this.getMeasureUnit(string3, string);
                dataFileOraclev9i.setMeasureUnit(string2);
            }
            if (Token.hasToken(string, "REUSE")) {
                dataFileOraclev9i.setReuse("YES");
            } else {
                dataFileOraclev9i.setReuse("NO");
            }
            if (Token.hasToken(string, "AUTOEXTEND")) {
                string3 = Token.getTokenAfter(string, "AUTOEXTEND").trim();
                if ("ON".equalsIgnoreCase(string3)) {
                    dataFileOraclev9i.setAutoextend("ON");
                    if (Token.hasToken(string, "NEXT")) {
                        string2 = Token.getTokenAfter(string, "NEXT").trim();
                        try {
                            int n = Integer.parseInt(this.getNumberOnly(string2));
                            dataFileOraclev9i.setNextBlockSize(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.error("wrong format in SHCreateTablespaceOracle.initDataFile!", numberFormatException);
                            this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
                        }
                    }
                    if (Token.hasToken(string, "MAXSIZE")) {
                        dataFileOraclev9i.setMaxSize(this.getNumberOnly(Token.getTokenAfter(string, "MAXSIZE").trim()));
                    }
                } else if ("OFF".equalsIgnoreCase(string3)) {
                    dataFileOraclev9i.setAutoextend("OFF");
                }
            }
        }
    }

    private String getNumberOnly(String string) {
        String string2 = string.toUpperCase();
        if (string2.endsWith("K") || string2.endsWith("M")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String getMeasureUnit(String string, String string2) {
        String string3 = string.toUpperCase();
        if (string3.endsWith("K")) {
            return "K";
        }
        if (string3.endsWith("M")) {
            return "M";
        }
        string3 = Token.getTokenAfter(string2, string).toUpperCase();
        if (string3.equals("K") || string3.equals("M")) {
            return string3;
        }
        return "";
    }

    private void initRetention() {
        if (Token.hasToken(this.statement, "RETENTION")) {
            this.tableSpace.setRetention(Token.getTokenAfter(this.statement, "RETENTION").toUpperCase());
        }
    }
}

